package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties for {@link CodeStarConnectionsSourceAction}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Artifact sourceOutput = new Artifact();
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("BitBucket_Source")
 *         .owner("aws")
 *         .repo("aws-cdk")
 *         .output(sourceOutput)
 *         .connectionArn("arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.874Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeStarConnectionsSourceActionProps")
@software.amazon.jsii.Jsii.Proxy(CodeStarConnectionsSourceActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeStarConnectionsSourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * "arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh";
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn();

    /**
     * The output artifact that this action produces.
     * <p>
     * Can be used as input for further pipeline actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getOutput();

    /**
     * The owning user or organization of the repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * "aws";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * The name of the repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * "aws-cdk";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepo();

    /**
     * The branch to build.
     * <p>
     * Default: 'master'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranch() {
        return null;
    }

    /**
     * Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
     * <p>
     * <strong>Note</strong>: if this option is true,
     * then only CodeBuild actions can use the resulting {&#64;link output}.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCodeBuildCloneOutput() {
        return null;
    }

    /**
     * Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
     * <p>
     * If unspecified,
     * the default value is true, and the field does not display by default.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTriggerOnPush() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeStarConnectionsSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeStarConnectionsSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeStarConnectionsSourceActionProps> {
        java.lang.String connectionArn;
        software.amazon.awscdk.services.codepipeline.Artifact output;
        java.lang.String owner;
        java.lang.String repo;
        java.lang.String branch;
        java.lang.Boolean codeBuildCloneOutput;
        java.lang.Boolean triggerOnPush;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getConnectionArn}
         * @param connectionArn The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getOutput}
         * @param output The output artifact that this action produces. This parameter is required.
         *               Can be used as input for further pipeline actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getOwner}
         * @param owner The owning user or organization of the repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getRepo}
         * @param repo The name of the repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(java.lang.String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getBranch}
         * @param branch The branch to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(java.lang.String branch) {
            this.branch = branch;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getCodeBuildCloneOutput}
         * @param codeBuildCloneOutput Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
         *                             <strong>Note</strong>: if this option is true,
         *                             then only CodeBuild actions can use the resulting {&#64;link output}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildCloneOutput(java.lang.Boolean codeBuildCloneOutput) {
            this.codeBuildCloneOutput = codeBuildCloneOutput;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getTriggerOnPush}
         * @param triggerOnPush Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
         *                      If unspecified,
         *                      the default value is true, and the field does not display by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerOnPush(java.lang.Boolean triggerOnPush) {
            this.triggerOnPush = triggerOnPush;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your {&#64;link IAction.bind}
         *             method in the {&#64;link ActionBindOptions.role} property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link CodeStarConnectionsSourceActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeStarConnectionsSourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeStarConnectionsSourceActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeStarConnectionsSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeStarConnectionsSourceActionProps {
        private final java.lang.String connectionArn;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final java.lang.String owner;
        private final java.lang.String repo;
        private final java.lang.String branch;
        private final java.lang.Boolean codeBuildCloneOutput;
        private final java.lang.Boolean triggerOnPush;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repo = software.amazon.jsii.Kernel.get(this, "repo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeBuildCloneOutput = software.amazon.jsii.Kernel.get(this, "codeBuildCloneOutput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.triggerOnPush = software.amazon.jsii.Kernel.get(this, "triggerOnPush", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionArn = java.util.Objects.requireNonNull(builder.connectionArn, "connectionArn is required");
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.repo = java.util.Objects.requireNonNull(builder.repo, "repo is required");
            this.branch = builder.branch;
            this.codeBuildCloneOutput = builder.codeBuildCloneOutput;
            this.triggerOnPush = builder.triggerOnPush;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRepo() {
            return this.repo;
        }

        @Override
        public final java.lang.String getBranch() {
            return this.branch;
        }

        @Override
        public final java.lang.Boolean getCodeBuildCloneOutput() {
            return this.codeBuildCloneOutput;
        }

        @Override
        public final java.lang.Boolean getTriggerOnPush() {
            return this.triggerOnPush;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            data.set("output", om.valueToTree(this.getOutput()));
            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repo", om.valueToTree(this.getRepo()));
            if (this.getBranch() != null) {
                data.set("branch", om.valueToTree(this.getBranch()));
            }
            if (this.getCodeBuildCloneOutput() != null) {
                data.set("codeBuildCloneOutput", om.valueToTree(this.getCodeBuildCloneOutput()));
            }
            if (this.getTriggerOnPush() != null) {
                data.set("triggerOnPush", om.valueToTree(this.getTriggerOnPush()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CodeStarConnectionsSourceActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeStarConnectionsSourceActionProps.Jsii$Proxy that = (CodeStarConnectionsSourceActionProps.Jsii$Proxy) o;

            if (!connectionArn.equals(that.connectionArn)) return false;
            if (!output.equals(that.output)) return false;
            if (!owner.equals(that.owner)) return false;
            if (!repo.equals(that.repo)) return false;
            if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
            if (this.codeBuildCloneOutput != null ? !this.codeBuildCloneOutput.equals(that.codeBuildCloneOutput) : that.codeBuildCloneOutput != null) return false;
            if (this.triggerOnPush != null ? !this.triggerOnPush.equals(that.triggerOnPush) : that.triggerOnPush != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionArn.hashCode();
            result = 31 * result + (this.output.hashCode());
            result = 31 * result + (this.owner.hashCode());
            result = 31 * result + (this.repo.hashCode());
            result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
            result = 31 * result + (this.codeBuildCloneOutput != null ? this.codeBuildCloneOutput.hashCode() : 0);
            result = 31 * result + (this.triggerOnPush != null ? this.triggerOnPush.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
