package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * import software.amazon.awscdk.services.iam.*;
 * Artifact artifact;
 * ArtifactPath artifactPath;
 * IEcsDeploymentGroup ecsDeploymentGroup;
 * Role role;
 * CodeDeployEcsDeployAction codeDeployEcsDeployAction = CodeDeployEcsDeployAction.Builder.create()
 *         .actionName("actionName")
 *         .deploymentGroup(ecsDeploymentGroup)
 *         // the properties below are optional
 *         .appSpecTemplateFile(artifactPath)
 *         .appSpecTemplateInput(artifact)
 *         .containerImageInputs(List.of(CodeDeployEcsContainerImageInput.builder()
 *                 .input(artifact)
 *                 // the properties below are optional
 *                 .taskDefinitionPlaceholder("taskDefinitionPlaceholder")
 *                 .build()))
 *         .role(role)
 *         .runOrder(123)
 *         .taskDefinitionTemplateFile(artifactPath)
 *         .taskDefinitionTemplateInput(artifact)
 *         .variablesNamespace("variablesNamespace")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.870Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeDeployEcsDeployAction")
public class CodeDeployEcsDeployAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CodeDeployEcsDeployAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeDeployEcsDeployAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeDeployEcsDeployAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the {@link IAction.bind} method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your {&#64;link IAction.bind}
         * method in the {&#64;link ActionBindOptions.role} property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The CodeDeploy ECS Deployment Group to deploy to.
         * <p>
         * @return {@code this}
         * @param deploymentGroup The CodeDeploy ECS Deployment Group to deploy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroup(final software.amazon.awscdk.services.codedeploy.IEcsDeploymentGroup deploymentGroup) {
            this.props.deploymentGroup(deploymentGroup);
            return this;
        }

        /**
         * The name of the CodeDeploy AppSpec file.
         * <p>
         * During deployment, a new task definition will be registered
         * with ECS, and the new task definition ID will be inserted into
         * the CodeDeploy AppSpec file.  The AppSpec file contents will be
         * provided to CodeDeploy for the deployment.
         * <p>
         * Use this property if you want to use a different name for this file than the default 'appspec.yaml'.
         * If you use this property, you don't need to specify the <code>appSpecTemplateInput</code> property.
         * <p>
         * Default: - one of this property, or `appSpecTemplateInput`, is required
         * <p>
         * @return {@code this}
         * @param appSpecTemplateFile The name of the CodeDeploy AppSpec file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecTemplateFile(final software.amazon.awscdk.services.codepipeline.ArtifactPath appSpecTemplateFile) {
            this.props.appSpecTemplateFile(appSpecTemplateFile);
            return this;
        }

        /**
         * The artifact containing the CodeDeploy AppSpec file.
         * <p>
         * During deployment, a new task definition will be registered
         * with ECS, and the new task definition ID will be inserted into
         * the CodeDeploy AppSpec file.  The AppSpec file contents will be
         * provided to CodeDeploy for the deployment.
         * <p>
         * If you use this property, it's assumed the file is called 'appspec.yaml'.
         * If your AppSpec file uses a different filename, leave this property empty,
         * and use the <code>appSpecTemplateFile</code> property instead.
         * <p>
         * Default: - one of this property, or `appSpecTemplateFile`, is required
         * <p>
         * @return {@code this}
         * @param appSpecTemplateInput The artifact containing the CodeDeploy AppSpec file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecTemplateInput(final software.amazon.awscdk.services.codepipeline.Artifact appSpecTemplateInput) {
            this.props.appSpecTemplateInput(appSpecTemplateInput);
            return this;
        }

        /**
         * Configuration for dynamically updated images in the task definition.
         * <p>
         * Provide pairs of an image details input artifact and a placeholder string
         * that will be used to dynamically update the ECS task definition template
         * file prior to deployment. A maximum of 4 images can be given.
         * <p>
         * @return {@code this}
         * @param containerImageInputs Configuration for dynamically updated images in the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerImageInputs(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsContainerImageInput> containerImageInputs) {
            this.props.containerImageInputs(containerImageInputs);
            return this;
        }

        /**
         * The name of the ECS task definition template file.
         * <p>
         * During deployment, the task definition template file contents
         * will be registered with ECS.
         * <p>
         * Use this property if you want to use a different name for this file than the default 'taskdef.json'.
         * If you use this property, you don't need to specify the <code>taskDefinitionTemplateInput</code> property.
         * <p>
         * Default: - one of this property, or `taskDefinitionTemplateInput`, is required
         * <p>
         * @return {@code this}
         * @param taskDefinitionTemplateFile The name of the ECS task definition template file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionTemplateFile(final software.amazon.awscdk.services.codepipeline.ArtifactPath taskDefinitionTemplateFile) {
            this.props.taskDefinitionTemplateFile(taskDefinitionTemplateFile);
            return this;
        }

        /**
         * The artifact containing the ECS task definition template file.
         * <p>
         * During deployment, the task definition template file contents
         * will be registered with ECS.
         * <p>
         * If you use this property, it's assumed the file is called 'taskdef.json'.
         * If your task definition template uses a different filename, leave this property empty,
         * and use the <code>taskDefinitionTemplateFile</code> property instead.
         * <p>
         * Default: - one of this property, or `taskDefinitionTemplateFile`, is required
         * <p>
         * @return {@code this}
         * @param taskDefinitionTemplateInput The artifact containing the ECS task definition template file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionTemplateInput(final software.amazon.awscdk.services.codepipeline.Artifact taskDefinitionTemplateInput) {
            this.props.taskDefinitionTemplateInput(taskDefinitionTemplateInput);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CodeDeployEcsDeployAction(
                this.props.build()
            );
        }
    }
}
