package software.amazon.awscdk.services.codebuild;

/**
 * Source provider definition for a CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISource gitHubSource = Source.gitHub(GitHubSourceProps.builder()
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .webhook(true) // optional, default: true if `webhookFilters` were provided, false otherwise
 *         .webhookTriggersBatchBuild(true) // optional, default is false
 *         .webhookFilters(List.of(FilterGroup.inEventOf(EventAction.PUSH).andBranchIs("main").andCommitMessageIs("the commit message")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Source")
public abstract class Source extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.ISource {

    protected Source(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Source(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Source(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.SourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource bitBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BitBucketSourceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Source.class, "bitBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource codeCommit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CodeCommitSourceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Source.class, "codeCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource gitHub(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.GitHubSourceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Source.class, "gitHub", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource gitHubEnterprise(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.GitHubEnterpriseSourceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Source.class, "gitHubEnterprise", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ISource s3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.S3SourceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Source.class, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ISource.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by the project when the source is added so that the source can perform binding operations on the source.
     * <p>
     * For example, it can grant permissions to the
     * code build project to read from the S3 bucket.
     * <p>
     * @param _scope This parameter is required.
     * @param _project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.SourceConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject _project) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.SourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_project, "_project is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getBadgeSupported() {
        return software.amazon.jsii.Kernel.get(this, "badgeSupported", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.Source implements software.amazon.awscdk.services.codebuild.ISource.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
