package software.amazon.awscdk.services.codebuild;

/**
 * Location of a PEM certificate on S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository ecrRepository;
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", WindowsImageType.SERVER_2019))
 *                 // optional certificate to include in the build image
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(Bucket.fromBucketName(this, "Bucket", "my-bucket"))
 *                         .objectKey("path/to/cert.pem")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.642Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BuildEnvironmentCertificate")
@software.amazon.jsii.Jsii.Proxy(BuildEnvironmentCertificate.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BuildEnvironmentCertificate extends software.amazon.jsii.JsiiSerializable {

    /**
     * The bucket where the certificate is.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The full path and name of the key file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * @return a {@link Builder} of {@link BuildEnvironmentCertificate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BuildEnvironmentCertificate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BuildEnvironmentCertificate> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String objectKey;

        /**
         * Sets the value of {@link BuildEnvironmentCertificate#getBucket}
         * @param bucket The bucket where the certificate is. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link BuildEnvironmentCertificate#getObjectKey}
         * @param objectKey The full path and name of the key file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildEnvironmentCertificate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BuildEnvironmentCertificate build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BuildEnvironmentCertificate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildEnvironmentCertificate {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String objectKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.objectKey = software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.objectKey = java.util.Objects.requireNonNull(builder.objectKey, "objectKey is required");
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.BuildEnvironmentCertificate"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BuildEnvironmentCertificate.Jsii$Proxy that = (BuildEnvironmentCertificate.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            return this.objectKey.equals(that.objectKey);
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.objectKey.hashCode());
            return result;
        }
    }
}
