package software.amazon.awscdk.services.cloudfront;

/**
 * HTTP status code to failover to second origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Configuring origin fallback options for the CloudFrontWebDistribution
 * // Configuring origin fallback options for the CloudFrontWebDistribution
 * CloudFrontWebDistribution.Builder.create(this, "ADistribution")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(Bucket.fromBucketName(this, "aBucket", "myoriginbucket"))
 *                         .originPath("/")
 *                         .originHeaders(Map.of(
 *                                 "myHeader", "42"))
 *                         .originShieldRegion("us-west-2")
 *                         .build())
 *                 .failoverS3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(Bucket.fromBucketName(this, "aBucketFallback", "myoriginbucketfallback"))
 *                         .originPath("/somewhere")
 *                         .originHeaders(Map.of(
 *                                 "myHeader2", "21"))
 *                         .originShieldRegion("us-east-1")
 *                         .build())
 *                 .failoverCriteriaStatusCodes(List.of(FailoverStatusCode.INTERNAL_SERVER_ERROR))
 *                 .behaviors(List.of(Behavior.builder()
 *                         .isDefaultBehavior(true)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.484Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FailoverStatusCode")
public enum FailoverStatusCode {
    /**
     * Forbidden (403).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORBIDDEN,
    /**
     * Not found (404).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOT_FOUND,
    /**
     * Internal Server Error (500).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTERNAL_SERVER_ERROR,
    /**
     * Bad Gateway (502).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BAD_GATEWAY,
    /**
     * Service Unavailable (503).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVICE_UNAVAILABLE,
    /**
     * Gateway Timeout (504).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GATEWAY_TIMEOUT,
}
