package software.amazon.awscdk.services.appmesh;

/**
 * Defines HTTP route matching based on the URL path of the request.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .weight(50)
 *                         .build(), WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .weight(50)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.startsWith("/path-to-app"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:48.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpRoutePathMatch")
public abstract class HttpRoutePathMatch extends software.amazon.jsii.JsiiObject {

    protected HttpRoutePathMatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpRoutePathMatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected HttpRoutePathMatch() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The value of the path must match the specified value exactly.
     * <p>
     * The provided <code>path</code> must start with the '/' character.
     * <p>
     * @param path the exact path to match on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRoutePathMatch exactly(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class, "exactly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * The value of the path must match the specified regex.
     * <p>
     * @param regex the regex used to match the path. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRoutePathMatch regex(final @org.jetbrains.annotations.NotNull java.lang.String regex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class, "regex", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(regex, "regex is required") });
    }

    /**
     * The value of the path must match the specified prefix.
     * <p>
     * @param prefix the value to use to match the beginning of the path part of the URL of the request. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRoutePathMatch startsWith(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class, "startsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the route path match configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRoutePathMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.HttpRoutePathMatch {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the route path match configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRoutePathMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRoutePathMatchConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
