package software.amazon.awscdk.pipelines;

/**
 * Factory for explicit CodePipeline Actions.
 * <p>
 * If you have specific types of Actions you want to add to a
 * CodePipeline, write a subclass of <code>Step</code> that implements this
 * interface, and add the action or actions you want in the <code>produce</code> method.
 * <p>
 * There needs to be a level of indirection here, because some aspects of the
 * Action creation need to be controlled by the workflow engine (name and
 * runOrder). All the rest of the properties are controlled by the factory.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:55.189Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ICodePipelineActionFactory")
@software.amazon.jsii.Jsii.Proxy(ICodePipelineActionFactory.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ICodePipelineActionFactory extends software.amazon.jsii.JsiiSerializable {

    /**
     * Create the desired Action and add it to the pipeline.
     * <p>
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult produceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ProduceActionOptions options);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.pipelines.ICodePipelineActionFactory.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Create the desired Action and add it to the pipeline.
         * <p>
         * @param stage This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult produceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ProduceActionOptions options) {
            return software.amazon.jsii.Kernel.call(this, "produceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }

    /**
     * Internal default implementation for {@link ICodePipelineActionFactory}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ICodePipelineActionFactory {

        /**
         * Create the desired Action and add it to the pipeline.
         * <p>
         * @param stage This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult produceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ProduceActionOptions options) {
            return software.amazon.jsii.Kernel.call(this, "produceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }
}
