package software.amazon.awscdk;

/**
 * The lambda runtime to use for the resource provider.
 * <p>
 * This also indicates
 * which language is used for the handler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * CustomResourceProvider provider = CustomResourceProvider.getOrCreateProvider(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
 *         .codeDirectory(String.format("%s/my-handler", __dirname))
 *         .runtime(CustomResourceProviderRuntime.NODEJS_14_X)
 *         .build());
 * provider.addToRolePolicy(Map.of(
 *         "Effect", "Allow",
 *         "Action", "s3:GetObject",
 *         "Resource", "*"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:48.259Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResourceProviderRuntime")
public enum CustomResourceProviderRuntime {
    /**
     * Node.js 12.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_12_X,
    /**
     * Node.js 14.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_14_X,
    /**
     * Node.js 16.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_16_X,
}
