package software.amazon.awscdk;

/**
 * A CloudFormation `AWS::CloudFormation::Stack`.
 * <p>
 * The <code>AWS::CloudFormation::Stack</code> resource nests a stack as a resource in a top-level template.
 * <p>
 * You can add output values from a nested stack within the containing template. You use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">GetAtt</a> function with the nested stack's logical name and the name of the output value in the nested stack in the format <code>Outputs. *NestedStackOutputName*</code> .
 * <p>
 * <blockquote>
 * <p>
 * We strongly recommend that updates to nested stacks are run from the parent stack.
 * <p>
 * </blockquote>
 * <p>
 * When you apply template changes to update a top-level stack, CloudFormation updates the top-level stack and initiates an update to its nested stacks. CloudFormation updates the resources of modified nested stacks, but doesn't update the resources of unmodified nested stacks. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">CloudFormation stack updates</a> .
 * <p>
 * <blockquote>
 * <p>
 * You must acknowledge IAM capabilities for nested stacks that contain IAM resources. Also, verify that you have cancel update stack permissions, which is required if an update rolls back. For more information about IAM and CloudFormation , see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling access with AWS Identity and Access Management</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnStack cfnStack = CfnStack.Builder.create(this, "MyCfnStack")
 *         .templateUrl("templateUrl")
 *         // the properties below are optional
 *         .notificationArns(List.of("notificationArns"))
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutInMinutes(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:48.222Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnStack")
public class CfnStack extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.CfnStack.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFormation::Stack`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs to associate with this stack.
     * <p>
     * AWS CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template anatomy</a> .
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateUrl() {
        return software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template anatomy</a> .
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateUrl", java.util.Objects.requireNonNull(value, "templateUrl is required"));
    }

    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic ARNs to publish stack related events.
     * <p>
     * You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic ARNs to publish stack related events.
     * <p>
     * You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "notificationArns", value);
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     * <p>
     * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
     * <p>
     * </blockquote>
     * <p>
     * Conditional. Required if the nested stack requires input parameters.
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     * <p>
     * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
     * <p>
     * </blockquote>
     * <p>
     * Conditional. Required if the nested stack requires input parameters.
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     * <p>
     * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
     * <p>
     * </blockquote>
     * <p>
     * Conditional. Required if the nested stack requires input parameters.
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the `CREATE_COMPLETE` state.
     * <p>
     * The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
     * <p>
     * Updates aren't supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the `CREATE_COMPLETE` state.
     * <p>
     * The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
     * <p>
     * Updates aren't supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeoutInMinutes", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CfnStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CfnStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.CfnStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.CfnStackProps.Builder();
        }

        /**
         * Location of file containing the template body.
         * <p>
         * The URL must point to a template (max size: 460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template anatomy</a> .
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @param templateUrl Location of file containing the template body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateUrl(final java.lang.String templateUrl) {
            this.props.templateUrl(templateUrl);
            return this;
        }

        /**
         * The Amazon Simple Notification Service (Amazon SNS) topic ARNs to publish stack related events.
         * <p>
         * You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
         * <p>
         * @return {@code this}
         * @param notificationArns The Amazon Simple Notification Service (Amazon SNS) topic ARNs to publish stack related events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props.notificationArns(notificationArns);
            return this;
        }

        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         * <p>
         * <blockquote>
         * <p>
         * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         * <p>
         * </blockquote>
         * <p>
         * Conditional. Required if the nested stack requires input parameters.
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         * <p>
         * <blockquote>
         * <p>
         * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         * <p>
         * </blockquote>
         * <p>
         * Conditional. Required if the nested stack requires input parameters.
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * Key-value pairs to associate with this stack.
         * <p>
         * AWS CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs to associate with this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the `CREATE_COMPLETE` state.
         * <p>
         * The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
         * <p>
         * Updates aren't supported.
         * <p>
         * @return {@code this}
         * @param timeoutInMinutes The length of time, in minutes, that CloudFormation waits for the nested stack to reach the `CREATE_COMPLETE` state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMinutes(final java.lang.Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.CfnStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CfnStack build() {
            return new software.amazon.awscdk.CfnStack(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
