/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.InstanceProps;
import software.amazon.awscdk.services.rds.PerformanceInsightRetention;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.InstanceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface InstanceProps
extends JsiiSerializable {
    @NotNull
    public IVpc getVpc();

    @Nullable
    default public Boolean getAllowMajorVersionUpgrade() {
        return null;
    }

    @Nullable
    default public Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    @Nullable
    default public Boolean getDeleteAutomatedBackups() {
        return null;
    }

    @Nullable
    default public Boolean getEnablePerformanceInsights() {
        return null;
    }

    @Nullable
    default public InstanceType getInstanceType() {
        return null;
    }

    @Nullable
    default public IParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Map<String, String> getParameters() {
        return null;
    }

    @Nullable
    default public IKey getPerformanceInsightEncryptionKey() {
        return null;
    }

    @Nullable
    default public PerformanceInsightRetention getPerformanceInsightRetention() {
        return null;
    }

    @Nullable
    default public Boolean getPubliclyAccessible() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<InstanceProps> {
        IVpc vpc;
        Boolean allowMajorVersionUpgrade;
        Boolean autoMinorVersionUpgrade;
        Boolean deleteAutomatedBackups;
        Boolean enablePerformanceInsights;
        InstanceType instanceType;
        IParameterGroup parameterGroup;
        Map<String, String> parameters;
        IKey performanceInsightEncryptionKey;
        PerformanceInsightRetention performanceInsightRetention;
        Boolean publiclyAccessible;
        List<ISecurityGroup> securityGroups;
        SubnetSelection vpcSubnets;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder performanceInsightEncryptionKey(IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        public Builder performanceInsightRetention(PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public InstanceProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

