/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda_event_sources.SnsEventSource")
public class SnsEventSource
extends JsiiObject
implements IEventSource {
    protected SnsEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnsEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SnsEventSource(@NotNull ITopic topic, @Nullable SnsEventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(topic, "topic is required"), props});
    }

    public SnsEventSource(@NotNull ITopic topic) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(topic, "topic is required")});
    }

    @Override
    public void bind(@NotNull IFunction target) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @NotNull
    public ITopic getTopic() {
        return (ITopic)Kernel.get((Object)this, (String)"topic", (NativeType)NativeType.forClass(ITopic.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SnsEventSource> {
        private final ITopic topic;
        private SnsEventSourceProps.Builder props;

        public static Builder create(ITopic topic) {
            return new Builder(topic);
        }

        private Builder(ITopic topic) {
            this.topic = topic;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder filterPolicy(Map<String, ? extends SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        public SnsEventSource build() {
            return new SnsEventSource(this.topic, this.props != null ? this.props.build() : null);
        }

        private SnsEventSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new SnsEventSourceProps.Builder();
            }
            return this.props;
        }
    }
}

