/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.globalaccelerator.EndpointGroupProps;
import software.amazon.awscdk.services.globalaccelerator.HealthCheckProtocol;
import software.amazon.awscdk.services.globalaccelerator.IEndpoint;
import software.amazon.awscdk.services.globalaccelerator.IEndpointGroup;
import software.amazon.awscdk.services.globalaccelerator.IListener;
import software.amazon.awscdk.services.globalaccelerator.PortOverride;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_globalaccelerator.EndpointGroup")
public class EndpointGroup
extends Resource
implements IEndpointGroup {
    protected EndpointGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EndpointGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EndpointGroup(@NotNull Construct scope, @NotNull String id, @NotNull EndpointGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEndpointGroup fromEndpointGroupArn(@NotNull Construct scope, @NotNull String id, @NotNull String endpointGroupArn) {
        return (IEndpointGroup)JsiiObject.jsiiStaticCall(EndpointGroup.class, (String)"fromEndpointGroupArn", (NativeType)NativeType.forClass(IEndpointGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(endpointGroupArn, "endpointGroupArn is required")});
    }

    public void addEndpoint(@NotNull IEndpoint endpoint) {
        Kernel.call((Object)this, (String)"addEndpoint", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(endpoint, "endpoint is required")});
    }

    @NotNull
    public IPeer connectionsPeer(@NotNull String id, @NotNull IVpc vpc) {
        return (IPeer)Kernel.call((Object)this, (String)"connectionsPeer", (NativeType)NativeType.forClass(IPeer.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(vpc, "vpc is required")});
    }

    @Override
    @NotNull
    public String getEndpointGroupArn() {
        return (String)Kernel.get((Object)this, (String)"endpointGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getEndpointGroupName() {
        return (String)Kernel.get((Object)this, (String)"endpointGroupName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected List<IEndpoint> getEndpoints() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"endpoints", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IEndpoint.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EndpointGroup> {
        private final Construct scope;
        private final String id;
        private final EndpointGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EndpointGroupProps.Builder();
        }

        public Builder endpointGroupName(String endpointGroupName) {
            this.props.endpointGroupName(endpointGroupName);
            return this;
        }

        public Builder endpoints(List<? extends IEndpoint> endpoints) {
            this.props.endpoints(endpoints);
            return this;
        }

        public Builder healthCheckInterval(Duration healthCheckInterval) {
            this.props.healthCheckInterval(healthCheckInterval);
            return this;
        }

        public Builder healthCheckPath(String healthCheckPath) {
            this.props.healthCheckPath(healthCheckPath);
            return this;
        }

        public Builder healthCheckPort(Number healthCheckPort) {
            this.props.healthCheckPort(healthCheckPort);
            return this;
        }

        public Builder healthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
            this.props.healthCheckProtocol(healthCheckProtocol);
            return this;
        }

        public Builder healthCheckThreshold(Number healthCheckThreshold) {
            this.props.healthCheckThreshold(healthCheckThreshold);
            return this;
        }

        public Builder portOverrides(List<? extends PortOverride> portOverrides) {
            this.props.portOverrides(portOverrides);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder trafficDialPercentage(Number trafficDialPercentage) {
            this.props.trafficDialPercentage(trafficDialPercentage);
            return this;
        }

        public Builder listener(IListener listener) {
            this.props.listener(listener);
            return this;
        }

        public EndpointGroup build() {
            return new EndpointGroup(this.scope, this.id, this.props.build());
        }
    }
}

