package software.amazon.awscdk.services.stepfunctions;

/**
 * Error handler details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CatchProps catchProps = CatchProps.builder()
 *         .errors(List.of("errors"))
 *         .resultPath("resultPath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CatchProps")
@software.amazon.jsii.Jsii.Proxy(CatchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CatchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Errors to recover from by going to the given state.
     * <p>
     * A list of error strings to retry, which can be either predefined errors
     * (for example Errors.NoChoiceMatched) or a self-defined error.
     * <p>
     * Default: All errors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getErrors() {
        return null;
    }

    /**
     * JSONPath expression to indicate where to inject the error data.
     * <p>
     * May also be the special value DISCARD, which will cause the error
     * data to be discarded.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CatchProps> {
        java.util.List<java.lang.String> errors;
        java.lang.String resultPath;

        /**
         * Sets the value of {@link CatchProps#getErrors}
         * @param errors Errors to recover from by going to the given state.
         *               A list of error strings to retry, which can be either predefined errors
         *               (for example Errors.NoChoiceMatched) or a self-defined error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(java.util.List<java.lang.String> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Sets the value of {@link CatchProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the error data.
         *                   May also be the special value DISCARD, which will cause the error
         *                   data to be discarded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CatchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CatchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatchProps {
        private final java.util.List<java.lang.String> errors;
        private final java.lang.String resultPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.errors = builder.errors;
            this.resultPath = builder.resultPath;
        }

        @Override
        public final java.util.List<java.lang.String> getErrors() {
            return this.errors;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getErrors() != null) {
                data.set("errors", om.valueToTree(this.getErrors()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CatchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CatchProps.Jsii$Proxy that = (CatchProps.Jsii$Proxy) o;

            if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
            return this.resultPath != null ? this.resultPath.equals(that.resultPath) : that.resultPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.errors != null ? this.errors.hashCode() : 0;
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            return result;
        }
    }
}
