package software.amazon.awscdk.services.sns;

/**
 * The policy for an SNS Topic.
 * <p>
 * Policies define the operations that are allowed on this resource.
 * <p>
 * You almost never need to define this construct directly.
 * <p>
 * All AWS resources that support resource policies have a method called
 * <code>addToResourcePolicy()</code>, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 * <p>
 * Prefer to use <code>addToResourcePolicy()</code> instead.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = new Topic(this, "Topic");
 * TopicPolicy topicPolicy = TopicPolicy.Builder.create(this, "TopicPolicy")
 *         .topics(List.of(topic))
 *         .build();
 * topicPolicy.document.addStatements(PolicyStatement.Builder.create()
 *         .actions(List.of("sns:Subscribe"))
 *         .principals(List.of(new AnyPrincipal()))
 *         .resources(List.of(topic.getTopicArn()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.745Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.TopicPolicy")
public class TopicPolicy extends software.amazon.awscdk.Resource {

    protected TopicPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TopicPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TopicPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The IAM policy document for this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.TopicPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.TopicPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sns.TopicPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sns.TopicPolicyProps.Builder();
        }

        /**
         * The set of topics this policy applies to.
         * <p>
         * @return {@code this}
         * @param topics The set of topics this policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topics(final java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> topics) {
            this.props.topics(topics);
            return this;
        }

        /**
         * IAM policy document to apply to topic(s).
         * <p>
         * Default: empty policy document
         * <p>
         * @return {@code this}
         * @param policyDocument IAM policy document to apply to topic(s). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(final software.amazon.awscdk.services.iam.PolicyDocument policyDocument) {
            this.props.policyDocument(policyDocument);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sns.TopicPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.TopicPolicy build() {
            return new software.amazon.awscdk.services.sns.TopicPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
