package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * HttpNamespace namespace = HttpNamespace.Builder.create(stack, "MyNamespace")
 *         .name("MyHTTPNamespace")
 *         .build();
 * Service service1 = namespace.createService("NonIpService", BaseServiceProps.builder()
 *         .description("service registering non-ip instances")
 *         .build());
 * service1.registerNonIpInstance("NonIpInstance", NonIpInstanceBaseProps.builder()
 *         .customAttributes(Map.of("arn", "arn:aws:s3:::mybucket"))
 *         .build());
 * Service service2 = namespace.createService("IpService", BaseServiceProps.builder()
 *         .description("service registering ip instances")
 *         .healthCheck(HealthCheckConfig.builder()
 *                 .type(HealthCheckType.HTTP)
 *                 .resourcePath("/check")
 *                 .build())
 *         .build());
 * service2.registerIpInstance("IpInstance", IpInstanceBaseProps.builder()
 *         .ipv4("54.239.25.192")
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.659Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.IpInstanceBaseProps")
@software.amazon.jsii.Jsii.Proxy(IpInstanceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IpInstanceBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.BaseInstanceProps {

    /**
     * If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv4() {
        return null;
    }

    /**
     * If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6() {
        return null;
    }

    /**
     * The port on the endpoint that you want AWS Cloud Map to perform health checks on.
     * <p>
     * This value is also used for
     * the port value in an SRV record if the service that you specify includes an SRV record. You can also specify a
     * default port that is applied to all instances in the Service configuration.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IpInstanceBaseProps> {
        java.lang.String ipv4;
        java.lang.String ipv6;
        java.lang.Number port;
        java.util.Map<java.lang.String, java.lang.String> customAttributes;
        java.lang.String instanceId;

        /**
         * Sets the value of {@link IpInstanceBaseProps#getIpv4}
         * @param ipv4 If the service that you specify contains a template for an A record, the IPv4 address that you want AWS Cloud Map to use for the value of the A record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4(java.lang.String ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        /**
         * Sets the value of {@link IpInstanceBaseProps#getIpv6}
         * @param ipv6 If the service that you specify contains a template for an AAAA record, the IPv6 address that you want AWS Cloud Map to use for the value of the AAAA record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6(java.lang.String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        /**
         * Sets the value of {@link IpInstanceBaseProps#getPort}
         * @param port The port on the endpoint that you want AWS Cloud Map to perform health checks on.
         *             This value is also used for
         *             the port value in an SRV record if the service that you specify includes an SRV record. You can also specify a
         *             default port that is applied to all instances in the Service configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link IpInstanceBaseProps#getCustomAttributes}
         * @param customAttributes Custom attributes of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link IpInstanceBaseProps#getInstanceId}
         * @param instanceId The id of the instance resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IpInstanceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IpInstanceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IpInstanceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpInstanceBaseProps {
        private final java.lang.String ipv4;
        private final java.lang.String ipv6;
        private final java.lang.Number port;
        private final java.util.Map<java.lang.String, java.lang.String> customAttributes;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipv4 = software.amazon.jsii.Kernel.get(this, "ipv4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6 = software.amazon.jsii.Kernel.get(this, "ipv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipv4 = builder.ipv4;
            this.ipv6 = builder.ipv6;
            this.port = builder.port;
            this.customAttributes = builder.customAttributes;
            this.instanceId = builder.instanceId;
        }

        @Override
        public final java.lang.String getIpv4() {
            return this.ipv4;
        }

        @Override
        public final java.lang.String getIpv6() {
            return this.ipv6;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIpv4() != null) {
                data.set("ipv4", om.valueToTree(this.getIpv4()));
            }
            if (this.getIpv6() != null) {
                data.set("ipv6", om.valueToTree(this.getIpv6()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.IpInstanceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IpInstanceBaseProps.Jsii$Proxy that = (IpInstanceBaseProps.Jsii$Proxy) o;

            if (this.ipv4 != null ? !this.ipv4.equals(that.ipv4) : that.ipv4 != null) return false;
            if (this.ipv6 != null ? !this.ipv6.equals(that.ipv6) : that.ipv6 != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ipv4 != null ? this.ipv4.hashCode() : 0;
            result = 31 * result + (this.ipv6 != null ? this.ipv6.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
