package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for a ProductStackHistory.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.*;
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProductV2");
 *     }
 * }
 * ProductStackHistory productStackHistory = ProductStackHistory.Builder.create(this, "ProductStackHistory")
 *         .productStack(new S3BucketProduct(this, "S3BucketProduct"))
 *         .currentVersionName("v2")
 *         .currentVersionLocked(true)
 *         .build();
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "MyFirstProduct")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(productStackHistory.currentVersion()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.609Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.ProductStackHistoryProps")
@software.amazon.jsii.Jsii.Proxy(ProductStackHistoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProductStackHistoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * If this is set to true, the ProductStack will not be overwritten if a snapshot is found for the currentVersionName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getCurrentVersionLocked();

    /**
     * The current version name of the ProductStack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCurrentVersionName();

    /**
     * The ProductStack whose history will be retained as a snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.ProductStack getProductStack();

    /**
     * The description of the product version.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The directory where template snapshots will be stored.
     * <p>
     * Default: 'product-stack-snapshots'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectory() {
        return null;
    }

    /**
     * Whether the specified product template will be validated by CloudFormation.
     * <p>
     * If turned off, an invalid template configuration can be stored.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getValidateTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProductStackHistoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProductStackHistoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProductStackHistoryProps> {
        java.lang.Boolean currentVersionLocked;
        java.lang.String currentVersionName;
        software.amazon.awscdk.services.servicecatalog.ProductStack productStack;
        java.lang.String description;
        java.lang.String directory;
        java.lang.Boolean validateTemplate;

        /**
         * Sets the value of {@link ProductStackHistoryProps#getCurrentVersionLocked}
         * @param currentVersionLocked If this is set to true, the ProductStack will not be overwritten if a snapshot is found for the currentVersionName. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionLocked(java.lang.Boolean currentVersionLocked) {
            this.currentVersionLocked = currentVersionLocked;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackHistoryProps#getCurrentVersionName}
         * @param currentVersionName The current version name of the ProductStack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionName(java.lang.String currentVersionName) {
            this.currentVersionName = currentVersionName;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackHistoryProps#getProductStack}
         * @param productStack The ProductStack whose history will be retained as a snapshot. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productStack(software.amazon.awscdk.services.servicecatalog.ProductStack productStack) {
            this.productStack = productStack;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackHistoryProps#getDescription}
         * @param description The description of the product version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackHistoryProps#getDirectory}
         * @param directory The directory where template snapshots will be stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(java.lang.String directory) {
            this.directory = directory;
            return this;
        }

        /**
         * Sets the value of {@link ProductStackHistoryProps#getValidateTemplate}
         * @param validateTemplate Whether the specified product template will be validated by CloudFormation.
         *                         If turned off, an invalid template configuration can be stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateTemplate(java.lang.Boolean validateTemplate) {
            this.validateTemplate = validateTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProductStackHistoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProductStackHistoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProductStackHistoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductStackHistoryProps {
        private final java.lang.Boolean currentVersionLocked;
        private final java.lang.String currentVersionName;
        private final software.amazon.awscdk.services.servicecatalog.ProductStack productStack;
        private final java.lang.String description;
        private final java.lang.String directory;
        private final java.lang.Boolean validateTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.currentVersionLocked = software.amazon.jsii.Kernel.get(this, "currentVersionLocked", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.currentVersionName = software.amazon.jsii.Kernel.get(this, "currentVersionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productStack = software.amazon.jsii.Kernel.get(this, "productStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.ProductStack.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directory = software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validateTemplate = software.amazon.jsii.Kernel.get(this, "validateTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.currentVersionLocked = java.util.Objects.requireNonNull(builder.currentVersionLocked, "currentVersionLocked is required");
            this.currentVersionName = java.util.Objects.requireNonNull(builder.currentVersionName, "currentVersionName is required");
            this.productStack = java.util.Objects.requireNonNull(builder.productStack, "productStack is required");
            this.description = builder.description;
            this.directory = builder.directory;
            this.validateTemplate = builder.validateTemplate;
        }

        @Override
        public final java.lang.Boolean getCurrentVersionLocked() {
            return this.currentVersionLocked;
        }

        @Override
        public final java.lang.String getCurrentVersionName() {
            return this.currentVersionName;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.ProductStack getProductStack() {
            return this.productStack;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDirectory() {
            return this.directory;
        }

        @Override
        public final java.lang.Boolean getValidateTemplate() {
            return this.validateTemplate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("currentVersionLocked", om.valueToTree(this.getCurrentVersionLocked()));
            data.set("currentVersionName", om.valueToTree(this.getCurrentVersionName()));
            data.set("productStack", om.valueToTree(this.getProductStack()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDirectory() != null) {
                data.set("directory", om.valueToTree(this.getDirectory()));
            }
            if (this.getValidateTemplate() != null) {
                data.set("validateTemplate", om.valueToTree(this.getValidateTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.ProductStackHistoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProductStackHistoryProps.Jsii$Proxy that = (ProductStackHistoryProps.Jsii$Proxy) o;

            if (!currentVersionLocked.equals(that.currentVersionLocked)) return false;
            if (!currentVersionName.equals(that.currentVersionName)) return false;
            if (!productStack.equals(that.productStack)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.directory != null ? !this.directory.equals(that.directory) : that.directory != null) return false;
            return this.validateTemplate != null ? this.validateTemplate.equals(that.validateTemplate) : that.validateTemplate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.currentVersionLocked.hashCode();
            result = 31 * result + (this.currentVersionName.hashCode());
            result = 31 * result + (this.productStack.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
            result = 31 * result + (this.validateTemplate != null ? this.validateTemplate.hashCode() : 0);
            return result;
        }
    }
}
