package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnEndpointConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpointConfigProps cfnEndpointConfigProps = CfnEndpointConfigProps.builder()
 *         .productionVariants(List.of(ProductionVariantProperty.builder()
 *                 .initialVariantWeight(123)
 *                 .modelName("modelName")
 *                 .variantName("variantName")
 *                 // the properties below are optional
 *                 .acceleratorType("acceleratorType")
 *                 .initialInstanceCount(123)
 *                 .instanceType("instanceType")
 *                 .serverlessConfig(ServerlessConfigProperty.builder()
 *                         .maxConcurrency(123)
 *                         .memorySizeInMb(123)
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .asyncInferenceConfig(AsyncInferenceConfigProperty.builder()
 *                 .outputConfig(AsyncInferenceOutputConfigProperty.builder()
 *                         .s3OutputPath("s3OutputPath")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
 *                                 .errorTopic("errorTopic")
 *                                 .successTopic("successTopic")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .clientConfig(AsyncInferenceClientConfigProperty.builder()
 *                         .maxConcurrentInvocationsPerInstance(123)
 *                         .build())
 *                 .build())
 *         .dataCaptureConfig(DataCaptureConfigProperty.builder()
 *                 .captureOptions(List.of(CaptureOptionProperty.builder()
 *                         .captureMode("captureMode")
 *                         .build()))
 *                 .destinationS3Uri("destinationS3Uri")
 *                 .initialSamplingPercentage(123)
 *                 // the properties below are optional
 *                 .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
 *                         .csvContentTypes(List.of("csvContentTypes"))
 *                         .jsonContentTypes(List.of("jsonContentTypes"))
 *                         .build())
 *                 .enableCapture(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .endpointConfigName("endpointConfigName")
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.388Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants();

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAsyncInferenceConfig() {
        return null;
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     * <p>
     * The data capture configuration applies to all production variants hosted at the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataCaptureConfig() {
        return null;
    }

    /**
     * The name of the endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     * <p>
     * <ul>
     * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
     * <li>Alias name: <code>alias/ExampleAlias</code></li>
     * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
     * </ul>
     * <p>
     * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
     * <p>
     * <blockquote>
     * <p>
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
     * <p>
     * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
     * <p>
     * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * A list of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointConfigProps> {
        java.lang.Object productionVariants;
        java.lang.Object asyncInferenceConfig;
        java.lang.Object dataCaptureConfig;
        java.lang.String endpointConfigName;
        java.lang.String kmsKeyId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(software.amazon.awscdk.IResolvable productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants A list of `ProductionVariant` objects, one for each model that you want to host at this endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(java.util.List<? extends java.lang.Object> productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getAsyncInferenceConfig}
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getAsyncInferenceConfig}
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(software.amazon.awscdk.IResolvable asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getDataCaptureConfig}
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor.
         *                          The data capture configuration applies to all production variants hosted at the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getDataCaptureConfig}
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor.
         *                          The data capture configuration applies to all production variants hosted at the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(software.amazon.awscdk.IResolvable dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getEndpointConfigName}
         * @param endpointConfigName The name of the endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(java.lang.String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         *                 <ul>
         *                 <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         *                 <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         *                 <li>Alias name: <code>alias/ExampleAlias</code></li>
         *                 <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
         *                 </ul>
         *                 <p>
         *                 The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
         *                 <p>
         *                 For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         *                 <p>
         *                 For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getTags}
         * @param tags A list of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointConfigProps {
        private final java.lang.Object productionVariants;
        private final java.lang.Object asyncInferenceConfig;
        private final java.lang.Object dataCaptureConfig;
        private final java.lang.String endpointConfigName;
        private final java.lang.String kmsKeyId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.productionVariants = software.amazon.jsii.Kernel.get(this, "productionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.asyncInferenceConfig = software.amazon.jsii.Kernel.get(this, "asyncInferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataCaptureConfig = software.amazon.jsii.Kernel.get(this, "dataCaptureConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointConfigName = software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.productionVariants = java.util.Objects.requireNonNull(builder.productionVariants, "productionVariants is required");
            this.asyncInferenceConfig = builder.asyncInferenceConfig;
            this.dataCaptureConfig = builder.dataCaptureConfig;
            this.endpointConfigName = builder.endpointConfigName;
            this.kmsKeyId = builder.kmsKeyId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getProductionVariants() {
            return this.productionVariants;
        }

        @Override
        public final java.lang.Object getAsyncInferenceConfig() {
            return this.asyncInferenceConfig;
        }

        @Override
        public final java.lang.Object getDataCaptureConfig() {
            return this.dataCaptureConfig;
        }

        @Override
        public final java.lang.String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("productionVariants", om.valueToTree(this.getProductionVariants()));
            if (this.getAsyncInferenceConfig() != null) {
                data.set("asyncInferenceConfig", om.valueToTree(this.getAsyncInferenceConfig()));
            }
            if (this.getDataCaptureConfig() != null) {
                data.set("dataCaptureConfig", om.valueToTree(this.getDataCaptureConfig()));
            }
            if (this.getEndpointConfigName() != null) {
                data.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointConfigProps.Jsii$Proxy that = (CfnEndpointConfigProps.Jsii$Proxy) o;

            if (!productionVariants.equals(that.productionVariants)) return false;
            if (this.asyncInferenceConfig != null ? !this.asyncInferenceConfig.equals(that.asyncInferenceConfig) : that.asyncInferenceConfig != null) return false;
            if (this.dataCaptureConfig != null ? !this.dataCaptureConfig.equals(that.dataCaptureConfig) : that.dataCaptureConfig != null) return false;
            if (this.endpointConfigName != null ? !this.endpointConfigName.equals(that.endpointConfigName) : that.endpointConfigName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.productionVariants.hashCode();
            result = 31 * result + (this.asyncInferenceConfig != null ? this.asyncInferenceConfig.hashCode() : 0);
            result = 31 * result + (this.dataCaptureConfig != null ? this.dataCaptureConfig.hashCode() : 0);
            result = 31 * result + (this.endpointConfigName != null ? this.endpointConfigName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
