package software.amazon.awscdk.services.route53;

/**
 * Properties for defining a `CfnKeySigningKey`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnKeySigningKeyProps cfnKeySigningKeyProps = CfnKeySigningKeyProps.builder()
 *         .hostedZoneId("hostedZoneId")
 *         .keyManagementServiceArn("keyManagementServiceArn")
 *         .name("name")
 *         .status("status")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.126Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnKeySigningKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeySigningKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeySigningKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique string (ID) that is used to identify a hosted zone.
     * <p>
     * For example: <code>Z00001111A1ABCaaABC11</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

    /**
     * The Amazon resource name (ARN) for a customer managed customer master key (CMK) in AWS Key Management Service ( AWS KMS ).
     * <p>
     * The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. For example: <code>arn:aws:kms:us-east-1:111122223333:key/111a2222-a11b-1ab1-2ab2-1ab21a2b3a111</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyManagementServiceArn();

    /**
     * A string used to identify a key-signing key (KSK).
     * <p>
     * <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A string that represents the current key-signing key (KSK) status.
     * <p>
     * Status can have one of the following values:
     * <p>
     * <ul>
     * <li><strong>ACTIVE</strong> - The KSK is being used for signing.</li>
     * <li><strong>INACTIVE</strong> - The KSK is not being used for signing.</li>
     * <li><strong>DELETING</strong> - The KSK is in the process of being deleted.</li>
     * <li><strong>ACTION_NEEDED</strong> - There is a problem with the KSK that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.</li>
     * <li><strong>INTERNAL_FAILURE</strong> - There was an error during a request. Before you can continue to work with DNSSEC signing, including actions that involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the KSK.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * @return a {@link Builder} of {@link CfnKeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeySigningKeyProps> {
        java.lang.String hostedZoneId;
        java.lang.String keyManagementServiceArn;
        java.lang.String name;
        java.lang.String status;

        /**
         * Sets the value of {@link CfnKeySigningKeyProps#getHostedZoneId}
         * @param hostedZoneId The unique string (ID) that is used to identify a hosted zone. This parameter is required.
         *                     For example: <code>Z00001111A1ABCaaABC11</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeySigningKeyProps#getKeyManagementServiceArn}
         * @param keyManagementServiceArn The Amazon resource name (ARN) for a customer managed customer master key (CMK) in AWS Key Management Service ( AWS KMS ). This parameter is required.
         *                                The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. For example: <code>arn:aws:kms:us-east-1:111122223333:key/111a2222-a11b-1ab1-2ab2-1ab21a2b3a111</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyManagementServiceArn(java.lang.String keyManagementServiceArn) {
            this.keyManagementServiceArn = keyManagementServiceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeySigningKeyProps#getName}
         * @param name A string used to identify a key-signing key (KSK). This parameter is required.
         *             <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeySigningKeyProps#getStatus}
         * @param status A string that represents the current key-signing key (KSK) status. This parameter is required.
         *               Status can have one of the following values:
         *               <p>
         *               <ul>
         *               <li><strong>ACTIVE</strong> - The KSK is being used for signing.</li>
         *               <li><strong>INACTIVE</strong> - The KSK is not being used for signing.</li>
         *               <li><strong>DELETING</strong> - The KSK is in the process of being deleted.</li>
         *               <li><strong>ACTION_NEEDED</strong> - There is a problem with the KSK that requires you to take action to resolve. For example, the customer managed key might have been deleted, or the permissions for the customer managed key might have been changed.</li>
         *               <li><strong>INTERNAL_FAILURE</strong> - There was an error during a request. Before you can continue to work with DNSSEC signing, including actions that involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the KSK.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeySigningKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeySigningKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeySigningKeyProps {
        private final java.lang.String hostedZoneId;
        private final java.lang.String keyManagementServiceArn;
        private final java.lang.String name;
        private final java.lang.String status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyManagementServiceArn = software.amazon.jsii.Kernel.get(this, "keyManagementServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZoneId = java.util.Objects.requireNonNull(builder.hostedZoneId, "hostedZoneId is required");
            this.keyManagementServiceArn = java.util.Objects.requireNonNull(builder.keyManagementServiceArn, "keyManagementServiceArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
        }

        @Override
        public final java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final java.lang.String getKeyManagementServiceArn() {
            return this.keyManagementServiceArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
            data.set("keyManagementServiceArn", om.valueToTree(this.getKeyManagementServiceArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("status", om.valueToTree(this.getStatus()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnKeySigningKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeySigningKeyProps.Jsii$Proxy that = (CfnKeySigningKeyProps.Jsii$Proxy) o;

            if (!hostedZoneId.equals(that.hostedZoneId)) return false;
            if (!keyManagementServiceArn.equals(that.keyManagementServiceArn)) return false;
            if (!name.equals(that.name)) return false;
            return this.status.equals(that.status);
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZoneId.hashCode();
            result = 31 * result + (this.keyManagementServiceArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.status.hashCode());
            return result;
        }
    }
}
