package software.amazon.awscdk.services.redshift;

/**
 * A CloudFormation `AWS::Redshift::Cluster`.
 * <p>
 * Specifies a cluster. A <em>cluster</em> is a fully managed data warehouse that consists of a set of compute nodes.
 * <p>
 * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .clusterType("clusterType")
 *         .dbName("dbName")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .nodeType("nodeType")
 *         // the properties below are optional
 *         .allowVersionUpgrade(false)
 *         .aquaConfigurationStatus("aquaConfigurationStatus")
 *         .automatedSnapshotRetentionPeriod(123)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneRelocation(false)
 *         .availabilityZoneRelocationStatus("availabilityZoneRelocationStatus")
 *         .classic(false)
 *         .clusterIdentifier("clusterIdentifier")
 *         .clusterParameterGroupName("clusterParameterGroupName")
 *         .clusterSecurityGroups(List.of("clusterSecurityGroups"))
 *         .clusterSubnetGroupName("clusterSubnetGroupName")
 *         .clusterVersion("clusterVersion")
 *         .deferMaintenance(false)
 *         .deferMaintenanceDuration(123)
 *         .deferMaintenanceEndTime("deferMaintenanceEndTime")
 *         .deferMaintenanceStartTime("deferMaintenanceStartTime")
 *         .destinationRegion("destinationRegion")
 *         .elasticIp("elasticIp")
 *         .encrypted(false)
 *         .enhancedVpcRouting(false)
 *         .hsmClientCertificateIdentifier("hsmClientCertificateIdentifier")
 *         .hsmConfigurationIdentifier("hsmConfigurationIdentifier")
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .loggingProperties(LoggingPropertiesProperty.builder()
 *                 .bucketName("bucketName")
 *                 // the properties below are optional
 *                 .s3KeyPrefix("s3KeyPrefix")
 *                 .build())
 *         .maintenanceTrackName("maintenanceTrackName")
 *         .manualSnapshotRetentionPeriod(123)
 *         .numberOfNodes(123)
 *         .ownerAccount("ownerAccount")
 *         .port(123)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .resourceAction("resourceAction")
 *         .revisionTarget("revisionTarget")
 *         .rotateEncryptionKey(false)
 *         .snapshotClusterIdentifier("snapshotClusterIdentifier")
 *         .snapshotCopyGrantName("snapshotCopyGrantName")
 *         .snapshotCopyManual(false)
 *         .snapshotCopyRetentionPeriod(123)
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.025Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Redshift::Cluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDeferMaintenanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrDeferMaintenanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The connection endpoint for the Amazon Redshift cluster.
     * <p>
     * For example: <code>examplecluster.cg034hpkmmjt.us-east-1.redshift.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the Amazon Redshift cluster accepts connections.
     * <p>
     * For example: <code>5439</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the cluster.
     * <p>
     * You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
     * <p>
     * Example: <code>myexamplecluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tag instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of the cluster. When cluster type is specified as.
     * <p>
     * <ul>
     * <li><code>single-node</code> , the <em>NumberOfNodes</em> parameter is not required.</li>
     * <li><code>multi-node</code> , the <em>NumberOfNodes</em> parameter is required.</li>
     * </ul>
     * <p>
     * Valid Values: <code>multi-node</code> | <code>single-node</code>
     * <p>
     * Default: <code>multi-node</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterType() {
        return software.amazon.jsii.Kernel.get(this, "clusterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the cluster. When cluster type is specified as.
     * <p>
     * <ul>
     * <li><code>single-node</code> , the <em>NumberOfNodes</em> parameter is not required.</li>
     * <li><code>multi-node</code> , the <em>NumberOfNodes</em> parameter is required.</li>
     * </ul>
     * <p>
     * Valid Values: <code>multi-node</code> | <code>single-node</code>
     * <p>
     * Default: <code>multi-node</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterType", java.util.Objects.requireNonNull(value, "clusterType is required"));
    }

    /**
     * The name of the first database to be created when the cluster is created.
     * <p>
     * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide.
     * <p>
     * Default: <code>dev</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 alphanumeric characters.</li>
     * <li>Must contain only lowercase letters.</li>
     * <li>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbName() {
        return software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the first database to be created when the cluster is created.
     * <p>
     * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide.
     * <p>
     * Default: <code>dev</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 alphanumeric characters.</li>
     * <li>Must contain only lowercase letters.</li>
     * <li>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbName", java.util.Objects.requireNonNull(value, "dbName is required"));
    }

    /**
     * The user name associated with the admin user account for the cluster that is being created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code> .</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user name associated with the admin user account for the cluster that is being created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code> .</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", java.util.Objects.requireNonNull(value, "masterUsername is required"));
    }

    /**
     * The password associated with the admin user account for the cluster that is being created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be between 8 and 64 characters in length.</li>
     * <li>Must contain at least one uppercase letter.</li>
     * <li>Must contain at least one lowercase letter.</li>
     * <li>Must contain one number.</li>
     * <li>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), , /, or &#64;.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password associated with the admin user account for the cluster that is being created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be between 8 and 64 characters in length.</li>
     * <li>Must contain at least one uppercase letter.</li>
     * <li>Must contain at least one lowercase letter.</li>
     * <li>Must contain one number.</li>
     * <li>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), , /, or &#64;.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", java.util.Objects.requireNonNull(value, "masterUserPassword is required"));
    }

    /**
     * The node type to be provisioned for the cluster.
     * <p>
     * For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNodeType() {
        return software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The node type to be provisioned for the cluster.
     * <p>
     * For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "nodeType", java.util.Objects.requireNonNull(value, "nodeType is required"));
    }

    /**
     * If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     * <p>
     * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
     * <p>
     * Default: <code>true</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "allowVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     * <p>
     * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
     * <p>
     * Default: <code>true</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowVersionUpgrade", value);
    }

    /**
     * If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     * <p>
     * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
     * <p>
     * Default: <code>true</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowVersionUpgrade", value);
    }

    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created.
     * <p>
     * Possible values include the following.
     * <p>
     * <ul>
     * <li>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</li>
     * <li>disabled - Don't use AQUA.</li>
     * <li>auto - Amazon Redshift determines whether to use AQUA.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAquaConfigurationStatus() {
        return software.amazon.jsii.Kernel.get(this, "aquaConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created.
     * <p>
     * Possible values include the following.
     * <p>
     * <ul>
     * <li>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</li>
     * <li>disabled - Don't use AQUA.</li>
     * <li>auto - Amazon Redshift determines whether to use AQUA.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAquaConfigurationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "aquaConfigurationStatus", value);
    }

    /**
     * The number of days that automated snapshots are retained.
     * <p>
     * If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html">CreateClusterSnapshot</a> in the <em>Amazon Redshift API Reference</em> .
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "automatedSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days that automated snapshots are retained.
     * <p>
     * If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html">CreateClusterSnapshot</a> in the <em>Amazon Redshift API Reference</em> .
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomatedSnapshotRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "automatedSnapshotRetentionPeriod", value);
    }

    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster.
     * <p>
     * For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
     * <p>
     * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
     * <p>
     * Example: <code>us-east-2d</code>
     * <p>
     * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster.
     * <p>
     * For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
     * <p>
     * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
     * <p>
     * Example: <code>us-east-2d</code>
     * <p>
     * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneRelocation() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneRelocation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneRelocation", value);
    }

    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneRelocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneRelocation", value);
    }

    /**
     * Describes the status of the Availability Zone relocation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneRelocationStatus() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Describes the status of the Availability Zone relocation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneRelocationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneRelocationStatus", value);
    }

    /**
     * A boolean value indicating whether the resize operation is using the classic resize process.
     * <p>
     * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClassic() {
        return software.amazon.jsii.Kernel.get(this, "classic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A boolean value indicating whether the resize operation is using the classic resize process.
     * <p>
     * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassic(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "classic", value);
    }

    /**
     * A boolean value indicating whether the resize operation is using the classic resize process.
     * <p>
     * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassic(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "classic", value);
    }

    /**
     * A unique identifier for the cluster.
     * <p>
     * You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li>
     * <li>Alphabetic characters must be lowercase.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * <li>Must be unique for all clusters within an AWS account .</li>
     * </ul>
     * <p>
     * Example: <code>myexamplecluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the cluster.
     * <p>
     * You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li>
     * <li>Alphabetic characters must be lowercase.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * <li>Must be unique for all clusters within an AWS account .</li>
     * </ul>
     * <p>
     * Example: <code>myexamplecluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterIdentifier", value);
    }

    /**
     * The name of the parameter group to be associated with this cluster.
     * <p>
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "clusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the parameter group to be associated with this cluster.
     * <p>
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterParameterGroupName", value);
    }

    /**
     * A list of security groups to be associated with this cluster.
     * <p>
     * Default: The default cluster security group for Amazon Redshift.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClusterSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "clusterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of security groups to be associated with this cluster.
     * <p>
     * Default: The default cluster security group for Amazon Redshift.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "clusterSecurityGroups", value);
    }

    /**
     * The name of a cluster subnet group to be associated with this cluster.
     * <p>
     * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "clusterSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a cluster subnet group to be associated with this cluster.
     * <p>
     * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterSubnetGroupName", value);
    }

    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * <p>
     * The version selected runs on all the nodes in the cluster.
     * <p>
     * Constraints: Only version 1.0 is currently available.
     * <p>
     * Example: <code>1.0</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterVersion() {
        return software.amazon.jsii.Kernel.get(this, "clusterVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * <p>
     * The version selected runs on all the nodes in the cluster.
     * <p>
     * Constraints: Only version 1.0 is currently available.
     * <p>
     * Example: <code>1.0</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterVersion", value);
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenance`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeferMaintenance() {
        return software.amazon.jsii.Kernel.get(this, "deferMaintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenance`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeferMaintenance(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deferMaintenance", value);
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenance`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeferMaintenance(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deferMaintenance", value);
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceDuration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDeferMaintenanceDuration() {
        return software.amazon.jsii.Kernel.get(this, "deferMaintenanceDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceDuration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeferMaintenanceDuration(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "deferMaintenanceDuration", value);
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceEndTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceEndTime() {
        return software.amazon.jsii.Kernel.get(this, "deferMaintenanceEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceEndTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeferMaintenanceEndTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deferMaintenanceEndTime", value);
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceStartTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceStartTime() {
        return software.amazon.jsii.Kernel.get(this, "deferMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Redshift::Cluster.DeferMaintenanceStartTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeferMaintenanceStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deferMaintenanceStartTime", value);
    }

    /**
     * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationRegion() {
        return software.amazon.jsii.Kernel.get(this, "destinationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationRegion", value);
    }

    /**
     * The Elastic IP (EIP) address for the cluster.
     * <p>
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getElasticIp() {
        return software.amazon.jsii.Kernel.get(this, "elasticIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Elastic IP (EIP) address for the cluster.
     * <p>
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticIp(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "elasticIp", value);
    }

    /**
     * If `true` , the data in the cluster is encrypted at rest.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If `true` , the data in the cluster is encrypted at rest.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * If `true` , the data in the cluster is encrypted at rest.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
     * <p>
     * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
     * <p>
     * If this option is <code>true</code> , enhanced VPC routing is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
     * <p>
     * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
     * <p>
     * If this option is <code>true</code> , enhanced VPC routing is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
     * <p>
     * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
     * <p>
     * If this option is <code>true</code> , enhanced VPC routing is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHsmClientCertificateIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "hsmClientCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHsmClientCertificateIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hsmClientCertificateIdentifier", value);
    }

    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHsmConfigurationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "hsmConfigurationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHsmConfigurationIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hsmConfigurationIdentifier", value);
    }

    /**
     * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.
     * <p>
     * You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.
     * <p>
     * You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "iamRoles", value);
    }

    /**
     * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingProperties() {
        return software.amazon.jsii.Kernel.get(this, "loggingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.CfnCluster.LoggingPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingProperties", value);
    }

    /**
     * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingProperties", value);
    }

    /**
     * An optional parameter for the name of the maintenance track for the cluster.
     * <p>
     * If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaintenanceTrackName() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceTrackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional parameter for the name of the maintenance track for the cluster.
     * <p>
     * If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceTrackName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceTrackName", value);
    }

    /**
     * The default number of days to retain a manual snapshot.
     * <p>
     * If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getManualSnapshotRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "manualSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default number of days to retain a manual snapshot.
     * <p>
     * If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManualSnapshotRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "manualSnapshotRetentionPeriod", value);
    }

    /**
     * The number of compute nodes in the cluster.
     * <p>
     * This parameter is required when the <em>ClusterType</em> parameter is specified as <code>multi-node</code> .
     * <p>
     * For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Value must be at least 1 and no more than 100.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
        return software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of compute nodes in the cluster.
     * <p>
     * This parameter is required when the <em>ClusterType</em> parameter is specified as <code>multi-node</code> .
     * <p>
     * For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Value must be at least 1 and no more than 100.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumberOfNodes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numberOfNodes", value);
    }

    /**
     * The AWS account used to create or copy the snapshot.
     * <p>
     * Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccount() {
        return software.amazon.jsii.Kernel.get(this, "ownerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account used to create or copy the snapshot.
     * <p>
     * Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnerAccount(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ownerAccount", value);
    }

    /**
     * The port number on which the cluster accepts incoming connections.
     * <p>
     * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * <p>
     * Default: <code>5439</code>
     * <p>
     * Valid Values: <code>1150-65535</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number on which the cluster accepts incoming connections.
     * <p>
     * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * <p>
     * Default: <code>5439</code>
     * <p>
     * Valid Values: <code>1150-65535</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * If `true` , the cluster can be accessed from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If `true` , the cluster can be accessed from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * If `true` , the cluster can be accessed from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * `AWS::Redshift::Cluster.ResourceAction`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceAction() {
        return software.amazon.jsii.Kernel.get(this, "resourceAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Redshift::Cluster.ResourceAction`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceAction(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceAction", value);
    }

    /**
     * `AWS::Redshift::Cluster.RevisionTarget`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRevisionTarget() {
        return software.amazon.jsii.Kernel.get(this, "revisionTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Redshift::Cluster.RevisionTarget`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRevisionTarget(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "revisionTarget", value);
    }

    /**
     * `AWS::Redshift::Cluster.RotateEncryptionKey`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotateEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "rotateEncryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Redshift::Cluster.RotateEncryptionKey`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateEncryptionKey(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "rotateEncryptionKey", value);
    }

    /**
     * `AWS::Redshift::Cluster.RotateEncryptionKey`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateEncryptionKey(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rotateEncryptionKey", value);
    }

    /**
     * The name of the cluster the source snapshot was created from.
     * <p>
     * This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cluster the source snapshot was created from.
     * <p>
     * This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotClusterIdentifier", value);
    }

    /**
     * The name of the snapshot copy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotCopyGrantName() {
        return software.amazon.jsii.Kernel.get(this, "snapshotCopyGrantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the snapshot copy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyGrantName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotCopyGrantName", value);
    }

    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotCopyManual() {
        return software.amazon.jsii.Kernel.get(this, "snapshotCopyManual", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyManual(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "snapshotCopyManual", value);
    }

    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyManual(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snapshotCopyManual", value);
    }

    /**
     * The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region .
     * <p>
     * By default, this only changes the retention period of copied automated snapshots.
     * <p>
     * If you decrease the retention period for automated snapshots that are copied to a destination AWS Region , Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.
     * <p>
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     * <p>
     * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period.
     * <p>
     * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     * <p>
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotCopyRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "snapshotCopyRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region .
     * <p>
     * By default, this only changes the retention period of copied automated snapshots.
     * <p>
     * If you decrease the retention period for automated snapshots that are copied to a destination AWS Region , Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.
     * <p>
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     * <p>
     * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period.
     * <p>
     * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     * <p>
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotCopyRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "snapshotCopyRetentionPeriod", value);
    }

    /**
     * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
     * <p>
     * Example: <code>my-snapshot-id</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
     * <p>
     * Example: <code>my-snapshot-id</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotIdentifier", value);
    }

    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * <p>
     * Default: The default VPC security group is associated with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * <p>
     * Default: The default VPC security group is associated with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     * Describes a connection endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .port("port")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnCluster.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS address of the Cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * The port that the database engine is listening on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.String port;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address The DNS address of the Cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port The port that the database engine is listening on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.String port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnCluster.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * LoggingPropertiesProperty loggingPropertiesProperty = LoggingPropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnCluster.LoggingPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an existing S3 bucket where the log files are to be stored.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the same region as the cluster</li>
         * <li>The cluster must have read bucket and put object permissions</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The prefix applied to the log file names.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Cannot exceed 512 characters</li>
         * <li>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (), or control characters. The hexadecimal codes for invalid characters are:</li>
         * <li>x00 to x20</li>
         * <li>x22</li>
         * <li>x27</li>
         * <li>x5c</li>
         * <li>x7f or larger</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingPropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link LoggingPropertiesProperty#getBucketName}
             * @param bucketName The name of an existing S3 bucket where the log files are to be stored. This parameter is required.
             *                   Constraints:
             *                   <p>
             *                   <ul>
             *                   <li>Must be in the same region as the cluster</li>
             *                   <li>The cluster must have read bucket and put object permissions</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link LoggingPropertiesProperty#getS3KeyPrefix}
             * @param s3KeyPrefix The prefix applied to the log file names.
             *                    Constraints:
             *                    <p>
             *                    <ul>
             *                    <li>Cannot exceed 512 characters</li>
             *                    <li>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (), or control characters. The hexadecimal codes for invalid characters are:</li>
             *                    <li>x00 to x20</li>
             *                    <li>x22</li>
             *                    <li>x27</li>
             *                    <li>x5c</li>
             *                    <li>x7f or larger</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingPropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnCluster.LoggingPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingPropertiesProperty.Jsii$Proxy that = (LoggingPropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshift.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshift.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshift.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshift.CfnClusterProps.Builder();
        }

        /**
         * The type of the cluster. When cluster type is specified as.
         * <p>
         * <ul>
         * <li><code>single-node</code> , the <em>NumberOfNodes</em> parameter is not required.</li>
         * <li><code>multi-node</code> , the <em>NumberOfNodes</em> parameter is required.</li>
         * </ul>
         * <p>
         * Valid Values: <code>multi-node</code> | <code>single-node</code>
         * <p>
         * Default: <code>multi-node</code>
         * <p>
         * @return {@code this}
         * @param clusterType The type of the cluster. When cluster type is specified as. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterType(final java.lang.String clusterType) {
            this.props.clusterType(clusterType);
            return this;
        }

        /**
         * The name of the first database to be created when the cluster is created.
         * <p>
         * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide.
         * <p>
         * Default: <code>dev</code>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 alphanumeric characters.</li>
         * <li>Must contain only lowercase letters.</li>
         * <li>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param dbName The name of the first database to be created when the cluster is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(final java.lang.String dbName) {
            this.props.dbName(dbName);
            return this;
        }

        /**
         * The user name associated with the admin user account for the cluster that is being created.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code> .</li>
         * <li>First character must be a letter.</li>
         * <li>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param masterUsername The user name associated with the admin user account for the cluster that is being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        /**
         * The password associated with the admin user account for the cluster that is being created.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be between 8 and 64 characters in length.</li>
         * <li>Must contain at least one uppercase letter.</li>
         * <li>Must contain at least one lowercase letter.</li>
         * <li>Must contain one number.</li>
         * <li>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), , /, or &#64;.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param masterUserPassword The password associated with the admin user account for the cluster that is being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The node type to be provisioned for the cluster.
         * <p>
         * For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * <p>
         * Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
         * <p>
         * @return {@code this}
         * @param nodeType The node type to be provisioned for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(final java.lang.String nodeType) {
            this.props.nodeType(nodeType);
            return this;
        }

        /**
         * If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         * <p>
         * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
         * <p>
         * Default: <code>true</code>
         * <p>
         * @return {@code this}
         * @param allowVersionUpgrade If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(final java.lang.Boolean allowVersionUpgrade) {
            this.props.allowVersionUpgrade(allowVersionUpgrade);
            return this;
        }
        /**
         * If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         * <p>
         * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
         * <p>
         * Default: <code>true</code>
         * <p>
         * @return {@code this}
         * @param allowVersionUpgrade If `true` , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(final software.amazon.awscdk.IResolvable allowVersionUpgrade) {
            this.props.allowVersionUpgrade(allowVersionUpgrade);
            return this;
        }

        /**
         * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created.
         * <p>
         * Possible values include the following.
         * <p>
         * <ul>
         * <li>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</li>
         * <li>disabled - Don't use AQUA.</li>
         * <li>auto - Amazon Redshift determines whether to use AQUA.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param aquaConfigurationStatus The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aquaConfigurationStatus(final java.lang.String aquaConfigurationStatus) {
            this.props.aquaConfigurationStatus(aquaConfigurationStatus);
            return this;
        }

        /**
         * The number of days that automated snapshots are retained.
         * <p>
         * If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html">CreateClusterSnapshot</a> in the <em>Amazon Redshift API Reference</em> .
         * <p>
         * Default: <code>1</code>
         * <p>
         * Constraints: Must be a value from 0 to 35.
         * <p>
         * @return {@code this}
         * @param automatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatedSnapshotRetentionPeriod(final java.lang.Number automatedSnapshotRetentionPeriod) {
            this.props.automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod);
            return this;
        }

        /**
         * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster.
         * <p>
         * For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
         * <p>
         * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
         * <p>
         * Example: <code>us-east-2d</code>
         * <p>
         * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
         * <p>
         * @return {@code this}
         * @param availabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
         * <p>
         * @return {@code this}
         * @param availabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(final java.lang.Boolean availabilityZoneRelocation) {
            this.props.availabilityZoneRelocation(availabilityZoneRelocation);
            return this;
        }
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
         * <p>
         * @return {@code this}
         * @param availabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(final software.amazon.awscdk.IResolvable availabilityZoneRelocation) {
            this.props.availabilityZoneRelocation(availabilityZoneRelocation);
            return this;
        }

        /**
         * Describes the status of the Availability Zone relocation operation.
         * <p>
         * @return {@code this}
         * @param availabilityZoneRelocationStatus Describes the status of the Availability Zone relocation operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocationStatus(final java.lang.String availabilityZoneRelocationStatus) {
            this.props.availabilityZoneRelocationStatus(availabilityZoneRelocationStatus);
            return this;
        }

        /**
         * A boolean value indicating whether the resize operation is using the classic resize process.
         * <p>
         * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
         * <p>
         * @return {@code this}
         * @param classic A boolean value indicating whether the resize operation is using the classic resize process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(final java.lang.Boolean classic) {
            this.props.classic(classic);
            return this;
        }
        /**
         * A boolean value indicating whether the resize operation is using the classic resize process.
         * <p>
         * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
         * <p>
         * @return {@code this}
         * @param classic A boolean value indicating whether the resize operation is using the classic resize process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(final software.amazon.awscdk.IResolvable classic) {
            this.props.classic(classic);
            return this;
        }

        /**
         * A unique identifier for the cluster.
         * <p>
         * You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li>
         * <li>Alphabetic characters must be lowercase.</li>
         * <li>First character must be a letter.</li>
         * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         * <li>Must be unique for all clusters within an AWS account .</li>
         * </ul>
         * <p>
         * Example: <code>myexamplecluster</code>
         * <p>
         * @return {@code this}
         * @param clusterIdentifier A unique identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(final java.lang.String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        /**
         * The name of the parameter group to be associated with this cluster.
         * <p>
         * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be 1 to 255 alphanumeric characters or hyphens.</li>
         * <li>First character must be a letter.</li>
         * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param clusterParameterGroupName The name of the parameter group to be associated with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterParameterGroupName(final java.lang.String clusterParameterGroupName) {
            this.props.clusterParameterGroupName(clusterParameterGroupName);
            return this;
        }

        /**
         * A list of security groups to be associated with this cluster.
         * <p>
         * Default: The default cluster security group for Amazon Redshift.
         * <p>
         * @return {@code this}
         * @param clusterSecurityGroups A list of security groups to be associated with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroups(final java.util.List<java.lang.String> clusterSecurityGroups) {
            this.props.clusterSecurityGroups(clusterSecurityGroups);
            return this;
        }

        /**
         * The name of a cluster subnet group to be associated with this cluster.
         * <p>
         * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
         * <p>
         * @return {@code this}
         * @param clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSubnetGroupName(final java.lang.String clusterSubnetGroupName) {
            this.props.clusterSubnetGroupName(clusterSubnetGroupName);
            return this;
        }

        /**
         * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
         * <p>
         * The version selected runs on all the nodes in the cluster.
         * <p>
         * Constraints: Only version 1.0 is currently available.
         * <p>
         * Example: <code>1.0</code>
         * <p>
         * @return {@code this}
         * @param clusterVersion The version of the Amazon Redshift engine software that you want to deploy on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterVersion(final java.lang.String clusterVersion) {
            this.props.clusterVersion(clusterVersion);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.DeferMaintenance`.
         * <p>
         * @return {@code this}
         * @param deferMaintenance `AWS::Redshift::Cluster.DeferMaintenance`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(final java.lang.Boolean deferMaintenance) {
            this.props.deferMaintenance(deferMaintenance);
            return this;
        }
        /**
         * `AWS::Redshift::Cluster.DeferMaintenance`.
         * <p>
         * @return {@code this}
         * @param deferMaintenance `AWS::Redshift::Cluster.DeferMaintenance`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(final software.amazon.awscdk.IResolvable deferMaintenance) {
            this.props.deferMaintenance(deferMaintenance);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.DeferMaintenanceDuration`.
         * <p>
         * @return {@code this}
         * @param deferMaintenanceDuration `AWS::Redshift::Cluster.DeferMaintenanceDuration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceDuration(final java.lang.Number deferMaintenanceDuration) {
            this.props.deferMaintenanceDuration(deferMaintenanceDuration);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.DeferMaintenanceEndTime`.
         * <p>
         * @return {@code this}
         * @param deferMaintenanceEndTime `AWS::Redshift::Cluster.DeferMaintenanceEndTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceEndTime(final java.lang.String deferMaintenanceEndTime) {
            this.props.deferMaintenanceEndTime(deferMaintenanceEndTime);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.DeferMaintenanceStartTime`.
         * <p>
         * @return {@code this}
         * @param deferMaintenanceStartTime `AWS::Redshift::Cluster.DeferMaintenanceStartTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceStartTime(final java.lang.String deferMaintenanceStartTime) {
            this.props.deferMaintenanceStartTime(deferMaintenanceStartTime);
            return this;
        }

        /**
         * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
         * <p>
         * @return {@code this}
         * @param destinationRegion The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationRegion(final java.lang.String destinationRegion) {
            this.props.destinationRegion(destinationRegion);
            return this;
        }

        /**
         * The Elastic IP (EIP) address for the cluster.
         * <p>
         * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
         * <p>
         * @return {@code this}
         * @param elasticIp The Elastic IP (EIP) address for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIp(final java.lang.String elasticIp) {
            this.props.elasticIp(elasticIp);
            return this;
        }

        /**
         * If `true` , the data in the cluster is encrypted at rest.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param encrypted If `true` , the data in the cluster is encrypted at rest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }
        /**
         * If `true` , the data in the cluster is encrypted at rest.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param encrypted If `true` , the data in the cluster is encrypted at rest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final software.amazon.awscdk.IResolvable encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
         * <p>
         * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
         * <p>
         * If this option is <code>true</code> , enhanced VPC routing is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC routing enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final java.lang.Boolean enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
         * <p>
         * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
         * <p>
         * If this option is <code>true</code> , enhanced VPC routing is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC routing enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final software.amazon.awscdk.IResolvable enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
         * <p>
         * @return {@code this}
         * @param hsmClientCertificateIdentifier Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmClientCertificateIdentifier(final java.lang.String hsmClientCertificateIdentifier) {
            this.props.hsmClientCertificateIdentifier(hsmClientCertificateIdentifier);
            return this;
        }

        /**
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         * <p>
         * @return {@code this}
         * @param hsmConfigurationIdentifier Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmConfigurationIdentifier(final java.lang.String hsmConfigurationIdentifier) {
            this.props.hsmConfigurationIdentifier(hsmConfigurationIdentifier);
            return this;
        }

        /**
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.
         * <p>
         * You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         * <p>
         * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * <p>
         * @return {@code this}
         * @param iamRoles A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(final java.util.List<java.lang.String> iamRoles) {
            this.props.iamRoles(iamRoles);
            return this;
        }

        /**
         * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * <p>
         * @return {@code this}
         * @param loggingProperties Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(final software.amazon.awscdk.services.redshift.CfnCluster.LoggingPropertiesProperty loggingProperties) {
            this.props.loggingProperties(loggingProperties);
            return this;
        }
        /**
         * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * <p>
         * @return {@code this}
         * @param loggingProperties Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(final software.amazon.awscdk.IResolvable loggingProperties) {
            this.props.loggingProperties(loggingProperties);
            return this;
        }

        /**
         * An optional parameter for the name of the maintenance track for the cluster.
         * <p>
         * If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.
         * <p>
         * @return {@code this}
         * @param maintenanceTrackName An optional parameter for the name of the maintenance track for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceTrackName(final java.lang.String maintenanceTrackName) {
            this.props.maintenanceTrackName(maintenanceTrackName);
            return this;
        }

        /**
         * The default number of days to retain a manual snapshot.
         * <p>
         * If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * <p>
         * @return {@code this}
         * @param manualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manualSnapshotRetentionPeriod(final java.lang.Number manualSnapshotRetentionPeriod) {
            this.props.manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod);
            return this;
        }

        /**
         * The number of compute nodes in the cluster.
         * <p>
         * This parameter is required when the <em>ClusterType</em> parameter is specified as <code>multi-node</code> .
         * <p>
         * For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * <p>
         * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
         * <p>
         * Default: <code>1</code>
         * <p>
         * Constraints: Value must be at least 1 and no more than 100.
         * <p>
         * @return {@code this}
         * @param numberOfNodes The number of compute nodes in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfNodes(final java.lang.Number numberOfNodes) {
            this.props.numberOfNodes(numberOfNodes);
            return this;
        }

        /**
         * The AWS account used to create or copy the snapshot.
         * <p>
         * Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         * <p>
         * @return {@code this}
         * @param ownerAccount The AWS account used to create or copy the snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerAccount(final java.lang.String ownerAccount) {
            this.props.ownerAccount(ownerAccount);
            return this;
        }

        /**
         * The port number on which the cluster accepts incoming connections.
         * <p>
         * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
         * <p>
         * Default: <code>5439</code>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * <p>
         * @return {@code this}
         * @param port The port number on which the cluster accepts incoming connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The weekly time range (in UTC) during which automated cluster maintenance can occur.
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster maintenance can occur. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * If `true` , the cluster can be accessed from a public network.
         * <p>
         * @return {@code this}
         * @param publiclyAccessible If `true` , the cluster can be accessed from a public network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * If `true` , the cluster can be accessed from a public network.
         * <p>
         * @return {@code this}
         * @param publiclyAccessible If `true` , the cluster can be accessed from a public network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.ResourceAction`.
         * <p>
         * @return {@code this}
         * @param resourceAction `AWS::Redshift::Cluster.ResourceAction`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceAction(final java.lang.String resourceAction) {
            this.props.resourceAction(resourceAction);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.RevisionTarget`.
         * <p>
         * @return {@code this}
         * @param revisionTarget `AWS::Redshift::Cluster.RevisionTarget`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revisionTarget(final java.lang.String revisionTarget) {
            this.props.revisionTarget(revisionTarget);
            return this;
        }

        /**
         * `AWS::Redshift::Cluster.RotateEncryptionKey`.
         * <p>
         * @return {@code this}
         * @param rotateEncryptionKey `AWS::Redshift::Cluster.RotateEncryptionKey`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(final java.lang.Boolean rotateEncryptionKey) {
            this.props.rotateEncryptionKey(rotateEncryptionKey);
            return this;
        }
        /**
         * `AWS::Redshift::Cluster.RotateEncryptionKey`.
         * <p>
         * @return {@code this}
         * @param rotateEncryptionKey `AWS::Redshift::Cluster.RotateEncryptionKey`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(final software.amazon.awscdk.IResolvable rotateEncryptionKey) {
            this.props.rotateEncryptionKey(rotateEncryptionKey);
            return this;
        }

        /**
         * The name of the cluster the source snapshot was created from.
         * <p>
         * This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         * <p>
         * @return {@code this}
         * @param snapshotClusterIdentifier The name of the cluster the source snapshot was created from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotClusterIdentifier(final java.lang.String snapshotClusterIdentifier) {
            this.props.snapshotClusterIdentifier(snapshotClusterIdentifier);
            return this;
        }

        /**
         * The name of the snapshot copy grant.
         * <p>
         * @return {@code this}
         * @param snapshotCopyGrantName The name of the snapshot copy grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyGrantName(final java.lang.String snapshotCopyGrantName) {
            this.props.snapshotCopyGrantName(snapshotCopyGrantName);
            return this;
        }

        /**
         * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
         * <p>
         * @return {@code this}
         * @param snapshotCopyManual Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(final java.lang.Boolean snapshotCopyManual) {
            this.props.snapshotCopyManual(snapshotCopyManual);
            return this;
        }
        /**
         * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
         * <p>
         * @return {@code this}
         * @param snapshotCopyManual Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(final software.amazon.awscdk.IResolvable snapshotCopyManual) {
            this.props.snapshotCopyManual(snapshotCopyManual);
            return this;
        }

        /**
         * The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region .
         * <p>
         * By default, this only changes the retention period of copied automated snapshots.
         * <p>
         * If you decrease the retention period for automated snapshots that are copied to a destination AWS Region , Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.
         * <p>
         * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         * <p>
         * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period.
         * <p>
         * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
         * <p>
         * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
         * <p>
         * @return {@code this}
         * @param snapshotCopyRetentionPeriod The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyRetentionPeriod(final java.lang.Number snapshotCopyRetentionPeriod) {
            this.props.snapshotCopyRetentionPeriod(snapshotCopyRetentionPeriod);
            return this;
        }

        /**
         * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
         * <p>
         * Example: <code>my-snapshot-id</code>
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * A list of tag instances.
         * <p>
         * @return {@code this}
         * @param tags A list of tag instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * <p>
         * Default: The default VPC security group is associated with the cluster.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.redshift.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshift.CfnCluster build() {
            return new software.amazon.awscdk.services.redshift.CfnCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
