package software.amazon.awscdk.services.qldb;

/**
 * Properties for defining a `CfnStream`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qldb.*;
 * CfnStreamProps cfnStreamProps = CfnStreamProps.builder()
 *         .inclusiveStartTime("inclusiveStartTime")
 *         .kinesisConfiguration(KinesisConfigurationProperty.builder()
 *                 .aggregationEnabled(false)
 *                 .streamArn("streamArn")
 *                 .build())
 *         .ledgerName("ledgerName")
 *         .roleArn("roleArn")
 *         .streamName("streamName")
 *         // the properties below are optional
 *         .exclusiveEndTime("exclusiveEndTime")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:09.789Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qldb.CfnStreamProps")
@software.amazon.jsii.Jsii.Proxy(CfnStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The inclusive start date and time from which to start streaming journal data.
     * <p>
     * This parameter must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code> .
     * <p>
     * The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code> .
     * <p>
     * If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code> , QLDB effectively defaults it to the ledger's <code>CreationDateTime</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInclusiveStartTime();

    /**
     * The configuration settings of the Kinesis Data Streams destination for your stream request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKinesisConfiguration();

    /**
     * The name of the ledger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLedgerName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     * <p>
     * To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal stream requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name that you want to assign to the QLDB journal stream.
     * <p>
     * User-defined names can help identify and indicate the purpose of a stream.
     * <p>
     * Your stream name must be unique among other <em>active</em> streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

    /**
     * The exclusive date and time that specifies when the stream ends.
     * <p>
     * If you don't define this parameter, the stream runs indefinitely until you cancel it.
     * <p>
     * The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExclusiveEndTime() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStreamProps> {
        java.lang.String inclusiveStartTime;
        java.lang.Object kinesisConfiguration;
        java.lang.String ledgerName;
        java.lang.String roleArn;
        java.lang.String streamName;
        java.lang.String exclusiveEndTime;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStreamProps#getInclusiveStartTime}
         * @param inclusiveStartTime The inclusive start date and time from which to start streaming journal data. This parameter is required.
         *                           This parameter must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code> .
         *                           <p>
         *                           The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code> .
         *                           <p>
         *                           If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code> , QLDB effectively defaults it to the ledger's <code>CreationDateTime</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inclusiveStartTime(java.lang.String inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getKinesisConfiguration}
         * @param kinesisConfiguration The configuration settings of the Kinesis Data Streams destination for your stream request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisConfiguration(software.amazon.awscdk.services.qldb.CfnStream.KinesisConfigurationProperty kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getKinesisConfiguration}
         * @param kinesisConfiguration The configuration settings of the Kinesis Data Streams destination for your stream request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisConfiguration(software.amazon.awscdk.IResolvable kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getLedgerName}
         * @param ledgerName The name of the ledger. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ledgerName(java.lang.String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource. This parameter is required.
         *                To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal stream requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getStreamName}
         * @param streamName The name that you want to assign to the QLDB journal stream. This parameter is required.
         *                   User-defined names can help identify and indicate the purpose of a stream.
         *                   <p>
         *                   Your stream name must be unique among other <em>active</em> streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <em>Amazon QLDB Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamName(java.lang.String streamName) {
            this.streamName = streamName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getExclusiveEndTime}
         * @param exclusiveEndTime The exclusive date and time that specifies when the stream ends.
         *                         If you don't define this parameter, the stream runs indefinitely until you cancel it.
         *                         <p>
         *                         The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusiveEndTime(java.lang.String exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamProps {
        private final java.lang.String inclusiveStartTime;
        private final java.lang.Object kinesisConfiguration;
        private final java.lang.String ledgerName;
        private final java.lang.String roleArn;
        private final java.lang.String streamName;
        private final java.lang.String exclusiveEndTime;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inclusiveStartTime = software.amazon.jsii.Kernel.get(this, "inclusiveStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kinesisConfiguration = software.amazon.jsii.Kernel.get(this, "kinesisConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ledgerName = software.amazon.jsii.Kernel.get(this, "ledgerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclusiveEndTime = software.amazon.jsii.Kernel.get(this, "exclusiveEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inclusiveStartTime = java.util.Objects.requireNonNull(builder.inclusiveStartTime, "inclusiveStartTime is required");
            this.kinesisConfiguration = java.util.Objects.requireNonNull(builder.kinesisConfiguration, "kinesisConfiguration is required");
            this.ledgerName = java.util.Objects.requireNonNull(builder.ledgerName, "ledgerName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
            this.exclusiveEndTime = builder.exclusiveEndTime;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInclusiveStartTime() {
            return this.inclusiveStartTime;
        }

        @Override
        public final java.lang.Object getKinesisConfiguration() {
            return this.kinesisConfiguration;
        }

        @Override
        public final java.lang.String getLedgerName() {
            return this.ledgerName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getStreamName() {
            return this.streamName;
        }

        @Override
        public final java.lang.String getExclusiveEndTime() {
            return this.exclusiveEndTime;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inclusiveStartTime", om.valueToTree(this.getInclusiveStartTime()));
            data.set("kinesisConfiguration", om.valueToTree(this.getKinesisConfiguration()));
            data.set("ledgerName", om.valueToTree(this.getLedgerName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("streamName", om.valueToTree(this.getStreamName()));
            if (this.getExclusiveEndTime() != null) {
                data.set("exclusiveEndTime", om.valueToTree(this.getExclusiveEndTime()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qldb.CfnStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamProps.Jsii$Proxy that = (CfnStreamProps.Jsii$Proxy) o;

            if (!inclusiveStartTime.equals(that.inclusiveStartTime)) return false;
            if (!kinesisConfiguration.equals(that.kinesisConfiguration)) return false;
            if (!ledgerName.equals(that.ledgerName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!streamName.equals(that.streamName)) return false;
            if (this.exclusiveEndTime != null ? !this.exclusiveEndTime.equals(that.exclusiveEndTime) : that.exclusiveEndTime != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inclusiveStartTime.hashCode();
            result = 31 * result + (this.kinesisConfiguration.hashCode());
            result = 31 * result + (this.ledgerName.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.streamName.hashCode());
            result = 31 * result + (this.exclusiveEndTime != null ? this.exclusiveEndTime.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
