package software.amazon.awscdk.services.lambda;

/**
 * X-Ray Tracing Modes (https://docs.aws.amazon.com/lambda/latest/dg/API_TracingConfig.html).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .tracing(Tracing.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:09.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Tracing")
public enum Tracing {
    /**
     * Lambda will respect any tracing header it receives from an upstream service.
     * <p>
     * If no tracing header is received, Lambda will call X-Ray for a tracing decision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTIVE,
    /**
     * Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PASS_THROUGH,
    /**
     * Lambda will not trace any request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISABLED,
}
