package software.amazon.awscdk.services.kinesisanalytics;

/**
 * Properties for defining a `CfnApplicationReferenceDataSource`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalytics.*;
 * CfnApplicationReferenceDataSourceProps cfnApplicationReferenceDataSourceProps = CfnApplicationReferenceDataSourceProps.builder()
 *         .applicationName("applicationName")
 *         .referenceDataSource(ReferenceDataSourceProperty.builder()
 *                 .referenceSchema(ReferenceSchemaProperty.builder()
 *                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                 .name("name")
 *                                 .sqlType("sqlType")
 *                                 // the properties below are optional
 *                                 .mapping("mapping")
 *                                 .build()))
 *                         .recordFormat(RecordFormatProperty.builder()
 *                                 .recordFormatType("recordFormatType")
 *                                 // the properties below are optional
 *                                 .mappingParameters(MappingParametersProperty.builder()
 *                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                 .build())
 *                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                 .recordRowPath("recordRowPath")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .recordEncoding("recordEncoding")
 *                         .build())
 *                 // the properties below are optional
 *                 .s3ReferenceDataSource(S3ReferenceDataSourceProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .fileKey("fileKey")
 *                         .referenceRoleArn("referenceRoleArn")
 *                         .build())
 *                 .tableName("tableName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.735Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationReferenceDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationReferenceDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of an existing application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * The reference data source can be an object in your Amazon S3 bucket.
     * <p>
     * Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getReferenceDataSource();

    /**
     * @return a {@link Builder} of {@link CfnApplicationReferenceDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationReferenceDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationReferenceDataSourceProps> {
        java.lang.String applicationName;
        java.lang.Object referenceDataSource;

        /**
         * Sets the value of {@link CfnApplicationReferenceDataSourceProps#getApplicationName}
         * @param applicationName Name of an existing application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationReferenceDataSourceProps#getReferenceDataSource}
         * @param referenceDataSource The reference data source can be an object in your Amazon S3 bucket. This parameter is required.
         *                            Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceDataSource(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationReferenceDataSourceProps#getReferenceDataSource}
         * @param referenceDataSource The reference data source can be an object in your Amazon S3 bucket. This parameter is required.
         *                            Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceDataSource(software.amazon.awscdk.IResolvable referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationReferenceDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationReferenceDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationReferenceDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationReferenceDataSourceProps {
        private final java.lang.String applicationName;
        private final java.lang.Object referenceDataSource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.referenceDataSource = software.amazon.jsii.Kernel.get(this, "referenceDataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.referenceDataSource = java.util.Objects.requireNonNull(builder.referenceDataSource, "referenceDataSource is required");
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Object getReferenceDataSource() {
            return this.referenceDataSource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("referenceDataSource", om.valueToTree(this.getReferenceDataSource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationReferenceDataSourceProps.Jsii$Proxy that = (CfnApplicationReferenceDataSourceProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            return this.referenceDataSource.equals(that.referenceDataSource);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.referenceDataSource.hashCode());
            return result;
        }
    }
}
