package software.amazon.awscdk.services.globalaccelerator;

/**
 * EndpointGroup construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Listener listener;
 * // Non-open ALB
 * ApplicationLoadBalancer alb;
 * // Remember that there is only one AGA security group per VPC.
 * Vpc vpc;
 * EndpointGroup endpointGroup = listener.addEndpointGroup("Group", EndpointGroupOptions.builder()
 *         .endpoints(List.of(
 *             ApplicationLoadBalancerEndpoint.Builder.create(alb)
 *                     .preserveClientIp(true)
 *                     .build()))
 *         .build());
 * IPeer agaSg = endpointGroup.connectionsPeer("GlobalAcceleratorSG", vpc);
 * // Allow connections from the AGA to the ALB
 * alb.connections.allowFrom(agaSg, Port.tcp(443));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.026Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.EndpointGroup")
public class EndpointGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.globalaccelerator.IEndpointGroup {

    protected EndpointGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EndpointGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EndpointGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.EndpointGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * import from ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param endpointGroupArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IEndpointGroup fromEndpointGroupArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String endpointGroupArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.globalaccelerator.EndpointGroup.class, "fromEndpointGroupArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IEndpointGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(endpointGroupArn, "endpointGroupArn is required") });
    }

    /**
     * Add an endpoint.
     * <p>
     * @param endpoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IEndpoint endpoint) {
        software.amazon.jsii.Kernel.call(this, "addEndpoint", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(endpoint, "endpoint is required") });
    }

    /**
     * Return an object that represents the Accelerator's Security Group.
     * <p>
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     * <p>
     * The Security Group will only be created if you enable <strong>Client IP
     * Preservation</strong> on any of the endpoints.
     * <p>
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     * <p>
     * @param id This parameter is required.
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer connectionsPeer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.Kernel.call(this, "connectionsPeer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * EndpointGroup ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "endpointGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointGroupName() {
        return software.amazon.jsii.Kernel.get(this, "endpointGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The array of the endpoints in this endpoint group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.globalaccelerator.IEndpoint> getEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IEndpoint.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.EndpointGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.EndpointGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.globalaccelerator.EndpointGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.globalaccelerator.EndpointGroupProps.Builder();
        }

        /**
         * Name of the endpoint group.
         * <p>
         * Default: - logical ID of the resource
         * <p>
         * @return {@code this}
         * @param endpointGroupName Name of the endpoint group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointGroupName(final java.lang.String endpointGroupName) {
            this.props.endpointGroupName(endpointGroupName);
            return this;
        }

        /**
         * Initial list of endpoints for this group.
         * <p>
         * Default: - Group is initially empty
         * <p>
         * @return {@code this}
         * @param endpoints Initial list of endpoints for this group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoints(final java.util.List<? extends software.amazon.awscdk.services.globalaccelerator.IEndpoint> endpoints) {
            this.props.endpoints(endpoints);
            return this;
        }

        /**
         * The time between health checks for each endpoint.
         * <p>
         * Must be either 10 or 30 seconds.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param healthCheckInterval The time between health checks for each endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckInterval(final software.amazon.awscdk.Duration healthCheckInterval) {
            this.props.healthCheckInterval(healthCheckInterval);
            return this;
        }

        /**
         * The ping path for health checks (if the protocol is HTTP(S)).
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param healthCheckPath The ping path for health checks (if the protocol is HTTP(S)). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPath(final java.lang.String healthCheckPath) {
            this.props.healthCheckPath(healthCheckPath);
            return this;
        }

        /**
         * The port used to perform health checks.
         * <p>
         * Default: - The listener's port
         * <p>
         * @return {@code this}
         * @param healthCheckPort The port used to perform health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPort(final java.lang.Number healthCheckPort) {
            this.props.healthCheckPort(healthCheckPort);
            return this;
        }

        /**
         * The protocol used to perform health checks.
         * <p>
         * Default: HealthCheckProtocol.TCP
         * <p>
         * @return {@code this}
         * @param healthCheckProtocol The protocol used to perform health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckProtocol(final software.amazon.awscdk.services.globalaccelerator.HealthCheckProtocol healthCheckProtocol) {
            this.props.healthCheckProtocol(healthCheckProtocol);
            return this;
        }

        /**
         * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param healthCheckThreshold The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckThreshold(final java.lang.Number healthCheckThreshold) {
            this.props.healthCheckThreshold(healthCheckThreshold);
            return this;
        }

        /**
         * Override the destination ports used to route traffic to an endpoint.
         * <p>
         * Unless overridden, the port used to hit the endpoint will be the same as the port
         * that traffic arrives on at the listener.
         * <p>
         * Default: - No overrides
         * <p>
         * @return {@code this}
         * @param portOverrides Override the destination ports used to route traffic to an endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portOverrides(final java.util.List<? extends software.amazon.awscdk.services.globalaccelerator.PortOverride> portOverrides) {
            this.props.portOverrides(portOverrides);
            return this;
        }

        /**
         * The AWS Region where the endpoint group is located.
         * <p>
         * Default: - region of the first endpoint in this group, or the stack region if that region can't be determined
         * <p>
         * @return {@code this}
         * @param region The AWS Region where the endpoint group is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * The percentage of traffic to send to this AWS Region.
         * <p>
         * The percentage is applied to the traffic that would otherwise have been
         * routed to the Region based on optimal routing. Additional traffic is
         * distributed to other endpoint groups for this listener.
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param trafficDialPercentage The percentage of traffic to send to this AWS Region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficDialPercentage(final java.lang.Number trafficDialPercentage) {
            this.props.trafficDialPercentage(trafficDialPercentage);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the listener.
         * <p>
         * @return {@code this}
         * @param listener The Amazon Resource Name (ARN) of the listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(final software.amazon.awscdk.services.globalaccelerator.IListener listener) {
            this.props.listener(listener);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.EndpointGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.EndpointGroup build() {
            return new software.amazon.awscdk.services.globalaccelerator.EndpointGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
