package software.amazon.awscdk.services.fis;

/**
 * A CloudFormation `AWS::FIS::ExperimentTemplate`.
 * <p>
 * Specifies an experiment template.
 * <p>
 * An experiment template includes the following components:
 * <p>
 * <ul>
 * <li><em>Targets</em> : A target can be a specific resource in your AWS environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.</li>
 * <li><em>Actions</em> : The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.</li>
 * <li><em>Stop conditions</em> : If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the <em>AWS Fault Injection Simulator User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fis.*;
 * Object cloudWatchLogsConfiguration;
 * Object s3Configuration;
 * CfnExperimentTemplate cfnExperimentTemplate = CfnExperimentTemplate.Builder.create(this, "MyCfnExperimentTemplate")
 *         .description("description")
 *         .roleArn("roleArn")
 *         .stopConditions(List.of(ExperimentTemplateStopConditionProperty.builder()
 *                 .source("source")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .targets(Map.of(
 *                 "targetsKey", ExperimentTemplateTargetProperty.builder()
 *                         .resourceType("resourceType")
 *                         .selectionMode("selectionMode")
 *                         // the properties below are optional
 *                         .filters(List.of(ExperimentTemplateTargetFilterProperty.builder()
 *                                 .path("path")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .resourceArns(List.of("resourceArns"))
 *                         .resourceTags(Map.of(
 *                                 "resourceTagsKey", "resourceTags"))
 *                         .build()))
 *         // the properties below are optional
 *         .actions(Map.of(
 *                 "actionsKey", ExperimentTemplateActionProperty.builder()
 *                         .actionId("actionId")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .startAfter(List.of("startAfter"))
 *                         .targets(Map.of(
 *                                 "targetsKey", "targets"))
 *                         .build()))
 *         .logConfiguration(ExperimentTemplateLogConfigurationProperty.builder()
 *                 .logSchemaVersion(123)
 *                 // the properties below are optional
 *                 .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration)
 *                 .s3Configuration(s3Configuration)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.875Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate")
public class CfnExperimentTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnExperimentTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExperimentTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fis.CfnExperimentTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FIS::ExperimentTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnExperimentTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fis.CfnExperimentTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to apply to the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A description for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The stop conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStopConditions() {
        return software.amazon.jsii.Kernel.get(this, "stopConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The stop conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStopConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stopConditions", java.util.Objects.requireNonNull(value, "stopConditions is required"));
    }

    /**
     * The stop conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStopConditions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stopConditions", java.util.Objects.requireNonNull(value, "stopConditions is required"));
    }

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateActionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateActionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }
    /**
     * Specifies an action for an experiment template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/actions.html">Actions</a> in the <em>AWS Fault Injection Simulator User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateActionProperty experimentTemplateActionProperty = ExperimentTemplateActionProperty.builder()
     *         .actionId("actionId")
     *         // the properties below are optional
     *         .description("description")
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .startAfter(List.of("startAfter"))
     *         .targets(Map.of(
     *                 "targetsKey", "targets"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the action.
         * <p>
         * The format of the action ID is: aws: <em>service-name</em> : <em>action-type</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionId();

        /**
         * A description for the action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The parameters for the action, if applicable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The name of the action that must be completed before the current action starts.
         * <p>
         * Omit this parameter to run the action at the start of the experiment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartAfter() {
            return null;
        }

        /**
         * The targets for the action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateActionProperty> {
            java.lang.String actionId;
            java.lang.String description;
            java.lang.Object parameters;
            java.util.List<java.lang.String> startAfter;
            java.lang.Object targets;

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getActionId}
             * @param actionId The ID of the action. This parameter is required.
             *                 The format of the action ID is: aws: <em>service-name</em> : <em>action-type</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionId(java.lang.String actionId) {
                this.actionId = actionId;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getDescription}
             * @param description A description for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getParameters}
             * @param parameters The parameters for the action, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getParameters}
             * @param parameters The parameters for the action, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getStartAfter}
             * @param startAfter The name of the action that must be completed before the current action starts.
             *                   Omit this parameter to run the action at the start of the experiment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startAfter(java.util.List<java.lang.String> startAfter) {
                this.startAfter = startAfter;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getTargets}
             * @param targets The targets for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(software.amazon.awscdk.IResolvable targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getTargets}
             * @param targets The targets for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(java.util.Map<java.lang.String, java.lang.String> targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateActionProperty {
            private final java.lang.String actionId;
            private final java.lang.String description;
            private final java.lang.Object parameters;
            private final java.util.List<java.lang.String> startAfter;
            private final java.lang.Object targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionId = software.amazon.jsii.Kernel.get(this, "actionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startAfter = software.amazon.jsii.Kernel.get(this, "startAfter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionId = java.util.Objects.requireNonNull(builder.actionId, "actionId is required");
                this.description = builder.description;
                this.parameters = builder.parameters;
                this.startAfter = builder.startAfter;
                this.targets = builder.targets;
            }

            @Override
            public final java.lang.String getActionId() {
                return this.actionId;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.util.List<java.lang.String> getStartAfter() {
                return this.startAfter;
            }

            @Override
            public final java.lang.Object getTargets() {
                return this.targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionId", om.valueToTree(this.getActionId()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getStartAfter() != null) {
                    data.set("startAfter", om.valueToTree(this.getStartAfter()));
                }
                if (this.getTargets() != null) {
                    data.set("targets", om.valueToTree(this.getTargets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateActionProperty.Jsii$Proxy that = (ExperimentTemplateActionProperty.Jsii$Proxy) o;

                if (!actionId.equals(that.actionId)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.startAfter != null ? !this.startAfter.equals(that.startAfter) : that.startAfter != null) return false;
                return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionId.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.startAfter != null ? this.startAfter.hashCode() : 0);
                result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for experiment logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * Object cloudWatchLogsConfiguration;
     * Object s3Configuration;
     * ExperimentTemplateLogConfigurationProperty experimentTemplateLogConfigurationProperty = ExperimentTemplateLogConfigurationProperty.builder()
     *         .logSchemaVersion(123)
     *         // the properties below are optional
     *         .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration)
     *         .s3Configuration(s3Configuration)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateLogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateLogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schema version.
         * <p>
         * The supported value is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLogSchemaVersion();

        /**
         * The configuration for experiment logging to Amazon CloudWatch Logs. The supported field is `LogGroupArn` . For example:.
         * <p>
         * <code>{"LogGroupArn": "aws:arn:logs: *region_name* : *account_id* :log-group: *log_group_name* "}</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsConfiguration() {
            return null;
        }

        /**
         * The configuration for experiment logging to Amazon S3. The following fields are supported:.
         * <p>
         * <ul>
         * <li><code>bucketName</code> - The name of the destination bucket.</li>
         * <li><code>prefix</code> - An optional bucket prefix.</li>
         * </ul>
         * <p>
         * For example:
         * <p>
         * <code>{"BucketName": " *my-s3-bucket* ", "Prefix": " *log-folder* "}</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateLogConfigurationProperty> {
            java.lang.Number logSchemaVersion;
            java.lang.Object cloudWatchLogsConfiguration;
            java.lang.Object s3Configuration;

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getLogSchemaVersion}
             * @param logSchemaVersion The schema version. This parameter is required.
             *                         The supported value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logSchemaVersion(java.lang.Number logSchemaVersion) {
                this.logSchemaVersion = logSchemaVersion;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getCloudWatchLogsConfiguration}
             * @param cloudWatchLogsConfiguration The configuration for experiment logging to Amazon CloudWatch Logs. The supported field is `LogGroupArn` . For example:.
             *                                    <code>{"LogGroupArn": "aws:arn:logs: *region_name* : *account_id* :log-group: *log_group_name* "}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsConfiguration(java.lang.Object cloudWatchLogsConfiguration) {
                this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration for experiment logging to Amazon S3. The following fields are supported:.
             *                        <ul>
             *                        <li><code>bucketName</code> - The name of the destination bucket.</li>
             *                        <li><code>prefix</code> - An optional bucket prefix.</li>
             *                        </ul>
             *                        <p>
             *                        For example:
             *                        <p>
             *                        <code>{"BucketName": " *my-s3-bucket* ", "Prefix": " *log-folder* "}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(java.lang.Object s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateLogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateLogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateLogConfigurationProperty {
            private final java.lang.Number logSchemaVersion;
            private final java.lang.Object cloudWatchLogsConfiguration;
            private final java.lang.Object s3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logSchemaVersion = software.amazon.jsii.Kernel.get(this, "logSchemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cloudWatchLogsConfiguration = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logSchemaVersion = java.util.Objects.requireNonNull(builder.logSchemaVersion, "logSchemaVersion is required");
                this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
                this.s3Configuration = builder.s3Configuration;
            }

            @Override
            public final java.lang.Number getLogSchemaVersion() {
                return this.logSchemaVersion;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsConfiguration() {
                return this.cloudWatchLogsConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logSchemaVersion", om.valueToTree(this.getLogSchemaVersion()));
                if (this.getCloudWatchLogsConfiguration() != null) {
                    data.set("cloudWatchLogsConfiguration", om.valueToTree(this.getCloudWatchLogsConfiguration()));
                }
                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateLogConfigurationProperty.Jsii$Proxy that = (ExperimentTemplateLogConfigurationProperty.Jsii$Proxy) o;

                if (!logSchemaVersion.equals(that.logSchemaVersion)) return false;
                if (this.cloudWatchLogsConfiguration != null ? !this.cloudWatchLogsConfiguration.equals(that.cloudWatchLogsConfiguration) : that.cloudWatchLogsConfiguration != null) return false;
                return this.s3Configuration != null ? this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logSchemaVersion.hashCode();
                result = 31 * result + (this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3Configuration != null ? this.s3Configuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a stop condition for an experiment template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateStopConditionProperty experimentTemplateStopConditionProperty = ExperimentTemplateStopConditionProperty.builder()
     *         .source("source")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateStopConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateStopConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source for the stop condition.
         * <p>
         * Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch alarm.
         * <p>
         * This is required if the source is a CloudWatch alarm.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateStopConditionProperty> {
            java.lang.String source;
            java.lang.String value;

            /**
             * Sets the value of {@link ExperimentTemplateStopConditionProperty#getSource}
             * @param source The source for the stop condition. This parameter is required.
             *               Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateStopConditionProperty#getValue}
             * @param value The Amazon Resource Name (ARN) of the CloudWatch alarm.
             *              This is required if the source is a CloudWatch alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateStopConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateStopConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateStopConditionProperty {
            private final java.lang.String source;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateStopConditionProperty.Jsii$Proxy that = (ExperimentTemplateStopConditionProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a filter used for the target resource input in an experiment template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters">Resource filters</a> in the <em>AWS Fault Injection Simulator User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateTargetFilterProperty experimentTemplateTargetFilterProperty = ExperimentTemplateTargetFilterProperty.builder()
     *         .path("path")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateTargetFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateTargetFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attribute path for the filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * The attribute values for the filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateTargetFilterProperty> {
            java.lang.String path;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ExperimentTemplateTargetFilterProperty#getPath}
             * @param path The attribute path for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetFilterProperty#getValues}
             * @param values The attribute values for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateTargetFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateTargetFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateTargetFilterProperty {
            private final java.lang.String path;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateTargetFilterProperty.Jsii$Proxy that = (ExperimentTemplateTargetFilterProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a target for an experiment.
     * <p>
     * You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs and tags.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html">Targets</a> in the <em>AWS Fault Injection Simulator User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateTargetProperty experimentTemplateTargetProperty = ExperimentTemplateTargetProperty.builder()
     *         .resourceType("resourceType")
     *         .selectionMode("selectionMode")
     *         // the properties below are optional
     *         .filters(List.of(ExperimentTemplateTargetFilterProperty.builder()
     *                 .path("path")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .resourceArns(List.of("resourceArns"))
     *         .resourceTags(Map.of(
     *                 "resourceTagsKey", "resourceTags"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource type.
         * <p>
         * The resource type must be supported for the specified action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources.
         * <p>
         * All identified resources are included in the target.
         * <p>
         * <ul>
         * <li>ALL - Run the action on all identified targets. This is the default.</li>
         * <li>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.</li>
         * <li>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSelectionMode();

        /**
         * The filters to apply to identify target resources using specific attributes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
            return null;
        }

        /**
         * The parameters for the resource type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The Amazon Resource Names (ARNs) of the resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceArns() {
            return null;
        }

        /**
         * The tags for the target resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateTargetProperty> {
            java.lang.String resourceType;
            java.lang.String selectionMode;
            java.lang.Object filters;
            java.lang.Object parameters;
            java.util.List<java.lang.String> resourceArns;
            java.lang.Object resourceTags;

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceType}
             * @param resourceType The resource type. This parameter is required.
             *                     The resource type must be supported for the specified action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getSelectionMode}
             * @param selectionMode Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. This parameter is required.
             *                      All identified resources are included in the target.
             *                      <p>
             *                      <ul>
             *                      <li>ALL - Run the action on all identified targets. This is the default.</li>
             *                      <li>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.</li>
             *                      <li>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionMode(java.lang.String selectionMode) {
                this.selectionMode = selectionMode;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getFilters}
             * @param filters The filters to apply to identify target resources using specific attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getFilters}
             * @param filters The filters to apply to identify target resources using specific attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getParameters}
             * @param parameters The parameters for the resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getParameters}
             * @param parameters The parameters for the resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceArns}
             * @param resourceArns The Amazon Resource Names (ARNs) of the resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
                this.resourceArns = resourceArns;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceTags}
             * @param resourceTags The tags for the target resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceTags}
             * @param resourceTags The tags for the target resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(java.util.Map<java.lang.String, java.lang.String> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateTargetProperty {
            private final java.lang.String resourceType;
            private final java.lang.String selectionMode;
            private final java.lang.Object filters;
            private final java.lang.Object parameters;
            private final java.util.List<java.lang.String> resourceArns;
            private final java.lang.Object resourceTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectionMode = software.amazon.jsii.Kernel.get(this, "selectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
                this.selectionMode = java.util.Objects.requireNonNull(builder.selectionMode, "selectionMode is required");
                this.filters = builder.filters;
                this.parameters = builder.parameters;
                this.resourceArns = builder.resourceArns;
                this.resourceTags = builder.resourceTags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.String getSelectionMode() {
                return this.selectionMode;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceArns() {
                return this.resourceArns;
            }

            @Override
            public final java.lang.Object getResourceTags() {
                return this.resourceTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                data.set("selectionMode", om.valueToTree(this.getSelectionMode()));
                if (this.getFilters() != null) {
                    data.set("filters", om.valueToTree(this.getFilters()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getResourceArns() != null) {
                    data.set("resourceArns", om.valueToTree(this.getResourceArns()));
                }
                if (this.getResourceTags() != null) {
                    data.set("resourceTags", om.valueToTree(this.getResourceTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateTargetProperty.Jsii$Proxy that = (ExperimentTemplateTargetProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                if (!selectionMode.equals(that.selectionMode)) return false;
                if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.resourceArns != null ? !this.resourceArns.equals(that.resourceArns) : that.resourceArns != null) return false;
                return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.selectionMode.hashCode());
                result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.resourceArns != null ? this.resourceArns.hashCode() : 0);
                result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fis.CfnExperimentTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fis.CfnExperimentTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fis.CfnExperimentTemplateProps.Builder();
        }

        /**
         * A description for the experiment template.
         * <p>
         * @return {@code this}
         * @param description A description for the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The stop conditions.
         * <p>
         * @return {@code this}
         * @param stopConditions The stop conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(final software.amazon.awscdk.IResolvable stopConditions) {
            this.props.stopConditions(stopConditions);
            return this;
        }
        /**
         * The stop conditions.
         * <p>
         * @return {@code this}
         * @param stopConditions The stop conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(final java.util.List<? extends java.lang.Object> stopConditions) {
            this.props.stopConditions(stopConditions);
            return this;
        }

        /**
         * The tags to apply to the experiment template.
         * <p>
         * @return {@code this}
         * @param tags The tags to apply to the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The targets for the experiment.
         * <p>
         * @return {@code this}
         * @param targets The targets for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * The targets for the experiment.
         * <p>
         * @return {@code this}
         * @param targets The targets for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.Map<java.lang.String, ? extends java.lang.Object> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * The actions for the experiment.
         * <p>
         * @return {@code this}
         * @param actions The actions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * The actions for the experiment.
         * <p>
         * @return {@code this}
         * @param actions The actions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.Map<java.lang.String, ? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The configuration for experiment logging.
         * <p>
         * @return {@code this}
         * @param logConfiguration The configuration for experiment logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }
        /**
         * The configuration for experiment logging.
         * <p>
         * @return {@code this}
         * @param logConfiguration The configuration for experiment logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.IResolvable logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fis.CfnExperimentTemplate build() {
            return new software.amazon.awscdk.services.fis.CfnExperimentTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
