package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a `CfnStudio`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * CfnStudioProps cfnStudioProps = CfnStudioProps.builder()
 *         .authMode("authMode")
 *         .defaultS3Location("defaultS3Location")
 *         .engineSecurityGroupId("engineSecurityGroupId")
 *         .name("name")
 *         .serviceRole("serviceRole")
 *         .subnetIds(List.of("subnetIds"))
 *         .vpcId("vpcId")
 *         .workspaceSecurityGroupId("workspaceSecurityGroupId")
 *         // the properties below are optional
 *         .description("description")
 *         .idpAuthUrl("idpAuthUrl")
 *         .idpRelayStateParameterName("idpRelayStateParameterName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userRole("userRole")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.747Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnStudioProps")
@software.amazon.jsii.Jsii.Proxy(CfnStudioProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStudioProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the Studio authenticates users using AWS SSO or IAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthMode();

    /**
     * The Amazon S3 location to back up EMR Studio Workspaces and notebook files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDefaultS3Location();

    /**
     * The ID of the Amazon EMR Studio Engine security group.
     * <p>
     * The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineSecurityGroupId();

    /**
     * A descriptive name for the Amazon EMR Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that will be assumed by the Amazon EMR Studio.
     * <p>
     * The service role provides a way for Amazon EMR Studio to interoperate with other AWS services.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRole();

    /**
     * A list of subnet IDs to associate with the Amazon EMR Studio.
     * <p>
     * A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code> . Studio users can create a Workspace in any of the specified subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * The ID of the Workspace security group associated with the Amazon EMR Studio.
     * <p>
     * The Workspace security group allows outbound network traffic to resources in the Engine security group and to the internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceSecurityGroupId();

    /**
     * A detailed description of the Amazon EMR Studio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Your identity provider's authentication endpoint.
     * <p>
     * Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdpAuthUrl() {
        return null;
    }

    /**
     * The name of your identity provider's `RelayState` parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdpRelayStateParameterName() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM user role that will be assumed by users and groups logged in to a Studio.
     * <p>
     * The permissions attached to this IAM role can be scoped down for each user or group using session policies. You only need to specify <code>UserRole</code> when you set <code>AuthMode</code> to <code>SSO</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStudioProps> {
        java.lang.String authMode;
        java.lang.String defaultS3Location;
        java.lang.String engineSecurityGroupId;
        java.lang.String name;
        java.lang.String serviceRole;
        java.util.List<java.lang.String> subnetIds;
        java.lang.String vpcId;
        java.lang.String workspaceSecurityGroupId;
        java.lang.String description;
        java.lang.String idpAuthUrl;
        java.lang.String idpRelayStateParameterName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userRole;

        /**
         * Sets the value of {@link CfnStudioProps#getAuthMode}
         * @param authMode Specifies whether the Studio authenticates users using AWS SSO or IAM. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authMode(java.lang.String authMode) {
            this.authMode = authMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getDefaultS3Location}
         * @param defaultS3Location The Amazon S3 location to back up EMR Studio Workspaces and notebook files. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultS3Location(java.lang.String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getEngineSecurityGroupId}
         * @param engineSecurityGroupId The ID of the Amazon EMR Studio Engine security group. This parameter is required.
         *                              The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineSecurityGroupId(java.lang.String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getName}
         * @param name A descriptive name for the Amazon EMR Studio. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getServiceRole}
         * @param serviceRole The Amazon Resource Name (ARN) of the IAM role that will be assumed by the Amazon EMR Studio. This parameter is required.
         *                    The service role provides a way for Amazon EMR Studio to interoperate with other AWS services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(java.lang.String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getSubnetIds}
         * @param subnetIds A list of subnet IDs to associate with the Amazon EMR Studio. This parameter is required.
         *                  A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code> . Studio users can create a Workspace in any of the specified subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getVpcId}
         * @param vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getWorkspaceSecurityGroupId}
         * @param workspaceSecurityGroupId The ID of the Workspace security group associated with the Amazon EMR Studio. This parameter is required.
         *                                 The Workspace security group allows outbound network traffic to resources in the Engine security group and to the internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceSecurityGroupId(java.lang.String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getDescription}
         * @param description A detailed description of the Amazon EMR Studio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getIdpAuthUrl}
         * @param idpAuthUrl Your identity provider's authentication endpoint.
         *                   Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpAuthUrl(java.lang.String idpAuthUrl) {
            this.idpAuthUrl = idpAuthUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getIdpRelayStateParameterName}
         * @param idpRelayStateParameterName The name of your identity provider's `RelayState` parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpRelayStateParameterName(java.lang.String idpRelayStateParameterName) {
            this.idpRelayStateParameterName = idpRelayStateParameterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getUserRole}
         * @param userRole The Amazon Resource Name (ARN) of the IAM user role that will be assumed by users and groups logged in to a Studio.
         *                 The permissions attached to this IAM role can be scoped down for each user or group using session policies. You only need to specify <code>UserRole</code> when you set <code>AuthMode</code> to <code>SSO</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRole(java.lang.String userRole) {
            this.userRole = userRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStudioProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStudioProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStudioProps {
        private final java.lang.String authMode;
        private final java.lang.String defaultS3Location;
        private final java.lang.String engineSecurityGroupId;
        private final java.lang.String name;
        private final java.lang.String serviceRole;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String vpcId;
        private final java.lang.String workspaceSecurityGroupId;
        private final java.lang.String description;
        private final java.lang.String idpAuthUrl;
        private final java.lang.String idpRelayStateParameterName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authMode = software.amazon.jsii.Kernel.get(this, "authMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultS3Location = software.amazon.jsii.Kernel.get(this, "defaultS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineSecurityGroupId = software.amazon.jsii.Kernel.get(this, "engineSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceSecurityGroupId = software.amazon.jsii.Kernel.get(this, "workspaceSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idpAuthUrl = software.amazon.jsii.Kernel.get(this, "idpAuthUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idpRelayStateParameterName = software.amazon.jsii.Kernel.get(this, "idpRelayStateParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userRole = software.amazon.jsii.Kernel.get(this, "userRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authMode = java.util.Objects.requireNonNull(builder.authMode, "authMode is required");
            this.defaultS3Location = java.util.Objects.requireNonNull(builder.defaultS3Location, "defaultS3Location is required");
            this.engineSecurityGroupId = java.util.Objects.requireNonNull(builder.engineSecurityGroupId, "engineSecurityGroupId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.serviceRole = java.util.Objects.requireNonNull(builder.serviceRole, "serviceRole is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.workspaceSecurityGroupId = java.util.Objects.requireNonNull(builder.workspaceSecurityGroupId, "workspaceSecurityGroupId is required");
            this.description = builder.description;
            this.idpAuthUrl = builder.idpAuthUrl;
            this.idpRelayStateParameterName = builder.idpRelayStateParameterName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userRole = builder.userRole;
        }

        @Override
        public final java.lang.String getAuthMode() {
            return this.authMode;
        }

        @Override
        public final java.lang.String getDefaultS3Location() {
            return this.defaultS3Location;
        }

        @Override
        public final java.lang.String getEngineSecurityGroupId() {
            return this.engineSecurityGroupId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getWorkspaceSecurityGroupId() {
            return this.workspaceSecurityGroupId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getIdpAuthUrl() {
            return this.idpAuthUrl;
        }

        @Override
        public final java.lang.String getIdpRelayStateParameterName() {
            return this.idpRelayStateParameterName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserRole() {
            return this.userRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authMode", om.valueToTree(this.getAuthMode()));
            data.set("defaultS3Location", om.valueToTree(this.getDefaultS3Location()));
            data.set("engineSecurityGroupId", om.valueToTree(this.getEngineSecurityGroupId()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            data.set("workspaceSecurityGroupId", om.valueToTree(this.getWorkspaceSecurityGroupId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getIdpAuthUrl() != null) {
                data.set("idpAuthUrl", om.valueToTree(this.getIdpAuthUrl()));
            }
            if (this.getIdpRelayStateParameterName() != null) {
                data.set("idpRelayStateParameterName", om.valueToTree(this.getIdpRelayStateParameterName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserRole() != null) {
                data.set("userRole", om.valueToTree(this.getUserRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnStudioProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStudioProps.Jsii$Proxy that = (CfnStudioProps.Jsii$Proxy) o;

            if (!authMode.equals(that.authMode)) return false;
            if (!defaultS3Location.equals(that.defaultS3Location)) return false;
            if (!engineSecurityGroupId.equals(that.engineSecurityGroupId)) return false;
            if (!name.equals(that.name)) return false;
            if (!serviceRole.equals(that.serviceRole)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (!workspaceSecurityGroupId.equals(that.workspaceSecurityGroupId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.idpAuthUrl != null ? !this.idpAuthUrl.equals(that.idpAuthUrl) : that.idpAuthUrl != null) return false;
            if (this.idpRelayStateParameterName != null ? !this.idpRelayStateParameterName.equals(that.idpRelayStateParameterName) : that.idpRelayStateParameterName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userRole != null ? this.userRole.equals(that.userRole) : that.userRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authMode.hashCode();
            result = 31 * result + (this.defaultS3Location.hashCode());
            result = 31 * result + (this.engineSecurityGroupId.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.serviceRole.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.workspaceSecurityGroupId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.idpAuthUrl != null ? this.idpAuthUrl.hashCode() : 0);
            result = 31 * result + (this.idpRelayStateParameterName != null ? this.idpRelayStateParameterName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userRole != null ? this.userRole.hashCode() : 0);
            return result;
        }
    }
}
