package software.amazon.awscdk.services.ecs;

/**
 * The operating system for Fargate Runtime Platform.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the Windows container to start
 * FargateTaskDefinition taskDefinition = FargateTaskDefinition.Builder.create(this, "TaskDef")
 *         .runtimePlatform(RuntimePlatform.builder()
 *                 .operatingSystemFamily(OperatingSystemFamily.WINDOWS_SERVER_2019_CORE)
 *                 .cpuArchitecture(CpuArchitecture.X86_64)
 *                 .build())
 *         .cpu(1024)
 *         .memoryLimitMiB(2048)
 *         .build();
 * taskDefinition.addContainer("windowsservercore", ContainerDefinitionOptions.builder()
 *         .logging(LogDriver.awsLogs(AwsLogDriverProps.builder().streamPrefix("win-iis-on-fargate").build()))
 *         .portMappings(List.of(PortMapping.builder().containerPort(80).build()))
 *         .image(ContainerImage.fromRegistry("mcr.microsoft.com/windows/servercore/iis:windowsservercore-ltsc2019"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.255Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.OperatingSystemFamily")
public class OperatingSystemFamily extends software.amazon.jsii.JsiiObject {

    protected OperatingSystemFamily(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OperatingSystemFamily(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        LINUX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "LINUX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2004_CORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2004_CORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2016_FULL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2016_FULL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2019_CORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2019_CORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2019_FULL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2019_FULL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2022_CORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2022_CORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_2022_FULL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_2022_FULL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        WINDOWS_SERVER_20_H2_CORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "WINDOWS_SERVER_20H2_CORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
    }

    /**
     * Other operating system family.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily for all available operating system family.">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily for all available operating system family.</a>
     * @param family operating system family. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.OperatingSystemFamily of(final @org.jetbrains.annotations.NotNull java.lang.String family) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class), new Object[] { java.util.Objects.requireNonNull(family, "family is required") });
    }

    /**
     * LINUX.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily LINUX;

    /**
     * WINDOWS_SERVER_2004_CORE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2004_CORE;

    /**
     * WINDOWS_SERVER_2016_FULL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2016_FULL;

    /**
     * WINDOWS_SERVER_2019_CORE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2019_CORE;

    /**
     * WINDOWS_SERVER_2019_FULL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2019_FULL;

    /**
     * WINDOWS_SERVER_2022_CORE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2022_CORE;

    /**
     * WINDOWS_SERVER_2022_FULL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_2022_FULL;

    /**
     * WINDOWS_SERVER_20H2_CORE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.OperatingSystemFamily WINDOWS_SERVER_20_H2_CORE;
}
