package software.amazon.awscdk.services.ecr.assets;

/**
 * platform supported by docker.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * import software.amazon.awscdk.services.ecr.assets.Platform;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .platform(Platform.LINUX_ARM64)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.074Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.Platform")
public class Platform extends software.amazon.jsii.JsiiObject {

    protected Platform(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Platform(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        LINUX_AMD64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.Platform.class, "LINUX_AMD64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
        LINUX_ARM64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.Platform.class, "LINUX_ARM64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
    }

    /**
     * Used to specify a custom platform Use this if the platform name is not yet supported by the CDK.
     * <p>
     * @param platform The platform to use for docker build. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.Platform custom(final @org.jetbrains.annotations.NotNull java.lang.String platform) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.assets.Platform.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class), new Object[] { java.util.Objects.requireNonNull(platform, "platform is required") });
    }

    /**
     * Build for linux/amd64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.assets.Platform LINUX_AMD64;

    /**
     * Build for linux/arm64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecr.assets.Platform LINUX_ARM64;

    /**
     * The platform to use for docker build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlatform() {
        return software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
