package software.amazon.awscdk.services.ec2;

/**
 * Properties for a NAT gateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NatGatewayProps natGatewayProps = NatGatewayProps.builder()
 *         .eipAllocationIds(List.of("eipAllocationIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.995Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatGatewayProps")
@software.amazon.jsii.Jsii.Proxy(NatGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NatGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * EIP allocation IDs for the NAT gateways.
     * <p>
     * Default: - No fixed EIPs allocated for the NAT gateways
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEipAllocationIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NatGatewayProps> {
        java.util.List<java.lang.String> eipAllocationIds;

        /**
         * Sets the value of {@link NatGatewayProps#getEipAllocationIds}
         * @param eipAllocationIds EIP allocation IDs for the NAT gateways.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eipAllocationIds(java.util.List<java.lang.String> eipAllocationIds) {
            this.eipAllocationIds = eipAllocationIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NatGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NatGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NatGatewayProps {
        private final java.util.List<java.lang.String> eipAllocationIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eipAllocationIds = software.amazon.jsii.Kernel.get(this, "eipAllocationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eipAllocationIds = builder.eipAllocationIds;
        }

        @Override
        public final java.util.List<java.lang.String> getEipAllocationIds() {
            return this.eipAllocationIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEipAllocationIds() != null) {
                data.set("eipAllocationIds", om.valueToTree(this.getEipAllocationIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NatGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NatGatewayProps.Jsii$Proxy that = (NatGatewayProps.Jsii$Proxy) o;

            return this.eipAllocationIds != null ? this.eipAllocationIds.equals(that.eipAllocationIds) : that.eipAllocationIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eipAllocationIds != null ? this.eipAllocationIds.hashCode() : 0;
            return result;
        }
    }
}
