package software.amazon.awscdk.services.databrew;

/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 * <p>
 * Specifies a new AWS Glue DataBrew transformation recipe.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * CfnRecipe cfnRecipe = CfnRecipe.Builder.create(this, "MyCfnRecipe")
 *         .name("name")
 *         .steps(List.of(RecipeStepProperty.builder()
 *                 .action(ActionProperty.builder()
 *                         .operation("operation")
 *                         // the properties below are optional
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .build())
 *                 // the properties below are optional
 *                 .conditionExpressions(List.of(ConditionExpressionProperty.builder()
 *                         .condition("condition")
 *                         .targetColumn("targetColumn")
 *                         // the properties below are optional
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.354Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe")
public class CfnRecipe extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRecipe(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRecipe(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.databrew.CfnRecipe.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataBrew::Recipe`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRecipe(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.databrew.CfnRecipeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata tags that have been applied to the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique name for the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name for the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A list of steps that are defined by the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSteps() {
        return software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of steps that are defined by the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * A list of steps that are defined by the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.databrew.CfnRecipe.RecipeStepProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.databrew.CfnRecipe.RecipeStepProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * The description of the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * Represents a transformation and associated parameters that are used to apply a change to an AWS Glue DataBrew dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .operation("operation")
     *         // the properties below are optional
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a valid DataBrew transformation to be performed on the data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperation();

        /**
         * Contextual parameters for the transformation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.String operation;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link ActionProperty#getOperation}
             * @param operation The name of a valid DataBrew transformation to be performed on the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operation(java.lang.String operation) {
                this.operation = operation;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getParameters}
             * @param parameters Contextual parameters for the transformation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getParameters}
             * @param parameters Contextual parameters for the transformation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String operation;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operation = software.amazon.jsii.Kernel.get(this, "operation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operation = java.util.Objects.requireNonNull(builder.operation, "operation is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getOperation() {
                return this.operation;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operation", om.valueToTree(this.getOperation()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!operation.equals(that.operation)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operation.hashCode();
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents an individual condition that evaluates to true or false.
     * <p>
     * Conditions are used with recipe actions. The action is only performed for column values where the condition evaluates to true.
     * <p>
     * If a recipe requires more than one condition, then the recipe must specify multiple <code>ConditionExpression</code> elements. Each condition is applied to the rows in a dataset first, before the recipe action is performed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ConditionExpressionProperty conditionExpressionProperty = ConditionExpressionProperty.builder()
     *         .condition("condition")
     *         .targetColumn("targetColumn")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.ConditionExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A specific condition to apply to a recipe action.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipe-structure.html">Recipe structure</a> in the <em>AWS Glue DataBrew Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * A column to apply this condition to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetColumn();

        /**
         * A value that the condition must evaluate to for the condition to succeed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionExpressionProperty> {
            java.lang.String condition;
            java.lang.String targetColumn;
            java.lang.String value;

            /**
             * Sets the value of {@link ConditionExpressionProperty#getCondition}
             * @param condition A specific condition to apply to a recipe action. This parameter is required.
             *                  For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipe-structure.html">Recipe structure</a> in the <em>AWS Glue DataBrew Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionExpressionProperty#getTargetColumn}
             * @param targetColumn A column to apply this condition to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetColumn(java.lang.String targetColumn) {
                this.targetColumn = targetColumn;
                return this;
            }

            /**
             * Sets the value of {@link ConditionExpressionProperty#getValue}
             * @param value A value that the condition must evaluate to for the condition to succeed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionExpressionProperty {
            private final java.lang.String condition;
            private final java.lang.String targetColumn;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetColumn = software.amazon.jsii.Kernel.get(this, "targetColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.targetColumn = java.util.Objects.requireNonNull(builder.targetColumn, "targetColumn is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getTargetColumn() {
                return this.targetColumn;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("targetColumn", om.valueToTree(this.getTargetColumn()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.ConditionExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionExpressionProperty.Jsii$Proxy that = (ConditionExpressionProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                if (!targetColumn.equals(that.targetColumn)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.targetColumn.hashCode());
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents how metadata stored in the AWS Glue Data Catalog is defined in a DataBrew dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DataCatalogInputDefinitionProperty dataCatalogInputDefinitionProperty = DataCatalogInputDefinitionProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         .tempDirectory(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.DataCatalogInputDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCatalogInputDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCatalogInputDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the AWS account that holds the Data Catalog that stores the data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * The name of a database in the Data Catalog.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The name of a database table in the Data Catalog.
         * <p>
         * This table corresponds to a DataBrew dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
            return null;
        }

        /**
         * Represents an Amazon location where DataBrew can store intermediate results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTempDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCatalogInputDefinitionProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String tableName;
            java.lang.Object tempDirectory;

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getCatalogId}
             * @param catalogId The unique identifier of the AWS account that holds the Data Catalog that stores the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getDatabaseName}
             * @param databaseName The name of a database in the Data Catalog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTableName}
             * @param tableName The name of a database table in the Data Catalog.
             *                  This table corresponds to a DataBrew dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory Represents an Amazon location where DataBrew can store intermediate results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.services.databrew.CfnRecipe.S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory Represents an Amazon location where DataBrew can store intermediate results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCatalogInputDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCatalogInputDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogInputDefinitionProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String tableName;
            private final java.lang.Object tempDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tempDirectory = software.amazon.jsii.Kernel.get(this, "tempDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.tableName = builder.tableName;
                this.tempDirectory = builder.tempDirectory;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getTempDirectory() {
                return this.tempDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getTableName() != null) {
                    data.set("tableName", om.valueToTree(this.getTableName()));
                }
                if (this.getTempDirectory() != null) {
                    data.set("tempDirectory", om.valueToTree(this.getTempDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.DataCatalogInputDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCatalogInputDefinitionProperty.Jsii$Proxy that = (DataCatalogInputDefinitionProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
                return this.tempDirectory != null ? this.tempDirectory.equals(that.tempDirectory) : that.tempDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
                result = 31 * result + (this.tempDirectory != null ? this.tempDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters that are used as inputs for various recipe actions.
     * <p>
     * The parameters are specific to the context in which they're used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * Object input;
     * RecipeParametersProperty recipeParametersProperty = RecipeParametersProperty.builder()
     *         .aggregateFunction("aggregateFunction")
     *         .base("base")
     *         .caseStatement("caseStatement")
     *         .categoryMap("categoryMap")
     *         .charsToRemove("charsToRemove")
     *         .collapseConsecutiveWhitespace("collapseConsecutiveWhitespace")
     *         .columnDataType("columnDataType")
     *         .columnRange("columnRange")
     *         .count("count")
     *         .customCharacters("customCharacters")
     *         .customStopWords("customStopWords")
     *         .customValue("customValue")
     *         .datasetsColumns("datasetsColumns")
     *         .dateAddValue("dateAddValue")
     *         .dateTimeFormat("dateTimeFormat")
     *         .dateTimeParameters("dateTimeParameters")
     *         .deleteOtherRows("deleteOtherRows")
     *         .delimiter("delimiter")
     *         .endPattern("endPattern")
     *         .endPosition("endPosition")
     *         .endValue("endValue")
     *         .expandContractions("expandContractions")
     *         .exponent("exponent")
     *         .falseString("falseString")
     *         .groupByAggFunctionOptions("groupByAggFunctionOptions")
     *         .groupByColumns("groupByColumns")
     *         .hiddenColumns("hiddenColumns")
     *         .ignoreCase("ignoreCase")
     *         .includeInSplit("includeInSplit")
     *         .input(input)
     *         .interval("interval")
     *         .isText("isText")
     *         .joinKeys("joinKeys")
     *         .joinType("joinType")
     *         .leftColumns("leftColumns")
     *         .limit("limit")
     *         .lowerBound("lowerBound")
     *         .mapType("mapType")
     *         .modeType("modeType")
     *         .multiLine(false)
     *         .numRows("numRows")
     *         .numRowsAfter("numRowsAfter")
     *         .numRowsBefore("numRowsBefore")
     *         .orderByColumn("orderByColumn")
     *         .orderByColumns("orderByColumns")
     *         .other("other")
     *         .pattern("pattern")
     *         .patternOption1("patternOption1")
     *         .patternOption2("patternOption2")
     *         .patternOptions("patternOptions")
     *         .period("period")
     *         .position("position")
     *         .removeAllPunctuation("removeAllPunctuation")
     *         .removeAllQuotes("removeAllQuotes")
     *         .removeAllWhitespace("removeAllWhitespace")
     *         .removeCustomCharacters("removeCustomCharacters")
     *         .removeCustomValue("removeCustomValue")
     *         .removeLeadingAndTrailingPunctuation("removeLeadingAndTrailingPunctuation")
     *         .removeLeadingAndTrailingQuotes("removeLeadingAndTrailingQuotes")
     *         .removeLeadingAndTrailingWhitespace("removeLeadingAndTrailingWhitespace")
     *         .removeLetters("removeLetters")
     *         .removeNumbers("removeNumbers")
     *         .removeSourceColumn("removeSourceColumn")
     *         .removeSpecialCharacters("removeSpecialCharacters")
     *         .rightColumns("rightColumns")
     *         .sampleSize("sampleSize")
     *         .sampleType("sampleType")
     *         .secondaryInputs(List.of(SecondaryInputProperty.builder()
     *                 .dataCatalogInputDefinition(DataCatalogInputDefinitionProperty.builder()
     *                         .catalogId("catalogId")
     *                         .databaseName("databaseName")
     *                         .tableName("tableName")
     *                         .tempDirectory(S3LocationProperty.builder()
     *                                 .bucket("bucket")
     *                                 // the properties below are optional
     *                                 .key("key")
     *                                 .build())
     *                         .build())
     *                 .s3InputDefinition(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .key("key")
     *                         .build())
     *                 .build()))
     *         .secondInput("secondInput")
     *         .sheetIndexes(List.of(123))
     *         .sheetNames(List.of("sheetNames"))
     *         .sourceColumn("sourceColumn")
     *         .sourceColumn1("sourceColumn1")
     *         .sourceColumn2("sourceColumn2")
     *         .sourceColumns("sourceColumns")
     *         .startColumnIndex("startColumnIndex")
     *         .startPattern("startPattern")
     *         .startPosition("startPosition")
     *         .startValue("startValue")
     *         .stemmingMode("stemmingMode")
     *         .stepCount("stepCount")
     *         .stepIndex("stepIndex")
     *         .stopWordsMode("stopWordsMode")
     *         .strategy("strategy")
     *         .targetColumn("targetColumn")
     *         .targetColumnNames("targetColumnNames")
     *         .targetDateFormat("targetDateFormat")
     *         .targetIndex("targetIndex")
     *         .timeZone("timeZone")
     *         .tokenizerPattern("tokenizerPattern")
     *         .trueString("trueString")
     *         .udfLang("udfLang")
     *         .units("units")
     *         .unpivotColumn("unpivotColumn")
     *         .upperBound("upperBound")
     *         .useNewDataFrame("useNewDataFrame")
     *         .value("value")
     *         .value1("value1")
     *         .value2("value2")
     *         .valueColumn("valueColumn")
     *         .viewFrame("viewFrame")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.RecipeParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipeParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipeParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an aggregation function to apply.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregateFunction() {
            return null;
        }

        /**
         * The number of digits used in a counting system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBase() {
            return null;
        }

        /**
         * A case statement associated with a recipe.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCaseStatement() {
            return null;
        }

        /**
         * A category map used for one-hot encoding.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCategoryMap() {
            return null;
        }

        /**
         * Characters to remove from a step that applies one-hot encoding or tokenization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCharsToRemove() {
            return null;
        }

        /**
         * Remove any non-word non-punctuation character.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCollapseConsecutiveWhitespace() {
            return null;
        }

        /**
         * The data type of the column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnDataType() {
            return null;
        }

        /**
         * A range of columns to which a step is applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnRange() {
            return null;
        }

        /**
         * The number of times a string needs to be repeated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCount() {
            return null;
        }

        /**
         * One or more characters that can be substituted or removed, depending on the context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomCharacters() {
            return null;
        }

        /**
         * A list of words to ignore in a step that applies word tokenization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomStopWords() {
            return null;
        }

        /**
         * A list of custom values to use in a step that requires that you provide a value to finish the operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomValue() {
            return null;
        }

        /**
         * A list of the dataset columns included in a project.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetsColumns() {
            return null;
        }

        /**
         * A value that specifies how many units of time to add or subtract for a date math operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateAddValue() {
            return null;
        }

        /**
         * A date format to apply to a date.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateTimeFormat() {
            return null;
        }

        /**
         * A set of parameters associated with a datetime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateTimeParameters() {
            return null;
        }

        /**
         * Determines whether unmapped rows in a categorical mapping should be deleted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeleteOtherRows() {
            return null;
        }

        /**
         * The delimiter to use when parsing separated values in a text file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * The end pattern to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndPattern() {
            return null;
        }

        /**
         * The end position to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndPosition() {
            return null;
        }

        /**
         * The end value to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndValue() {
            return null;
        }

        /**
         * A list of word contractions and what they expand to.
         * <p>
         * For eample: <em>can't</em> ; <em>cannot</em> ; <em>can not</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpandContractions() {
            return null;
        }

        /**
         * The exponent to apply in an exponential operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExponent() {
            return null;
        }

        /**
         * A value that represents `FALSE` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFalseString() {
            return null;
        }

        /**
         * Specifies options to apply to the `GROUP BY` used in an aggregation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupByAggFunctionOptions() {
            return null;
        }

        /**
         * The columns to use in the `GROUP BY` clause.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupByColumns() {
            return null;
        }

        /**
         * A list of columns to hide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHiddenColumns() {
            return null;
        }

        /**
         * Indicates that lower and upper case letters are treated equally.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIgnoreCase() {
            return null;
        }

        /**
         * Indicates if this column is participating in a split transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIncludeInSplit() {
            return null;
        }

        /**
         * The input location to load the dataset from - Amazon S3 or AWS Glue Data Catalog .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInput() {
            return null;
        }

        /**
         * The number of characters to split by.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInterval() {
            return null;
        }

        /**
         * Indicates if the content is text.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIsText() {
            return null;
        }

        /**
         * The keys or columns involved in a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJoinKeys() {
            return null;
        }

        /**
         * The type of join to use, for example, `INNER JOIN` , `OUTER JOIN` , and so on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJoinType() {
            return null;
        }

        /**
         * The columns on the left side of the join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLeftColumns() {
            return null;
        }

        /**
         * The number of times to perform `split` or `replaceBy` in a string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLimit() {
            return null;
        }

        /**
         * The lower boundary for a value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLowerBound() {
            return null;
        }

        /**
         * The type of mappings to apply to construct a new dynamic frame.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMapType() {
            return null;
        }

        /**
         * Determines the manner in which mode value is calculated, in case there is more than one mode value.
         * <p>
         * Valid values: <code>NONE</code> | <code>AVERAGE</code> | <code>MINIMUM</code> | <code>MAXIMUM</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModeType() {
            return null;
        }

        /**
         * Specifies whether JSON input contains embedded new line characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiLine() {
            return null;
        }

        /**
         * The number of rows to consider in a window.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNumRows() {
            return null;
        }

        /**
         * The number of rows to consider after the current row in a window.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNumRowsAfter() {
            return null;
        }

        /**
         * The number of rows to consider before the current row in a window.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNumRowsBefore() {
            return null;
        }

        /**
         * A column to sort the results by.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrderByColumn() {
            return null;
        }

        /**
         * The columns to sort the results by.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrderByColumns() {
            return null;
        }

        /**
         * The value to assign to unmapped cells, in categorical mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOther() {
            return null;
        }

        /**
         * The pattern to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPattern() {
            return null;
        }

        /**
         * The starting pattern to split between.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternOption1() {
            return null;
        }

        /**
         * The ending pattern to split between.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternOption2() {
            return null;
        }

        /**
         * For splitting by multiple delimiters: A JSON-encoded string that lists the patterns in the format.
         * <p>
         * For example: <code>[{\"pattern\":\"1\",\"includeInSplit\":true}]</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternOptions() {
            return null;
        }

        /**
         * The size of the rolling window.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPeriod() {
            return null;
        }

        /**
         * The character index within a string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPosition() {
            return null;
        }

        /**
         * If `true` , removes all of the following characters: `.` `.!` `.,` `.?`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveAllPunctuation() {
            return null;
        }

        /**
         * If `true` , removes all single quotes and double quotes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveAllQuotes() {
            return null;
        }

        /**
         * If `true` , removes all whitespaces from the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveAllWhitespace() {
            return null;
        }

        /**
         * If `true` , removes all chraracters specified by `CustomCharacters` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveCustomCharacters() {
            return null;
        }

        /**
         * If `true` , removes all chraracters specified by `CustomValue` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveCustomValue() {
            return null;
        }

        /**
         * If `true` , removes the following characters if they occur at the start or end of the value: `.` `!` `,` `?`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveLeadingAndTrailingPunctuation() {
            return null;
        }

        /**
         * If `true` , removes single quotes and double quotes from the beginning and end of the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveLeadingAndTrailingQuotes() {
            return null;
        }

        /**
         * If `true` , removes all whitespaces from the beginning and end of the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveLeadingAndTrailingWhitespace() {
            return null;
        }

        /**
         * If `true` , removes all uppercase and lowercase alphabetic characters (A through Z;
         * <p>
         * a through z).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveLetters() {
            return null;
        }

        /**
         * If `true` , removes all numeric characters (0 through 9).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveNumbers() {
            return null;
        }

        /**
         * If `true` , the source column will be removed after un-nesting that column.
         * <p>
         * (Used with nested column types, such as Map, Struct, or Array.)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveSourceColumn() {
            return null;
        }

        /**
         * If `true` , removes all of the following characters: `!
         * <p>
         * " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? &#64; [ \ ] ^ _ <code> { | } ~</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoveSpecialCharacters() {
            return null;
        }

        /**
         * The columns on the right side of a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRightColumns() {
            return null;
        }

        /**
         * The number of rows in the sample.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSampleSize() {
            return null;
        }

        /**
         * The sampling type to apply to the dataset.
         * <p>
         * Valid values: <code>FIRST_N</code> | <code>LAST_N</code> | <code>RANDOM</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSampleType() {
            return null;
        }

        /**
         * A list of secondary inputs in a UNION transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryInputs() {
            return null;
        }

        /**
         * A object value to indicate the second dataset used in a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondInput() {
            return null;
        }

        /**
         * One or more sheet numbers in the Excel file, which will be included in a dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheetIndexes() {
            return null;
        }

        /**
         * Oone or more named sheets in the Excel file, which will be included in a dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSheetNames() {
            return null;
        }

        /**
         * A source column needed for an operation, step, or transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumn() {
            return null;
        }

        /**
         * A source column needed for an operation, step, or transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumn1() {
            return null;
        }

        /**
         * A source column needed for an operation, step, or transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumn2() {
            return null;
        }

        /**
         * A list of source columns needed for an operation, step, or transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumns() {
            return null;
        }

        /**
         * The index number of the first column used by an operation, step, or transform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartColumnIndex() {
            return null;
        }

        /**
         * The starting pattern to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartPattern() {
            return null;
        }

        /**
         * The starting position to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartPosition() {
            return null;
        }

        /**
         * The starting value to locate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartValue() {
            return null;
        }

        /**
         * Indicates this operation uses stems and lemmas (base words) for word tokenization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStemmingMode() {
            return null;
        }

        /**
         * The total number of transforms in this recipe.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStepCount() {
            return null;
        }

        /**
         * The index ID of a step.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStepIndex() {
            return null;
        }

        /**
         * Indicates this operation uses stop words as part of word tokenization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStopWordsMode() {
            return null;
        }

        /**
         * The resolution strategy to apply in resolving ambiguities.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrategy() {
            return null;
        }

        /**
         * The column targeted by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetColumn() {
            return null;
        }

        /**
         * The names to give columns altered by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetColumnNames() {
            return null;
        }

        /**
         * The date format to convert to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetDateFormat() {
            return null;
        }

        /**
         * The index number of an object that is targeted by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetIndex() {
            return null;
        }

        /**
         * The current timezone that you want to use for dates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
            return null;
        }

        /**
         * A regex expression to use when splitting text into terms, also called words or tokens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenizerPattern() {
            return null;
        }

        /**
         * A value to use to represent `TRUE` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrueString() {
            return null;
        }

        /**
         * The language that's used in the user-defined function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUdfLang() {
            return null;
        }

        /**
         * Specifies a unit of time.
         * <p>
         * For example: <code>MINUTES</code> ; <code>SECONDS</code> ; <code>HOURS</code> ; etc.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnits() {
            return null;
        }

        /**
         * Cast columns as rows, so that each value is a different row in a single column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnpivotColumn() {
            return null;
        }

        /**
         * The upper boundary for a value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpperBound() {
            return null;
        }

        /**
         * Create a new container to hold a dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUseNewDataFrame() {
            return null;
        }

        /**
         * A static value that can be used in a comparison, a substitution, or in another context-specific way.
         * <p>
         * A <code>Value</code> can be a number, string, or other datatype, depending on the recipe action in which it's used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * A value that's used by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue1() {
            return null;
        }

        /**
         * A value that's used by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue2() {
            return null;
        }

        /**
         * The column that is provided as a value that's used by this operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValueColumn() {
            return null;
        }

        /**
         * The subset of rows currently available for viewing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getViewFrame() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecipeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipeParametersProperty> {
            java.lang.String aggregateFunction;
            java.lang.String base;
            java.lang.String caseStatement;
            java.lang.String categoryMap;
            java.lang.String charsToRemove;
            java.lang.String collapseConsecutiveWhitespace;
            java.lang.String columnDataType;
            java.lang.String columnRange;
            java.lang.String count;
            java.lang.String customCharacters;
            java.lang.String customStopWords;
            java.lang.String customValue;
            java.lang.String datasetsColumns;
            java.lang.String dateAddValue;
            java.lang.String dateTimeFormat;
            java.lang.String dateTimeParameters;
            java.lang.String deleteOtherRows;
            java.lang.String delimiter;
            java.lang.String endPattern;
            java.lang.String endPosition;
            java.lang.String endValue;
            java.lang.String expandContractions;
            java.lang.String exponent;
            java.lang.String falseString;
            java.lang.String groupByAggFunctionOptions;
            java.lang.String groupByColumns;
            java.lang.String hiddenColumns;
            java.lang.String ignoreCase;
            java.lang.String includeInSplit;
            java.lang.Object input;
            java.lang.String interval;
            java.lang.String isText;
            java.lang.String joinKeys;
            java.lang.String joinType;
            java.lang.String leftColumns;
            java.lang.String limit;
            java.lang.String lowerBound;
            java.lang.String mapType;
            java.lang.String modeType;
            java.lang.Object multiLine;
            java.lang.String numRows;
            java.lang.String numRowsAfter;
            java.lang.String numRowsBefore;
            java.lang.String orderByColumn;
            java.lang.String orderByColumns;
            java.lang.String other;
            java.lang.String pattern;
            java.lang.String patternOption1;
            java.lang.String patternOption2;
            java.lang.String patternOptions;
            java.lang.String period;
            java.lang.String position;
            java.lang.String removeAllPunctuation;
            java.lang.String removeAllQuotes;
            java.lang.String removeAllWhitespace;
            java.lang.String removeCustomCharacters;
            java.lang.String removeCustomValue;
            java.lang.String removeLeadingAndTrailingPunctuation;
            java.lang.String removeLeadingAndTrailingQuotes;
            java.lang.String removeLeadingAndTrailingWhitespace;
            java.lang.String removeLetters;
            java.lang.String removeNumbers;
            java.lang.String removeSourceColumn;
            java.lang.String removeSpecialCharacters;
            java.lang.String rightColumns;
            java.lang.String sampleSize;
            java.lang.String sampleType;
            java.lang.Object secondaryInputs;
            java.lang.String secondInput;
            java.lang.Object sheetIndexes;
            java.util.List<java.lang.String> sheetNames;
            java.lang.String sourceColumn;
            java.lang.String sourceColumn1;
            java.lang.String sourceColumn2;
            java.lang.String sourceColumns;
            java.lang.String startColumnIndex;
            java.lang.String startPattern;
            java.lang.String startPosition;
            java.lang.String startValue;
            java.lang.String stemmingMode;
            java.lang.String stepCount;
            java.lang.String stepIndex;
            java.lang.String stopWordsMode;
            java.lang.String strategy;
            java.lang.String targetColumn;
            java.lang.String targetColumnNames;
            java.lang.String targetDateFormat;
            java.lang.String targetIndex;
            java.lang.String timeZone;
            java.lang.String tokenizerPattern;
            java.lang.String trueString;
            java.lang.String udfLang;
            java.lang.String units;
            java.lang.String unpivotColumn;
            java.lang.String upperBound;
            java.lang.String useNewDataFrame;
            java.lang.String value;
            java.lang.String value1;
            java.lang.String value2;
            java.lang.String valueColumn;
            java.lang.String viewFrame;

            /**
             * Sets the value of {@link RecipeParametersProperty#getAggregateFunction}
             * @param aggregateFunction The name of an aggregation function to apply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateFunction(java.lang.String aggregateFunction) {
                this.aggregateFunction = aggregateFunction;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getBase}
             * @param base The number of digits used in a counting system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.String base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCaseStatement}
             * @param caseStatement A case statement associated with a recipe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseStatement(java.lang.String caseStatement) {
                this.caseStatement = caseStatement;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCategoryMap}
             * @param categoryMap A category map used for one-hot encoding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryMap(java.lang.String categoryMap) {
                this.categoryMap = categoryMap;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCharsToRemove}
             * @param charsToRemove Characters to remove from a step that applies one-hot encoding or tokenization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder charsToRemove(java.lang.String charsToRemove) {
                this.charsToRemove = charsToRemove;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCollapseConsecutiveWhitespace}
             * @param collapseConsecutiveWhitespace Remove any non-word non-punctuation character.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collapseConsecutiveWhitespace(java.lang.String collapseConsecutiveWhitespace) {
                this.collapseConsecutiveWhitespace = collapseConsecutiveWhitespace;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getColumnDataType}
             * @param columnDataType The data type of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDataType(java.lang.String columnDataType) {
                this.columnDataType = columnDataType;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getColumnRange}
             * @param columnRange A range of columns to which a step is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnRange(java.lang.String columnRange) {
                this.columnRange = columnRange;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCount}
             * @param count The number of times a string needs to be repeated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.String count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCustomCharacters}
             * @param customCharacters One or more characters that can be substituted or removed, depending on the context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customCharacters(java.lang.String customCharacters) {
                this.customCharacters = customCharacters;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCustomStopWords}
             * @param customStopWords A list of words to ignore in a step that applies word tokenization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStopWords(java.lang.String customStopWords) {
                this.customStopWords = customStopWords;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getCustomValue}
             * @param customValue A list of custom values to use in a step that requires that you provide a value to finish the operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customValue(java.lang.String customValue) {
                this.customValue = customValue;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDatasetsColumns}
             * @param datasetsColumns A list of the dataset columns included in a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetsColumns(java.lang.String datasetsColumns) {
                this.datasetsColumns = datasetsColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDateAddValue}
             * @param dateAddValue A value that specifies how many units of time to add or subtract for a date math operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateAddValue(java.lang.String dateAddValue) {
                this.dateAddValue = dateAddValue;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDateTimeFormat}
             * @param dateTimeFormat A date format to apply to a date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeFormat(java.lang.String dateTimeFormat) {
                this.dateTimeFormat = dateTimeFormat;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDateTimeParameters}
             * @param dateTimeParameters A set of parameters associated with a datetime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeParameters(java.lang.String dateTimeParameters) {
                this.dateTimeParameters = dateTimeParameters;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDeleteOtherRows}
             * @param deleteOtherRows Determines whether unmapped rows in a categorical mapping should be deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOtherRows(java.lang.String deleteOtherRows) {
                this.deleteOtherRows = deleteOtherRows;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getDelimiter}
             * @param delimiter The delimiter to use when parsing separated values in a text file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getEndPattern}
             * @param endPattern The end pattern to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endPattern(java.lang.String endPattern) {
                this.endPattern = endPattern;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getEndPosition}
             * @param endPosition The end position to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endPosition(java.lang.String endPosition) {
                this.endPosition = endPosition;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getEndValue}
             * @param endValue The end value to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endValue(java.lang.String endValue) {
                this.endValue = endValue;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getExpandContractions}
             * @param expandContractions A list of word contractions and what they expand to.
             *                           For eample: <em>can't</em> ; <em>cannot</em> ; <em>can not</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expandContractions(java.lang.String expandContractions) {
                this.expandContractions = expandContractions;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getExponent}
             * @param exponent The exponent to apply in an exponential operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exponent(java.lang.String exponent) {
                this.exponent = exponent;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getFalseString}
             * @param falseString A value that represents `FALSE` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder falseString(java.lang.String falseString) {
                this.falseString = falseString;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getGroupByAggFunctionOptions}
             * @param groupByAggFunctionOptions Specifies options to apply to the `GROUP BY` used in an aggregation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupByAggFunctionOptions(java.lang.String groupByAggFunctionOptions) {
                this.groupByAggFunctionOptions = groupByAggFunctionOptions;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getGroupByColumns}
             * @param groupByColumns The columns to use in the `GROUP BY` clause.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupByColumns(java.lang.String groupByColumns) {
                this.groupByColumns = groupByColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getHiddenColumns}
             * @param hiddenColumns A list of columns to hide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiddenColumns(java.lang.String hiddenColumns) {
                this.hiddenColumns = hiddenColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getIgnoreCase}
             * @param ignoreCase Indicates that lower and upper case letters are treated equally.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreCase(java.lang.String ignoreCase) {
                this.ignoreCase = ignoreCase;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getIncludeInSplit}
             * @param includeInSplit Indicates if this column is participating in a split transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeInSplit(java.lang.String includeInSplit) {
                this.includeInSplit = includeInSplit;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getInput}
             * @param input The input location to load the dataset from - Amazon S3 or AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.Object input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getInterval}
             * @param interval The number of characters to split by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.String interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getIsText}
             * @param isText Indicates if the content is text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isText(java.lang.String isText) {
                this.isText = isText;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getJoinKeys}
             * @param joinKeys The keys or columns involved in a join.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinKeys(java.lang.String joinKeys) {
                this.joinKeys = joinKeys;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getJoinType}
             * @param joinType The type of join to use, for example, `INNER JOIN` , `OUTER JOIN` , and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinType(java.lang.String joinType) {
                this.joinType = joinType;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getLeftColumns}
             * @param leftColumns The columns on the left side of the join.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftColumns(java.lang.String leftColumns) {
                this.leftColumns = leftColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getLimit}
             * @param limit The number of times to perform `split` or `replaceBy` in a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limit(java.lang.String limit) {
                this.limit = limit;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getLowerBound}
             * @param lowerBound The lower boundary for a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowerBound(java.lang.String lowerBound) {
                this.lowerBound = lowerBound;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getMapType}
             * @param mapType The type of mappings to apply to construct a new dynamic frame.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapType(java.lang.String mapType) {
                this.mapType = mapType;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getModeType}
             * @param modeType Determines the manner in which mode value is calculated, in case there is more than one mode value.
             *                 Valid values: <code>NONE</code> | <code>AVERAGE</code> | <code>MINIMUM</code> | <code>MAXIMUM</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modeType(java.lang.String modeType) {
                this.modeType = modeType;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getMultiLine}
             * @param multiLine Specifies whether JSON input contains embedded new line characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiLine(java.lang.Boolean multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getMultiLine}
             * @param multiLine Specifies whether JSON input contains embedded new line characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiLine(software.amazon.awscdk.IResolvable multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getNumRows}
             * @param numRows The number of rows to consider in a window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numRows(java.lang.String numRows) {
                this.numRows = numRows;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getNumRowsAfter}
             * @param numRowsAfter The number of rows to consider after the current row in a window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numRowsAfter(java.lang.String numRowsAfter) {
                this.numRowsAfter = numRowsAfter;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getNumRowsBefore}
             * @param numRowsBefore The number of rows to consider before the current row in a window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numRowsBefore(java.lang.String numRowsBefore) {
                this.numRowsBefore = numRowsBefore;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getOrderByColumn}
             * @param orderByColumn A column to sort the results by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderByColumn(java.lang.String orderByColumn) {
                this.orderByColumn = orderByColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getOrderByColumns}
             * @param orderByColumns The columns to sort the results by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderByColumns(java.lang.String orderByColumns) {
                this.orderByColumns = orderByColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getOther}
             * @param other The value to assign to unmapped cells, in categorical mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder other(java.lang.String other) {
                this.other = other;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPattern}
             * @param pattern The pattern to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPatternOption1}
             * @param patternOption1 The starting pattern to split between.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternOption1(java.lang.String patternOption1) {
                this.patternOption1 = patternOption1;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPatternOption2}
             * @param patternOption2 The ending pattern to split between.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternOption2(java.lang.String patternOption2) {
                this.patternOption2 = patternOption2;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPatternOptions}
             * @param patternOptions For splitting by multiple delimiters: A JSON-encoded string that lists the patterns in the format.
             *                       For example: <code>[{\"pattern\":\"1\",\"includeInSplit\":true}]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternOptions(java.lang.String patternOptions) {
                this.patternOptions = patternOptions;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPeriod}
             * @param period The size of the rolling window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.String period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getPosition}
             * @param position The character index within a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(java.lang.String position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveAllPunctuation}
             * @param removeAllPunctuation If `true` , removes all of the following characters: `.` `.!` `.,` `.?`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAllPunctuation(java.lang.String removeAllPunctuation) {
                this.removeAllPunctuation = removeAllPunctuation;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveAllQuotes}
             * @param removeAllQuotes If `true` , removes all single quotes and double quotes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAllQuotes(java.lang.String removeAllQuotes) {
                this.removeAllQuotes = removeAllQuotes;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveAllWhitespace}
             * @param removeAllWhitespace If `true` , removes all whitespaces from the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAllWhitespace(java.lang.String removeAllWhitespace) {
                this.removeAllWhitespace = removeAllWhitespace;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveCustomCharacters}
             * @param removeCustomCharacters If `true` , removes all chraracters specified by `CustomCharacters` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomCharacters(java.lang.String removeCustomCharacters) {
                this.removeCustomCharacters = removeCustomCharacters;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveCustomValue}
             * @param removeCustomValue If `true` , removes all chraracters specified by `CustomValue` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomValue(java.lang.String removeCustomValue) {
                this.removeCustomValue = removeCustomValue;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveLeadingAndTrailingPunctuation}
             * @param removeLeadingAndTrailingPunctuation If `true` , removes the following characters if they occur at the start or end of the value: `.` `!` `,` `?`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeLeadingAndTrailingPunctuation(java.lang.String removeLeadingAndTrailingPunctuation) {
                this.removeLeadingAndTrailingPunctuation = removeLeadingAndTrailingPunctuation;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveLeadingAndTrailingQuotes}
             * @param removeLeadingAndTrailingQuotes If `true` , removes single quotes and double quotes from the beginning and end of the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeLeadingAndTrailingQuotes(java.lang.String removeLeadingAndTrailingQuotes) {
                this.removeLeadingAndTrailingQuotes = removeLeadingAndTrailingQuotes;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveLeadingAndTrailingWhitespace}
             * @param removeLeadingAndTrailingWhitespace If `true` , removes all whitespaces from the beginning and end of the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeLeadingAndTrailingWhitespace(java.lang.String removeLeadingAndTrailingWhitespace) {
                this.removeLeadingAndTrailingWhitespace = removeLeadingAndTrailingWhitespace;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveLetters}
             * @param removeLetters If `true` , removes all uppercase and lowercase alphabetic characters (A through Z;.
             *                      a through z).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeLetters(java.lang.String removeLetters) {
                this.removeLetters = removeLetters;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveNumbers}
             * @param removeNumbers If `true` , removes all numeric characters (0 through 9).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeNumbers(java.lang.String removeNumbers) {
                this.removeNumbers = removeNumbers;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveSourceColumn}
             * @param removeSourceColumn If `true` , the source column will be removed after un-nesting that column.
             *                           (Used with nested column types, such as Map, Struct, or Array.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeSourceColumn(java.lang.String removeSourceColumn) {
                this.removeSourceColumn = removeSourceColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRemoveSpecialCharacters}
             * @param removeSpecialCharacters If `true` , removes all of the following characters: `!.
             *                                " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? &#64; [ \ ] ^ _ <code> { | } ~</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeSpecialCharacters(java.lang.String removeSpecialCharacters) {
                this.removeSpecialCharacters = removeSpecialCharacters;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getRightColumns}
             * @param rightColumns The columns on the right side of a join.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightColumns(java.lang.String rightColumns) {
                this.rightColumns = rightColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSampleSize}
             * @param sampleSize The number of rows in the sample.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleSize(java.lang.String sampleSize) {
                this.sampleSize = sampleSize;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSampleType}
             * @param sampleType The sampling type to apply to the dataset.
             *                   Valid values: <code>FIRST_N</code> | <code>LAST_N</code> | <code>RANDOM</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleType(java.lang.String sampleType) {
                this.sampleType = sampleType;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSecondaryInputs}
             * @param secondaryInputs A list of secondary inputs in a UNION transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryInputs(software.amazon.awscdk.IResolvable secondaryInputs) {
                this.secondaryInputs = secondaryInputs;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSecondaryInputs}
             * @param secondaryInputs A list of secondary inputs in a UNION transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryInputs(java.util.List<? extends java.lang.Object> secondaryInputs) {
                this.secondaryInputs = secondaryInputs;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSecondInput}
             * @param secondInput A object value to indicate the second dataset used in a join.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondInput(java.lang.String secondInput) {
                this.secondInput = secondInput;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSheetIndexes}
             * @param sheetIndexes One or more sheet numbers in the Excel file, which will be included in a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetIndexes(software.amazon.awscdk.IResolvable sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSheetIndexes}
             * @param sheetIndexes One or more sheet numbers in the Excel file, which will be included in a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetIndexes(java.util.List<? extends java.lang.Number> sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSheetNames}
             * @param sheetNames Oone or more named sheets in the Excel file, which will be included in a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetNames(java.util.List<java.lang.String> sheetNames) {
                this.sheetNames = sheetNames;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSourceColumn}
             * @param sourceColumn A source column needed for an operation, step, or transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumn(java.lang.String sourceColumn) {
                this.sourceColumn = sourceColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSourceColumn1}
             * @param sourceColumn1 A source column needed for an operation, step, or transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumn1(java.lang.String sourceColumn1) {
                this.sourceColumn1 = sourceColumn1;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSourceColumn2}
             * @param sourceColumn2 A source column needed for an operation, step, or transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumn2(java.lang.String sourceColumn2) {
                this.sourceColumn2 = sourceColumn2;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getSourceColumns}
             * @param sourceColumns A list of source columns needed for an operation, step, or transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumns(java.lang.String sourceColumns) {
                this.sourceColumns = sourceColumns;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStartColumnIndex}
             * @param startColumnIndex The index number of the first column used by an operation, step, or transform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startColumnIndex(java.lang.String startColumnIndex) {
                this.startColumnIndex = startColumnIndex;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStartPattern}
             * @param startPattern The starting pattern to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startPattern(java.lang.String startPattern) {
                this.startPattern = startPattern;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStartPosition}
             * @param startPosition The starting position to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startPosition(java.lang.String startPosition) {
                this.startPosition = startPosition;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStartValue}
             * @param startValue The starting value to locate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startValue(java.lang.String startValue) {
                this.startValue = startValue;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStemmingMode}
             * @param stemmingMode Indicates this operation uses stems and lemmas (base words) for word tokenization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stemmingMode(java.lang.String stemmingMode) {
                this.stemmingMode = stemmingMode;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStepCount}
             * @param stepCount The total number of transforms in this recipe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepCount(java.lang.String stepCount) {
                this.stepCount = stepCount;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStepIndex}
             * @param stepIndex The index ID of a step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepIndex(java.lang.String stepIndex) {
                this.stepIndex = stepIndex;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStopWordsMode}
             * @param stopWordsMode Indicates this operation uses stop words as part of word tokenization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopWordsMode(java.lang.String stopWordsMode) {
                this.stopWordsMode = stopWordsMode;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getStrategy}
             * @param strategy The resolution strategy to apply in resolving ambiguities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strategy(java.lang.String strategy) {
                this.strategy = strategy;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTargetColumn}
             * @param targetColumn The column targeted by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetColumn(java.lang.String targetColumn) {
                this.targetColumn = targetColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTargetColumnNames}
             * @param targetColumnNames The names to give columns altered by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetColumnNames(java.lang.String targetColumnNames) {
                this.targetColumnNames = targetColumnNames;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTargetDateFormat}
             * @param targetDateFormat The date format to convert to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDateFormat(java.lang.String targetDateFormat) {
                this.targetDateFormat = targetDateFormat;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTargetIndex}
             * @param targetIndex The index number of an object that is targeted by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetIndex(java.lang.String targetIndex) {
                this.targetIndex = targetIndex;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTimeZone}
             * @param timeZone The current timezone that you want to use for dates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTokenizerPattern}
             * @param tokenizerPattern A regex expression to use when splitting text into terms, also called words or tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenizerPattern(java.lang.String tokenizerPattern) {
                this.tokenizerPattern = tokenizerPattern;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getTrueString}
             * @param trueString A value to use to represent `TRUE` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trueString(java.lang.String trueString) {
                this.trueString = trueString;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getUdfLang}
             * @param udfLang The language that's used in the user-defined function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder udfLang(java.lang.String udfLang) {
                this.udfLang = udfLang;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getUnits}
             * @param units Specifies a unit of time.
             *              For example: <code>MINUTES</code> ; <code>SECONDS</code> ; <code>HOURS</code> ; etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder units(java.lang.String units) {
                this.units = units;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getUnpivotColumn}
             * @param unpivotColumn Cast columns as rows, so that each value is a different row in a single column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unpivotColumn(java.lang.String unpivotColumn) {
                this.unpivotColumn = unpivotColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getUpperBound}
             * @param upperBound The upper boundary for a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upperBound(java.lang.String upperBound) {
                this.upperBound = upperBound;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getUseNewDataFrame}
             * @param useNewDataFrame Create a new container to hold a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useNewDataFrame(java.lang.String useNewDataFrame) {
                this.useNewDataFrame = useNewDataFrame;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getValue}
             * @param value A static value that can be used in a comparison, a substitution, or in another context-specific way.
             *              A <code>Value</code> can be a number, string, or other datatype, depending on the recipe action in which it's used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getValue1}
             * @param value1 A value that's used by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value1(java.lang.String value1) {
                this.value1 = value1;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getValue2}
             * @param value2 A value that's used by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value2(java.lang.String value2) {
                this.value2 = value2;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getValueColumn}
             * @param valueColumn The column that is provided as a value that's used by this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueColumn(java.lang.String valueColumn) {
                this.valueColumn = valueColumn;
                return this;
            }

            /**
             * Sets the value of {@link RecipeParametersProperty#getViewFrame}
             * @param viewFrame The subset of rows currently available for viewing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewFrame(java.lang.String viewFrame) {
                this.viewFrame = viewFrame;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipeParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipeParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipeParametersProperty {
            private final java.lang.String aggregateFunction;
            private final java.lang.String base;
            private final java.lang.String caseStatement;
            private final java.lang.String categoryMap;
            private final java.lang.String charsToRemove;
            private final java.lang.String collapseConsecutiveWhitespace;
            private final java.lang.String columnDataType;
            private final java.lang.String columnRange;
            private final java.lang.String count;
            private final java.lang.String customCharacters;
            private final java.lang.String customStopWords;
            private final java.lang.String customValue;
            private final java.lang.String datasetsColumns;
            private final java.lang.String dateAddValue;
            private final java.lang.String dateTimeFormat;
            private final java.lang.String dateTimeParameters;
            private final java.lang.String deleteOtherRows;
            private final java.lang.String delimiter;
            private final java.lang.String endPattern;
            private final java.lang.String endPosition;
            private final java.lang.String endValue;
            private final java.lang.String expandContractions;
            private final java.lang.String exponent;
            private final java.lang.String falseString;
            private final java.lang.String groupByAggFunctionOptions;
            private final java.lang.String groupByColumns;
            private final java.lang.String hiddenColumns;
            private final java.lang.String ignoreCase;
            private final java.lang.String includeInSplit;
            private final java.lang.Object input;
            private final java.lang.String interval;
            private final java.lang.String isText;
            private final java.lang.String joinKeys;
            private final java.lang.String joinType;
            private final java.lang.String leftColumns;
            private final java.lang.String limit;
            private final java.lang.String lowerBound;
            private final java.lang.String mapType;
            private final java.lang.String modeType;
            private final java.lang.Object multiLine;
            private final java.lang.String numRows;
            private final java.lang.String numRowsAfter;
            private final java.lang.String numRowsBefore;
            private final java.lang.String orderByColumn;
            private final java.lang.String orderByColumns;
            private final java.lang.String other;
            private final java.lang.String pattern;
            private final java.lang.String patternOption1;
            private final java.lang.String patternOption2;
            private final java.lang.String patternOptions;
            private final java.lang.String period;
            private final java.lang.String position;
            private final java.lang.String removeAllPunctuation;
            private final java.lang.String removeAllQuotes;
            private final java.lang.String removeAllWhitespace;
            private final java.lang.String removeCustomCharacters;
            private final java.lang.String removeCustomValue;
            private final java.lang.String removeLeadingAndTrailingPunctuation;
            private final java.lang.String removeLeadingAndTrailingQuotes;
            private final java.lang.String removeLeadingAndTrailingWhitespace;
            private final java.lang.String removeLetters;
            private final java.lang.String removeNumbers;
            private final java.lang.String removeSourceColumn;
            private final java.lang.String removeSpecialCharacters;
            private final java.lang.String rightColumns;
            private final java.lang.String sampleSize;
            private final java.lang.String sampleType;
            private final java.lang.Object secondaryInputs;
            private final java.lang.String secondInput;
            private final java.lang.Object sheetIndexes;
            private final java.util.List<java.lang.String> sheetNames;
            private final java.lang.String sourceColumn;
            private final java.lang.String sourceColumn1;
            private final java.lang.String sourceColumn2;
            private final java.lang.String sourceColumns;
            private final java.lang.String startColumnIndex;
            private final java.lang.String startPattern;
            private final java.lang.String startPosition;
            private final java.lang.String startValue;
            private final java.lang.String stemmingMode;
            private final java.lang.String stepCount;
            private final java.lang.String stepIndex;
            private final java.lang.String stopWordsMode;
            private final java.lang.String strategy;
            private final java.lang.String targetColumn;
            private final java.lang.String targetColumnNames;
            private final java.lang.String targetDateFormat;
            private final java.lang.String targetIndex;
            private final java.lang.String timeZone;
            private final java.lang.String tokenizerPattern;
            private final java.lang.String trueString;
            private final java.lang.String udfLang;
            private final java.lang.String units;
            private final java.lang.String unpivotColumn;
            private final java.lang.String upperBound;
            private final java.lang.String useNewDataFrame;
            private final java.lang.String value;
            private final java.lang.String value1;
            private final java.lang.String value2;
            private final java.lang.String valueColumn;
            private final java.lang.String viewFrame;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregateFunction = software.amazon.jsii.Kernel.get(this, "aggregateFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.caseStatement = software.amazon.jsii.Kernel.get(this, "caseStatement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.categoryMap = software.amazon.jsii.Kernel.get(this, "categoryMap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.charsToRemove = software.amazon.jsii.Kernel.get(this, "charsToRemove", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.collapseConsecutiveWhitespace = software.amazon.jsii.Kernel.get(this, "collapseConsecutiveWhitespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnDataType = software.amazon.jsii.Kernel.get(this, "columnDataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnRange = software.amazon.jsii.Kernel.get(this, "columnRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customCharacters = software.amazon.jsii.Kernel.get(this, "customCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customStopWords = software.amazon.jsii.Kernel.get(this, "customStopWords", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customValue = software.amazon.jsii.Kernel.get(this, "customValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetsColumns = software.amazon.jsii.Kernel.get(this, "datasetsColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateAddValue = software.amazon.jsii.Kernel.get(this, "dateAddValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateTimeFormat = software.amazon.jsii.Kernel.get(this, "dateTimeFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateTimeParameters = software.amazon.jsii.Kernel.get(this, "dateTimeParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deleteOtherRows = software.amazon.jsii.Kernel.get(this, "deleteOtherRows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endPattern = software.amazon.jsii.Kernel.get(this, "endPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endPosition = software.amazon.jsii.Kernel.get(this, "endPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endValue = software.amazon.jsii.Kernel.get(this, "endValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expandContractions = software.amazon.jsii.Kernel.get(this, "expandContractions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exponent = software.amazon.jsii.Kernel.get(this, "exponent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.falseString = software.amazon.jsii.Kernel.get(this, "falseString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupByAggFunctionOptions = software.amazon.jsii.Kernel.get(this, "groupByAggFunctionOptions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupByColumns = software.amazon.jsii.Kernel.get(this, "groupByColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hiddenColumns = software.amazon.jsii.Kernel.get(this, "hiddenColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ignoreCase = software.amazon.jsii.Kernel.get(this, "ignoreCase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeInSplit = software.amazon.jsii.Kernel.get(this, "includeInSplit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isText = software.amazon.jsii.Kernel.get(this, "isText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.joinKeys = software.amazon.jsii.Kernel.get(this, "joinKeys", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.joinType = software.amazon.jsii.Kernel.get(this, "joinType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftColumns = software.amazon.jsii.Kernel.get(this, "leftColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lowerBound = software.amazon.jsii.Kernel.get(this, "lowerBound", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mapType = software.amazon.jsii.Kernel.get(this, "mapType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modeType = software.amazon.jsii.Kernel.get(this, "modeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multiLine = software.amazon.jsii.Kernel.get(this, "multiLine", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numRows = software.amazon.jsii.Kernel.get(this, "numRows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numRowsAfter = software.amazon.jsii.Kernel.get(this, "numRowsAfter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numRowsBefore = software.amazon.jsii.Kernel.get(this, "numRowsBefore", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orderByColumn = software.amazon.jsii.Kernel.get(this, "orderByColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orderByColumns = software.amazon.jsii.Kernel.get(this, "orderByColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.other = software.amazon.jsii.Kernel.get(this, "other", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternOption1 = software.amazon.jsii.Kernel.get(this, "patternOption1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternOption2 = software.amazon.jsii.Kernel.get(this, "patternOption2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternOptions = software.amazon.jsii.Kernel.get(this, "patternOptions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeAllPunctuation = software.amazon.jsii.Kernel.get(this, "removeAllPunctuation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeAllQuotes = software.amazon.jsii.Kernel.get(this, "removeAllQuotes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeAllWhitespace = software.amazon.jsii.Kernel.get(this, "removeAllWhitespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeCustomCharacters = software.amazon.jsii.Kernel.get(this, "removeCustomCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeCustomValue = software.amazon.jsii.Kernel.get(this, "removeCustomValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeLeadingAndTrailingPunctuation = software.amazon.jsii.Kernel.get(this, "removeLeadingAndTrailingPunctuation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeLeadingAndTrailingQuotes = software.amazon.jsii.Kernel.get(this, "removeLeadingAndTrailingQuotes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeLeadingAndTrailingWhitespace = software.amazon.jsii.Kernel.get(this, "removeLeadingAndTrailingWhitespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeLetters = software.amazon.jsii.Kernel.get(this, "removeLetters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeNumbers = software.amazon.jsii.Kernel.get(this, "removeNumbers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeSourceColumn = software.amazon.jsii.Kernel.get(this, "removeSourceColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeSpecialCharacters = software.amazon.jsii.Kernel.get(this, "removeSpecialCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightColumns = software.amazon.jsii.Kernel.get(this, "rightColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleSize = software.amazon.jsii.Kernel.get(this, "sampleSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleType = software.amazon.jsii.Kernel.get(this, "sampleType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryInputs = software.amazon.jsii.Kernel.get(this, "secondaryInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondInput = software.amazon.jsii.Kernel.get(this, "secondInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sheetIndexes = software.amazon.jsii.Kernel.get(this, "sheetIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheetNames = software.amazon.jsii.Kernel.get(this, "sheetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceColumn = software.amazon.jsii.Kernel.get(this, "sourceColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceColumn1 = software.amazon.jsii.Kernel.get(this, "sourceColumn1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceColumn2 = software.amazon.jsii.Kernel.get(this, "sourceColumn2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceColumns = software.amazon.jsii.Kernel.get(this, "sourceColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startColumnIndex = software.amazon.jsii.Kernel.get(this, "startColumnIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startPattern = software.amazon.jsii.Kernel.get(this, "startPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startPosition = software.amazon.jsii.Kernel.get(this, "startPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startValue = software.amazon.jsii.Kernel.get(this, "startValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stemmingMode = software.amazon.jsii.Kernel.get(this, "stemmingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stepCount = software.amazon.jsii.Kernel.get(this, "stepCount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stepIndex = software.amazon.jsii.Kernel.get(this, "stepIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stopWordsMode = software.amazon.jsii.Kernel.get(this, "stopWordsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strategy = software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetColumn = software.amazon.jsii.Kernel.get(this, "targetColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetColumnNames = software.amazon.jsii.Kernel.get(this, "targetColumnNames", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetDateFormat = software.amazon.jsii.Kernel.get(this, "targetDateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetIndex = software.amazon.jsii.Kernel.get(this, "targetIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenizerPattern = software.amazon.jsii.Kernel.get(this, "tokenizerPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trueString = software.amazon.jsii.Kernel.get(this, "trueString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.udfLang = software.amazon.jsii.Kernel.get(this, "udfLang", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.units = software.amazon.jsii.Kernel.get(this, "units", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unpivotColumn = software.amazon.jsii.Kernel.get(this, "unpivotColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.upperBound = software.amazon.jsii.Kernel.get(this, "upperBound", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useNewDataFrame = software.amazon.jsii.Kernel.get(this, "useNewDataFrame", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value1 = software.amazon.jsii.Kernel.get(this, "value1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value2 = software.amazon.jsii.Kernel.get(this, "value2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueColumn = software.amazon.jsii.Kernel.get(this, "valueColumn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewFrame = software.amazon.jsii.Kernel.get(this, "viewFrame", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregateFunction = builder.aggregateFunction;
                this.base = builder.base;
                this.caseStatement = builder.caseStatement;
                this.categoryMap = builder.categoryMap;
                this.charsToRemove = builder.charsToRemove;
                this.collapseConsecutiveWhitespace = builder.collapseConsecutiveWhitespace;
                this.columnDataType = builder.columnDataType;
                this.columnRange = builder.columnRange;
                this.count = builder.count;
                this.customCharacters = builder.customCharacters;
                this.customStopWords = builder.customStopWords;
                this.customValue = builder.customValue;
                this.datasetsColumns = builder.datasetsColumns;
                this.dateAddValue = builder.dateAddValue;
                this.dateTimeFormat = builder.dateTimeFormat;
                this.dateTimeParameters = builder.dateTimeParameters;
                this.deleteOtherRows = builder.deleteOtherRows;
                this.delimiter = builder.delimiter;
                this.endPattern = builder.endPattern;
                this.endPosition = builder.endPosition;
                this.endValue = builder.endValue;
                this.expandContractions = builder.expandContractions;
                this.exponent = builder.exponent;
                this.falseString = builder.falseString;
                this.groupByAggFunctionOptions = builder.groupByAggFunctionOptions;
                this.groupByColumns = builder.groupByColumns;
                this.hiddenColumns = builder.hiddenColumns;
                this.ignoreCase = builder.ignoreCase;
                this.includeInSplit = builder.includeInSplit;
                this.input = builder.input;
                this.interval = builder.interval;
                this.isText = builder.isText;
                this.joinKeys = builder.joinKeys;
                this.joinType = builder.joinType;
                this.leftColumns = builder.leftColumns;
                this.limit = builder.limit;
                this.lowerBound = builder.lowerBound;
                this.mapType = builder.mapType;
                this.modeType = builder.modeType;
                this.multiLine = builder.multiLine;
                this.numRows = builder.numRows;
                this.numRowsAfter = builder.numRowsAfter;
                this.numRowsBefore = builder.numRowsBefore;
                this.orderByColumn = builder.orderByColumn;
                this.orderByColumns = builder.orderByColumns;
                this.other = builder.other;
                this.pattern = builder.pattern;
                this.patternOption1 = builder.patternOption1;
                this.patternOption2 = builder.patternOption2;
                this.patternOptions = builder.patternOptions;
                this.period = builder.period;
                this.position = builder.position;
                this.removeAllPunctuation = builder.removeAllPunctuation;
                this.removeAllQuotes = builder.removeAllQuotes;
                this.removeAllWhitespace = builder.removeAllWhitespace;
                this.removeCustomCharacters = builder.removeCustomCharacters;
                this.removeCustomValue = builder.removeCustomValue;
                this.removeLeadingAndTrailingPunctuation = builder.removeLeadingAndTrailingPunctuation;
                this.removeLeadingAndTrailingQuotes = builder.removeLeadingAndTrailingQuotes;
                this.removeLeadingAndTrailingWhitespace = builder.removeLeadingAndTrailingWhitespace;
                this.removeLetters = builder.removeLetters;
                this.removeNumbers = builder.removeNumbers;
                this.removeSourceColumn = builder.removeSourceColumn;
                this.removeSpecialCharacters = builder.removeSpecialCharacters;
                this.rightColumns = builder.rightColumns;
                this.sampleSize = builder.sampleSize;
                this.sampleType = builder.sampleType;
                this.secondaryInputs = builder.secondaryInputs;
                this.secondInput = builder.secondInput;
                this.sheetIndexes = builder.sheetIndexes;
                this.sheetNames = builder.sheetNames;
                this.sourceColumn = builder.sourceColumn;
                this.sourceColumn1 = builder.sourceColumn1;
                this.sourceColumn2 = builder.sourceColumn2;
                this.sourceColumns = builder.sourceColumns;
                this.startColumnIndex = builder.startColumnIndex;
                this.startPattern = builder.startPattern;
                this.startPosition = builder.startPosition;
                this.startValue = builder.startValue;
                this.stemmingMode = builder.stemmingMode;
                this.stepCount = builder.stepCount;
                this.stepIndex = builder.stepIndex;
                this.stopWordsMode = builder.stopWordsMode;
                this.strategy = builder.strategy;
                this.targetColumn = builder.targetColumn;
                this.targetColumnNames = builder.targetColumnNames;
                this.targetDateFormat = builder.targetDateFormat;
                this.targetIndex = builder.targetIndex;
                this.timeZone = builder.timeZone;
                this.tokenizerPattern = builder.tokenizerPattern;
                this.trueString = builder.trueString;
                this.udfLang = builder.udfLang;
                this.units = builder.units;
                this.unpivotColumn = builder.unpivotColumn;
                this.upperBound = builder.upperBound;
                this.useNewDataFrame = builder.useNewDataFrame;
                this.value = builder.value;
                this.value1 = builder.value1;
                this.value2 = builder.value2;
                this.valueColumn = builder.valueColumn;
                this.viewFrame = builder.viewFrame;
            }

            @Override
            public final java.lang.String getAggregateFunction() {
                return this.aggregateFunction;
            }

            @Override
            public final java.lang.String getBase() {
                return this.base;
            }

            @Override
            public final java.lang.String getCaseStatement() {
                return this.caseStatement;
            }

            @Override
            public final java.lang.String getCategoryMap() {
                return this.categoryMap;
            }

            @Override
            public final java.lang.String getCharsToRemove() {
                return this.charsToRemove;
            }

            @Override
            public final java.lang.String getCollapseConsecutiveWhitespace() {
                return this.collapseConsecutiveWhitespace;
            }

            @Override
            public final java.lang.String getColumnDataType() {
                return this.columnDataType;
            }

            @Override
            public final java.lang.String getColumnRange() {
                return this.columnRange;
            }

            @Override
            public final java.lang.String getCount() {
                return this.count;
            }

            @Override
            public final java.lang.String getCustomCharacters() {
                return this.customCharacters;
            }

            @Override
            public final java.lang.String getCustomStopWords() {
                return this.customStopWords;
            }

            @Override
            public final java.lang.String getCustomValue() {
                return this.customValue;
            }

            @Override
            public final java.lang.String getDatasetsColumns() {
                return this.datasetsColumns;
            }

            @Override
            public final java.lang.String getDateAddValue() {
                return this.dateAddValue;
            }

            @Override
            public final java.lang.String getDateTimeFormat() {
                return this.dateTimeFormat;
            }

            @Override
            public final java.lang.String getDateTimeParameters() {
                return this.dateTimeParameters;
            }

            @Override
            public final java.lang.String getDeleteOtherRows() {
                return this.deleteOtherRows;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getEndPattern() {
                return this.endPattern;
            }

            @Override
            public final java.lang.String getEndPosition() {
                return this.endPosition;
            }

            @Override
            public final java.lang.String getEndValue() {
                return this.endValue;
            }

            @Override
            public final java.lang.String getExpandContractions() {
                return this.expandContractions;
            }

            @Override
            public final java.lang.String getExponent() {
                return this.exponent;
            }

            @Override
            public final java.lang.String getFalseString() {
                return this.falseString;
            }

            @Override
            public final java.lang.String getGroupByAggFunctionOptions() {
                return this.groupByAggFunctionOptions;
            }

            @Override
            public final java.lang.String getGroupByColumns() {
                return this.groupByColumns;
            }

            @Override
            public final java.lang.String getHiddenColumns() {
                return this.hiddenColumns;
            }

            @Override
            public final java.lang.String getIgnoreCase() {
                return this.ignoreCase;
            }

            @Override
            public final java.lang.String getIncludeInSplit() {
                return this.includeInSplit;
            }

            @Override
            public final java.lang.Object getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIsText() {
                return this.isText;
            }

            @Override
            public final java.lang.String getJoinKeys() {
                return this.joinKeys;
            }

            @Override
            public final java.lang.String getJoinType() {
                return this.joinType;
            }

            @Override
            public final java.lang.String getLeftColumns() {
                return this.leftColumns;
            }

            @Override
            public final java.lang.String getLimit() {
                return this.limit;
            }

            @Override
            public final java.lang.String getLowerBound() {
                return this.lowerBound;
            }

            @Override
            public final java.lang.String getMapType() {
                return this.mapType;
            }

            @Override
            public final java.lang.String getModeType() {
                return this.modeType;
            }

            @Override
            public final java.lang.Object getMultiLine() {
                return this.multiLine;
            }

            @Override
            public final java.lang.String getNumRows() {
                return this.numRows;
            }

            @Override
            public final java.lang.String getNumRowsAfter() {
                return this.numRowsAfter;
            }

            @Override
            public final java.lang.String getNumRowsBefore() {
                return this.numRowsBefore;
            }

            @Override
            public final java.lang.String getOrderByColumn() {
                return this.orderByColumn;
            }

            @Override
            public final java.lang.String getOrderByColumns() {
                return this.orderByColumns;
            }

            @Override
            public final java.lang.String getOther() {
                return this.other;
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getPatternOption1() {
                return this.patternOption1;
            }

            @Override
            public final java.lang.String getPatternOption2() {
                return this.patternOption2;
            }

            @Override
            public final java.lang.String getPatternOptions() {
                return this.patternOptions;
            }

            @Override
            public final java.lang.String getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.String getPosition() {
                return this.position;
            }

            @Override
            public final java.lang.String getRemoveAllPunctuation() {
                return this.removeAllPunctuation;
            }

            @Override
            public final java.lang.String getRemoveAllQuotes() {
                return this.removeAllQuotes;
            }

            @Override
            public final java.lang.String getRemoveAllWhitespace() {
                return this.removeAllWhitespace;
            }

            @Override
            public final java.lang.String getRemoveCustomCharacters() {
                return this.removeCustomCharacters;
            }

            @Override
            public final java.lang.String getRemoveCustomValue() {
                return this.removeCustomValue;
            }

            @Override
            public final java.lang.String getRemoveLeadingAndTrailingPunctuation() {
                return this.removeLeadingAndTrailingPunctuation;
            }

            @Override
            public final java.lang.String getRemoveLeadingAndTrailingQuotes() {
                return this.removeLeadingAndTrailingQuotes;
            }

            @Override
            public final java.lang.String getRemoveLeadingAndTrailingWhitespace() {
                return this.removeLeadingAndTrailingWhitespace;
            }

            @Override
            public final java.lang.String getRemoveLetters() {
                return this.removeLetters;
            }

            @Override
            public final java.lang.String getRemoveNumbers() {
                return this.removeNumbers;
            }

            @Override
            public final java.lang.String getRemoveSourceColumn() {
                return this.removeSourceColumn;
            }

            @Override
            public final java.lang.String getRemoveSpecialCharacters() {
                return this.removeSpecialCharacters;
            }

            @Override
            public final java.lang.String getRightColumns() {
                return this.rightColumns;
            }

            @Override
            public final java.lang.String getSampleSize() {
                return this.sampleSize;
            }

            @Override
            public final java.lang.String getSampleType() {
                return this.sampleType;
            }

            @Override
            public final java.lang.Object getSecondaryInputs() {
                return this.secondaryInputs;
            }

            @Override
            public final java.lang.String getSecondInput() {
                return this.secondInput;
            }

            @Override
            public final java.lang.Object getSheetIndexes() {
                return this.sheetIndexes;
            }

            @Override
            public final java.util.List<java.lang.String> getSheetNames() {
                return this.sheetNames;
            }

            @Override
            public final java.lang.String getSourceColumn() {
                return this.sourceColumn;
            }

            @Override
            public final java.lang.String getSourceColumn1() {
                return this.sourceColumn1;
            }

            @Override
            public final java.lang.String getSourceColumn2() {
                return this.sourceColumn2;
            }

            @Override
            public final java.lang.String getSourceColumns() {
                return this.sourceColumns;
            }

            @Override
            public final java.lang.String getStartColumnIndex() {
                return this.startColumnIndex;
            }

            @Override
            public final java.lang.String getStartPattern() {
                return this.startPattern;
            }

            @Override
            public final java.lang.String getStartPosition() {
                return this.startPosition;
            }

            @Override
            public final java.lang.String getStartValue() {
                return this.startValue;
            }

            @Override
            public final java.lang.String getStemmingMode() {
                return this.stemmingMode;
            }

            @Override
            public final java.lang.String getStepCount() {
                return this.stepCount;
            }

            @Override
            public final java.lang.String getStepIndex() {
                return this.stepIndex;
            }

            @Override
            public final java.lang.String getStopWordsMode() {
                return this.stopWordsMode;
            }

            @Override
            public final java.lang.String getStrategy() {
                return this.strategy;
            }

            @Override
            public final java.lang.String getTargetColumn() {
                return this.targetColumn;
            }

            @Override
            public final java.lang.String getTargetColumnNames() {
                return this.targetColumnNames;
            }

            @Override
            public final java.lang.String getTargetDateFormat() {
                return this.targetDateFormat;
            }

            @Override
            public final java.lang.String getTargetIndex() {
                return this.targetIndex;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            public final java.lang.String getTokenizerPattern() {
                return this.tokenizerPattern;
            }

            @Override
            public final java.lang.String getTrueString() {
                return this.trueString;
            }

            @Override
            public final java.lang.String getUdfLang() {
                return this.udfLang;
            }

            @Override
            public final java.lang.String getUnits() {
                return this.units;
            }

            @Override
            public final java.lang.String getUnpivotColumn() {
                return this.unpivotColumn;
            }

            @Override
            public final java.lang.String getUpperBound() {
                return this.upperBound;
            }

            @Override
            public final java.lang.String getUseNewDataFrame() {
                return this.useNewDataFrame;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getValue1() {
                return this.value1;
            }

            @Override
            public final java.lang.String getValue2() {
                return this.value2;
            }

            @Override
            public final java.lang.String getValueColumn() {
                return this.valueColumn;
            }

            @Override
            public final java.lang.String getViewFrame() {
                return this.viewFrame;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregateFunction() != null) {
                    data.set("aggregateFunction", om.valueToTree(this.getAggregateFunction()));
                }
                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getCaseStatement() != null) {
                    data.set("caseStatement", om.valueToTree(this.getCaseStatement()));
                }
                if (this.getCategoryMap() != null) {
                    data.set("categoryMap", om.valueToTree(this.getCategoryMap()));
                }
                if (this.getCharsToRemove() != null) {
                    data.set("charsToRemove", om.valueToTree(this.getCharsToRemove()));
                }
                if (this.getCollapseConsecutiveWhitespace() != null) {
                    data.set("collapseConsecutiveWhitespace", om.valueToTree(this.getCollapseConsecutiveWhitespace()));
                }
                if (this.getColumnDataType() != null) {
                    data.set("columnDataType", om.valueToTree(this.getColumnDataType()));
                }
                if (this.getColumnRange() != null) {
                    data.set("columnRange", om.valueToTree(this.getColumnRange()));
                }
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getCustomCharacters() != null) {
                    data.set("customCharacters", om.valueToTree(this.getCustomCharacters()));
                }
                if (this.getCustomStopWords() != null) {
                    data.set("customStopWords", om.valueToTree(this.getCustomStopWords()));
                }
                if (this.getCustomValue() != null) {
                    data.set("customValue", om.valueToTree(this.getCustomValue()));
                }
                if (this.getDatasetsColumns() != null) {
                    data.set("datasetsColumns", om.valueToTree(this.getDatasetsColumns()));
                }
                if (this.getDateAddValue() != null) {
                    data.set("dateAddValue", om.valueToTree(this.getDateAddValue()));
                }
                if (this.getDateTimeFormat() != null) {
                    data.set("dateTimeFormat", om.valueToTree(this.getDateTimeFormat()));
                }
                if (this.getDateTimeParameters() != null) {
                    data.set("dateTimeParameters", om.valueToTree(this.getDateTimeParameters()));
                }
                if (this.getDeleteOtherRows() != null) {
                    data.set("deleteOtherRows", om.valueToTree(this.getDeleteOtherRows()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getEndPattern() != null) {
                    data.set("endPattern", om.valueToTree(this.getEndPattern()));
                }
                if (this.getEndPosition() != null) {
                    data.set("endPosition", om.valueToTree(this.getEndPosition()));
                }
                if (this.getEndValue() != null) {
                    data.set("endValue", om.valueToTree(this.getEndValue()));
                }
                if (this.getExpandContractions() != null) {
                    data.set("expandContractions", om.valueToTree(this.getExpandContractions()));
                }
                if (this.getExponent() != null) {
                    data.set("exponent", om.valueToTree(this.getExponent()));
                }
                if (this.getFalseString() != null) {
                    data.set("falseString", om.valueToTree(this.getFalseString()));
                }
                if (this.getGroupByAggFunctionOptions() != null) {
                    data.set("groupByAggFunctionOptions", om.valueToTree(this.getGroupByAggFunctionOptions()));
                }
                if (this.getGroupByColumns() != null) {
                    data.set("groupByColumns", om.valueToTree(this.getGroupByColumns()));
                }
                if (this.getHiddenColumns() != null) {
                    data.set("hiddenColumns", om.valueToTree(this.getHiddenColumns()));
                }
                if (this.getIgnoreCase() != null) {
                    data.set("ignoreCase", om.valueToTree(this.getIgnoreCase()));
                }
                if (this.getIncludeInSplit() != null) {
                    data.set("includeInSplit", om.valueToTree(this.getIncludeInSplit()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIsText() != null) {
                    data.set("isText", om.valueToTree(this.getIsText()));
                }
                if (this.getJoinKeys() != null) {
                    data.set("joinKeys", om.valueToTree(this.getJoinKeys()));
                }
                if (this.getJoinType() != null) {
                    data.set("joinType", om.valueToTree(this.getJoinType()));
                }
                if (this.getLeftColumns() != null) {
                    data.set("leftColumns", om.valueToTree(this.getLeftColumns()));
                }
                if (this.getLimit() != null) {
                    data.set("limit", om.valueToTree(this.getLimit()));
                }
                if (this.getLowerBound() != null) {
                    data.set("lowerBound", om.valueToTree(this.getLowerBound()));
                }
                if (this.getMapType() != null) {
                    data.set("mapType", om.valueToTree(this.getMapType()));
                }
                if (this.getModeType() != null) {
                    data.set("modeType", om.valueToTree(this.getModeType()));
                }
                if (this.getMultiLine() != null) {
                    data.set("multiLine", om.valueToTree(this.getMultiLine()));
                }
                if (this.getNumRows() != null) {
                    data.set("numRows", om.valueToTree(this.getNumRows()));
                }
                if (this.getNumRowsAfter() != null) {
                    data.set("numRowsAfter", om.valueToTree(this.getNumRowsAfter()));
                }
                if (this.getNumRowsBefore() != null) {
                    data.set("numRowsBefore", om.valueToTree(this.getNumRowsBefore()));
                }
                if (this.getOrderByColumn() != null) {
                    data.set("orderByColumn", om.valueToTree(this.getOrderByColumn()));
                }
                if (this.getOrderByColumns() != null) {
                    data.set("orderByColumns", om.valueToTree(this.getOrderByColumns()));
                }
                if (this.getOther() != null) {
                    data.set("other", om.valueToTree(this.getOther()));
                }
                if (this.getPattern() != null) {
                    data.set("pattern", om.valueToTree(this.getPattern()));
                }
                if (this.getPatternOption1() != null) {
                    data.set("patternOption1", om.valueToTree(this.getPatternOption1()));
                }
                if (this.getPatternOption2() != null) {
                    data.set("patternOption2", om.valueToTree(this.getPatternOption2()));
                }
                if (this.getPatternOptions() != null) {
                    data.set("patternOptions", om.valueToTree(this.getPatternOptions()));
                }
                if (this.getPeriod() != null) {
                    data.set("period", om.valueToTree(this.getPeriod()));
                }
                if (this.getPosition() != null) {
                    data.set("position", om.valueToTree(this.getPosition()));
                }
                if (this.getRemoveAllPunctuation() != null) {
                    data.set("removeAllPunctuation", om.valueToTree(this.getRemoveAllPunctuation()));
                }
                if (this.getRemoveAllQuotes() != null) {
                    data.set("removeAllQuotes", om.valueToTree(this.getRemoveAllQuotes()));
                }
                if (this.getRemoveAllWhitespace() != null) {
                    data.set("removeAllWhitespace", om.valueToTree(this.getRemoveAllWhitespace()));
                }
                if (this.getRemoveCustomCharacters() != null) {
                    data.set("removeCustomCharacters", om.valueToTree(this.getRemoveCustomCharacters()));
                }
                if (this.getRemoveCustomValue() != null) {
                    data.set("removeCustomValue", om.valueToTree(this.getRemoveCustomValue()));
                }
                if (this.getRemoveLeadingAndTrailingPunctuation() != null) {
                    data.set("removeLeadingAndTrailingPunctuation", om.valueToTree(this.getRemoveLeadingAndTrailingPunctuation()));
                }
                if (this.getRemoveLeadingAndTrailingQuotes() != null) {
                    data.set("removeLeadingAndTrailingQuotes", om.valueToTree(this.getRemoveLeadingAndTrailingQuotes()));
                }
                if (this.getRemoveLeadingAndTrailingWhitespace() != null) {
                    data.set("removeLeadingAndTrailingWhitespace", om.valueToTree(this.getRemoveLeadingAndTrailingWhitespace()));
                }
                if (this.getRemoveLetters() != null) {
                    data.set("removeLetters", om.valueToTree(this.getRemoveLetters()));
                }
                if (this.getRemoveNumbers() != null) {
                    data.set("removeNumbers", om.valueToTree(this.getRemoveNumbers()));
                }
                if (this.getRemoveSourceColumn() != null) {
                    data.set("removeSourceColumn", om.valueToTree(this.getRemoveSourceColumn()));
                }
                if (this.getRemoveSpecialCharacters() != null) {
                    data.set("removeSpecialCharacters", om.valueToTree(this.getRemoveSpecialCharacters()));
                }
                if (this.getRightColumns() != null) {
                    data.set("rightColumns", om.valueToTree(this.getRightColumns()));
                }
                if (this.getSampleSize() != null) {
                    data.set("sampleSize", om.valueToTree(this.getSampleSize()));
                }
                if (this.getSampleType() != null) {
                    data.set("sampleType", om.valueToTree(this.getSampleType()));
                }
                if (this.getSecondaryInputs() != null) {
                    data.set("secondaryInputs", om.valueToTree(this.getSecondaryInputs()));
                }
                if (this.getSecondInput() != null) {
                    data.set("secondInput", om.valueToTree(this.getSecondInput()));
                }
                if (this.getSheetIndexes() != null) {
                    data.set("sheetIndexes", om.valueToTree(this.getSheetIndexes()));
                }
                if (this.getSheetNames() != null) {
                    data.set("sheetNames", om.valueToTree(this.getSheetNames()));
                }
                if (this.getSourceColumn() != null) {
                    data.set("sourceColumn", om.valueToTree(this.getSourceColumn()));
                }
                if (this.getSourceColumn1() != null) {
                    data.set("sourceColumn1", om.valueToTree(this.getSourceColumn1()));
                }
                if (this.getSourceColumn2() != null) {
                    data.set("sourceColumn2", om.valueToTree(this.getSourceColumn2()));
                }
                if (this.getSourceColumns() != null) {
                    data.set("sourceColumns", om.valueToTree(this.getSourceColumns()));
                }
                if (this.getStartColumnIndex() != null) {
                    data.set("startColumnIndex", om.valueToTree(this.getStartColumnIndex()));
                }
                if (this.getStartPattern() != null) {
                    data.set("startPattern", om.valueToTree(this.getStartPattern()));
                }
                if (this.getStartPosition() != null) {
                    data.set("startPosition", om.valueToTree(this.getStartPosition()));
                }
                if (this.getStartValue() != null) {
                    data.set("startValue", om.valueToTree(this.getStartValue()));
                }
                if (this.getStemmingMode() != null) {
                    data.set("stemmingMode", om.valueToTree(this.getStemmingMode()));
                }
                if (this.getStepCount() != null) {
                    data.set("stepCount", om.valueToTree(this.getStepCount()));
                }
                if (this.getStepIndex() != null) {
                    data.set("stepIndex", om.valueToTree(this.getStepIndex()));
                }
                if (this.getStopWordsMode() != null) {
                    data.set("stopWordsMode", om.valueToTree(this.getStopWordsMode()));
                }
                if (this.getStrategy() != null) {
                    data.set("strategy", om.valueToTree(this.getStrategy()));
                }
                if (this.getTargetColumn() != null) {
                    data.set("targetColumn", om.valueToTree(this.getTargetColumn()));
                }
                if (this.getTargetColumnNames() != null) {
                    data.set("targetColumnNames", om.valueToTree(this.getTargetColumnNames()));
                }
                if (this.getTargetDateFormat() != null) {
                    data.set("targetDateFormat", om.valueToTree(this.getTargetDateFormat()));
                }
                if (this.getTargetIndex() != null) {
                    data.set("targetIndex", om.valueToTree(this.getTargetIndex()));
                }
                if (this.getTimeZone() != null) {
                    data.set("timeZone", om.valueToTree(this.getTimeZone()));
                }
                if (this.getTokenizerPattern() != null) {
                    data.set("tokenizerPattern", om.valueToTree(this.getTokenizerPattern()));
                }
                if (this.getTrueString() != null) {
                    data.set("trueString", om.valueToTree(this.getTrueString()));
                }
                if (this.getUdfLang() != null) {
                    data.set("udfLang", om.valueToTree(this.getUdfLang()));
                }
                if (this.getUnits() != null) {
                    data.set("units", om.valueToTree(this.getUnits()));
                }
                if (this.getUnpivotColumn() != null) {
                    data.set("unpivotColumn", om.valueToTree(this.getUnpivotColumn()));
                }
                if (this.getUpperBound() != null) {
                    data.set("upperBound", om.valueToTree(this.getUpperBound()));
                }
                if (this.getUseNewDataFrame() != null) {
                    data.set("useNewDataFrame", om.valueToTree(this.getUseNewDataFrame()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }
                if (this.getValue1() != null) {
                    data.set("value1", om.valueToTree(this.getValue1()));
                }
                if (this.getValue2() != null) {
                    data.set("value2", om.valueToTree(this.getValue2()));
                }
                if (this.getValueColumn() != null) {
                    data.set("valueColumn", om.valueToTree(this.getValueColumn()));
                }
                if (this.getViewFrame() != null) {
                    data.set("viewFrame", om.valueToTree(this.getViewFrame()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.RecipeParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipeParametersProperty.Jsii$Proxy that = (RecipeParametersProperty.Jsii$Proxy) o;

                if (this.aggregateFunction != null ? !this.aggregateFunction.equals(that.aggregateFunction) : that.aggregateFunction != null) return false;
                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                if (this.caseStatement != null ? !this.caseStatement.equals(that.caseStatement) : that.caseStatement != null) return false;
                if (this.categoryMap != null ? !this.categoryMap.equals(that.categoryMap) : that.categoryMap != null) return false;
                if (this.charsToRemove != null ? !this.charsToRemove.equals(that.charsToRemove) : that.charsToRemove != null) return false;
                if (this.collapseConsecutiveWhitespace != null ? !this.collapseConsecutiveWhitespace.equals(that.collapseConsecutiveWhitespace) : that.collapseConsecutiveWhitespace != null) return false;
                if (this.columnDataType != null ? !this.columnDataType.equals(that.columnDataType) : that.columnDataType != null) return false;
                if (this.columnRange != null ? !this.columnRange.equals(that.columnRange) : that.columnRange != null) return false;
                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.customCharacters != null ? !this.customCharacters.equals(that.customCharacters) : that.customCharacters != null) return false;
                if (this.customStopWords != null ? !this.customStopWords.equals(that.customStopWords) : that.customStopWords != null) return false;
                if (this.customValue != null ? !this.customValue.equals(that.customValue) : that.customValue != null) return false;
                if (this.datasetsColumns != null ? !this.datasetsColumns.equals(that.datasetsColumns) : that.datasetsColumns != null) return false;
                if (this.dateAddValue != null ? !this.dateAddValue.equals(that.dateAddValue) : that.dateAddValue != null) return false;
                if (this.dateTimeFormat != null ? !this.dateTimeFormat.equals(that.dateTimeFormat) : that.dateTimeFormat != null) return false;
                if (this.dateTimeParameters != null ? !this.dateTimeParameters.equals(that.dateTimeParameters) : that.dateTimeParameters != null) return false;
                if (this.deleteOtherRows != null ? !this.deleteOtherRows.equals(that.deleteOtherRows) : that.deleteOtherRows != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.endPattern != null ? !this.endPattern.equals(that.endPattern) : that.endPattern != null) return false;
                if (this.endPosition != null ? !this.endPosition.equals(that.endPosition) : that.endPosition != null) return false;
                if (this.endValue != null ? !this.endValue.equals(that.endValue) : that.endValue != null) return false;
                if (this.expandContractions != null ? !this.expandContractions.equals(that.expandContractions) : that.expandContractions != null) return false;
                if (this.exponent != null ? !this.exponent.equals(that.exponent) : that.exponent != null) return false;
                if (this.falseString != null ? !this.falseString.equals(that.falseString) : that.falseString != null) return false;
                if (this.groupByAggFunctionOptions != null ? !this.groupByAggFunctionOptions.equals(that.groupByAggFunctionOptions) : that.groupByAggFunctionOptions != null) return false;
                if (this.groupByColumns != null ? !this.groupByColumns.equals(that.groupByColumns) : that.groupByColumns != null) return false;
                if (this.hiddenColumns != null ? !this.hiddenColumns.equals(that.hiddenColumns) : that.hiddenColumns != null) return false;
                if (this.ignoreCase != null ? !this.ignoreCase.equals(that.ignoreCase) : that.ignoreCase != null) return false;
                if (this.includeInSplit != null ? !this.includeInSplit.equals(that.includeInSplit) : that.includeInSplit != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.isText != null ? !this.isText.equals(that.isText) : that.isText != null) return false;
                if (this.joinKeys != null ? !this.joinKeys.equals(that.joinKeys) : that.joinKeys != null) return false;
                if (this.joinType != null ? !this.joinType.equals(that.joinType) : that.joinType != null) return false;
                if (this.leftColumns != null ? !this.leftColumns.equals(that.leftColumns) : that.leftColumns != null) return false;
                if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
                if (this.lowerBound != null ? !this.lowerBound.equals(that.lowerBound) : that.lowerBound != null) return false;
                if (this.mapType != null ? !this.mapType.equals(that.mapType) : that.mapType != null) return false;
                if (this.modeType != null ? !this.modeType.equals(that.modeType) : that.modeType != null) return false;
                if (this.multiLine != null ? !this.multiLine.equals(that.multiLine) : that.multiLine != null) return false;
                if (this.numRows != null ? !this.numRows.equals(that.numRows) : that.numRows != null) return false;
                if (this.numRowsAfter != null ? !this.numRowsAfter.equals(that.numRowsAfter) : that.numRowsAfter != null) return false;
                if (this.numRowsBefore != null ? !this.numRowsBefore.equals(that.numRowsBefore) : that.numRowsBefore != null) return false;
                if (this.orderByColumn != null ? !this.orderByColumn.equals(that.orderByColumn) : that.orderByColumn != null) return false;
                if (this.orderByColumns != null ? !this.orderByColumns.equals(that.orderByColumns) : that.orderByColumns != null) return false;
                if (this.other != null ? !this.other.equals(that.other) : that.other != null) return false;
                if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) return false;
                if (this.patternOption1 != null ? !this.patternOption1.equals(that.patternOption1) : that.patternOption1 != null) return false;
                if (this.patternOption2 != null ? !this.patternOption2.equals(that.patternOption2) : that.patternOption2 != null) return false;
                if (this.patternOptions != null ? !this.patternOptions.equals(that.patternOptions) : that.patternOptions != null) return false;
                if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
                if (this.position != null ? !this.position.equals(that.position) : that.position != null) return false;
                if (this.removeAllPunctuation != null ? !this.removeAllPunctuation.equals(that.removeAllPunctuation) : that.removeAllPunctuation != null) return false;
                if (this.removeAllQuotes != null ? !this.removeAllQuotes.equals(that.removeAllQuotes) : that.removeAllQuotes != null) return false;
                if (this.removeAllWhitespace != null ? !this.removeAllWhitespace.equals(that.removeAllWhitespace) : that.removeAllWhitespace != null) return false;
                if (this.removeCustomCharacters != null ? !this.removeCustomCharacters.equals(that.removeCustomCharacters) : that.removeCustomCharacters != null) return false;
                if (this.removeCustomValue != null ? !this.removeCustomValue.equals(that.removeCustomValue) : that.removeCustomValue != null) return false;
                if (this.removeLeadingAndTrailingPunctuation != null ? !this.removeLeadingAndTrailingPunctuation.equals(that.removeLeadingAndTrailingPunctuation) : that.removeLeadingAndTrailingPunctuation != null) return false;
                if (this.removeLeadingAndTrailingQuotes != null ? !this.removeLeadingAndTrailingQuotes.equals(that.removeLeadingAndTrailingQuotes) : that.removeLeadingAndTrailingQuotes != null) return false;
                if (this.removeLeadingAndTrailingWhitespace != null ? !this.removeLeadingAndTrailingWhitespace.equals(that.removeLeadingAndTrailingWhitespace) : that.removeLeadingAndTrailingWhitespace != null) return false;
                if (this.removeLetters != null ? !this.removeLetters.equals(that.removeLetters) : that.removeLetters != null) return false;
                if (this.removeNumbers != null ? !this.removeNumbers.equals(that.removeNumbers) : that.removeNumbers != null) return false;
                if (this.removeSourceColumn != null ? !this.removeSourceColumn.equals(that.removeSourceColumn) : that.removeSourceColumn != null) return false;
                if (this.removeSpecialCharacters != null ? !this.removeSpecialCharacters.equals(that.removeSpecialCharacters) : that.removeSpecialCharacters != null) return false;
                if (this.rightColumns != null ? !this.rightColumns.equals(that.rightColumns) : that.rightColumns != null) return false;
                if (this.sampleSize != null ? !this.sampleSize.equals(that.sampleSize) : that.sampleSize != null) return false;
                if (this.sampleType != null ? !this.sampleType.equals(that.sampleType) : that.sampleType != null) return false;
                if (this.secondaryInputs != null ? !this.secondaryInputs.equals(that.secondaryInputs) : that.secondaryInputs != null) return false;
                if (this.secondInput != null ? !this.secondInput.equals(that.secondInput) : that.secondInput != null) return false;
                if (this.sheetIndexes != null ? !this.sheetIndexes.equals(that.sheetIndexes) : that.sheetIndexes != null) return false;
                if (this.sheetNames != null ? !this.sheetNames.equals(that.sheetNames) : that.sheetNames != null) return false;
                if (this.sourceColumn != null ? !this.sourceColumn.equals(that.sourceColumn) : that.sourceColumn != null) return false;
                if (this.sourceColumn1 != null ? !this.sourceColumn1.equals(that.sourceColumn1) : that.sourceColumn1 != null) return false;
                if (this.sourceColumn2 != null ? !this.sourceColumn2.equals(that.sourceColumn2) : that.sourceColumn2 != null) return false;
                if (this.sourceColumns != null ? !this.sourceColumns.equals(that.sourceColumns) : that.sourceColumns != null) return false;
                if (this.startColumnIndex != null ? !this.startColumnIndex.equals(that.startColumnIndex) : that.startColumnIndex != null) return false;
                if (this.startPattern != null ? !this.startPattern.equals(that.startPattern) : that.startPattern != null) return false;
                if (this.startPosition != null ? !this.startPosition.equals(that.startPosition) : that.startPosition != null) return false;
                if (this.startValue != null ? !this.startValue.equals(that.startValue) : that.startValue != null) return false;
                if (this.stemmingMode != null ? !this.stemmingMode.equals(that.stemmingMode) : that.stemmingMode != null) return false;
                if (this.stepCount != null ? !this.stepCount.equals(that.stepCount) : that.stepCount != null) return false;
                if (this.stepIndex != null ? !this.stepIndex.equals(that.stepIndex) : that.stepIndex != null) return false;
                if (this.stopWordsMode != null ? !this.stopWordsMode.equals(that.stopWordsMode) : that.stopWordsMode != null) return false;
                if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) return false;
                if (this.targetColumn != null ? !this.targetColumn.equals(that.targetColumn) : that.targetColumn != null) return false;
                if (this.targetColumnNames != null ? !this.targetColumnNames.equals(that.targetColumnNames) : that.targetColumnNames != null) return false;
                if (this.targetDateFormat != null ? !this.targetDateFormat.equals(that.targetDateFormat) : that.targetDateFormat != null) return false;
                if (this.targetIndex != null ? !this.targetIndex.equals(that.targetIndex) : that.targetIndex != null) return false;
                if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) return false;
                if (this.tokenizerPattern != null ? !this.tokenizerPattern.equals(that.tokenizerPattern) : that.tokenizerPattern != null) return false;
                if (this.trueString != null ? !this.trueString.equals(that.trueString) : that.trueString != null) return false;
                if (this.udfLang != null ? !this.udfLang.equals(that.udfLang) : that.udfLang != null) return false;
                if (this.units != null ? !this.units.equals(that.units) : that.units != null) return false;
                if (this.unpivotColumn != null ? !this.unpivotColumn.equals(that.unpivotColumn) : that.unpivotColumn != null) return false;
                if (this.upperBound != null ? !this.upperBound.equals(that.upperBound) : that.upperBound != null) return false;
                if (this.useNewDataFrame != null ? !this.useNewDataFrame.equals(that.useNewDataFrame) : that.useNewDataFrame != null) return false;
                if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
                if (this.value1 != null ? !this.value1.equals(that.value1) : that.value1 != null) return false;
                if (this.value2 != null ? !this.value2.equals(that.value2) : that.value2 != null) return false;
                if (this.valueColumn != null ? !this.valueColumn.equals(that.valueColumn) : that.valueColumn != null) return false;
                return this.viewFrame != null ? this.viewFrame.equals(that.viewFrame) : that.viewFrame == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregateFunction != null ? this.aggregateFunction.hashCode() : 0;
                result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
                result = 31 * result + (this.caseStatement != null ? this.caseStatement.hashCode() : 0);
                result = 31 * result + (this.categoryMap != null ? this.categoryMap.hashCode() : 0);
                result = 31 * result + (this.charsToRemove != null ? this.charsToRemove.hashCode() : 0);
                result = 31 * result + (this.collapseConsecutiveWhitespace != null ? this.collapseConsecutiveWhitespace.hashCode() : 0);
                result = 31 * result + (this.columnDataType != null ? this.columnDataType.hashCode() : 0);
                result = 31 * result + (this.columnRange != null ? this.columnRange.hashCode() : 0);
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                result = 31 * result + (this.customCharacters != null ? this.customCharacters.hashCode() : 0);
                result = 31 * result + (this.customStopWords != null ? this.customStopWords.hashCode() : 0);
                result = 31 * result + (this.customValue != null ? this.customValue.hashCode() : 0);
                result = 31 * result + (this.datasetsColumns != null ? this.datasetsColumns.hashCode() : 0);
                result = 31 * result + (this.dateAddValue != null ? this.dateAddValue.hashCode() : 0);
                result = 31 * result + (this.dateTimeFormat != null ? this.dateTimeFormat.hashCode() : 0);
                result = 31 * result + (this.dateTimeParameters != null ? this.dateTimeParameters.hashCode() : 0);
                result = 31 * result + (this.deleteOtherRows != null ? this.deleteOtherRows.hashCode() : 0);
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.endPattern != null ? this.endPattern.hashCode() : 0);
                result = 31 * result + (this.endPosition != null ? this.endPosition.hashCode() : 0);
                result = 31 * result + (this.endValue != null ? this.endValue.hashCode() : 0);
                result = 31 * result + (this.expandContractions != null ? this.expandContractions.hashCode() : 0);
                result = 31 * result + (this.exponent != null ? this.exponent.hashCode() : 0);
                result = 31 * result + (this.falseString != null ? this.falseString.hashCode() : 0);
                result = 31 * result + (this.groupByAggFunctionOptions != null ? this.groupByAggFunctionOptions.hashCode() : 0);
                result = 31 * result + (this.groupByColumns != null ? this.groupByColumns.hashCode() : 0);
                result = 31 * result + (this.hiddenColumns != null ? this.hiddenColumns.hashCode() : 0);
                result = 31 * result + (this.ignoreCase != null ? this.ignoreCase.hashCode() : 0);
                result = 31 * result + (this.includeInSplit != null ? this.includeInSplit.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.isText != null ? this.isText.hashCode() : 0);
                result = 31 * result + (this.joinKeys != null ? this.joinKeys.hashCode() : 0);
                result = 31 * result + (this.joinType != null ? this.joinType.hashCode() : 0);
                result = 31 * result + (this.leftColumns != null ? this.leftColumns.hashCode() : 0);
                result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
                result = 31 * result + (this.lowerBound != null ? this.lowerBound.hashCode() : 0);
                result = 31 * result + (this.mapType != null ? this.mapType.hashCode() : 0);
                result = 31 * result + (this.modeType != null ? this.modeType.hashCode() : 0);
                result = 31 * result + (this.multiLine != null ? this.multiLine.hashCode() : 0);
                result = 31 * result + (this.numRows != null ? this.numRows.hashCode() : 0);
                result = 31 * result + (this.numRowsAfter != null ? this.numRowsAfter.hashCode() : 0);
                result = 31 * result + (this.numRowsBefore != null ? this.numRowsBefore.hashCode() : 0);
                result = 31 * result + (this.orderByColumn != null ? this.orderByColumn.hashCode() : 0);
                result = 31 * result + (this.orderByColumns != null ? this.orderByColumns.hashCode() : 0);
                result = 31 * result + (this.other != null ? this.other.hashCode() : 0);
                result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
                result = 31 * result + (this.patternOption1 != null ? this.patternOption1.hashCode() : 0);
                result = 31 * result + (this.patternOption2 != null ? this.patternOption2.hashCode() : 0);
                result = 31 * result + (this.patternOptions != null ? this.patternOptions.hashCode() : 0);
                result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
                result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
                result = 31 * result + (this.removeAllPunctuation != null ? this.removeAllPunctuation.hashCode() : 0);
                result = 31 * result + (this.removeAllQuotes != null ? this.removeAllQuotes.hashCode() : 0);
                result = 31 * result + (this.removeAllWhitespace != null ? this.removeAllWhitespace.hashCode() : 0);
                result = 31 * result + (this.removeCustomCharacters != null ? this.removeCustomCharacters.hashCode() : 0);
                result = 31 * result + (this.removeCustomValue != null ? this.removeCustomValue.hashCode() : 0);
                result = 31 * result + (this.removeLeadingAndTrailingPunctuation != null ? this.removeLeadingAndTrailingPunctuation.hashCode() : 0);
                result = 31 * result + (this.removeLeadingAndTrailingQuotes != null ? this.removeLeadingAndTrailingQuotes.hashCode() : 0);
                result = 31 * result + (this.removeLeadingAndTrailingWhitespace != null ? this.removeLeadingAndTrailingWhitespace.hashCode() : 0);
                result = 31 * result + (this.removeLetters != null ? this.removeLetters.hashCode() : 0);
                result = 31 * result + (this.removeNumbers != null ? this.removeNumbers.hashCode() : 0);
                result = 31 * result + (this.removeSourceColumn != null ? this.removeSourceColumn.hashCode() : 0);
                result = 31 * result + (this.removeSpecialCharacters != null ? this.removeSpecialCharacters.hashCode() : 0);
                result = 31 * result + (this.rightColumns != null ? this.rightColumns.hashCode() : 0);
                result = 31 * result + (this.sampleSize != null ? this.sampleSize.hashCode() : 0);
                result = 31 * result + (this.sampleType != null ? this.sampleType.hashCode() : 0);
                result = 31 * result + (this.secondaryInputs != null ? this.secondaryInputs.hashCode() : 0);
                result = 31 * result + (this.secondInput != null ? this.secondInput.hashCode() : 0);
                result = 31 * result + (this.sheetIndexes != null ? this.sheetIndexes.hashCode() : 0);
                result = 31 * result + (this.sheetNames != null ? this.sheetNames.hashCode() : 0);
                result = 31 * result + (this.sourceColumn != null ? this.sourceColumn.hashCode() : 0);
                result = 31 * result + (this.sourceColumn1 != null ? this.sourceColumn1.hashCode() : 0);
                result = 31 * result + (this.sourceColumn2 != null ? this.sourceColumn2.hashCode() : 0);
                result = 31 * result + (this.sourceColumns != null ? this.sourceColumns.hashCode() : 0);
                result = 31 * result + (this.startColumnIndex != null ? this.startColumnIndex.hashCode() : 0);
                result = 31 * result + (this.startPattern != null ? this.startPattern.hashCode() : 0);
                result = 31 * result + (this.startPosition != null ? this.startPosition.hashCode() : 0);
                result = 31 * result + (this.startValue != null ? this.startValue.hashCode() : 0);
                result = 31 * result + (this.stemmingMode != null ? this.stemmingMode.hashCode() : 0);
                result = 31 * result + (this.stepCount != null ? this.stepCount.hashCode() : 0);
                result = 31 * result + (this.stepIndex != null ? this.stepIndex.hashCode() : 0);
                result = 31 * result + (this.stopWordsMode != null ? this.stopWordsMode.hashCode() : 0);
                result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
                result = 31 * result + (this.targetColumn != null ? this.targetColumn.hashCode() : 0);
                result = 31 * result + (this.targetColumnNames != null ? this.targetColumnNames.hashCode() : 0);
                result = 31 * result + (this.targetDateFormat != null ? this.targetDateFormat.hashCode() : 0);
                result = 31 * result + (this.targetIndex != null ? this.targetIndex.hashCode() : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                result = 31 * result + (this.tokenizerPattern != null ? this.tokenizerPattern.hashCode() : 0);
                result = 31 * result + (this.trueString != null ? this.trueString.hashCode() : 0);
                result = 31 * result + (this.udfLang != null ? this.udfLang.hashCode() : 0);
                result = 31 * result + (this.units != null ? this.units.hashCode() : 0);
                result = 31 * result + (this.unpivotColumn != null ? this.unpivotColumn.hashCode() : 0);
                result = 31 * result + (this.upperBound != null ? this.upperBound.hashCode() : 0);
                result = 31 * result + (this.useNewDataFrame != null ? this.useNewDataFrame.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                result = 31 * result + (this.value1 != null ? this.value1.hashCode() : 0);
                result = 31 * result + (this.value2 != null ? this.value2.hashCode() : 0);
                result = 31 * result + (this.valueColumn != null ? this.valueColumn.hashCode() : 0);
                result = 31 * result + (this.viewFrame != null ? this.viewFrame.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a single step from a DataBrew recipe to be performed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * RecipeStepProperty recipeStepProperty = RecipeStepProperty.builder()
     *         .action(ActionProperty.builder()
     *                 .operation("operation")
     *                 // the properties below are optional
     *                 .parameters(Map.of(
     *                         "parametersKey", "parameters"))
     *                 .build())
     *         // the properties below are optional
     *         .conditionExpressions(List.of(ConditionExpressionProperty.builder()
     *                 .condition("condition")
     *                 .targetColumn("targetColumn")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.RecipeStepProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipeStepProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipeStepProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The particular action to be performed in the recipe step.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * One or more conditions that must be met for the recipe step to succeed.
         * <p>
         * <blockquote>
         * <p>
         * All of the conditions in the array must be met. In other words, all of the conditions must be combined using a logical AND operation.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditionExpressions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecipeStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipeStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipeStepProperty> {
            java.lang.Object action;
            java.lang.Object conditionExpressions;

            /**
             * Sets the value of {@link RecipeStepProperty#getAction}
             * @param action The particular action to be performed in the recipe step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.databrew.CfnRecipe.ActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link RecipeStepProperty#getAction}
             * @param action The particular action to be performed in the recipe step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link RecipeStepProperty#getConditionExpressions}
             * @param conditionExpressions One or more conditions that must be met for the recipe step to succeed.
             *                             <blockquote>
             *                             <p>
             *                             All of the conditions in the array must be met. In other words, all of the conditions must be combined using a logical AND operation.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionExpressions(software.amazon.awscdk.IResolvable conditionExpressions) {
                this.conditionExpressions = conditionExpressions;
                return this;
            }

            /**
             * Sets the value of {@link RecipeStepProperty#getConditionExpressions}
             * @param conditionExpressions One or more conditions that must be met for the recipe step to succeed.
             *                             <blockquote>
             *                             <p>
             *                             All of the conditions in the array must be met. In other words, all of the conditions must be combined using a logical AND operation.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionExpressions(java.util.List<? extends java.lang.Object> conditionExpressions) {
                this.conditionExpressions = conditionExpressions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipeStepProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipeStepProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipeStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipeStepProperty {
            private final java.lang.Object action;
            private final java.lang.Object conditionExpressions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conditionExpressions = software.amazon.jsii.Kernel.get(this, "conditionExpressions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.conditionExpressions = builder.conditionExpressions;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getConditionExpressions() {
                return this.conditionExpressions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                if (this.getConditionExpressions() != null) {
                    data.set("conditionExpressions", om.valueToTree(this.getConditionExpressions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.RecipeStepProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipeStepProperty.Jsii$Proxy that = (RecipeStepProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.conditionExpressions != null ? this.conditionExpressions.equals(that.conditionExpressions) : that.conditionExpressions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.conditionExpressions != null ? this.conditionExpressions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The unique name of the object in the bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The unique name of the object in the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents secondary inputs in a UNION transform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * SecondaryInputProperty secondaryInputProperty = SecondaryInputProperty.builder()
     *         .dataCatalogInputDefinition(DataCatalogInputDefinitionProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .tableName("tableName")
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .s3InputDefinition(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnRecipe.SecondaryInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SecondaryInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecondaryInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Glue Data Catalog parameters for the data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogInputDefinition() {
            return null;
        }

        /**
         * The Amazon S3 location where the data is stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3InputDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecondaryInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecondaryInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecondaryInputProperty> {
            java.lang.Object dataCatalogInputDefinition;
            java.lang.Object s3InputDefinition;

            /**
             * Sets the value of {@link SecondaryInputProperty#getDataCatalogInputDefinition}
             * @param dataCatalogInputDefinition The AWS Glue Data Catalog parameters for the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogInputDefinition(software.amazon.awscdk.services.databrew.CfnRecipe.DataCatalogInputDefinitionProperty dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link SecondaryInputProperty#getDataCatalogInputDefinition}
             * @param dataCatalogInputDefinition The AWS Glue Data Catalog parameters for the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogInputDefinition(software.amazon.awscdk.IResolvable dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link SecondaryInputProperty#getS3InputDefinition}
             * @param s3InputDefinition The Amazon S3 location where the data is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputDefinition(software.amazon.awscdk.services.databrew.CfnRecipe.S3LocationProperty s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link SecondaryInputProperty#getS3InputDefinition}
             * @param s3InputDefinition The Amazon S3 location where the data is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputDefinition(software.amazon.awscdk.IResolvable s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecondaryInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecondaryInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecondaryInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecondaryInputProperty {
            private final java.lang.Object dataCatalogInputDefinition;
            private final java.lang.Object s3InputDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataCatalogInputDefinition = software.amazon.jsii.Kernel.get(this, "dataCatalogInputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3InputDefinition = software.amazon.jsii.Kernel.get(this, "s3InputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataCatalogInputDefinition = builder.dataCatalogInputDefinition;
                this.s3InputDefinition = builder.s3InputDefinition;
            }

            @Override
            public final java.lang.Object getDataCatalogInputDefinition() {
                return this.dataCatalogInputDefinition;
            }

            @Override
            public final java.lang.Object getS3InputDefinition() {
                return this.s3InputDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataCatalogInputDefinition() != null) {
                    data.set("dataCatalogInputDefinition", om.valueToTree(this.getDataCatalogInputDefinition()));
                }
                if (this.getS3InputDefinition() != null) {
                    data.set("s3InputDefinition", om.valueToTree(this.getS3InputDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnRecipe.SecondaryInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecondaryInputProperty.Jsii$Proxy that = (SecondaryInputProperty.Jsii$Proxy) o;

                if (this.dataCatalogInputDefinition != null ? !this.dataCatalogInputDefinition.equals(that.dataCatalogInputDefinition) : that.dataCatalogInputDefinition != null) return false;
                return this.s3InputDefinition != null ? this.s3InputDefinition.equals(that.s3InputDefinition) : that.s3InputDefinition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataCatalogInputDefinition != null ? this.dataCatalogInputDefinition.hashCode() : 0;
                result = 31 * result + (this.s3InputDefinition != null ? this.s3InputDefinition.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.databrew.CfnRecipe}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.databrew.CfnRecipe> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.databrew.CfnRecipeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.databrew.CfnRecipeProps.Builder();
        }

        /**
         * The unique name for the recipe.
         * <p>
         * @return {@code this}
         * @param name The unique name for the recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of steps that are defined by the recipe.
         * <p>
         * @return {@code this}
         * @param steps A list of steps that are defined by the recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final software.amazon.awscdk.IResolvable steps) {
            this.props.steps(steps);
            return this;
        }
        /**
         * A list of steps that are defined by the recipe.
         * <p>
         * @return {@code this}
         * @param steps A list of steps that are defined by the recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final java.util.List<? extends java.lang.Object> steps) {
            this.props.steps(steps);
            return this;
        }

        /**
         * The description of the recipe.
         * <p>
         * @return {@code this}
         * @param description The description of the recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Metadata tags that have been applied to the recipe.
         * <p>
         * @return {@code this}
         * @param tags Metadata tags that have been applied to the recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.databrew.CfnRecipe}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.databrew.CfnRecipe build() {
            return new software.amazon.awscdk.services.databrew.CfnRecipe(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
