package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 * <p>
 * An organization config rule that has information about config rules that AWS Config creates in member accounts. Only a master account and a delegated administrator can create or update an organization config rule.
 * <p>
 * <code>OrganizationConfigRule</code> resource enables organization service access through <code>EnableAWSServiceAccess</code> action and creates a service linked role in the master account of your organization. The service linked role is created only when the role does not exist in the master account. AWS Config verifies the existence of role with <code>GetRole</code> action.
 * <p>
 * When creating custom organization config rules using a centralized Lambda function, you will need to allow Lambda permissions to sub-accounts and you will need to create an IAM role will to pass to the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/devops/how-to-centrally-manage-aws-config-rules-across-multiple-aws-accounts/">How to Centrally Manage AWS Config Rules across Multiple AWS Accounts</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnOrganizationConfigRule cfnOrganizationConfigRule = CfnOrganizationConfigRule.Builder.create(this, "MyCfnOrganizationConfigRule")
 *         .organizationConfigRuleName("organizationConfigRuleName")
 *         // the properties below are optional
 *         .excludedAccounts(List.of("excludedAccounts"))
 *         .organizationCustomCodeRuleMetadata(OrganizationCustomCodeRuleMetadataProperty.builder()
 *                 .codeText("codeText")
 *                 .runtime("runtime")
 *                 // the properties below are optional
 *                 .debugLogDeliveryAccounts(List.of("debugLogDeliveryAccounts"))
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .organizationCustomRuleMetadata(OrganizationCustomRuleMetadataProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
 *                 // the properties below are optional
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .organizationManagedRuleMetadata(OrganizationManagedRuleMetadataProperty.builder()
 *                 .ruleIdentifier("ruleIdentifier")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .inputParameters("inputParameters")
 *                 .maximumExecutionFrequency("maximumExecutionFrequency")
 *                 .resourceIdScope("resourceIdScope")
 *                 .resourceTypesScope(List.of("resourceTypesScope"))
 *                 .tagKeyScope("tagKeyScope")
 *                 .tagValueScope("tagValueScope")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule")
public class CfnOrganizationConfigRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnOrganizationConfigRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOrganizationConfigRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnOrganizationConfigRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::OrganizationConfigRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOrganizationConfigRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name that you assign to organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOrganizationConfigRuleName() {
        return software.amazon.jsii.Kernel.get(this, "organizationConfigRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name that you assign to organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationConfigRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "organizationConfigRuleName", java.util.Objects.requireNonNull(value, "organizationConfigRuleName is required"));
    }

    /**
     * A comma-separated list of accounts excluded from organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedAccounts() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "excludedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A comma-separated list of accounts excluded from organization AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludedAccounts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "excludedAccounts", value);
    }

    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationCustomCodeRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationCustomCodeRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomCodeRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomCodeRuleMetadata", value);
    }

    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomCodeRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomCodeRuleMetadata", value);
    }

    /**
     * An `OrganizationCustomRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationCustomRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationCustomRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An `OrganizationCustomRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomRuleMetadata", value);
    }

    /**
     * An `OrganizationCustomRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationCustomRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationCustomRuleMetadata", value);
    }

    /**
     * An `OrganizationManagedRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationManagedRuleMetadata() {
        return software.amazon.jsii.Kernel.get(this, "organizationManagedRuleMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An `OrganizationManagedRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationManagedRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationManagedRuleMetadata", value);
    }

    /**
     * An `OrganizationManagedRuleMetadata` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationManagedRuleMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationManagedRuleMetadata", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationCustomCodeRuleMetadataProperty organizationCustomCodeRuleMetadataProperty = OrganizationCustomCodeRuleMetadataProperty.builder()
     *         .codeText("codeText")
     *         .runtime("runtime")
     *         // the properties below are optional
     *         .debugLogDeliveryAccounts(List.of("debugLogDeliveryAccounts"))
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationCustomCodeRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationCustomCodeRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.CodeText`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCodeText();

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.Runtime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuntime();

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.DebugLogDeliveryAccounts`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDebugLogDeliveryAccounts() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.Description`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.InputParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.MaximumExecutionFrequency`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.OrganizationConfigRuleTriggerTypes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.ResourceIdScope`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.ResourceTypesScope`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.TagKeyScope`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.TagValueScope`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationCustomCodeRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationCustomCodeRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationCustomCodeRuleMetadataProperty> {
            java.lang.String codeText;
            java.lang.String runtime;
            java.util.List<java.lang.String> debugLogDeliveryAccounts;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getCodeText}
             * @param codeText `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.CodeText`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeText(java.lang.String codeText) {
                this.codeText = codeText;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getRuntime}
             * @param runtime `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.Runtime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtime(java.lang.String runtime) {
                this.runtime = runtime;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getDebugLogDeliveryAccounts}
             * @param debugLogDeliveryAccounts `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.DebugLogDeliveryAccounts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder debugLogDeliveryAccounts(java.util.List<java.lang.String> debugLogDeliveryAccounts) {
                this.debugLogDeliveryAccounts = debugLogDeliveryAccounts;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getDescription}
             * @param description `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getInputParameters}
             * @param inputParameters `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.InputParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.MaximumExecutionFrequency`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getOrganizationConfigRuleTriggerTypes}
             * @param organizationConfigRuleTriggerTypes `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.OrganizationConfigRuleTriggerTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationConfigRuleTriggerTypes(java.util.List<java.lang.String> organizationConfigRuleTriggerTypes) {
                this.organizationConfigRuleTriggerTypes = organizationConfigRuleTriggerTypes;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.ResourceIdScope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.ResourceTypesScope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.TagKeyScope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomCodeRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope `CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty.TagValueScope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationCustomCodeRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationCustomCodeRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationCustomCodeRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationCustomCodeRuleMetadataProperty {
            private final java.lang.String codeText;
            private final java.lang.String runtime;
            private final java.util.List<java.lang.String> debugLogDeliveryAccounts;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeText = software.amazon.jsii.Kernel.get(this, "codeText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.debugLogDeliveryAccounts = software.amazon.jsii.Kernel.get(this, "debugLogDeliveryAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationConfigRuleTriggerTypes = software.amazon.jsii.Kernel.get(this, "organizationConfigRuleTriggerTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeText = java.util.Objects.requireNonNull(builder.codeText, "codeText is required");
                this.runtime = java.util.Objects.requireNonNull(builder.runtime, "runtime is required");
                this.debugLogDeliveryAccounts = builder.debugLogDeliveryAccounts;
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.organizationConfigRuleTriggerTypes = builder.organizationConfigRuleTriggerTypes;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getCodeText() {
                return this.codeText;
            }

            @Override
            public final java.lang.String getRuntime() {
                return this.runtime;
            }

            @Override
            public final java.util.List<java.lang.String> getDebugLogDeliveryAccounts() {
                return this.debugLogDeliveryAccounts;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
                return this.organizationConfigRuleTriggerTypes;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("codeText", om.valueToTree(this.getCodeText()));
                data.set("runtime", om.valueToTree(this.getRuntime()));
                if (this.getDebugLogDeliveryAccounts() != null) {
                    data.set("debugLogDeliveryAccounts", om.valueToTree(this.getDebugLogDeliveryAccounts()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getOrganizationConfigRuleTriggerTypes() != null) {
                    data.set("organizationConfigRuleTriggerTypes", om.valueToTree(this.getOrganizationConfigRuleTriggerTypes()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationCustomCodeRuleMetadataProperty.Jsii$Proxy that = (OrganizationCustomCodeRuleMetadataProperty.Jsii$Proxy) o;

                if (!codeText.equals(that.codeText)) return false;
                if (!runtime.equals(that.runtime)) return false;
                if (this.debugLogDeliveryAccounts != null ? !this.debugLogDeliveryAccounts.equals(that.debugLogDeliveryAccounts) : that.debugLogDeliveryAccounts != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.organizationConfigRuleTriggerTypes != null ? !this.organizationConfigRuleTriggerTypes.equals(that.organizationConfigRuleTriggerTypes) : that.organizationConfigRuleTriggerTypes != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeText.hashCode();
                result = 31 * result + (this.runtime.hashCode());
                result = 31 * result + (this.debugLogDeliveryAccounts != null ? this.debugLogDeliveryAccounts.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.organizationConfigRuleTriggerTypes != null ? this.organizationConfigRuleTriggerTypes.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies organization custom rule metadata such as resource type, resource ID of AWS resource, Lambda function ARN, and organization trigger types that trigger AWS Config to evaluate your AWS resources against a rule.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationCustomRuleMetadataProperty organizationCustomRuleMetadataProperty = OrganizationCustomRuleMetadataProperty.builder()
     *         .lambdaFunctionArn("lambdaFunctionArn")
     *         .organizationConfigRuleTriggerTypes(List.of("organizationConfigRuleTriggerTypes"))
     *         // the properties below are optional
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationCustomRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationCustomRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lambda function ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaFunctionArn();

        /**
         * The type of notification that triggers AWS Config to run an evaluation for a rule.
         * <p>
         * You can specify the following notification types:
         * <p>
         * <ul>
         * <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
         * <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
         * <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes();

        /**
         * The description that you provide for your organization AWS Config rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * The ID of the AWS resource that was evaluated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * The type of the AWS resource that was evaluated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * One part of a key-value pair that make up a tag.
         * <p>
         * A key is a general label that acts like a category for more specific tag values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * The optional part of a key-value pair that make up a tag.
         * <p>
         * A value acts as a descriptor within a tag category (key).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationCustomRuleMetadataProperty> {
            java.lang.String lambdaFunctionArn;
            java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn The lambda function ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getOrganizationConfigRuleTriggerTypes}
             * @param organizationConfigRuleTriggerTypes The type of notification that triggers AWS Config to run an evaluation for a rule. This parameter is required.
             *                                           You can specify the following notification types:
             *                                           <p>
             *                                           <ul>
             *                                           <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
             *                                           <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
             *                                           <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
             *                                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationConfigRuleTriggerTypes(java.util.List<java.lang.String> organizationConfigRuleTriggerTypes) {
                this.organizationConfigRuleTriggerTypes = organizationConfigRuleTriggerTypes;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getDescription}
             * @param description The description that you provide for your organization AWS Config rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getInputParameters}
             * @param inputParameters A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
             *                                  Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <code>ConfigSnapshotDeliveryProperties</code> .
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope The ID of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope The type of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope One part of a key-value pair that make up a tag.
             *                    A key is a general label that acts like a category for more specific tag values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationCustomRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope The optional part of a key-value pair that make up a tag.
             *                      A value acts as a descriptor within a tag category (key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationCustomRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationCustomRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationCustomRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationCustomRuleMetadataProperty {
            private final java.lang.String lambdaFunctionArn;
            private final java.util.List<java.lang.String> organizationConfigRuleTriggerTypes;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationConfigRuleTriggerTypes = software.amazon.jsii.Kernel.get(this, "organizationConfigRuleTriggerTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaFunctionArn = java.util.Objects.requireNonNull(builder.lambdaFunctionArn, "lambdaFunctionArn is required");
                this.organizationConfigRuleTriggerTypes = java.util.Objects.requireNonNull(builder.organizationConfigRuleTriggerTypes, "organizationConfigRuleTriggerTypes is required");
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationConfigRuleTriggerTypes() {
                return this.organizationConfigRuleTriggerTypes;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                data.set("organizationConfigRuleTriggerTypes", om.valueToTree(this.getOrganizationConfigRuleTriggerTypes()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationCustomRuleMetadataProperty.Jsii$Proxy that = (OrganizationCustomRuleMetadataProperty.Jsii$Proxy) o;

                if (!lambdaFunctionArn.equals(that.lambdaFunctionArn)) return false;
                if (!organizationConfigRuleTriggerTypes.equals(that.organizationConfigRuleTriggerTypes)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaFunctionArn.hashCode();
                result = 31 * result + (this.organizationConfigRuleTriggerTypes.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies organization managed rule metadata such as resource type and ID of AWS resource along with the rule identifier.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationManagedRuleMetadataProperty organizationManagedRuleMetadataProperty = OrganizationManagedRuleMetadataProperty.builder()
     *         .ruleIdentifier("ruleIdentifier")
     *         // the properties below are optional
     *         .description("description")
     *         .inputParameters("inputParameters")
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .resourceIdScope("resourceIdScope")
     *         .resourceTypesScope(List.of("resourceTypesScope"))
     *         .tagKeyScope("tagKeyScope")
     *         .tagValueScope("tagValueScope")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationManagedRuleMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationManagedRuleMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For organization config managed rules, a predefined identifier from a list.
         * <p>
         * For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuleIdentifier();

        /**
         * The description that you provide for your organization AWS Config rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputParameters() {
            return null;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * You are using an AWS Config managed rule that is triggered at a periodic frequency.
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * The ID of the AWS resource that was evaluated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdScope() {
            return null;
        }

        /**
         * The type of the AWS resource that was evaluated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypesScope() {
            return null;
        }

        /**
         * One part of a key-value pair that make up a tag.
         * <p>
         * A key is a general label that acts like a category for more specific tag values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKeyScope() {
            return null;
        }

        /**
         * The optional part of a key-value pair that make up a tag.
         * <p>
         * A value acts as a descriptor within a tag category (key).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValueScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationManagedRuleMetadataProperty> {
            java.lang.String ruleIdentifier;
            java.lang.String description;
            java.lang.String inputParameters;
            java.lang.String maximumExecutionFrequency;
            java.lang.String resourceIdScope;
            java.util.List<java.lang.String> resourceTypesScope;
            java.lang.String tagKeyScope;
            java.lang.String tagValueScope;

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getRuleIdentifier}
             * @param ruleIdentifier For organization config managed rules, a predefined identifier from a list. This parameter is required.
             *                       For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using AWS Config managed rules</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleIdentifier(java.lang.String ruleIdentifier) {
                this.ruleIdentifier = ruleIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getDescription}
             * @param description The description that you provide for your organization AWS Config rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getInputParameters}
             * @param inputParameters A string, in JSON format, that is passed to your organization AWS Config rule Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParameters(java.lang.String inputParameters) {
                this.inputParameters = inputParameters;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
             *                                  You are using an AWS Config managed rule that is triggered at a periodic frequency.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getResourceIdScope}
             * @param resourceIdScope The ID of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdScope(java.lang.String resourceIdScope) {
                this.resourceIdScope = resourceIdScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getResourceTypesScope}
             * @param resourceTypesScope The type of the AWS resource that was evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypesScope(java.util.List<java.lang.String> resourceTypesScope) {
                this.resourceTypesScope = resourceTypesScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getTagKeyScope}
             * @param tagKeyScope One part of a key-value pair that make up a tag.
             *                    A key is a general label that acts like a category for more specific tag values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKeyScope(java.lang.String tagKeyScope) {
                this.tagKeyScope = tagKeyScope;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationManagedRuleMetadataProperty#getTagValueScope}
             * @param tagValueScope The optional part of a key-value pair that make up a tag.
             *                      A value acts as a descriptor within a tag category (key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValueScope(java.lang.String tagValueScope) {
                this.tagValueScope = tagValueScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationManagedRuleMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationManagedRuleMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationManagedRuleMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationManagedRuleMetadataProperty {
            private final java.lang.String ruleIdentifier;
            private final java.lang.String description;
            private final java.lang.String inputParameters;
            private final java.lang.String maximumExecutionFrequency;
            private final java.lang.String resourceIdScope;
            private final java.util.List<java.lang.String> resourceTypesScope;
            private final java.lang.String tagKeyScope;
            private final java.lang.String tagValueScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleIdentifier = software.amazon.jsii.Kernel.get(this, "ruleIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceIdScope = software.amazon.jsii.Kernel.get(this, "resourceIdScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypesScope = software.amazon.jsii.Kernel.get(this, "resourceTypesScope", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKeyScope = software.amazon.jsii.Kernel.get(this, "tagKeyScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValueScope = software.amazon.jsii.Kernel.get(this, "tagValueScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleIdentifier = java.util.Objects.requireNonNull(builder.ruleIdentifier, "ruleIdentifier is required");
                this.description = builder.description;
                this.inputParameters = builder.inputParameters;
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
                this.resourceIdScope = builder.resourceIdScope;
                this.resourceTypesScope = builder.resourceTypesScope;
                this.tagKeyScope = builder.tagKeyScope;
                this.tagValueScope = builder.tagValueScope;
            }

            @Override
            public final java.lang.String getRuleIdentifier() {
                return this.ruleIdentifier;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputParameters() {
                return this.inputParameters;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getResourceIdScope() {
                return this.resourceIdScope;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypesScope() {
                return this.resourceTypesScope;
            }

            @Override
            public final java.lang.String getTagKeyScope() {
                return this.tagKeyScope;
            }

            @Override
            public final java.lang.String getTagValueScope() {
                return this.tagValueScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleIdentifier", om.valueToTree(this.getRuleIdentifier()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputParameters() != null) {
                    data.set("inputParameters", om.valueToTree(this.getInputParameters()));
                }
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }
                if (this.getResourceIdScope() != null) {
                    data.set("resourceIdScope", om.valueToTree(this.getResourceIdScope()));
                }
                if (this.getResourceTypesScope() != null) {
                    data.set("resourceTypesScope", om.valueToTree(this.getResourceTypesScope()));
                }
                if (this.getTagKeyScope() != null) {
                    data.set("tagKeyScope", om.valueToTree(this.getTagKeyScope()));
                }
                if (this.getTagValueScope() != null) {
                    data.set("tagValueScope", om.valueToTree(this.getTagValueScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationManagedRuleMetadataProperty.Jsii$Proxy that = (OrganizationManagedRuleMetadataProperty.Jsii$Proxy) o;

                if (!ruleIdentifier.equals(that.ruleIdentifier)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
                if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
                if (this.resourceIdScope != null ? !this.resourceIdScope.equals(that.resourceIdScope) : that.resourceIdScope != null) return false;
                if (this.resourceTypesScope != null ? !this.resourceTypesScope.equals(that.resourceTypesScope) : that.resourceTypesScope != null) return false;
                if (this.tagKeyScope != null ? !this.tagKeyScope.equals(that.tagKeyScope) : that.tagKeyScope != null) return false;
                return this.tagValueScope != null ? this.tagValueScope.equals(that.tagValueScope) : that.tagValueScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleIdentifier.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                result = 31 * result + (this.resourceIdScope != null ? this.resourceIdScope.hashCode() : 0);
                result = 31 * result + (this.resourceTypesScope != null ? this.resourceTypesScope.hashCode() : 0);
                result = 31 * result + (this.tagKeyScope != null ? this.tagKeyScope.hashCode() : 0);
                result = 31 * result + (this.tagValueScope != null ? this.tagValueScope.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnOrganizationConfigRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnOrganizationConfigRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps.Builder();
        }

        /**
         * The name that you assign to organization AWS Config rule.
         * <p>
         * @return {@code this}
         * @param organizationConfigRuleName The name that you assign to organization AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationConfigRuleName(final java.lang.String organizationConfigRuleName) {
            this.props.organizationConfigRuleName(organizationConfigRuleName);
            return this;
        }

        /**
         * A comma-separated list of accounts excluded from organization AWS Config rule.
         * <p>
         * @return {@code this}
         * @param excludedAccounts A comma-separated list of accounts excluded from organization AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludedAccounts(final java.util.List<java.lang.String> excludedAccounts) {
            this.props.excludedAccounts(excludedAccounts);
            return this;
        }

        /**
         * `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`.
         * <p>
         * @return {@code this}
         * @param organizationCustomCodeRuleMetadata `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomCodeRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomCodeRuleMetadataProperty organizationCustomCodeRuleMetadata) {
            this.props.organizationCustomCodeRuleMetadata(organizationCustomCodeRuleMetadata);
            return this;
        }
        /**
         * `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`.
         * <p>
         * @return {@code this}
         * @param organizationCustomCodeRuleMetadata `AWS::Config::OrganizationConfigRule.OrganizationCustomCodeRuleMetadata`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomCodeRuleMetadata(final software.amazon.awscdk.IResolvable organizationCustomCodeRuleMetadata) {
            this.props.organizationCustomCodeRuleMetadata(organizationCustomCodeRuleMetadata);
            return this;
        }

        /**
         * An `OrganizationCustomRuleMetadata` object.
         * <p>
         * @return {@code this}
         * @param organizationCustomRuleMetadata An `OrganizationCustomRuleMetadata` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty organizationCustomRuleMetadata) {
            this.props.organizationCustomRuleMetadata(organizationCustomRuleMetadata);
            return this;
        }
        /**
         * An `OrganizationCustomRuleMetadata` object.
         * <p>
         * @return {@code this}
         * @param organizationCustomRuleMetadata An `OrganizationCustomRuleMetadata` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationCustomRuleMetadata(final software.amazon.awscdk.IResolvable organizationCustomRuleMetadata) {
            this.props.organizationCustomRuleMetadata(organizationCustomRuleMetadata);
            return this;
        }

        /**
         * An `OrganizationManagedRuleMetadata` object.
         * <p>
         * @return {@code this}
         * @param organizationManagedRuleMetadata An `OrganizationManagedRuleMetadata` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationManagedRuleMetadata(final software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty organizationManagedRuleMetadata) {
            this.props.organizationManagedRuleMetadata(organizationManagedRuleMetadata);
            return this;
        }
        /**
         * An `OrganizationManagedRuleMetadata` object.
         * <p>
         * @return {@code this}
         * @param organizationManagedRuleMetadata An `OrganizationManagedRuleMetadata` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationManagedRuleMetadata(final software.amazon.awscdk.IResolvable organizationManagedRuleMetadata) {
            this.props.organizationManagedRuleMetadata(organizationManagedRuleMetadata);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnOrganizationConfigRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnOrganizationConfigRule build() {
            return new software.amazon.awscdk.services.config.CfnOrganizationConfigRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
