package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Source that is provided by a GitHub repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * // Read the secret from Secrets Manager
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction sourceAction = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub_Source")
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .oauthToken(SecretValue.secretsManager("my-github-token"))
 *         .output(sourceOutput)
 *         .branch("develop")
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.GitHubSourceAction")
public class GitHubSourceAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected GitHubSourceAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GitHubSourceAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GitHubSourceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.GitHubSourceActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the {@link IAction.bind} method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.GitHubSourceVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.GitHubSourceVariables.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.GitHubSourceActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.GitHubSourceActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * A GitHub OAuth token to use for authentication.
         * <p>
         * It is recommended to use a Secrets Manager <code>Secret</code> to obtain the token:
         * <p>
         * const oauth = cdk.SecretValue.secretsManager('my-github-token');
         * new GitHubSource(this, 'GitHubAction', { oauthToken: oauth, ... });
         * <p>
         * If you rotate the value in the Secret, you must also change at least one property
         * of the CodePipeline to force CloudFormation to re-read the secret.
         * <p>
         * The GitHub Personal Access Token should have these scopes:
         * <p>
         * <ul>
         * <li><strong>repo</strong> - to read the repository</li>
         * <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/appendix-github-oauth.html#GitHub-create-personal-token-CLI">https://docs.aws.amazon.com/codepipeline/latest/userguide/appendix-github-oauth.html#GitHub-create-personal-token-CLI</a>
         * @param oauthToken A GitHub OAuth token to use for authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oauthToken(final software.amazon.awscdk.SecretValue oauthToken) {
            this.props.oauthToken(oauthToken);
            return this;
        }

        /**
         * @return {@code this}
         * @param output This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * The GitHub account/user that owns the repo.
         * <p>
         * @return {@code this}
         * @param owner The GitHub account/user that owns the repo. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * The name of the repo, without the username.
         * <p>
         * @return {@code this}
         * @param repo The name of the repo, without the username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(final java.lang.String repo) {
            this.props.repo(repo);
            return this;
        }

        /**
         * The branch to use.
         * <p>
         * Default: "master"
         * <p>
         * @return {@code this}
         * @param branch The branch to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(final java.lang.String branch) {
            this.props.branch(branch);
            return this;
        }

        /**
         * How AWS CodePipeline should be triggered.
         * <p>
         * With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action
         * With "POLL", CodePipeline periodically checks the source for changes
         * With "None", the action is not triggered through changes in the source
         * <p>
         * To use <code>WEBHOOK</code>, your GitHub Personal Access Token should have
         * <strong>admin:repo_hook</strong> scope (in addition to the regular <strong>repo</strong> scope).
         * <p>
         * Default: GitHubTrigger.WEBHOOK
         * <p>
         * @return {@code this}
         * @param trigger How AWS CodePipeline should be triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(final software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger trigger) {
            this.props.trigger(trigger);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction(
                this.props.build()
            );
        }
    }
}
