package software.amazon.awscdk.services.codebuild;

/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 * <p>
 * The <code>AWS::CodeBuild::Project</code> resource configures how AWS CodeBuild builds your source code. For example, it tells CodeBuild where to get the source code and which build environment to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * CfnProject cfnProject = CfnProject.Builder.create(this, "MyCfnProject")
 *         .artifacts(ArtifactsProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .artifactIdentifier("artifactIdentifier")
 *                 .encryptionDisabled(false)
 *                 .location("location")
 *                 .name("name")
 *                 .namespaceType("namespaceType")
 *                 .overrideArtifactName(false)
 *                 .packaging("packaging")
 *                 .path("path")
 *                 .build())
 *         .environment(EnvironmentProperty.builder()
 *                 .computeType("computeType")
 *                 .image("image")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .certificate("certificate")
 *                 .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         // the properties below are optional
 *                         .type("type")
 *                         .build()))
 *                 .imagePullCredentialsType("imagePullCredentialsType")
 *                 .privilegedMode(false)
 *                 .registryCredential(RegistryCredentialProperty.builder()
 *                         .credential("credential")
 *                         .credentialProvider("credentialProvider")
 *                         .build())
 *                 .build())
 *         .serviceRole("serviceRole")
 *         .source(SourceProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .auth(SourceAuthProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .resource("resource")
 *                         .build())
 *                 .buildSpec("buildSpec")
 *                 .buildStatusConfig(BuildStatusConfigProperty.builder()
 *                         .context("context")
 *                         .targetUrl("targetUrl")
 *                         .build())
 *                 .gitCloneDepth(123)
 *                 .gitSubmodulesConfig(GitSubmodulesConfigProperty.builder()
 *                         .fetchSubmodules(false)
 *                         .build())
 *                 .insecureSsl(false)
 *                 .location("location")
 *                 .reportBuildStatus(false)
 *                 .sourceIdentifier("sourceIdentifier")
 *                 .build())
 *         // the properties below are optional
 *         .badgeEnabled(false)
 *         .buildBatchConfig(ProjectBuildBatchConfigProperty.builder()
 *                 .batchReportMode("batchReportMode")
 *                 .combineArtifacts(false)
 *                 .restrictions(BatchRestrictionsProperty.builder()
 *                         .computeTypesAllowed(List.of("computeTypesAllowed"))
 *                         .maximumBuildsAllowed(123)
 *                         .build())
 *                 .serviceRole("serviceRole")
 *                 .timeoutInMins(123)
 *                 .build())
 *         .cache(ProjectCacheProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .location("location")
 *                 .modes(List.of("modes"))
 *                 .build())
 *         .concurrentBuildLimit(123)
 *         .description("description")
 *         .encryptionKey("encryptionKey")
 *         .fileSystemLocations(List.of(ProjectFileSystemLocationProperty.builder()
 *                 .identifier("identifier")
 *                 .location("location")
 *                 .mountPoint("mountPoint")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .mountOptions("mountOptions")
 *                 .build()))
 *         .logsConfig(LogsConfigProperty.builder()
 *                 .cloudWatchLogs(CloudWatchLogsConfigProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .groupName("groupName")
 *                         .streamName("streamName")
 *                         .build())
 *                 .s3Logs(S3LogsConfigProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .encryptionDisabled(false)
 *                         .location("location")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .queuedTimeoutInMinutes(123)
 *         .resourceAccessRole("resourceAccessRole")
 *         .secondaryArtifacts(List.of(ArtifactsProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .artifactIdentifier("artifactIdentifier")
 *                 .encryptionDisabled(false)
 *                 .location("location")
 *                 .name("name")
 *                 .namespaceType("namespaceType")
 *                 .overrideArtifactName(false)
 *                 .packaging("packaging")
 *                 .path("path")
 *                 .build()))
 *         .secondarySources(List.of(SourceProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .auth(SourceAuthProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .resource("resource")
 *                         .build())
 *                 .buildSpec("buildSpec")
 *                 .buildStatusConfig(BuildStatusConfigProperty.builder()
 *                         .context("context")
 *                         .targetUrl("targetUrl")
 *                         .build())
 *                 .gitCloneDepth(123)
 *                 .gitSubmodulesConfig(GitSubmodulesConfigProperty.builder()
 *                         .fetchSubmodules(false)
 *                         .build())
 *                 .insecureSsl(false)
 *                 .location("location")
 *                 .reportBuildStatus(false)
 *                 .sourceIdentifier("sourceIdentifier")
 *                 .build()))
 *         .secondarySourceVersions(List.of(ProjectSourceVersionProperty.builder()
 *                 .sourceIdentifier("sourceIdentifier")
 *                 // the properties below are optional
 *                 .sourceVersion("sourceVersion")
 *                 .build()))
 *         .sourceVersion("sourceVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutInMinutes(123)
 *         .triggers(ProjectTriggersProperty.builder()
 *                 .buildType("buildType")
 *                 .filterGroups(List.of(List.of(WebhookFilterProperty.builder()
 *                         .pattern("pattern")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .excludeMatchedPattern(false)
 *                         .build())))
 *                 .webhook(false)
 *                 .build())
 *         .visibility("visibility")
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:05.816Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject")
public class CfnProject extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.CfnProject.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CodeBuild::Project`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the AWS CodeBuild project, such as `arn:aws:codebuild:us-west-2:123456789012:project/myProjectName` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An arbitrary set of tags (key-value pairs) for the AWS CodeBuild project.
     * <p>
     * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getArtifacts() {
        return software.amazon.jsii.Kernel.get(this, "artifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty value) {
        software.amazon.jsii.Kernel.set(this, "artifacts", java.util.Objects.requireNonNull(value, "artifacts is required"));
    }

    /**
     * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifacts", java.util.Objects.requireNonNull(value, "artifacts is required"));
    }

    /**
     * The build environment settings for the project, such as the environment type or the environment variables to use for the build environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The build environment settings for the project, such as the environment type or the environment variables to use for the build environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentProperty value) {
        software.amazon.jsii.Kernel.set(this, "environment", java.util.Objects.requireNonNull(value, "environment is required"));
    }

    /**
     * The build environment settings for the project, such as the environment type or the environment variables to use for the build environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environment", java.util.Objects.requireNonNull(value, "environment is required"));
    }

    /**
     * The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * The source code settings for the project, such as the source code's repository type and location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The source code settings for the project, such as the source code's repository type and location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The source code settings for the project, such as the source code's repository type and location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-badges.html">Build Badges Sample</a> in the <em>AWS CodeBuild User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Including build badges with your project is currently not supported if the source type is CodePipeline. If you specify <code>CODEPIPELINE</code> for the <code>Source</code> property, do not specify the <code>BadgeEnabled</code> property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBadgeEnabled() {
        return software.amazon.jsii.Kernel.get(this, "badgeEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-badges.html">Build Badges Sample</a> in the <em>AWS CodeBuild User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Including build badges with your project is currently not supported if the source type is CodePipeline. If you specify <code>CODEPIPELINE</code> for the <code>Source</code> property, do not specify the <code>BadgeEnabled</code> property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBadgeEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "badgeEnabled", value);
    }

    /**
     * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-badges.html">Build Badges Sample</a> in the <em>AWS CodeBuild User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Including build badges with your project is currently not supported if the source type is CodePipeline. If you specify <code>CODEPIPELINE</code> for the <code>Source</code> property, do not specify the <code>BadgeEnabled</code> property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBadgeEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "badgeEnabled", value);
    }

    /**
     * A `ProjectBuildBatchConfig` object that defines the batch build options for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBuildBatchConfig() {
        return software.amazon.jsii.Kernel.get(this, "buildBatchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A `ProjectBuildBatchConfig` object that defines the batch build options for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildBatchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectBuildBatchConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "buildBatchConfig", value);
    }

    /**
     * A `ProjectBuildBatchConfig` object that defines the batch build options for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildBatchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "buildBatchConfig", value);
    }

    /**
     * Settings that AWS CodeBuild uses to store and reuse build dependencies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCache() {
        return software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings that AWS CodeBuild uses to store and reuse build dependencies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCache(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectCacheProperty value) {
        software.amazon.jsii.Kernel.set(this, "cache", value);
    }

    /**
     * Settings that AWS CodeBuild uses to store and reuse build dependencies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCache(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cache", value);
    }

    /**
     * The maximum number of concurrent builds that are allowed for this project.
     * <p>
     * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getConcurrentBuildLimit() {
        return software.amazon.jsii.Kernel.get(this, "concurrentBuildLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of concurrent builds that are allowed for this project.
     * <p>
     * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConcurrentBuildLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "concurrentBuildLimit", value);
    }

    /**
     * A description that makes the build project easy to identify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description that makes the build project easy to identify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The AWS Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     * <p>
     * <blockquote>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     * <p>
     * </blockquote>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/&lt;alias-name&gt;</code> ). If you don't specify a value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     * <p>
     * <blockquote>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     * <p>
     * </blockquote>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/&lt;alias-name&gt;</code> ). If you don't specify a value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionKey", value);
    }

    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project.
     * <p>
     * A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code> , <code>location</code> , <code>mountOptions</code> , <code>mountPoint</code> , and <code>type</code> of a file system created using Amazon Elastic File System.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemLocations() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project.
     * <p>
     * A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code> , <code>location</code> , <code>mountOptions</code> , <code>mountPoint</code> , and <code>type</code> of a file system created using Amazon Elastic File System.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemLocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemLocations", value);
    }

    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project.
     * <p>
     * A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code> , <code>location</code> , <code>mountOptions</code> , <code>mountPoint</code> , and <code>type</code> of a file system created using Amazon Elastic File System.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemLocations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fileSystemLocations", value);
    }

    /**
     * Information about logs for the build project.
     * <p>
     * A project can create logs in CloudWatch Logs, an S3 bucket, or both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogsConfig() {
        return software.amazon.jsii.Kernel.get(this, "logsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about logs for the build project.
     * <p>
     * A project can create logs in CloudWatch Logs, an S3 bucket, or both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.LogsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "logsConfig", value);
    }

    /**
     * Information about logs for the build project.
     * <p>
     * A project can create logs in CloudWatch Logs, an S3 bucket, or both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logsConfig", value);
    }

    /**
     * The name of the build project.
     * <p>
     * The name must be unique across all of the projects in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the build project.
     * <p>
     * The name must be unique across all of the projects in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getQueuedTimeoutInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "queuedTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueuedTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "queuedTimeoutInMinutes", value);
    }

    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceAccessRole() {
        return software.amazon.jsii.Kernel.get(this, "resourceAccessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceAccessRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceAccessRole", value);
    }

    /**
     * A list of `Artifacts` objects.
     * <p>
     * Each artifacts object specifies output settings that the project generates during a build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryArtifacts() {
        return software.amazon.jsii.Kernel.get(this, "secondaryArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of `Artifacts` objects.
     * <p>
     * Each artifacts object specifies output settings that the project generates during a build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondaryArtifacts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "secondaryArtifacts", value);
    }

    /**
     * A list of `Artifacts` objects.
     * <p>
     * Each artifacts object specifies output settings that the project generates during a build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondaryArtifacts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "secondaryArtifacts", value);
    }

    /**
     * An array of `ProjectSource` objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondarySources() {
        return software.amazon.jsii.Kernel.get(this, "secondarySources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of `ProjectSource` objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "secondarySources", value);
    }

    /**
     * An array of `ProjectSource` objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "secondarySources", value);
    }

    /**
     * An array of `ProjectSourceVersion` objects.
     * <p>
     * If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondarySourceVersions() {
        return software.amazon.jsii.Kernel.get(this, "secondarySourceVersions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of `ProjectSourceVersion` objects.
     * <p>
     * If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySourceVersions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "secondarySourceVersions", value);
    }

    /**
     * An array of `ProjectSourceVersion` objects.
     * <p>
     * If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySourceVersions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.codebuild.CfnProject.ProjectSourceVersionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ProjectSourceVersionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "secondarySourceVersions", value);
    }

    /**
     * A version of the build input to be built for this project.
     * <p>
     * If not specified, the latest version is used. If specified, it must be one of:
     * <p>
     * <ul>
     * <li>For CodeCommit: the commit ID, branch, or Git tag to use.</li>
     * <li>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code> ). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
     * <li>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
     * <li>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</li>
     * </ul>
     * <p>
     * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <em>AWS CodeBuild User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceVersion() {
        return software.amazon.jsii.Kernel.get(this, "sourceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A version of the build input to be built for this project.
     * <p>
     * If not specified, the latest version is used. If specified, it must be one of:
     * <p>
     * <ul>
     * <li>For CodeCommit: the commit ID, branch, or Git tag to use.</li>
     * <li>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code> ). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
     * <li>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
     * <li>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</li>
     * </ul>
     * <p>
     * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <em>AWS CodeBuild User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceVersion", value);
    }

    /**
     * How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any related build that did not get marked as completed.
     * <p>
     * The default is 60 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any related build that did not get marked as completed.
     * <p>
     * The default is 60 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeoutInMinutes", value);
    }

    /**
     * For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty value) {
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * Specifies the visibility of the project's builds. Possible values are:.
     * <p>
     * <ul>
     * <li><strong>PUBLIC_READ</strong> - The project builds are visible to the public.</li>
     * <li><strong>PRIVATE</strong> - The project builds are not visible to the public.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVisibility() {
        return software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the visibility of the project's builds. Possible values are:.
     * <p>
     * <ul>
     * <li><strong>PUBLIC_READ</strong> - The project builds are visible to the public.</li>
     * <li><strong>PRIVATE</strong> - The project builds are not visible to the public.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibility(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "visibility", value);
    }

    /**
     * `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">Use AWS CodeBuild with Amazon Virtual Private Cloud</a> in the <em>AWS CodeBuild User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">Use AWS CodeBuild with Amazon Virtual Private Cloud</a> in the <em>AWS CodeBuild User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">Use AWS CodeBuild with Amazon Virtual Private Cloud</a> in the <em>AWS CodeBuild User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ArtifactsProperty artifactsProperty = ArtifactsProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .artifactIdentifier("artifactIdentifier")
     *         .encryptionDisabled(false)
     *         .location("location")
     *         .name("name")
     *         .namespaceType("namespaceType")
     *         .overrideArtifactName(false)
     *         .packaging("packaging")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ArtifactsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of build output artifact. Valid values include:.
         * <p>
         * <ul>
         * <li><code>CODEPIPELINE</code> : The build project has build output generated through CodePipeline.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>CODEPIPELINE</code> type is not supported for <code>secondaryArtifacts</code> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>NO_ARTIFACTS</code> : The build project does not produce any build output.</li>
         * <li><code>S3</code> : The build project stores build output in Amazon S3.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * An identifier for this artifact definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArtifactIdentifier() {
            return null;
        }

        /**
         * Set to true if you do not want your output artifacts encrypted.
         * <p>
         * This option is valid only if your artifacts type is Amazon Simple Storage Service (Amazon S3). If this is set with another artifacts type, an <code>invalidInputException</code> is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * Information about the build output artifact location:.
         * <p>
         * <ul>
         * <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , AWS CodePipeline ignores this value if specified. This is because CodePipeline manages its build output locations instead of CodeBuild .</li>
         * <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
         * <li>If <code>type</code> is set to <code>S3</code> , this is the name of the output bucket.</li>
         * </ul>
         * <p>
         * If you specify <code>CODEPIPELINE</code> or <code>NO_ARTIFACTS</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * Along with `path` and `namespaceType` , the pattern that AWS CodeBuild uses to name and store the output artifact:.
         * <p>
         * <ul>
         * <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , AWS CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of AWS CodeBuild .</li>
         * <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
         * <li>If <code>type</code> is set to <code>S3</code> , this is the name of the output artifact object. If you set the name to be a forward slash ("/"), the artifact is stored in the root of the output bucket.</li>
         * </ul>
         * <p>
         * For example:
         * <p>
         * <ul>
         * <li>If <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , then the output artifact is stored in <code>MyArtifacts/ *build-ID* /MyArtifact.zip</code> .</li>
         * <li>If <code>path</code> is empty, <code>namespaceType</code> is set to <code>NONE</code> , and <code>name</code> is set to " <code>/</code> ", the output artifact is stored in the root of the output bucket.</li>
         * <li>If <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to " <code>/</code> ", the output artifact is stored in <code>MyArtifacts/ *build-ID*</code> .</li>
         * </ul>
         * <p>
         * If you specify <code>CODEPIPELINE</code> or <code>NO_ARTIFACTS</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Along with `path` and `name` , the pattern that AWS CodeBuild uses to determine the name and location to store the output artifact:  - If `type` is set to `CODEPIPELINE` , CodePipeline ignores this value if specified.
         * <p>
         * This is because CodePipeline manages its build output names instead of AWS CodeBuild .
         * <p>
         * <ul>
         * <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
         * <li>If <code>type</code> is set to <code>S3</code> , valid values include:</li>
         * <li><code>BUILD_ID</code> : Include the build ID in the location of the build output artifact.</li>
         * <li><code>NONE</code> : Do not include the build ID. This is the default if <code>namespaceType</code> is not specified.</li>
         * </ul>
         * <p>
         * For example, if <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , the output artifact is stored in <code>MyArtifacts/&lt;build-ID&gt;/MyArtifact.zip</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceType() {
            return null;
        }

        /**
         * If set to true a name specified in the buildspec file overrides the artifact name.
         * <p>
         * The name specified in a buildspec file is calculated at build time and uses the Shell command language. For example, you can append a date and time to your artifact name so that it is always unique.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideArtifactName() {
            return null;
        }

        /**
         * The type of build output artifact to create:.
         * <p>
         * <ul>
         * <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , CodePipeline ignores this value if specified. This is because CodePipeline manages its build output artifacts instead of AWS CodeBuild .</li>
         * <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
         * <li>If <code>type</code> is set to <code>S3</code> , valid values include:</li>
         * <li><code>NONE</code> : AWS CodeBuild creates in the output bucket a folder that contains the build output. This is the default if <code>packaging</code> is not specified.</li>
         * <li><code>ZIP</code> : AWS CodeBuild creates in the output bucket a ZIP file that contains the build output.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPackaging() {
            return null;
        }

        /**
         * Along with `namespaceType` and `name` , the pattern that AWS CodeBuild uses to name and store the output artifact:.
         * <p>
         * <ul>
         * <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of AWS CodeBuild .</li>
         * <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
         * <li>If <code>type</code> is set to <code>S3</code> , this is the path to the output artifact. If <code>path</code> is not specified, <code>path</code> is not used.</li>
         * </ul>
         * <p>
         * For example, if <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>NONE</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , the output artifact is stored in the output bucket at <code>MyArtifacts/MyArtifact.zip</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactsProperty> {
            java.lang.String type;
            java.lang.String artifactIdentifier;
            java.lang.Object encryptionDisabled;
            java.lang.String location;
            java.lang.String name;
            java.lang.String namespaceType;
            java.lang.Object overrideArtifactName;
            java.lang.String packaging;
            java.lang.String path;

            /**
             * Sets the value of {@link ArtifactsProperty#getType}
             * @param type The type of build output artifact. Valid values include:. This parameter is required.
             *             <ul>
             *             <li><code>CODEPIPELINE</code> : The build project has build output generated through CodePipeline.</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             The <code>CODEPIPELINE</code> type is not supported for <code>secondaryArtifacts</code> .
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><code>NO_ARTIFACTS</code> : The build project does not produce any build output.</li>
             *             <li><code>S3</code> : The build project stores build output in Amazon S3.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getArtifactIdentifier}
             * @param artifactIdentifier An identifier for this artifact definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactIdentifier(java.lang.String artifactIdentifier) {
                this.artifactIdentifier = artifactIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getEncryptionDisabled}
             * @param encryptionDisabled Set to true if you do not want your output artifacts encrypted.
             *                           This option is valid only if your artifacts type is Amazon Simple Storage Service (Amazon S3). If this is set with another artifacts type, an <code>invalidInputException</code> is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getEncryptionDisabled}
             * @param encryptionDisabled Set to true if you do not want your output artifacts encrypted.
             *                           This option is valid only if your artifacts type is Amazon Simple Storage Service (Amazon S3). If this is set with another artifacts type, an <code>invalidInputException</code> is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getLocation}
             * @param location Information about the build output artifact location:.
             *                 <ul>
             *                 <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , AWS CodePipeline ignores this value if specified. This is because CodePipeline manages its build output locations instead of CodeBuild .</li>
             *                 <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
             *                 <li>If <code>type</code> is set to <code>S3</code> , this is the name of the output bucket.</li>
             *                 </ul>
             *                 <p>
             *                 If you specify <code>CODEPIPELINE</code> or <code>NO_ARTIFACTS</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getName}
             * @param name Along with `path` and `namespaceType` , the pattern that AWS CodeBuild uses to name and store the output artifact:.
             *             <ul>
             *             <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , AWS CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of AWS CodeBuild .</li>
             *             <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
             *             <li>If <code>type</code> is set to <code>S3</code> , this is the name of the output artifact object. If you set the name to be a forward slash ("/"), the artifact is stored in the root of the output bucket.</li>
             *             </ul>
             *             <p>
             *             For example:
             *             <p>
             *             <ul>
             *             <li>If <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , then the output artifact is stored in <code>MyArtifacts/ *build-ID* /MyArtifact.zip</code> .</li>
             *             <li>If <code>path</code> is empty, <code>namespaceType</code> is set to <code>NONE</code> , and <code>name</code> is set to " <code>/</code> ", the output artifact is stored in the root of the output bucket.</li>
             *             <li>If <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to " <code>/</code> ", the output artifact is stored in <code>MyArtifacts/ *build-ID*</code> .</li>
             *             </ul>
             *             <p>
             *             If you specify <code>CODEPIPELINE</code> or <code>NO_ARTIFACTS</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getNamespaceType}
             * @param namespaceType Along with `path` and `name` , the pattern that AWS CodeBuild uses to determine the name and location to store the output artifact:  - If `type` is set to `CODEPIPELINE` , CodePipeline ignores this value if specified.
             *                      This is because CodePipeline manages its build output names instead of AWS CodeBuild .
             *                      <p>
             *                      <ul>
             *                      <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
             *                      <li>If <code>type</code> is set to <code>S3</code> , valid values include:</li>
             *                      <li><code>BUILD_ID</code> : Include the build ID in the location of the build output artifact.</li>
             *                      <li><code>NONE</code> : Do not include the build ID. This is the default if <code>namespaceType</code> is not specified.</li>
             *                      </ul>
             *                      <p>
             *                      For example, if <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>BUILD_ID</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , the output artifact is stored in <code>MyArtifacts/&lt;build-ID&gt;/MyArtifact.zip</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceType(java.lang.String namespaceType) {
                this.namespaceType = namespaceType;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getOverrideArtifactName}
             * @param overrideArtifactName If set to true a name specified in the buildspec file overrides the artifact name.
             *                             The name specified in a buildspec file is calculated at build time and uses the Shell command language. For example, you can append a date and time to your artifact name so that it is always unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideArtifactName(java.lang.Boolean overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getOverrideArtifactName}
             * @param overrideArtifactName If set to true a name specified in the buildspec file overrides the artifact name.
             *                             The name specified in a buildspec file is calculated at build time and uses the Shell command language. For example, you can append a date and time to your artifact name so that it is always unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideArtifactName(software.amazon.awscdk.IResolvable overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getPackaging}
             * @param packaging The type of build output artifact to create:.
             *                  <ul>
             *                  <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , CodePipeline ignores this value if specified. This is because CodePipeline manages its build output artifacts instead of AWS CodeBuild .</li>
             *                  <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
             *                  <li>If <code>type</code> is set to <code>S3</code> , valid values include:</li>
             *                  <li><code>NONE</code> : AWS CodeBuild creates in the output bucket a folder that contains the build output. This is the default if <code>packaging</code> is not specified.</li>
             *                  <li><code>ZIP</code> : AWS CodeBuild creates in the output bucket a ZIP file that contains the build output.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packaging(java.lang.String packaging) {
                this.packaging = packaging;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getPath}
             * @param path Along with `namespaceType` and `name` , the pattern that AWS CodeBuild uses to name and store the output artifact:.
             *             <ul>
             *             <li>If <code>type</code> is set to <code>CODEPIPELINE</code> , CodePipeline ignores this value if specified. This is because CodePipeline manages its build output names instead of AWS CodeBuild .</li>
             *             <li>If <code>type</code> is set to <code>NO_ARTIFACTS</code> , this value is ignored if specified, because no build output is produced.</li>
             *             <li>If <code>type</code> is set to <code>S3</code> , this is the path to the output artifact. If <code>path</code> is not specified, <code>path</code> is not used.</li>
             *             </ul>
             *             <p>
             *             For example, if <code>path</code> is set to <code>MyArtifacts</code> , <code>namespaceType</code> is set to <code>NONE</code> , and <code>name</code> is set to <code>MyArtifact.zip</code> , the output artifact is stored in the output bucket at <code>MyArtifacts/MyArtifact.zip</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactsProperty {
            private final java.lang.String type;
            private final java.lang.String artifactIdentifier;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String location;
            private final java.lang.String name;
            private final java.lang.String namespaceType;
            private final java.lang.Object overrideArtifactName;
            private final java.lang.String packaging;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.artifactIdentifier = software.amazon.jsii.Kernel.get(this, "artifactIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionDisabled = software.amazon.jsii.Kernel.get(this, "encryptionDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaceType = software.amazon.jsii.Kernel.get(this, "namespaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overrideArtifactName = software.amazon.jsii.Kernel.get(this, "overrideArtifactName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.packaging = software.amazon.jsii.Kernel.get(this, "packaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.artifactIdentifier = builder.artifactIdentifier;
                this.encryptionDisabled = builder.encryptionDisabled;
                this.location = builder.location;
                this.name = builder.name;
                this.namespaceType = builder.namespaceType;
                this.overrideArtifactName = builder.overrideArtifactName;
                this.packaging = builder.packaging;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getArtifactIdentifier() {
                return this.artifactIdentifier;
            }

            @Override
            public final java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNamespaceType() {
                return this.namespaceType;
            }

            @Override
            public final java.lang.Object getOverrideArtifactName() {
                return this.overrideArtifactName;
            }

            @Override
            public final java.lang.String getPackaging() {
                return this.packaging;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getArtifactIdentifier() != null) {
                    data.set("artifactIdentifier", om.valueToTree(this.getArtifactIdentifier()));
                }
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getNamespaceType() != null) {
                    data.set("namespaceType", om.valueToTree(this.getNamespaceType()));
                }
                if (this.getOverrideArtifactName() != null) {
                    data.set("overrideArtifactName", om.valueToTree(this.getOverrideArtifactName()));
                }
                if (this.getPackaging() != null) {
                    data.set("packaging", om.valueToTree(this.getPackaging()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ArtifactsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactsProperty.Jsii$Proxy that = (ArtifactsProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.artifactIdentifier != null ? !this.artifactIdentifier.equals(that.artifactIdentifier) : that.artifactIdentifier != null) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.namespaceType != null ? !this.namespaceType.equals(that.namespaceType) : that.namespaceType != null) return false;
                if (this.overrideArtifactName != null ? !this.overrideArtifactName.equals(that.overrideArtifactName) : that.overrideArtifactName != null) return false;
                if (this.packaging != null ? !this.packaging.equals(that.packaging) : that.packaging != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.artifactIdentifier != null ? this.artifactIdentifier.hashCode() : 0);
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.namespaceType != null ? this.namespaceType.hashCode() : 0);
                result = 31 * result + (this.overrideArtifactName != null ? this.overrideArtifactName.hashCode() : 0);
                result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies restrictions for the batch build.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * BatchRestrictionsProperty batchRestrictionsProperty = BatchRestrictionsProperty.builder()
     *         .computeTypesAllowed(List.of("computeTypesAllowed"))
     *         .maximumBuildsAllowed(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.BatchRestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchRestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchRestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of strings that specify the compute types that are allowed for the batch build.
         * <p>
         * See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild User Guide</em> for these values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getComputeTypesAllowed() {
            return null;
        }

        /**
         * Specifies the maximum number of builds allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBuildsAllowed() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchRestrictionsProperty> {
            java.util.List<java.lang.String> computeTypesAllowed;
            java.lang.Number maximumBuildsAllowed;

            /**
             * Sets the value of {@link BatchRestrictionsProperty#getComputeTypesAllowed}
             * @param computeTypesAllowed An array of strings that specify the compute types that are allowed for the batch build.
             *                            See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild User Guide</em> for these values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeTypesAllowed(java.util.List<java.lang.String> computeTypesAllowed) {
                this.computeTypesAllowed = computeTypesAllowed;
                return this;
            }

            /**
             * Sets the value of {@link BatchRestrictionsProperty#getMaximumBuildsAllowed}
             * @param maximumBuildsAllowed Specifies the maximum number of builds allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBuildsAllowed(java.lang.Number maximumBuildsAllowed) {
                this.maximumBuildsAllowed = maximumBuildsAllowed;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchRestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchRestrictionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchRestrictionsProperty {
            private final java.util.List<java.lang.String> computeTypesAllowed;
            private final java.lang.Number maximumBuildsAllowed;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeTypesAllowed = software.amazon.jsii.Kernel.get(this, "computeTypesAllowed", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maximumBuildsAllowed = software.amazon.jsii.Kernel.get(this, "maximumBuildsAllowed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeTypesAllowed = builder.computeTypesAllowed;
                this.maximumBuildsAllowed = builder.maximumBuildsAllowed;
            }

            @Override
            public final java.util.List<java.lang.String> getComputeTypesAllowed() {
                return this.computeTypesAllowed;
            }

            @Override
            public final java.lang.Number getMaximumBuildsAllowed() {
                return this.maximumBuildsAllowed;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeTypesAllowed() != null) {
                    data.set("computeTypesAllowed", om.valueToTree(this.getComputeTypesAllowed()));
                }
                if (this.getMaximumBuildsAllowed() != null) {
                    data.set("maximumBuildsAllowed", om.valueToTree(this.getMaximumBuildsAllowed()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.BatchRestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchRestrictionsProperty.Jsii$Proxy that = (BatchRestrictionsProperty.Jsii$Proxy) o;

                if (this.computeTypesAllowed != null ? !this.computeTypesAllowed.equals(that.computeTypesAllowed) : that.computeTypesAllowed != null) return false;
                return this.maximumBuildsAllowed != null ? this.maximumBuildsAllowed.equals(that.maximumBuildsAllowed) : that.maximumBuildsAllowed == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeTypesAllowed != null ? this.computeTypesAllowed.hashCode() : 0;
                result = 31 * result + (this.maximumBuildsAllowed != null ? this.maximumBuildsAllowed.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information that defines how the AWS CodeBuild build project reports the build status to the source provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * BuildStatusConfigProperty buildStatusConfigProperty = BuildStatusConfigProperty.builder()
     *         .context("context")
     *         .targetUrl("targetUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.BuildStatusConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BuildStatusConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BuildStatusConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the context of the build status CodeBuild sends to the source provider.
         * <p>
         * The usage of this parameter depends on the source provider.
         * <p>
         * <ul>
         * <li><strong>Bitbucket</strong> - This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</li>
         * <li><strong>GitHub/GitHub Enterprise Server</strong> - This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContext() {
            return null;
        }

        /**
         * Specifies the target url of the build status CodeBuild sends to the source provider.
         * <p>
         * The usage of this parameter depends on the source provider.
         * <p>
         * <ul>
         * <li><strong>Bitbucket</strong> - This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</li>
         * <li><strong>GitHub/GitHub Enterprise Server</strong> - This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BuildStatusConfigProperty> {
            java.lang.String context;
            java.lang.String targetUrl;

            /**
             * Sets the value of {@link BuildStatusConfigProperty#getContext}
             * @param context Specifies the context of the build status CodeBuild sends to the source provider.
             *                The usage of this parameter depends on the source provider.
             *                <p>
             *                <ul>
             *                <li><strong>Bitbucket</strong> - This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</li>
             *                <li><strong>GitHub/GitHub Enterprise Server</strong> - This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder context(java.lang.String context) {
                this.context = context;
                return this;
            }

            /**
             * Sets the value of {@link BuildStatusConfigProperty#getTargetUrl}
             * @param targetUrl Specifies the target url of the build status CodeBuild sends to the source provider.
             *                  The usage of this parameter depends on the source provider.
             *                  <p>
             *                  <ul>
             *                  <li><strong>Bitbucket</strong> - This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</li>
             *                  <li><strong>GitHub/GitHub Enterprise Server</strong> - This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more information, see <a href="https://docs.aws.amazon.com/https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetUrl(java.lang.String targetUrl) {
                this.targetUrl = targetUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BuildStatusConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BuildStatusConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildStatusConfigProperty {
            private final java.lang.String context;
            private final java.lang.String targetUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetUrl = software.amazon.jsii.Kernel.get(this, "targetUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.context = builder.context;
                this.targetUrl = builder.targetUrl;
            }

            @Override
            public final java.lang.String getContext() {
                return this.context;
            }

            @Override
            public final java.lang.String getTargetUrl() {
                return this.targetUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContext() != null) {
                    data.set("context", om.valueToTree(this.getContext()));
                }
                if (this.getTargetUrl() != null) {
                    data.set("targetUrl", om.valueToTree(this.getTargetUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.BuildStatusConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BuildStatusConfigProperty.Jsii$Proxy that = (BuildStatusConfigProperty.Jsii$Proxy) o;

                if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
                return this.targetUrl != null ? this.targetUrl.equals(that.targetUrl) : that.targetUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.context != null ? this.context.hashCode() : 0;
                result = 31 * result + (this.targetUrl != null ? this.targetUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `CloudWatchLogs` is a property of the [AWS CodeBuild Project LogsConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html) property type that specifies settings for CloudWatch logs generated by an AWS CodeBuild build.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * CloudWatchLogsConfigProperty cloudWatchLogsConfigProperty = CloudWatchLogsConfigProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .groupName("groupName")
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.CloudWatchLogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The current status of the logs in CloudWatch Logs for a build project. Valid values are:.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> : CloudWatch Logs are enabled for this build project.</li>
         * <li><code>DISABLED</code> : CloudWatch Logs are not enabled for this build project.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * The group name of the logs in CloudWatch Logs.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * The prefix of the stream name of the CloudWatch Logs.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsConfigProperty> {
            java.lang.String status;
            java.lang.String groupName;
            java.lang.String streamName;

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getStatus}
             * @param status The current status of the logs in CloudWatch Logs for a build project. Valid values are:. This parameter is required.
             *               <ul>
             *               <li><code>ENABLED</code> : CloudWatch Logs are enabled for this build project.</li>
             *               <li><code>DISABLED</code> : CloudWatch Logs are not enabled for this build project.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getGroupName}
             * @param groupName The group name of the logs in CloudWatch Logs.
             *                  For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getStreamName}
             * @param streamName The prefix of the stream name of the CloudWatch Logs.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsConfigProperty {
            private final java.lang.String status;
            private final java.lang.String groupName;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.groupName = builder.groupName;
                this.streamName = builder.streamName;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.CloudWatchLogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsConfigProperty.Jsii$Proxy that = (CloudWatchLogsConfigProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Environment` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies the environment for an AWS CodeBuild project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * EnvironmentProperty environmentProperty = EnvironmentProperty.builder()
     *         .computeType("computeType")
     *         .image("image")
     *         .type("type")
     *         // the properties below are optional
     *         .certificate("certificate")
     *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build()))
     *         .imagePullCredentialsType("imagePullCredentialsType")
     *         .privilegedMode(false)
     *         .registryCredential(RegistryCredentialProperty.builder()
     *                 .credential("credential")
     *                 .credentialProvider("credentialProvider")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of compute environment.
         * <p>
         * This determines the number of CPU cores and memory the build environment uses. Available values include:
         * <p>
         * <ul>
         * <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 3 GB memory and 2 vCPUs for builds.</li>
         * <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 7 GB memory and 4 vCPUs for builds.</li>
         * <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 15 GB memory and 8 vCPUs for builds.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment Compute Types</a> in the <em>AWS CodeBuild User Guide.</em>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComputeType();

        /**
         * The image tag or image digest that identifies the Docker image to use for this build project.
         * <p>
         * Use the following formats:
         * <p>
         * <ul>
         * <li>For an image tag: <code>&lt;registry&gt;/&lt;repository&gt;:&lt;tag&gt;</code> . For example, in the Docker repository that CodeBuild uses to manage its Docker images, this would be <code>aws/codebuild/standard:4.0</code> .</li>
         * <li>For an image digest: <code>&lt;registry&gt;/&lt;repository&gt;&#64;&lt;digest&gt;</code> . For example, to specify an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use <code>&lt;registry&gt;/&lt;repository&gt;&#64;sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <em>AWS CodeBuild user guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The type of build environment to use for related builds.
         * <p>
         * <ul>
         * <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and EU (Frankfurt).</li>
         * <li>The environment type <code>LINUX_CONTAINER</code> with compute type <code>build.general1.2xlarge</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</li>
         * <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and China (Ningxia).</li>
         * <li>The environment types <code>WINDOWS_CONTAINER</code> and <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and EU (Ireland).</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded certificate for the build project.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the <em>AWS CodeBuild User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
            return null;
        }

        /**
         * A set of environment variables to make available to builds for this build project.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:.
         * <p>
         * <ul>
         * <li><code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust AWS CodeBuild service principal.</li>
         * <li><code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.</li>
         * </ul>
         * <p>
         * When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImagePullCredentialsType() {
            return null;
        }

        /**
         * Enables running the Docker daemon inside a Docker container.
         * <p>
         * Set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. The default setting is <code>false</code> .
         * <p>
         * You can initialize the Docker daemon during the install phase of your build by adding one of the following sets of commands to the install phase of your buildspec file:
         * <p>
         * If the operating system's base image is Ubuntu Linux:
         * <p>
         * <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
         * <p>
         * <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
         * <p>
         * If the operating system's base image is Alpine Linux and the previous command does not work, add the <code>-t</code> argument to <code>timeout</code> :
         * <p>
         * <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
         * <p>
         * <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivilegedMode() {
            return null;
        }

        /**
         * `RegistryCredential` is a property of the [AWS::CodeBuild::Project Environment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment) property that specifies information about credentials that provide access to a private Docker registry. When this is set:.
         * <p>
         * <ul>
         * <li><code>imagePullCredentialsType</code> must be set to <code>SERVICE_ROLE</code> .</li>
         * <li>images cannot be curated or an Amazon ECR image.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegistryCredential() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            java.lang.String computeType;
            java.lang.String image;
            java.lang.String type;
            java.lang.String certificate;
            java.lang.Object environmentVariables;
            java.lang.String imagePullCredentialsType;
            java.lang.Object privilegedMode;
            java.lang.Object registryCredential;

            /**
             * Sets the value of {@link EnvironmentProperty#getComputeType}
             * @param computeType The type of compute environment. This parameter is required.
             *                    This determines the number of CPU cores and memory the build environment uses. Available values include:
             *                    <p>
             *                    <ul>
             *                    <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 3 GB memory and 2 vCPUs for builds.</li>
             *                    <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 7 GB memory and 4 vCPUs for builds.</li>
             *                    <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 15 GB memory and 8 vCPUs for builds.</li>
             *                    </ul>
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment Compute Types</a> in the <em>AWS CodeBuild User Guide.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeType(java.lang.String computeType) {
                this.computeType = computeType;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getImage}
             * @param image The image tag or image digest that identifies the Docker image to use for this build project. This parameter is required.
             *              Use the following formats:
             *              <p>
             *              <ul>
             *              <li>For an image tag: <code>&lt;registry&gt;/&lt;repository&gt;:&lt;tag&gt;</code> . For example, in the Docker repository that CodeBuild uses to manage its Docker images, this would be <code>aws/codebuild/standard:4.0</code> .</li>
             *              <li>For an image digest: <code>&lt;registry&gt;/&lt;repository&gt;&#64;&lt;digest&gt;</code> . For example, to specify an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use <code>&lt;registry&gt;/&lt;repository&gt;&#64;sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code> .</li>
             *              </ul>
             *              <p>
             *              For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <em>AWS CodeBuild user guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getType}
             * @param type The type of build environment to use for related builds. This parameter is required.
             *             <ul>
             *             <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and EU (Frankfurt).</li>
             *             <li>The environment type <code>LINUX_CONTAINER</code> with compute type <code>build.general1.2xlarge</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</li>
             *             <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Canada (Central), EU (Ireland), EU (London), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and China (Ningxia).</li>
             *             <li>The environment types <code>WINDOWS_CONTAINER</code> and <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), and EU (Ireland).</li>
             *             </ul>
             *             <p>
             *             For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getCertificate}
             * @param certificate The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded certificate for the build project.
             *                    For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the <em>AWS CodeBuild User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(java.lang.String certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getEnvironmentVariables}
             * @param environmentVariables A set of environment variables to make available to builds for this build project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getEnvironmentVariables}
             * @param environmentVariables A set of environment variables to make available to builds for this build project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.List<? extends java.lang.Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getImagePullCredentialsType}
             * @param imagePullCredentialsType The type of credentials AWS CodeBuild uses to pull images in your build. There are two valid values:.
             *                                 <ul>
             *                                 <li><code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust AWS CodeBuild service principal.</li>
             *                                 <li><code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.</li>
             *                                 </ul>
             *                                 <p>
             *                                 When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullCredentialsType(java.lang.String imagePullCredentialsType) {
                this.imagePullCredentialsType = imagePullCredentialsType;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getPrivilegedMode}
             * @param privilegedMode Enables running the Docker daemon inside a Docker container.
             *                       Set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. The default setting is <code>false</code> .
             *                       <p>
             *                       You can initialize the Docker daemon during the install phase of your build by adding one of the following sets of commands to the install phase of your buildspec file:
             *                       <p>
             *                       If the operating system's base image is Ubuntu Linux:
             *                       <p>
             *                       <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
             *                       <p>
             *                       <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
             *                       <p>
             *                       If the operating system's base image is Alpine Linux and the previous command does not work, add the <code>-t</code> argument to <code>timeout</code> :
             *                       <p>
             *                       <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
             *                       <p>
             *                       <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privilegedMode(java.lang.Boolean privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getPrivilegedMode}
             * @param privilegedMode Enables running the Docker daemon inside a Docker container.
             *                       Set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. The default setting is <code>false</code> .
             *                       <p>
             *                       You can initialize the Docker daemon during the install phase of your build by adding one of the following sets of commands to the install phase of your buildspec file:
             *                       <p>
             *                       If the operating system's base image is Ubuntu Linux:
             *                       <p>
             *                       <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
             *                       <p>
             *                       <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
             *                       <p>
             *                       If the operating system's base image is Alpine Linux and the previous command does not work, add the <code>-t</code> argument to <code>timeout</code> :
             *                       <p>
             *                       <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&amp;</code>
             *                       <p>
             *                       <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privilegedMode(software.amazon.awscdk.IResolvable privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getRegistryCredential}
             * @param registryCredential `RegistryCredential` is a property of the [AWS::CodeBuild::Project Environment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment) property that specifies information about credentials that provide access to a private Docker registry. When this is set:.
             *                           <ul>
             *                           <li><code>imagePullCredentialsType</code> must be set to <code>SERVICE_ROLE</code> .</li>
             *                           <li>images cannot be curated or an Amazon ECR image.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryCredential(software.amazon.awscdk.services.codebuild.CfnProject.RegistryCredentialProperty registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getRegistryCredential}
             * @param registryCredential `RegistryCredential` is a property of the [AWS::CodeBuild::Project Environment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment) property that specifies information about credentials that provide access to a private Docker registry. When this is set:.
             *                           <ul>
             *                           <li><code>imagePullCredentialsType</code> must be set to <code>SERVICE_ROLE</code> .</li>
             *                           <li>images cannot be curated or an Amazon ECR image.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryCredential(software.amazon.awscdk.IResolvable registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.String computeType;
            private final java.lang.String image;
            private final java.lang.String type;
            private final java.lang.String certificate;
            private final java.lang.Object environmentVariables;
            private final java.lang.String imagePullCredentialsType;
            private final java.lang.Object privilegedMode;
            private final java.lang.Object registryCredential;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imagePullCredentialsType = software.amazon.jsii.Kernel.get(this, "imagePullCredentialsType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privilegedMode = software.amazon.jsii.Kernel.get(this, "privilegedMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.registryCredential = software.amazon.jsii.Kernel.get(this, "registryCredential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeType = java.util.Objects.requireNonNull(builder.computeType, "computeType is required");
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.certificate = builder.certificate;
                this.environmentVariables = builder.environmentVariables;
                this.imagePullCredentialsType = builder.imagePullCredentialsType;
                this.privilegedMode = builder.privilegedMode;
                this.registryCredential = builder.registryCredential;
            }

            @Override
            public final java.lang.String getComputeType() {
                return this.computeType;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.String getImagePullCredentialsType() {
                return this.imagePullCredentialsType;
            }

            @Override
            public final java.lang.Object getPrivilegedMode() {
                return this.privilegedMode;
            }

            @Override
            public final java.lang.Object getRegistryCredential() {
                return this.registryCredential;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("computeType", om.valueToTree(this.getComputeType()));
                data.set("image", om.valueToTree(this.getImage()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCertificate() != null) {
                    data.set("certificate", om.valueToTree(this.getCertificate()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getImagePullCredentialsType() != null) {
                    data.set("imagePullCredentialsType", om.valueToTree(this.getImagePullCredentialsType()));
                }
                if (this.getPrivilegedMode() != null) {
                    data.set("privilegedMode", om.valueToTree(this.getPrivilegedMode()));
                }
                if (this.getRegistryCredential() != null) {
                    data.set("registryCredential", om.valueToTree(this.getRegistryCredential()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (!computeType.equals(that.computeType)) return false;
                if (!image.equals(that.image)) return false;
                if (!type.equals(that.type)) return false;
                if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.imagePullCredentialsType != null ? !this.imagePullCredentialsType.equals(that.imagePullCredentialsType) : that.imagePullCredentialsType != null) return false;
                if (this.privilegedMode != null ? !this.privilegedMode.equals(that.privilegedMode) : that.privilegedMode != null) return false;
                return this.registryCredential != null ? this.registryCredential.equals(that.registryCredential) : that.registryCredential == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeType.hashCode();
                result = 31 * result + (this.image.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.imagePullCredentialsType != null ? this.imagePullCredentialsType.hashCode() : 0);
                result = 31 * result + (this.privilegedMode != null ? this.privilegedMode.hashCode() : 0);
                result = 31 * result + (this.registryCredential != null ? this.registryCredential.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `EnvironmentVariable` is a property of the [AWS CodeBuild Project Environment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html) property type that specifies the name and value of an environment variable for an AWS CodeBuild project environment. When you use the environment to run a build, these variables are available for your builds to use. `EnvironmentVariable` contains a list of `EnvironmentVariable` property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * EnvironmentVariableProperty environmentVariableProperty = EnvironmentVariableProperty.builder()
     *         .name("name")
     *         .value("value")
     *         // the properties below are optional
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name or key of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the environment variable.
         * <p>
         * <blockquote>
         * <p>
         * We strongly discourage the use of <code>PLAINTEXT</code> environment variables to store sensitive values, especially AWS secret key IDs and secret access keys. <code>PLAINTEXT</code> environment variables can be displayed in plain text using the AWS CodeBuild console and the AWS CLI . For sensitive values, we recommend you use an environment variable of type <code>PARAMETER_STORE</code> or <code>SECRETS_MANAGER</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * The type of environment variable. Valid values include:.
         * <p>
         * <ul>
         * <li><code>PARAMETER_STORE</code> : An environment variable stored in Systems Manager Parameter Store. To learn how to specify a parameter store environment variable, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the <em>AWS CodeBuild User Guide</em> .</li>
         * <li><code>PLAINTEXT</code> : An environment variable in plain text format. This is the default value.</li>
         * <li><code>SECRETS_MANAGER</code> : An environment variable stored in AWS Secrets Manager . To learn how to specify a secrets manager environment variable, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the <em>AWS CodeBuild User Guide</em> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;
            java.lang.String type;

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getName}
             * @param name The name or key of the environment variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getValue}
             * @param value The value of the environment variable. This parameter is required.
             *              <blockquote>
             *              <p>
             *              We strongly discourage the use of <code>PLAINTEXT</code> environment variables to store sensitive values, especially AWS secret key IDs and secret access keys. <code>PLAINTEXT</code> environment variables can be displayed in plain text using the AWS CodeBuild console and the AWS CLI . For sensitive values, we recommend you use an environment variable of type <code>PARAMETER_STORE</code> or <code>SECRETS_MANAGER</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getType}
             * @param type The type of environment variable. Valid values include:.
             *             <ul>
             *             <li><code>PARAMETER_STORE</code> : An environment variable stored in Systems Manager Parameter Store. To learn how to specify a parameter store environment variable, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the <em>AWS CodeBuild User Guide</em> .</li>
             *             <li><code>PLAINTEXT</code> : An environment variable in plain text format. This is the default value.</li>
             *             <li><code>SECRETS_MANAGER</code> : An environment variable stored in AWS Secrets Manager . To learn how to specify a secrets manager environment variable, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the <em>AWS CodeBuild User Guide</em> .</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.EnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentVariableProperty.Jsii$Proxy that = (EnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!value.equals(that.value)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `GitSubmodulesConfig` is a property of the [AWS CodeBuild Project Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html) property type that specifies information about the Git submodules configuration for the build project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * GitSubmodulesConfigProperty gitSubmodulesConfigProperty = GitSubmodulesConfigProperty.builder()
     *         .fetchSubmodules(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.GitSubmodulesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GitSubmodulesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitSubmodulesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set to true to fetch Git submodules for your AWS CodeBuild build project.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFetchSubmodules();

        /**
         * @return a {@link Builder} of {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitSubmodulesConfigProperty> {
            java.lang.Object fetchSubmodules;

            /**
             * Sets the value of {@link GitSubmodulesConfigProperty#getFetchSubmodules}
             * @param fetchSubmodules Set to true to fetch Git submodules for your AWS CodeBuild build project. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fetchSubmodules(java.lang.Boolean fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            /**
             * Sets the value of {@link GitSubmodulesConfigProperty#getFetchSubmodules}
             * @param fetchSubmodules Set to true to fetch Git submodules for your AWS CodeBuild build project. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fetchSubmodules(software.amazon.awscdk.IResolvable fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitSubmodulesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitSubmodulesConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitSubmodulesConfigProperty {
            private final java.lang.Object fetchSubmodules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fetchSubmodules = software.amazon.jsii.Kernel.get(this, "fetchSubmodules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fetchSubmodules = java.util.Objects.requireNonNull(builder.fetchSubmodules, "fetchSubmodules is required");
            }

            @Override
            public final java.lang.Object getFetchSubmodules() {
                return this.fetchSubmodules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fetchSubmodules", om.valueToTree(this.getFetchSubmodules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.GitSubmodulesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitSubmodulesConfigProperty.Jsii$Proxy that = (GitSubmodulesConfigProperty.Jsii$Proxy) o;

                return this.fetchSubmodules.equals(that.fetchSubmodules);
            }

            @Override
            public final int hashCode() {
                int result = this.fetchSubmodules.hashCode();
                return result;
            }
        }
    }
    /**
     * `LogsConfig` is a property of the [AWS CodeBuild Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies information about logs for a build project. These can be logs in Amazon CloudWatch Logs, built in a specified S3 bucket, or both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * LogsConfigProperty logsConfigProperty = LogsConfigProperty.builder()
     *         .cloudWatchLogs(CloudWatchLogsConfigProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .groupName("groupName")
     *                 .streamName("streamName")
     *                 .build())
     *         .s3Logs(S3LogsConfigProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .encryptionDisabled(false)
     *                 .location("location")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.LogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about CloudWatch Logs for a build project.
         * <p>
         * CloudWatch Logs are enabled by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogs() {
            return null;
        }

        /**
         * Information about logs built to an S3 bucket for a build project.
         * <p>
         * S3 logs are not enabled by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Logs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogsConfigProperty> {
            java.lang.Object cloudWatchLogs;
            java.lang.Object s3Logs;

            /**
             * Sets the value of {@link LogsConfigProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Information about CloudWatch Logs for a build project.
             *                       CloudWatch Logs are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.services.codebuild.CfnProject.CloudWatchLogsConfigProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Information about CloudWatch Logs for a build project.
             *                       CloudWatch Logs are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getS3Logs}
             * @param s3Logs Information about logs built to an S3 bucket for a build project.
             *               S3 logs are not enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.services.codebuild.CfnProject.S3LogsConfigProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getS3Logs}
             * @param s3Logs Information about logs built to an S3 bucket for a build project.
             *               S3 logs are not enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogsConfigProperty {
            private final java.lang.Object cloudWatchLogs;
            private final java.lang.Object s3Logs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogs = software.amazon.jsii.Kernel.get(this, "cloudWatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Logs = software.amazon.jsii.Kernel.get(this, "s3Logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogs = builder.cloudWatchLogs;
                this.s3Logs = builder.s3Logs;
            }

            @Override
            public final java.lang.Object getCloudWatchLogs() {
                return this.cloudWatchLogs;
            }

            @Override
            public final java.lang.Object getS3Logs() {
                return this.s3Logs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogs() != null) {
                    data.set("cloudWatchLogs", om.valueToTree(this.getCloudWatchLogs()));
                }
                if (this.getS3Logs() != null) {
                    data.set("s3Logs", om.valueToTree(this.getS3Logs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.LogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogsConfigProperty.Jsii$Proxy that = (LogsConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogs != null ? !this.cloudWatchLogs.equals(that.cloudWatchLogs) : that.cloudWatchLogs != null) return false;
                return this.s3Logs != null ? this.s3Logs.equals(that.s3Logs) : that.s3Logs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogs != null ? this.cloudWatchLogs.hashCode() : 0;
                result = 31 * result + (this.s3Logs != null ? this.s3Logs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configuration information about a batch build project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProjectBuildBatchConfigProperty projectBuildBatchConfigProperty = ProjectBuildBatchConfigProperty.builder()
     *         .batchReportMode("batchReportMode")
     *         .combineArtifacts(false)
     *         .restrictions(BatchRestrictionsProperty.builder()
     *                 .computeTypesAllowed(List.of("computeTypesAllowed"))
     *                 .maximumBuildsAllowed(123)
     *                 .build())
     *         .serviceRole("serviceRole")
     *         .timeoutInMins(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ProjectBuildBatchConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectBuildBatchConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectBuildBatchConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies how build status reports are sent to the source provider for the batch build.
         * <p>
         * This property is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is configured to report build statuses to the source provider.
         * <p>
         * <ul>
         * <li><strong>REPORT_AGGREGATED_BATCH</strong> - (Default) Aggregate all of the build statuses into a single status report.</li>
         * <li><strong>REPORT_INDIVIDUAL_BUILDS</strong> - Send a separate status report for each individual build.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBatchReportMode() {
            return null;
        }

        /**
         * Specifies if the build artifacts for the batch build should be combined into a single artifact location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCombineArtifacts() {
            return null;
        }

        /**
         * A `BatchRestrictions` object that specifies the restrictions for the batch build.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictions() {
            return null;
        }

        /**
         * Specifies the service role ARN for the batch build project.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
            return null;
        }

        /**
         * Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMins() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectBuildBatchConfigProperty> {
            java.lang.String batchReportMode;
            java.lang.Object combineArtifacts;
            java.lang.Object restrictions;
            java.lang.String serviceRole;
            java.lang.Number timeoutInMins;

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getBatchReportMode}
             * @param batchReportMode Specifies how build status reports are sent to the source provider for the batch build.
             *                        This property is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is configured to report build statuses to the source provider.
             *                        <p>
             *                        <ul>
             *                        <li><strong>REPORT_AGGREGATED_BATCH</strong> - (Default) Aggregate all of the build statuses into a single status report.</li>
             *                        <li><strong>REPORT_INDIVIDUAL_BUILDS</strong> - Send a separate status report for each individual build.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchReportMode(java.lang.String batchReportMode) {
                this.batchReportMode = batchReportMode;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getCombineArtifacts}
             * @param combineArtifacts Specifies if the build artifacts for the batch build should be combined into a single artifact location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder combineArtifacts(java.lang.Boolean combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getCombineArtifacts}
             * @param combineArtifacts Specifies if the build artifacts for the batch build should be combined into a single artifact location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder combineArtifacts(software.amazon.awscdk.IResolvable combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getRestrictions}
             * @param restrictions A `BatchRestrictions` object that specifies the restrictions for the batch build.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.codebuild.CfnProject.BatchRestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getRestrictions}
             * @param restrictions A `BatchRestrictions` object that specifies the restrictions for the batch build.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getServiceRole}
             * @param serviceRole Specifies the service role ARN for the batch build project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceRole(java.lang.String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getTimeoutInMins}
             * @param timeoutInMins Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMins(java.lang.Number timeoutInMins) {
                this.timeoutInMins = timeoutInMins;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectBuildBatchConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectBuildBatchConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectBuildBatchConfigProperty {
            private final java.lang.String batchReportMode;
            private final java.lang.Object combineArtifacts;
            private final java.lang.Object restrictions;
            private final java.lang.String serviceRole;
            private final java.lang.Number timeoutInMins;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchReportMode = software.amazon.jsii.Kernel.get(this, "batchReportMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.combineArtifacts = software.amazon.jsii.Kernel.get(this, "combineArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictions = software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutInMins = software.amazon.jsii.Kernel.get(this, "timeoutInMins", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchReportMode = builder.batchReportMode;
                this.combineArtifacts = builder.combineArtifacts;
                this.restrictions = builder.restrictions;
                this.serviceRole = builder.serviceRole;
                this.timeoutInMins = builder.timeoutInMins;
            }

            @Override
            public final java.lang.String getBatchReportMode() {
                return this.batchReportMode;
            }

            @Override
            public final java.lang.Object getCombineArtifacts() {
                return this.combineArtifacts;
            }

            @Override
            public final java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            public final java.lang.String getServiceRole() {
                return this.serviceRole;
            }

            @Override
            public final java.lang.Number getTimeoutInMins() {
                return this.timeoutInMins;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBatchReportMode() != null) {
                    data.set("batchReportMode", om.valueToTree(this.getBatchReportMode()));
                }
                if (this.getCombineArtifacts() != null) {
                    data.set("combineArtifacts", om.valueToTree(this.getCombineArtifacts()));
                }
                if (this.getRestrictions() != null) {
                    data.set("restrictions", om.valueToTree(this.getRestrictions()));
                }
                if (this.getServiceRole() != null) {
                    data.set("serviceRole", om.valueToTree(this.getServiceRole()));
                }
                if (this.getTimeoutInMins() != null) {
                    data.set("timeoutInMins", om.valueToTree(this.getTimeoutInMins()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ProjectBuildBatchConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectBuildBatchConfigProperty.Jsii$Proxy that = (ProjectBuildBatchConfigProperty.Jsii$Proxy) o;

                if (this.batchReportMode != null ? !this.batchReportMode.equals(that.batchReportMode) : that.batchReportMode != null) return false;
                if (this.combineArtifacts != null ? !this.combineArtifacts.equals(that.combineArtifacts) : that.combineArtifacts != null) return false;
                if (this.restrictions != null ? !this.restrictions.equals(that.restrictions) : that.restrictions != null) return false;
                if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
                return this.timeoutInMins != null ? this.timeoutInMins.equals(that.timeoutInMins) : that.timeoutInMins == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchReportMode != null ? this.batchReportMode.hashCode() : 0;
                result = 31 * result + (this.combineArtifacts != null ? this.combineArtifacts.hashCode() : 0);
                result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
                result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
                result = 31 * result + (this.timeoutInMins != null ? this.timeoutInMins.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ProjectCache` is a property of the [AWS CodeBuild Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies information about the cache for the build project. If `ProjectCache` is not specified, then both of its properties default to `NO_CACHE` .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProjectCacheProperty projectCacheProperty = ProjectCacheProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .location("location")
     *         .modes(List.of("modes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ProjectCacheProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectCacheProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectCacheProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of cache used by the build project. Valid values include:.
         * <p>
         * <ul>
         * <li><code>NO_CACHE</code> : The build project does not use any cache.</li>
         * <li><code>S3</code> : The build project reads and writes from and to S3.</li>
         * <li><code>LOCAL</code> : The build project stores a cache locally on a build host that is only available to that build host.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Information about the cache location:.
         * <p>
         * <ul>
         * <li><code>NO_CACHE</code> or <code>LOCAL</code> : This value is ignored.</li>
         * <li><code>S3</code> : This is the S3 bucket name/prefix.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * An array of strings that specify the local cache modes.
         * <p>
         * You can use one or more local cache modes at the same time. This is only used for <code>LOCAL</code> cache types.
         * <p>
         * Possible values are:
         * <p>
         * <ul>
         * <li><strong>LOCAL_SOURCE_CACHE</strong> - Caches Git metadata for primary and secondary sources. After the cache is created, subsequent builds pull only the change between commits. This mode is a good choice for projects with a clean working directory and a source that is a large Git repository. If you choose this option and your project does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the option is ignored.</li>
         * <li><strong>LOCAL_DOCKER_LAYER_CACHE</strong> - Caches existing Docker layers. This mode is a good choice for projects that build or pull large Docker images. It can prevent the performance issues caused by pulling large Docker images down from the network.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>You can use a Docker layer cache in the Linux environment only.</li>
         * <li>The <code>privileged</code> flag must be set so that your project has the required Docker permissions.</li>
         * <li>You should consider the security implications before you use a Docker layer cache.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>LOCAL_CUSTOM_CACHE</strong> - Caches directories you specify in the buildspec file. This mode is a good choice if your build scenario is not suited to one of the other three local cache modes. If you use a custom cache:</li>
         * <li>Only directories can be specified for caching. You cannot specify individual files.</li>
         * <li>Symlinks are used to reference cached directories.</li>
         * <li>Cached directories are linked to your build before it downloads its project sources. Cached items are overridden if a source item has the same name. Directories are specified using cache paths in the buildspec file.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getModes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectCacheProperty> {
            java.lang.String type;
            java.lang.String location;
            java.util.List<java.lang.String> modes;

            /**
             * Sets the value of {@link ProjectCacheProperty#getType}
             * @param type The type of cache used by the build project. Valid values include:. This parameter is required.
             *             <ul>
             *             <li><code>NO_CACHE</code> : The build project does not use any cache.</li>
             *             <li><code>S3</code> : The build project reads and writes from and to S3.</li>
             *             <li><code>LOCAL</code> : The build project stores a cache locally on a build host that is only available to that build host.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProjectCacheProperty#getLocation}
             * @param location Information about the cache location:.
             *                 <ul>
             *                 <li><code>NO_CACHE</code> or <code>LOCAL</code> : This value is ignored.</li>
             *                 <li><code>S3</code> : This is the S3 bucket name/prefix.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ProjectCacheProperty#getModes}
             * @param modes An array of strings that specify the local cache modes.
             *              You can use one or more local cache modes at the same time. This is only used for <code>LOCAL</code> cache types.
             *              <p>
             *              Possible values are:
             *              <p>
             *              <ul>
             *              <li><strong>LOCAL_SOURCE_CACHE</strong> - Caches Git metadata for primary and secondary sources. After the cache is created, subsequent builds pull only the change between commits. This mode is a good choice for projects with a clean working directory and a source that is a large Git repository. If you choose this option and your project does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the option is ignored.</li>
             *              <li><strong>LOCAL_DOCKER_LAYER_CACHE</strong> - Caches existing Docker layers. This mode is a good choice for projects that build or pull large Docker images. It can prevent the performance issues caused by pulling large Docker images down from the network.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              <ul>
             *              <li>You can use a Docker layer cache in the Linux environment only.</li>
             *              <li>The <code>privileged</code> flag must be set so that your project has the required Docker permissions.</li>
             *              <li>You should consider the security implications before you use a Docker layer cache.</li>
             *              </ul>
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><strong>LOCAL_CUSTOM_CACHE</strong> - Caches directories you specify in the buildspec file. This mode is a good choice if your build scenario is not suited to one of the other three local cache modes. If you use a custom cache:</li>
             *              <li>Only directories can be specified for caching. You cannot specify individual files.</li>
             *              <li>Symlinks are used to reference cached directories.</li>
             *              <li>Cached directories are linked to your build before it downloads its project sources. Cached items are overridden if a source item has the same name. Directories are specified using cache paths in the buildspec file.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modes(java.util.List<java.lang.String> modes) {
                this.modes = modes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectCacheProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectCacheProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectCacheProperty {
            private final java.lang.String type;
            private final java.lang.String location;
            private final java.util.List<java.lang.String> modes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modes = software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.location = builder.location;
                this.modes = builder.modes;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.util.List<java.lang.String> getModes() {
                return this.modes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getModes() != null) {
                    data.set("modes", om.valueToTree(this.getModes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ProjectCacheProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectCacheProperty.Jsii$Proxy that = (ProjectCacheProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                return this.modes != null ? this.modes.equals(that.modes) : that.modes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.modes != null ? this.modes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a file system created by Amazon Elastic File System (EFS).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html">What Is Amazon Elastic File System?</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProjectFileSystemLocationProperty projectFileSystemLocationProperty = ProjectFileSystemLocationProperty.builder()
     *         .identifier("identifier")
     *         .location("location")
     *         .mountPoint("mountPoint")
     *         .type("type")
     *         // the properties below are optional
     *         .mountOptions("mountOptions")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ProjectFileSystemLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectFileSystemLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectFileSystemLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name used to access a file system created by Amazon EFS.
         * <p>
         * CodeBuild creates an environment variable by appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code> . For example, if you specify <code>my_efs</code> for <code>identifier</code> , a new environment variable is create named <code>CODEBUILD_MY_EFS</code> .
         * <p>
         * The <code>identifier</code> is used to mount your file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * A string that specifies the location of the file system created by Amazon EFS.
         * <p>
         * Its format is <code>efs-dns-name:/directory-path</code> . You can find the DNS name of file system when you view it in the Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For example, if the DNS name of a file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code> , and its mount directory is <code>my-efs-mount-directory</code> , then the <code>location</code> is <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code> .
         * <p>
         * The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * The location in the container where you mount the file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMountPoint();

        /**
         * The type of the file system.
         * <p>
         * The one supported type is <code>EFS</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The mount options for a file system created by Amazon EFS.
         * <p>
         * The default mount options used by CodeBuild are <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount Options</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectFileSystemLocationProperty> {
            java.lang.String identifier;
            java.lang.String location;
            java.lang.String mountPoint;
            java.lang.String type;
            java.lang.String mountOptions;

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getIdentifier}
             * @param identifier The name used to access a file system created by Amazon EFS. This parameter is required.
             *                   CodeBuild creates an environment variable by appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code> . For example, if you specify <code>my_efs</code> for <code>identifier</code> , a new environment variable is create named <code>CODEBUILD_MY_EFS</code> .
             *                   <p>
             *                   The <code>identifier</code> is used to mount your file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getLocation}
             * @param location A string that specifies the location of the file system created by Amazon EFS. This parameter is required.
             *                 Its format is <code>efs-dns-name:/directory-path</code> . You can find the DNS name of file system when you view it in the Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For example, if the DNS name of a file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code> , and its mount directory is <code>my-efs-mount-directory</code> , then the <code>location</code> is <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code> .
             *                 <p>
             *                 The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getMountPoint}
             * @param mountPoint The location in the container where you mount the file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoint(java.lang.String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getType}
             * @param type The type of the file system. This parameter is required.
             *             The one supported type is <code>EFS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getMountOptions}
             * @param mountOptions The mount options for a file system created by Amazon EFS.
             *                     The default mount options used by CodeBuild are <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount Options</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(java.lang.String mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectFileSystemLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectFileSystemLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectFileSystemLocationProperty {
            private final java.lang.String identifier;
            private final java.lang.String location;
            private final java.lang.String mountPoint;
            private final java.lang.String type;
            private final java.lang.String mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mountPoint = software.amazon.jsii.Kernel.get(this, "mountPoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.mountPoint = java.util.Objects.requireNonNull(builder.mountPoint, "mountPoint is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.mountOptions = builder.mountOptions;
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getMountPoint() {
                return this.mountPoint;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getMountOptions() {
                return this.mountOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));
                data.set("location", om.valueToTree(this.getLocation()));
                data.set("mountPoint", om.valueToTree(this.getMountPoint()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getMountOptions() != null) {
                    data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ProjectFileSystemLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectFileSystemLocationProperty.Jsii$Proxy that = (ProjectFileSystemLocationProperty.Jsii$Proxy) o;

                if (!identifier.equals(that.identifier)) return false;
                if (!location.equals(that.location)) return false;
                if (!mountPoint.equals(that.mountPoint)) return false;
                if (!type.equals(that.type)) return false;
                return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.identifier.hashCode();
                result = 31 * result + (this.location.hashCode());
                result = 31 * result + (this.mountPoint.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A source identifier and its corresponding version.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProjectSourceVersionProperty projectSourceVersionProperty = ProjectSourceVersionProperty.builder()
     *         .sourceIdentifier("sourceIdentifier")
     *         // the properties below are optional
     *         .sourceVersion("sourceVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ProjectSourceVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectSourceVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectSourceVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for a source in the build project.
         * <p>
         * The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceIdentifier();

        /**
         * The source version for the corresponding source identifier. If specified, must be one of:.
         * <p>
         * <ul>
         * <li>For CodeCommit: the commit ID, branch, or Git tag to use.</li>
         * <li>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example, <code>pr/25</code> ). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
         * <li>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
         * <li>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <em>AWS CodeBuild User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectSourceVersionProperty> {
            java.lang.String sourceIdentifier;
            java.lang.String sourceVersion;

            /**
             * Sets the value of {@link ProjectSourceVersionProperty#getSourceIdentifier}
             * @param sourceIdentifier An identifier for a source in the build project. This parameter is required.
             *                         The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ProjectSourceVersionProperty#getSourceVersion}
             * @param sourceVersion The source version for the corresponding source identifier. If specified, must be one of:.
             *                      <ul>
             *                      <li>For CodeCommit: the commit ID, branch, or Git tag to use.</li>
             *                      <li>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example, <code>pr/25</code> ). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
             *                      <li>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
             *                      <li>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</li>
             *                      </ul>
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <em>AWS CodeBuild User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVersion(java.lang.String sourceVersion) {
                this.sourceVersion = sourceVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectSourceVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectSourceVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectSourceVersionProperty {
            private final java.lang.String sourceIdentifier;
            private final java.lang.String sourceVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceIdentifier = software.amazon.jsii.Kernel.get(this, "sourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceVersion = software.amazon.jsii.Kernel.get(this, "sourceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceIdentifier = java.util.Objects.requireNonNull(builder.sourceIdentifier, "sourceIdentifier is required");
                this.sourceVersion = builder.sourceVersion;
            }

            @Override
            public final java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            public final java.lang.String getSourceVersion() {
                return this.sourceVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                if (this.getSourceVersion() != null) {
                    data.set("sourceVersion", om.valueToTree(this.getSourceVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ProjectSourceVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectSourceVersionProperty.Jsii$Proxy that = (ProjectSourceVersionProperty.Jsii$Proxy) o;

                if (!sourceIdentifier.equals(that.sourceIdentifier)) return false;
                return this.sourceVersion != null ? this.sourceVersion.equals(that.sourceVersion) : that.sourceVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceIdentifier.hashCode();
                result = 31 * result + (this.sourceVersion != null ? this.sourceVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ProjectTriggers` is a property of the [AWS CodeBuild Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies webhooks that trigger an AWS CodeBuild build.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * ProjectTriggersProperty projectTriggersProperty = ProjectTriggersProperty.builder()
     *         .buildType("buildType")
     *         .filterGroups(List.of(List.of(WebhookFilterProperty.builder()
     *                 .pattern("pattern")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .excludeMatchedPattern(false)
     *                 .build())))
     *         .webhook(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.ProjectTriggersProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectTriggersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectTriggersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of build this webhook will trigger. Allowed values are:.
         * <p>
         * <ul>
         * <li><strong>BUILD</strong> - A single build</li>
         * <li><strong>BUILD_BATCH</strong> - A batch build</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildType() {
            return null;
        }

        /**
         * A list of lists of `WebhookFilter` objects used to determine which webhook events are triggered.
         * <p>
         * At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterGroups() {
            return null;
        }

        /**
         * Specifies whether or not to begin automatically rebuilding the source code every time a code change is pushed to the repository.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebhook() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectTriggersProperty> {
            java.lang.String buildType;
            java.lang.Object filterGroups;
            java.lang.Object webhook;

            /**
             * Sets the value of {@link ProjectTriggersProperty#getBuildType}
             * @param buildType Specifies the type of build this webhook will trigger. Allowed values are:.
             *                  <ul>
             *                  <li><strong>BUILD</strong> - A single build</li>
             *                  <li><strong>BUILD_BATCH</strong> - A batch build</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildType(java.lang.String buildType) {
                this.buildType = buildType;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getFilterGroups}
             * @param filterGroups A list of lists of `WebhookFilter` objects used to determine which webhook events are triggered.
             *                     At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(software.amazon.awscdk.IResolvable filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getFilterGroups}
             * @param filterGroups A list of lists of `WebhookFilter` objects used to determine which webhook events are triggered.
             *                     At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(java.util.List<? extends java.lang.Object> filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getWebhook}
             * @param webhook Specifies whether or not to begin automatically rebuilding the source code every time a code change is pushed to the repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webhook(java.lang.Boolean webhook) {
                this.webhook = webhook;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getWebhook}
             * @param webhook Specifies whether or not to begin automatically rebuilding the source code every time a code change is pushed to the repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webhook(software.amazon.awscdk.IResolvable webhook) {
                this.webhook = webhook;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectTriggersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectTriggersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectTriggersProperty {
            private final java.lang.String buildType;
            private final java.lang.Object filterGroups;
            private final java.lang.Object webhook;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.buildType = software.amazon.jsii.Kernel.get(this, "buildType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterGroups = software.amazon.jsii.Kernel.get(this, "filterGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webhook = software.amazon.jsii.Kernel.get(this, "webhook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.buildType = builder.buildType;
                this.filterGroups = builder.filterGroups;
                this.webhook = builder.webhook;
            }

            @Override
            public final java.lang.String getBuildType() {
                return this.buildType;
            }

            @Override
            public final java.lang.Object getFilterGroups() {
                return this.filterGroups;
            }

            @Override
            public final java.lang.Object getWebhook() {
                return this.webhook;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBuildType() != null) {
                    data.set("buildType", om.valueToTree(this.getBuildType()));
                }
                if (this.getFilterGroups() != null) {
                    data.set("filterGroups", om.valueToTree(this.getFilterGroups()));
                }
                if (this.getWebhook() != null) {
                    data.set("webhook", om.valueToTree(this.getWebhook()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.ProjectTriggersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectTriggersProperty.Jsii$Proxy that = (ProjectTriggersProperty.Jsii$Proxy) o;

                if (this.buildType != null ? !this.buildType.equals(that.buildType) : that.buildType != null) return false;
                if (this.filterGroups != null ? !this.filterGroups.equals(that.filterGroups) : that.filterGroups != null) return false;
                return this.webhook != null ? this.webhook.equals(that.webhook) : that.webhook == null;
            }

            @Override
            public final int hashCode() {
                int result = this.buildType != null ? this.buildType.hashCode() : 0;
                result = 31 * result + (this.filterGroups != null ? this.filterGroups.hashCode() : 0);
                result = 31 * result + (this.webhook != null ? this.webhook.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `RegistryCredential` is a property of the [AWS CodeBuild Project Environment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html) property type that specifies information about credentials that provide access to a private Docker registry. When this is set:.
     * <p>
     * <ul>
     * <li><code>imagePullCredentialsType</code> must be set to <code>SERVICE_ROLE</code> .</li>
     * <li>images cannot be curated or an Amazon ECR image.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html">Private Registry with AWS Secrets Manager Sample for AWS CodeBuild</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * RegistryCredentialProperty registryCredentialProperty = RegistryCredentialProperty.builder()
     *         .credential("credential")
     *         .credentialProvider("credentialProvider")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.RegistryCredentialProperty")
    @software.amazon.jsii.Jsii.Proxy(RegistryCredentialProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegistryCredentialProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets Manager .
         * <p>
         * <blockquote>
         * <p>
         * The <code>credential</code> can use the name of the credentials only if they exist in your current AWS Region .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredential();

        /**
         * The service that created the credentials to access a private Docker registry.
         * <p>
         * The valid value, SECRETS_MANAGER, is for AWS Secrets Manager .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialProvider();

        /**
         * @return a {@link Builder} of {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegistryCredentialProperty> {
            java.lang.String credential;
            java.lang.String credentialProvider;

            /**
             * Sets the value of {@link RegistryCredentialProperty#getCredential}
             * @param credential The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets Manager . This parameter is required.
             *                   <blockquote>
             *                   <p>
             *                   The <code>credential</code> can use the name of the credentials only if they exist in your current AWS Region .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credential(java.lang.String credential) {
                this.credential = credential;
                return this;
            }

            /**
             * Sets the value of {@link RegistryCredentialProperty#getCredentialProvider}
             * @param credentialProvider The service that created the credentials to access a private Docker registry. This parameter is required.
             *                           The valid value, SECRETS_MANAGER, is for AWS Secrets Manager .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialProvider(java.lang.String credentialProvider) {
                this.credentialProvider = credentialProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegistryCredentialProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegistryCredentialProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegistryCredentialProperty {
            private final java.lang.String credential;
            private final java.lang.String credentialProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credential = software.amazon.jsii.Kernel.get(this, "credential", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialProvider = software.amazon.jsii.Kernel.get(this, "credentialProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credential = java.util.Objects.requireNonNull(builder.credential, "credential is required");
                this.credentialProvider = java.util.Objects.requireNonNull(builder.credentialProvider, "credentialProvider is required");
            }

            @Override
            public final java.lang.String getCredential() {
                return this.credential;
            }

            @Override
            public final java.lang.String getCredentialProvider() {
                return this.credentialProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credential", om.valueToTree(this.getCredential()));
                data.set("credentialProvider", om.valueToTree(this.getCredentialProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.RegistryCredentialProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegistryCredentialProperty.Jsii$Proxy that = (RegistryCredentialProperty.Jsii$Proxy) o;

                if (!credential.equals(that.credential)) return false;
                return this.credentialProvider.equals(that.credentialProvider);
            }

            @Override
            public final int hashCode() {
                int result = this.credential.hashCode();
                result = 31 * result + (this.credentialProvider.hashCode());
                return result;
            }
        }
    }
    /**
     * `S3Logs` is a property of the [AWS CodeBuild Project LogsConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html) property type that specifies settings for logs generated by an AWS CodeBuild build in an S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * S3LogsConfigProperty s3LogsConfigProperty = S3LogsConfigProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .encryptionDisabled(false)
     *         .location("location")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.S3LogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The current status of the S3 build logs. Valid values are:.
         * <p>
         * <ul>
         * <li><code>ENABLED</code> : S3 build logs are enabled for this build project.</li>
         * <li><code>DISABLED</code> : S3 build logs are not enabled for this build project.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * Set to true if you do not want your S3 build log output encrypted.
         * <p>
         * By default S3 build logs are encrypted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * The ARN of an S3 bucket and the path prefix for S3 logs.
         * <p>
         * If your Amazon S3 bucket name is <code>my-bucket</code> , and your path prefix is <code>build-log</code> , then acceptable formats are <code>my-bucket/build-log</code> or <code>arn:aws:s3:::my-bucket/build-log</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LogsConfigProperty> {
            java.lang.String status;
            java.lang.Object encryptionDisabled;
            java.lang.String location;

            /**
             * Sets the value of {@link S3LogsConfigProperty#getStatus}
             * @param status The current status of the S3 build logs. Valid values are:. This parameter is required.
             *               <ul>
             *               <li><code>ENABLED</code> : S3 build logs are enabled for this build project.</li>
             *               <li><code>DISABLED</code> : S3 build logs are not enabled for this build project.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled Set to true if you do not want your S3 build log output encrypted.
             *                           By default S3 build logs are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled Set to true if you do not want your S3 build log output encrypted.
             *                           By default S3 build logs are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getLocation}
             * @param location The ARN of an S3 bucket and the path prefix for S3 logs.
             *                 If your Amazon S3 bucket name is <code>my-bucket</code> , and your path prefix is <code>build-log</code> , then acceptable formats are <code>my-bucket/build-log</code> or <code>arn:aws:s3:::my-bucket/build-log</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LogsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LogsConfigProperty {
            private final java.lang.String status;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionDisabled = software.amazon.jsii.Kernel.get(this, "encryptionDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.encryptionDisabled = builder.encryptionDisabled;
                this.location = builder.location;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.S3LogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LogsConfigProperty.Jsii$Proxy that = (S3LogsConfigProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                return this.location != null ? this.location.equals(that.location) : that.location == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `SourceAuth` is a property of the [AWS CodeBuild Project Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html) property type that specifies authorization settings for AWS CodeBuild to access the source code to be built.
     * <p>
     * <code>SourceAuth</code> is for use by the CodeBuild console only. Do not get or set it directly.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * SourceAuthProperty sourceAuthProperty = SourceAuthProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .resource("resource")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.SourceAuthProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceAuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceAuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization type to use. The only valid value is `OAUTH` , which represents the OAuth authorization type.
         * <p>
         * <blockquote>
         * <p>
         * This data type is used by the AWS CodeBuild console only.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The resource value that applies to the specified authorization type.
         * <p>
         * <blockquote>
         * <p>
         * This data type is used by the AWS CodeBuild console only.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceAuthProperty> {
            java.lang.String type;
            java.lang.String resource;

            /**
             * Sets the value of {@link SourceAuthProperty#getType}
             * @param type The authorization type to use. The only valid value is `OAUTH` , which represents the OAuth authorization type. This parameter is required.
             *             <blockquote>
             *             <p>
             *             This data type is used by the AWS CodeBuild console only.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceAuthProperty#getResource}
             * @param resource The resource value that applies to the specified authorization type.
             *                 <blockquote>
             *                 <p>
             *                 This data type is used by the AWS CodeBuild console only.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceAuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceAuthProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceAuthProperty {
            private final java.lang.String type;
            private final java.lang.String resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.resource = builder.resource;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.SourceAuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceAuthProperty.Jsii$Proxy that = (SourceAuthProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Source` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies the source code settings for the project, such as the source code's repository type and location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .auth(SourceAuthProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .resource("resource")
     *                 .build())
     *         .buildSpec("buildSpec")
     *         .buildStatusConfig(BuildStatusConfigProperty.builder()
     *                 .context("context")
     *                 .targetUrl("targetUrl")
     *                 .build())
     *         .gitCloneDepth(123)
     *         .gitSubmodulesConfig(GitSubmodulesConfigProperty.builder()
     *                 .fetchSubmodules(false)
     *                 .build())
     *         .insecureSsl(false)
     *         .location("location")
     *         .reportBuildStatus(false)
     *         .sourceIdentifier("sourceIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of repository that contains the source code to be built. Valid values include:.
         * <p>
         * <ul>
         * <li><code>BITBUCKET</code> : The source code is in a Bitbucket repository.</li>
         * <li><code>CODECOMMIT</code> : The source code is in an CodeCommit repository.</li>
         * <li><code>CODEPIPELINE</code> : The source code settings are specified in the source action of a pipeline in CodePipeline.</li>
         * <li><code>GITHUB</code> : The source code is in a GitHub or GitHub Enterprise Cloud repository.</li>
         * <li><code>GITHUB_ENTERPRISE</code> : The source code is in a GitHub Enterprise Server repository.</li>
         * <li><code>NO_SOURCE</code> : The project does not have input source code.</li>
         * <li><code>S3</code> : The source code is in an Amazon S3 bucket.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Information about the authorization settings for AWS CodeBuild to access the source code to be built.
         * <p>
         * This information is for the AWS CodeBuild console's use only. Your code should not get or set <code>Auth</code> directly.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * The build specification for the project.
         * <p>
         * If this value is not provided, then the source code must contain a buildspec file named <code>buildspec.yml</code> at the root level. If this value is provided, it can be either a single string containing the entire build specification, or the path to an alternate buildspec file relative to the value of the built-in environment variable <code>CODEBUILD_SRC_DIR</code> . The alternate buildspec file can have a name other than <code>buildspec.yml</code> , for example <code>myspec.yml</code> or <code>build_spec_qa.yml</code> or similar. For more information, see the <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example">Build Spec Reference</a> in the <em>AWS CodeBuild User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
            return null;
        }

        /**
         * Contains information that defines how the build project reports the build status to the source provider.
         * <p>
         * This option is only used when the source provider is <code>GITHUB</code> , <code>GITHUB_ENTERPRISE</code> , or <code>BITBUCKET</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBuildStatusConfig() {
            return null;
        }

        /**
         * The depth of history to download.
         * <p>
         * Minimum value is 0. If this value is 0, greater than 25, or not provided, then the full history is downloaded with each build project. If your source type is Amazon S3, this value is not supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGitCloneDepth() {
            return null;
        }

        /**
         * Information about the Git submodules configuration for the build project.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGitSubmodulesConfig() {
            return null;
        }

        /**
         * This is used with GitHub Enterprise only.
         * <p>
         * Set to true to ignore SSL warnings while connecting to your GitHub Enterprise project repository. The default value is <code>false</code> . <code>InsecureSsl</code> should be used for testing purposes only. It should not be used in a production environment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInsecureSsl() {
            return null;
        }

        /**
         * Information about the location of the source code to be built. Valid values include:.
         * <p>
         * <ul>
         * <li>For source code settings that are specified in the source action of a pipeline in CodePipeline, <code>location</code> should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.</li>
         * <li>For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the buildspec file (for example, <code>https://git-codecommit.&lt;region-ID&gt;.amazonaws.com/v1/repos/&lt;repo-name&gt;</code> ).</li>
         * <li>For source code in an Amazon S3 input bucket, one of the following.</li>
         * <li>The path to the ZIP file that contains the source code (for example, <code>&lt;bucket-name&gt;/&lt;path&gt;/&lt;object-name&gt;.zip</code> ).</li>
         * <li>The path to the folder that contains the source code (for example, <code>&lt;bucket-name&gt;/&lt;path-to-source-code&gt;/&lt;folder&gt;/</code> ).</li>
         * <li>For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your AWS account to your GitHub account. Use the AWS CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitHub, on the GitHub <em>Authorize application</em> page, for <em>Organization access</em> , choose <em>Request access</em> next to each repository you want to allow AWS CodeBuild to have access to, and then choose <em>Authorize application</em> . (After you have connected to your GitHub account, you do not need to finish creating the build project. You can leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this connection, in the <code>source</code> object, set the <code>auth</code> object's <code>type</code> value to <code>OAUTH</code> .</li>
         * <li>For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your AWS account to your Bitbucket account. Use the AWS CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with Bitbucket, on the Bitbucket <em>Confirm access to your account</em> page, choose <em>Grant access</em> . (After you have connected to your Bitbucket account, you do not need to finish creating the build project. You can leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this connection, in the <code>source</code> object, set the <code>auth</code> object's <code>type</code> value to <code>OAUTH</code> .</li>
         * </ul>
         * <p>
         * If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify <code>Location</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * Set to true to report the status of a build's start and finish to your source provider.
         * <p>
         * This option is valid only when your source provider is GitHub, GitHub Enterprise, or Bitbucket. If this is set and you use a different source provider, an <code>invalidInputException</code> is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReportBuildStatus() {
            return null;
        }

        /**
         * An identifier for this project source.
         * <p>
         * The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String type;
            java.lang.Object auth;
            java.lang.String buildSpec;
            java.lang.Object buildStatusConfig;
            java.lang.Number gitCloneDepth;
            java.lang.Object gitSubmodulesConfig;
            java.lang.Object insecureSsl;
            java.lang.String location;
            java.lang.Object reportBuildStatus;
            java.lang.String sourceIdentifier;

            /**
             * Sets the value of {@link SourceProperty#getType}
             * @param type The type of repository that contains the source code to be built. Valid values include:. This parameter is required.
             *             <ul>
             *             <li><code>BITBUCKET</code> : The source code is in a Bitbucket repository.</li>
             *             <li><code>CODECOMMIT</code> : The source code is in an CodeCommit repository.</li>
             *             <li><code>CODEPIPELINE</code> : The source code settings are specified in the source action of a pipeline in CodePipeline.</li>
             *             <li><code>GITHUB</code> : The source code is in a GitHub or GitHub Enterprise Cloud repository.</li>
             *             <li><code>GITHUB_ENTERPRISE</code> : The source code is in a GitHub Enterprise Server repository.</li>
             *             <li><code>NO_SOURCE</code> : The project does not have input source code.</li>
             *             <li><code>S3</code> : The source code is in an Amazon S3 bucket.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getAuth}
             * @param auth Information about the authorization settings for AWS CodeBuild to access the source code to be built.
             *             This information is for the AWS CodeBuild console's use only. Your code should not get or set <code>Auth</code> directly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.codebuild.CfnProject.SourceAuthProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getAuth}
             * @param auth Information about the authorization settings for AWS CodeBuild to access the source code to be built.
             *             This information is for the AWS CodeBuild console's use only. Your code should not get or set <code>Auth</code> directly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildSpec}
             * @param buildSpec The build specification for the project.
             *                  If this value is not provided, then the source code must contain a buildspec file named <code>buildspec.yml</code> at the root level. If this value is provided, it can be either a single string containing the entire build specification, or the path to an alternate buildspec file relative to the value of the built-in environment variable <code>CODEBUILD_SRC_DIR</code> . The alternate buildspec file can have a name other than <code>buildspec.yml</code> , for example <code>myspec.yml</code> or <code>build_spec_qa.yml</code> or similar. For more information, see the <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example">Build Spec Reference</a> in the <em>AWS CodeBuild User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildSpec(java.lang.String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildStatusConfig}
             * @param buildStatusConfig Contains information that defines how the build project reports the build status to the source provider.
             *                          This option is only used when the source provider is <code>GITHUB</code> , <code>GITHUB_ENTERPRISE</code> , or <code>BITBUCKET</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildStatusConfig(software.amazon.awscdk.services.codebuild.CfnProject.BuildStatusConfigProperty buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildStatusConfig}
             * @param buildStatusConfig Contains information that defines how the build project reports the build status to the source provider.
             *                          This option is only used when the source provider is <code>GITHUB</code> , <code>GITHUB_ENTERPRISE</code> , or <code>BITBUCKET</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildStatusConfig(software.amazon.awscdk.IResolvable buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitCloneDepth}
             * @param gitCloneDepth The depth of history to download.
             *                      Minimum value is 0. If this value is 0, greater than 25, or not provided, then the full history is downloaded with each build project. If your source type is Amazon S3, this value is not supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitCloneDepth(java.lang.Number gitCloneDepth) {
                this.gitCloneDepth = gitCloneDepth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitSubmodulesConfig}
             * @param gitSubmodulesConfig Information about the Git submodules configuration for the build project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitSubmodulesConfig(software.amazon.awscdk.services.codebuild.CfnProject.GitSubmodulesConfigProperty gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitSubmodulesConfig}
             * @param gitSubmodulesConfig Information about the Git submodules configuration for the build project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitSubmodulesConfig(software.amazon.awscdk.IResolvable gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getInsecureSsl}
             * @param insecureSsl This is used with GitHub Enterprise only.
             *                    Set to true to ignore SSL warnings while connecting to your GitHub Enterprise project repository. The default value is <code>false</code> . <code>InsecureSsl</code> should be used for testing purposes only. It should not be used in a production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insecureSsl(java.lang.Boolean insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getInsecureSsl}
             * @param insecureSsl This is used with GitHub Enterprise only.
             *                    Set to true to ignore SSL warnings while connecting to your GitHub Enterprise project repository. The default value is <code>false</code> . <code>InsecureSsl</code> should be used for testing purposes only. It should not be used in a production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insecureSsl(software.amazon.awscdk.IResolvable insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getLocation}
             * @param location Information about the location of the source code to be built. Valid values include:.
             *                 <ul>
             *                 <li>For source code settings that are specified in the source action of a pipeline in CodePipeline, <code>location</code> should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.</li>
             *                 <li>For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the buildspec file (for example, <code>https://git-codecommit.&lt;region-ID&gt;.amazonaws.com/v1/repos/&lt;repo-name&gt;</code> ).</li>
             *                 <li>For source code in an Amazon S3 input bucket, one of the following.</li>
             *                 <li>The path to the ZIP file that contains the source code (for example, <code>&lt;bucket-name&gt;/&lt;path&gt;/&lt;object-name&gt;.zip</code> ).</li>
             *                 <li>The path to the folder that contains the source code (for example, <code>&lt;bucket-name&gt;/&lt;path-to-source-code&gt;/&lt;folder&gt;/</code> ).</li>
             *                 <li>For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your AWS account to your GitHub account. Use the AWS CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with GitHub, on the GitHub <em>Authorize application</em> page, for <em>Organization access</em> , choose <em>Request access</em> next to each repository you want to allow AWS CodeBuild to have access to, and then choose <em>Authorize application</em> . (After you have connected to your GitHub account, you do not need to finish creating the build project. You can leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this connection, in the <code>source</code> object, set the <code>auth</code> object's <code>type</code> value to <code>OAUTH</code> .</li>
             *                 <li>For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the buildspec file. You must connect your AWS account to your Bitbucket account. Use the AWS CodeBuild console to start creating a build project. When you use the console to connect (or reconnect) with Bitbucket, on the Bitbucket <em>Confirm access to your account</em> page, choose <em>Grant access</em> . (After you have connected to your Bitbucket account, you do not need to finish creating the build project. You can leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this connection, in the <code>source</code> object, set the <code>auth</code> object's <code>type</code> value to <code>OAUTH</code> .</li>
             *                 </ul>
             *                 <p>
             *                 If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this property. For all of the other types, you must specify <code>Location</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getReportBuildStatus}
             * @param reportBuildStatus Set to true to report the status of a build's start and finish to your source provider.
             *                          This option is valid only when your source provider is GitHub, GitHub Enterprise, or Bitbucket. If this is set and you use a different source provider, an <code>invalidInputException</code> is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportBuildStatus(java.lang.Boolean reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getReportBuildStatus}
             * @param reportBuildStatus Set to true to report the status of a build's start and finish to your source provider.
             *                          This option is valid only when your source provider is GitHub, GitHub Enterprise, or Bitbucket. If this is set and you use a different source provider, an <code>invalidInputException</code> is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportBuildStatus(software.amazon.awscdk.IResolvable reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIdentifier}
             * @param sourceIdentifier An identifier for this project source.
             *                         The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String type;
            private final java.lang.Object auth;
            private final java.lang.String buildSpec;
            private final java.lang.Object buildStatusConfig;
            private final java.lang.Number gitCloneDepth;
            private final java.lang.Object gitSubmodulesConfig;
            private final java.lang.Object insecureSsl;
            private final java.lang.String location;
            private final java.lang.Object reportBuildStatus;
            private final java.lang.String sourceIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.buildStatusConfig = software.amazon.jsii.Kernel.get(this, "buildStatusConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gitCloneDepth = software.amazon.jsii.Kernel.get(this, "gitCloneDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gitSubmodulesConfig = software.amazon.jsii.Kernel.get(this, "gitSubmodulesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.insecureSsl = software.amazon.jsii.Kernel.get(this, "insecureSsl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.reportBuildStatus = software.amazon.jsii.Kernel.get(this, "reportBuildStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceIdentifier = software.amazon.jsii.Kernel.get(this, "sourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.auth = builder.auth;
                this.buildSpec = builder.buildSpec;
                this.buildStatusConfig = builder.buildStatusConfig;
                this.gitCloneDepth = builder.gitCloneDepth;
                this.gitSubmodulesConfig = builder.gitSubmodulesConfig;
                this.insecureSsl = builder.insecureSsl;
                this.location = builder.location;
                this.reportBuildStatus = builder.reportBuildStatus;
                this.sourceIdentifier = builder.sourceIdentifier;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public final java.lang.String getBuildSpec() {
                return this.buildSpec;
            }

            @Override
            public final java.lang.Object getBuildStatusConfig() {
                return this.buildStatusConfig;
            }

            @Override
            public final java.lang.Number getGitCloneDepth() {
                return this.gitCloneDepth;
            }

            @Override
            public final java.lang.Object getGitSubmodulesConfig() {
                return this.gitSubmodulesConfig;
            }

            @Override
            public final java.lang.Object getInsecureSsl() {
                return this.insecureSsl;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getReportBuildStatus() {
                return this.reportBuildStatus;
            }

            @Override
            public final java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getBuildSpec() != null) {
                    data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
                }
                if (this.getBuildStatusConfig() != null) {
                    data.set("buildStatusConfig", om.valueToTree(this.getBuildStatusConfig()));
                }
                if (this.getGitCloneDepth() != null) {
                    data.set("gitCloneDepth", om.valueToTree(this.getGitCloneDepth()));
                }
                if (this.getGitSubmodulesConfig() != null) {
                    data.set("gitSubmodulesConfig", om.valueToTree(this.getGitSubmodulesConfig()));
                }
                if (this.getInsecureSsl() != null) {
                    data.set("insecureSsl", om.valueToTree(this.getInsecureSsl()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getReportBuildStatus() != null) {
                    data.set("reportBuildStatus", om.valueToTree(this.getReportBuildStatus()));
                }
                if (this.getSourceIdentifier() != null) {
                    data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
                if (this.buildStatusConfig != null ? !this.buildStatusConfig.equals(that.buildStatusConfig) : that.buildStatusConfig != null) return false;
                if (this.gitCloneDepth != null ? !this.gitCloneDepth.equals(that.gitCloneDepth) : that.gitCloneDepth != null) return false;
                if (this.gitSubmodulesConfig != null ? !this.gitSubmodulesConfig.equals(that.gitSubmodulesConfig) : that.gitSubmodulesConfig != null) return false;
                if (this.insecureSsl != null ? !this.insecureSsl.equals(that.insecureSsl) : that.insecureSsl != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.reportBuildStatus != null ? !this.reportBuildStatus.equals(that.reportBuildStatus) : that.reportBuildStatus != null) return false;
                return this.sourceIdentifier != null ? this.sourceIdentifier.equals(that.sourceIdentifier) : that.sourceIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
                result = 31 * result + (this.buildStatusConfig != null ? this.buildStatusConfig.hashCode() : 0);
                result = 31 * result + (this.gitCloneDepth != null ? this.gitCloneDepth.hashCode() : 0);
                result = 31 * result + (this.gitSubmodulesConfig != null ? this.gitSubmodulesConfig.hashCode() : 0);
                result = 31 * result + (this.insecureSsl != null ? this.insecureSsl.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.reportBuildStatus != null ? this.reportBuildStatus.hashCode() : 0);
                result = 31 * result + (this.sourceIdentifier != null ? this.sourceIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `VpcConfig` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that enable AWS CodeBuild to access resources in an Amazon VPC. For more information, see [Use AWS CodeBuild with Amazon Virtual Private Cloud](https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html) in the *AWS CodeBuild User Guide* .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of one or more security groups IDs in your Amazon VPC.
         * <p>
         * The maximum count is 5.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * A list of one or more subnet IDs in your Amazon VPC.
         * <p>
         * The maximum count is 16.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * The ID of the Amazon VPC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of one or more security groups IDs in your Amazon VPC.
             *                         The maximum count is 5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets A list of one or more subnet IDs in your Amazon VPC.
             *                The maximum count is 16.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getVpcId}
             * @param vpcId The ID of the Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnets = builder.subnets;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `WebhookFilter` is a structure of the `FilterGroups` property on the [AWS CodeBuild Project ProjectTriggers](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html) property type that specifies which webhooks trigger an AWS CodeBuild build.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codebuild.*;
     * WebhookFilterProperty webhookFilterProperty = WebhookFilterProperty.builder()
     *         .pattern("pattern")
     *         .type("type")
     *         // the properties below are optional
     *         .excludeMatchedPattern(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnProject.WebhookFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(WebhookFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebhookFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For a `WebHookFilter` that uses `EVENT` type, a comma-separated string that specifies one or more events.
         * <p>
         * For example, the webhook filter <code>PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request created, and pull request updated events to trigger a build.
         * <p>
         * For a <code>WebHookFilter</code> that uses any of the other filter types, a regular expression pattern. For example, a <code>WebHookFilter</code> that uses <code>HEAD_REF</code> for its <code>type</code> and the pattern <code>^refs/heads/</code> triggers a build when the head reference is a branch with a reference name <code>refs/heads/branch-name</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * The type of webhook filter.
         * <p>
         * There are six webhook filter types: <code>EVENT</code> , <code>ACTOR_ACCOUNT_ID</code> , <code>HEAD_REF</code> , <code>BASE_REF</code> , <code>FILE_PATH</code> , and <code>COMMIT_MESSAGE</code> .
         * <p>
         * <ul>
         * <li><strong>EVENT</strong> - A webhook event triggers a build when the provided <code>pattern</code> matches one of five event types: <code>PUSH</code> , <code>PULL_REQUEST_CREATED</code> , <code>PULL_REQUEST_UPDATED</code> , <code>PULL_REQUEST_REOPENED</code> , and <code>PULL_REQUEST_MERGED</code> . The <code>EVENT</code> patterns are specified as a comma-separated string. For example, <code>PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull request created, and pull request updated events.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub Enterprise only.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>ACTOR_ACCOUNT_ID</strong> - A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket account ID matches the regular expression <code>pattern</code> .</li>
         * <li><strong>HEAD_REF</strong> - A webhook event triggers a build when the head reference matches the regular expression <code>pattern</code> . For example, <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code> .</li>
         * </ul>
         * <p>
         * Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
         * <p>
         * <ul>
         * <li><strong>BASE_REF</strong> - A webhook event triggers a build when the base reference matches the regular expression <code>pattern</code> . For example, <code>refs/heads/branch-name</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Works with pull request events only.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>FILE_PATH</strong> - A webhook triggers a build when the path of a changed file matches the regular expression <code>pattern</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>COMMIT_MESSAGE</strong> - A webhook triggers a build when the head commit message matches the regular expression <code>pattern</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Used to indicate that the `pattern` determines which webhook events do not trigger a build.
         * <p>
         * If true, then a webhook event that does not match the <code>pattern</code> triggers a build. If false, then a webhook event that matches the <code>pattern</code> triggers a build.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeMatchedPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebhookFilterProperty> {
            java.lang.String pattern;
            java.lang.String type;
            java.lang.Object excludeMatchedPattern;

            /**
             * Sets the value of {@link WebhookFilterProperty#getPattern}
             * @param pattern For a `WebHookFilter` that uses `EVENT` type, a comma-separated string that specifies one or more events. This parameter is required.
             *                For example, the webhook filter <code>PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request created, and pull request updated events to trigger a build.
             *                <p>
             *                For a <code>WebHookFilter</code> that uses any of the other filter types, a regular expression pattern. For example, a <code>WebHookFilter</code> that uses <code>HEAD_REF</code> for its <code>type</code> and the pattern <code>^refs/heads/</code> triggers a build when the head reference is a branch with a reference name <code>refs/heads/branch-name</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getType}
             * @param type The type of webhook filter. This parameter is required.
             *             There are six webhook filter types: <code>EVENT</code> , <code>ACTOR_ACCOUNT_ID</code> , <code>HEAD_REF</code> , <code>BASE_REF</code> , <code>FILE_PATH</code> , and <code>COMMIT_MESSAGE</code> .
             *             <p>
             *             <ul>
             *             <li><strong>EVENT</strong> - A webhook event triggers a build when the provided <code>pattern</code> matches one of five event types: <code>PUSH</code> , <code>PULL_REQUEST_CREATED</code> , <code>PULL_REQUEST_UPDATED</code> , <code>PULL_REQUEST_REOPENED</code> , and <code>PULL_REQUEST_MERGED</code> . The <code>EVENT</code> patterns are specified as a comma-separated string. For example, <code>PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull request created, and pull request updated events.</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub Enterprise only.
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><strong>ACTOR_ACCOUNT_ID</strong> - A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket account ID matches the regular expression <code>pattern</code> .</li>
             *             <li><strong>HEAD_REF</strong> - A webhook event triggers a build when the head reference matches the regular expression <code>pattern</code> . For example, <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code> .</li>
             *             </ul>
             *             <p>
             *             Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
             *             <p>
             *             <ul>
             *             <li><strong>BASE_REF</strong> - A webhook event triggers a build when the base reference matches the regular expression <code>pattern</code> . For example, <code>refs/heads/branch-name</code> .</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             Works with pull request events only.
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><strong>FILE_PATH</strong> - A webhook triggers a build when the path of a changed file matches the regular expression <code>pattern</code> .</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><strong>COMMIT_MESSAGE</strong> - A webhook triggers a build when the head commit message matches the regular expression <code>pattern</code> .</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             Works with GitHub and Bitbucket events push and pull requests events. Also works with GitHub Enterprise push events, but does not work with GitHub Enterprise pull request events.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getExcludeMatchedPattern}
             * @param excludeMatchedPattern Used to indicate that the `pattern` determines which webhook events do not trigger a build.
             *                              If true, then a webhook event that does not match the <code>pattern</code> triggers a build. If false, then a webhook event that matches the <code>pattern</code> triggers a build.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeMatchedPattern(java.lang.Boolean excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getExcludeMatchedPattern}
             * @param excludeMatchedPattern Used to indicate that the `pattern` determines which webhook events do not trigger a build.
             *                              If true, then a webhook event that does not match the <code>pattern</code> triggers a build. If false, then a webhook event that matches the <code>pattern</code> triggers a build.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeMatchedPattern(software.amazon.awscdk.IResolvable excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebhookFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebhookFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebhookFilterProperty {
            private final java.lang.String pattern;
            private final java.lang.String type;
            private final java.lang.Object excludeMatchedPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeMatchedPattern = software.amazon.jsii.Kernel.get(this, "excludeMatchedPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.excludeMatchedPattern = builder.excludeMatchedPattern;
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getExcludeMatchedPattern() {
                return this.excludeMatchedPattern;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getExcludeMatchedPattern() != null) {
                    data.set("excludeMatchedPattern", om.valueToTree(this.getExcludeMatchedPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnProject.WebhookFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebhookFilterProperty.Jsii$Proxy that = (WebhookFilterProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (!type.equals(that.type)) return false;
                return this.excludeMatchedPattern != null ? this.excludeMatchedPattern.equals(that.excludeMatchedPattern) : that.excludeMatchedPattern == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.excludeMatchedPattern != null ? this.excludeMatchedPattern.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.CfnProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.CfnProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.CfnProjectProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.CfnProjectProps.Builder();
        }

        /**
         * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
         * <p>
         * @return {@code this}
         * @param artifacts `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifacts(final software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }
        /**
         * `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build.
         * <p>
         * @return {@code this}
         * @param artifacts `Artifacts` is a property of the [AWS::CodeBuild::Project](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html) resource that specifies output settings for artifacts generated by an AWS CodeBuild build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifacts(final software.amazon.awscdk.IResolvable artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        /**
         * The build environment settings for the project, such as the environment type or the environment variables to use for the build environment.
         * <p>
         * @return {@code this}
         * @param environment The build environment settings for the project, such as the environment type or the environment variables to use for the build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }
        /**
         * The build environment settings for the project, such as the environment type or the environment variables to use for the build environment.
         * <p>
         * @return {@code this}
         * @param environment The build environment settings for the project, such as the environment type or the environment variables to use for the build environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         * <p>
         * @return {@code this}
         * @param serviceRole The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The source code settings for the project, such as the source code's repository type and location.
         * <p>
         * @return {@code this}
         * @param source The source code settings for the project, such as the source code's repository type and location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty source) {
            this.props.source(source);
            return this;
        }
        /**
         * The source code settings for the project, such as the source code's repository type and location.
         * <p>
         * @return {@code this}
         * @param source The source code settings for the project, such as the source code's repository type and location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.IResolvable source) {
            this.props.source(source);
            return this;
        }

        /**
         * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-badges.html">Build Badges Sample</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * Including build badges with your project is currently not supported if the source type is CodePipeline. If you specify <code>CODEPIPELINE</code> for the <code>Source</code> property, do not specify the <code>BadgeEnabled</code> property.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param badgeEnabled Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badgeEnabled(final java.lang.Boolean badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }
        /**
         * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-badges.html">Build Badges Sample</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * Including build badges with your project is currently not supported if the source type is CodePipeline. If you specify <code>CODEPIPELINE</code> for the <code>Source</code> property, do not specify the <code>BadgeEnabled</code> property.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param badgeEnabled Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badgeEnabled(final software.amazon.awscdk.IResolvable badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }

        /**
         * A `ProjectBuildBatchConfig` object that defines the batch build options for the project.
         * <p>
         * @return {@code this}
         * @param buildBatchConfig A `ProjectBuildBatchConfig` object that defines the batch build options for the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildBatchConfig(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectBuildBatchConfigProperty buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }
        /**
         * A `ProjectBuildBatchConfig` object that defines the batch build options for the project.
         * <p>
         * @return {@code this}
         * @param buildBatchConfig A `ProjectBuildBatchConfig` object that defines the batch build options for the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildBatchConfig(final software.amazon.awscdk.IResolvable buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }

        /**
         * Settings that AWS CodeBuild uses to store and reuse build dependencies.
         * <p>
         * @return {@code this}
         * @param cache Settings that AWS CodeBuild uses to store and reuse build dependencies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectCacheProperty cache) {
            this.props.cache(cache);
            return this;
        }
        /**
         * Settings that AWS CodeBuild uses to store and reuse build dependencies.
         * <p>
         * @return {@code this}
         * @param cache Settings that AWS CodeBuild uses to store and reuse build dependencies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.IResolvable cache) {
            this.props.cache(cache);
            return this;
        }

        /**
         * The maximum number of concurrent builds that are allowed for this project.
         * <p>
         * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
         * <p>
         * @return {@code this}
         * @param concurrentBuildLimit The maximum number of concurrent builds that are allowed for this project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrentBuildLimit(final java.lang.Number concurrentBuildLimit) {
            this.props.concurrentBuildLimit(concurrentBuildLimit);
            return this;
        }

        /**
         * A description that makes the build project easy to identify.
         * <p>
         * @return {@code this}
         * @param description A description that makes the build project easy to identify. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The AWS Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
         * <p>
         * <blockquote>
         * <p>
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         * <p>
         * </blockquote>
         * <p>
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/&lt;alias-name&gt;</code> ). If you don't specify a value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
         * <p>
         * @return {@code this}
         * @param encryptionKey The AWS Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final java.lang.String encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project.
         * <p>
         * A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code> , <code>location</code> , <code>mountOptions</code> , <code>mountPoint</code> , and <code>type</code> of a file system created using Amazon Elastic File System.
         * <p>
         * @return {@code this}
         * @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final software.amazon.awscdk.IResolvable fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }
        /**
         * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project.
         * <p>
         * A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code> , <code>location</code> , <code>mountOptions</code> , <code>mountPoint</code> , and <code>type</code> of a file system created using Amazon Elastic File System.
         * <p>
         * @return {@code this}
         * @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final java.util.List<? extends java.lang.Object> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        /**
         * Information about logs for the build project.
         * <p>
         * A project can create logs in CloudWatch Logs, an S3 bucket, or both.
         * <p>
         * @return {@code this}
         * @param logsConfig Information about logs for the build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logsConfig(final software.amazon.awscdk.services.codebuild.CfnProject.LogsConfigProperty logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }
        /**
         * Information about logs for the build project.
         * <p>
         * A project can create logs in CloudWatch Logs, an S3 bucket, or both.
         * <p>
         * @return {@code this}
         * @param logsConfig Information about logs for the build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logsConfig(final software.amazon.awscdk.IResolvable logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }

        /**
         * The name of the build project.
         * <p>
         * The name must be unique across all of the projects in your AWS account .
         * <p>
         * @return {@code this}
         * @param name The name of the build project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The number of minutes a build is allowed to be queued before it times out.
         * <p>
         * @return {@code this}
         * @param queuedTimeoutInMinutes The number of minutes a build is allowed to be queued before it times out. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queuedTimeoutInMinutes(final java.lang.Number queuedTimeoutInMinutes) {
            this.props.queuedTimeoutInMinutes(queuedTimeoutInMinutes);
            return this;
        }

        /**
         * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
         * <p>
         * @return {@code this}
         * @param resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceAccessRole(final java.lang.String resourceAccessRole) {
            this.props.resourceAccessRole(resourceAccessRole);
            return this;
        }

        /**
         * A list of `Artifacts` objects.
         * <p>
         * Each artifacts object specifies output settings that the project generates during a build.
         * <p>
         * @return {@code this}
         * @param secondaryArtifacts A list of `Artifacts` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryArtifacts(final software.amazon.awscdk.IResolvable secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }
        /**
         * A list of `Artifacts` objects.
         * <p>
         * Each artifacts object specifies output settings that the project generates during a build.
         * <p>
         * @return {@code this}
         * @param secondaryArtifacts A list of `Artifacts` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryArtifacts(final java.util.List<? extends java.lang.Object> secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        /**
         * An array of `ProjectSource` objects.
         * <p>
         * @return {@code this}
         * @param secondarySources An array of `ProjectSource` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySources(final software.amazon.awscdk.IResolvable secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }
        /**
         * An array of `ProjectSource` objects.
         * <p>
         * @return {@code this}
         * @param secondarySources An array of `ProjectSource` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySources(final java.util.List<? extends java.lang.Object> secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        /**
         * An array of `ProjectSourceVersion` objects.
         * <p>
         * If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * <p>
         * @return {@code this}
         * @param secondarySourceVersions An array of `ProjectSourceVersion` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySourceVersions(final software.amazon.awscdk.IResolvable secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }
        /**
         * An array of `ProjectSourceVersion` objects.
         * <p>
         * If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * <p>
         * @return {@code this}
         * @param secondarySourceVersions An array of `ProjectSourceVersion` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySourceVersions(final java.util.List<? extends java.lang.Object> secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }

        /**
         * A version of the build input to be built for this project.
         * <p>
         * If not specified, the latest version is used. If specified, it must be one of:
         * <p>
         * <ul>
         * <li>For CodeCommit: the commit ID, branch, or Git tag to use.</li>
         * <li>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code> ). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
         * <li>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</li>
         * <li>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</li>
         * </ul>
         * <p>
         * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * @return {@code this}
         * @param sourceVersion A version of the build input to be built for this project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersion(final java.lang.String sourceVersion) {
            this.props.sourceVersion(sourceVersion);
            return this;
        }

        /**
         * An arbitrary set of tags (key-value pairs) for the AWS CodeBuild project.
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * <p>
         * @return {@code this}
         * @param tags An arbitrary set of tags (key-value pairs) for the AWS CodeBuild project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any related build that did not get marked as completed.
         * <p>
         * The default is 60 minutes.
         * <p>
         * @return {@code this}
         * @param timeoutInMinutes How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any related build that did not get marked as completed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMinutes(final java.lang.Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        /**
         * For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository.
         * <p>
         * @return {@code this}
         * @param triggers For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository.
         * <p>
         * @return {@code this}
         * @param triggers For an existing AWS CodeBuild build project that has its source code stored in a GitHub repository, enables AWS CodeBuild to begin automatically rebuilding the source code every time a code change is pushed to the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * Specifies the visibility of the project's builds. Possible values are:.
         * <p>
         * <ul>
         * <li><strong>PUBLIC_READ</strong> - The project builds are visible to the public.</li>
         * <li><strong>PRIVATE</strong> - The project builds are not visible to the public.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param visibility Specifies the visibility of the project's builds. Possible values are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(final java.lang.String visibility) {
            this.props.visibility(visibility);
            return this;
        }

        /**
         * `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">Use AWS CodeBuild with Amazon Virtual Private Cloud</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * @return {@code this}
         * @param vpcConfig `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">Use AWS CodeBuild with Amazon Virtual Private Cloud</a> in the <em>AWS CodeBuild User Guide</em> .
         * <p>
         * @return {@code this}
         * @param vpcConfig `VpcConfig` specifies settings that enable AWS CodeBuild to access resources in an Amazon VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.CfnProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.CfnProject build() {
            return new software.amazon.awscdk.services.codebuild.CfnProject(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
