package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties of {@link BitBucketSourceCredentials}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BitBucketSourceCredentials.Builder.create(this, "CodeBuildBitBucketCreds")
 *         .username(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("username").build()))
 *         .password(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("password").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:05.811Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BitBucketSourceCredentialsProps")
@software.amazon.jsii.Jsii.Proxy(BitBucketSourceCredentialsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BitBucketSourceCredentialsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Your BitBucket application password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getPassword();

    /**
     * Your BitBucket username.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getUsername();

    /**
     * @return a {@link Builder} of {@link BitBucketSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BitBucketSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BitBucketSourceCredentialsProps> {
        software.amazon.awscdk.SecretValue password;
        software.amazon.awscdk.SecretValue username;

        /**
         * Sets the value of {@link BitBucketSourceCredentialsProps#getPassword}
         * @param password Your BitBucket application password. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(software.amazon.awscdk.SecretValue password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceCredentialsProps#getUsername}
         * @param username Your BitBucket username. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(software.amazon.awscdk.SecretValue username) {
            this.username = username;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BitBucketSourceCredentialsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BitBucketSourceCredentialsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BitBucketSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BitBucketSourceCredentialsProps {
        private final software.amazon.awscdk.SecretValue password;
        private final software.amazon.awscdk.SecretValue username;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
        }

        @Override
        public final software.amazon.awscdk.SecretValue getPassword() {
            return this.password;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getUsername() {
            return this.username;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("password", om.valueToTree(this.getPassword()));
            data.set("username", om.valueToTree(this.getUsername()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.BitBucketSourceCredentialsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BitBucketSourceCredentialsProps.Jsii$Proxy that = (BitBucketSourceCredentialsProps.Jsii$Proxy) o;

            if (!password.equals(that.password)) return false;
            return this.username.equals(that.username);
        }

        @Override
        public final int hashCode() {
            int result = this.password.hashCode();
            result = 31 * result + (this.username.hashCode());
            return result;
        }
    }
}
