package software.amazon.awscdk.services.cloudwatch;

/**
 * Enumeration indicates state of Alarm used in building Alarm Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * dashboard.addWidgets(AlarmStatusWidget.Builder.create()
 *         .title("Errors")
 *         .alarms(List.of(errorAlarm))
 *         .sortBy(AlarmStatusWidgetSortBy.STATE_UPDATED_TIMESTAMP)
 *         .states(List.of(AlarmState.ALARM))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:05.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.AlarmState")
public enum AlarmState {
    /**
     * State indicates resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALARM,
    /**
     * State indicates resource is not in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OK,
    /**
     * State indicates there is not enough data to determine is resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSUFFICIENT_DATA,
}
