package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Metric metric;
 * ScalableTarget scalableTarget;
 * TargetTrackingScalingPolicy targetTrackingScalingPolicy = TargetTrackingScalingPolicy.Builder.create(this, "MyTargetTrackingScalingPolicy")
 *         .scalingTarget(scalableTarget)
 *         .targetValue(123)
 *         // the properties below are optional
 *         .customMetric(metric)
 *         .disableScaleIn(false)
 *         .policyName("policyName")
 *         .predefinedMetric(PredefinedMetric.APPSTREAM_AVERAGE_CAPACITY_UTILIZATION)
 *         .resourceLabel("resourceLabel")
 *         .scaleInCooldown(Duration.minutes(30))
 *         .scaleOutCooldown(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.926Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.TargetTrackingScalingPolicy")
public class TargetTrackingScalingPolicy extends software.constructs.Construct {

    protected TargetTrackingScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TargetTrackingScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TargetTrackingScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * ARN of the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalingPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "scalingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicyProps.Builder();
        }

        /**
         * Indicates whether scale in by the target tracking policy is disabled.
         * <p>
         * If the value is true, scale in is disabled and the target tracking policy
         * won't remove capacity from the scalable resource. Otherwise, scale in is
         * enabled and the target tracking policy can remove capacity from the
         * scalable resource.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(final java.lang.Boolean disableScaleIn) {
            this.props.disableScaleIn(disableScaleIn);
            return this;
        }

        /**
         * A name for the scaling policy.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param policyName A name for the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        /**
         * Period after a scale in activity completes before another scale in activity can start.
         * <p>
         * Default: Duration.seconds(300) for the following scalable targets: ECS services,
         * Spot Fleet requests, EMR clusters, AppStream 2.0 fleets, Aurora DB clusters,
         * Amazon SageMaker endpoint variants, Custom resources. For all other scalable
         * targets, the default value is Duration.seconds(0): DynamoDB tables, DynamoDB
         * global secondary indexes, Amazon Comprehend document classification endpoints,
         * Lambda provisioned concurrency
         * <p>
         * @return {@code this}
         * @param scaleInCooldown Period after a scale in activity completes before another scale in activity can start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInCooldown(final software.amazon.awscdk.Duration scaleInCooldown) {
            this.props.scaleInCooldown(scaleInCooldown);
            return this;
        }

        /**
         * Period after a scale out activity completes before another scale out activity can start.
         * <p>
         * Default: Duration.seconds(300) for the following scalable targets: ECS services,
         * Spot Fleet requests, EMR clusters, AppStream 2.0 fleets, Aurora DB clusters,
         * Amazon SageMaker endpoint variants, Custom resources. For all other scalable
         * targets, the default value is Duration.seconds(0): DynamoDB tables, DynamoDB
         * global secondary indexes, Amazon Comprehend document classification endpoints,
         * Lambda provisioned concurrency
         * <p>
         * @return {@code this}
         * @param scaleOutCooldown Period after a scale out activity completes before another scale out activity can start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleOutCooldown(final software.amazon.awscdk.Duration scaleOutCooldown) {
            this.props.scaleOutCooldown(scaleOutCooldown);
            return this;
        }

        /**
         * The target value for the metric.
         * <p>
         * @return {@code this}
         * @param targetValue The target value for the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetValue(final java.lang.Number targetValue) {
            this.props.targetValue(targetValue);
            return this;
        }

        /**
         * A custom metric for application autoscaling.
         * <p>
         * The metric must track utilization. Scaling out will happen if the metric is higher than
         * the target value, scaling in will happen in the metric is lower than the target value.
         * <p>
         * Exactly one of customMetric or predefinedMetric must be specified.
         * <p>
         * Default: - No custom metric.
         * <p>
         * @return {@code this}
         * @param customMetric A custom metric for application autoscaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customMetric(final software.amazon.awscdk.services.cloudwatch.IMetric customMetric) {
            this.props.customMetric(customMetric);
            return this;
        }

        /**
         * A predefined metric for application autoscaling.
         * <p>
         * The metric must track utilization. Scaling out will happen if the metric is higher than
         * the target value, scaling in will happen in the metric is lower than the target value.
         * <p>
         * Exactly one of customMetric or predefinedMetric must be specified.
         * <p>
         * Default: - No predefined metrics.
         * <p>
         * @return {@code this}
         * @param predefinedMetric A predefined metric for application autoscaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predefinedMetric(final software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric) {
            this.props.predefinedMetric(predefinedMetric);
            return this;
        }

        /**
         * Identify the resource associated with the metric type.
         * <p>
         * Only used for predefined metric ALBRequestCountPerTarget.
         * <p>
         * Example value: <code>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;</code>
         * <p>
         * Default: - No resource label.
         * <p>
         * @return {@code this}
         * @param resourceLabel Identify the resource associated with the metric type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLabel(final java.lang.String resourceLabel) {
            this.props.resourceLabel(resourceLabel);
            return this;
        }

        /**
         * @return {@code this}
         * @param scalingTarget This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.props.scalingTarget(scalingTarget);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy build() {
            return new software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
