package software.amazon.awscdk.services.appflow;

/**
 * A CloudFormation `AWS::AppFlow::Flow`.
 * <p>
 * The <code>AWS::AppFlow::Flow</code> resource is an Amazon AppFlow resource type that specifies a new flow.
 * <p>
 * <blockquote>
 * <p>
 * If you want to use AWS CloudFormation to create a connector profile for connectors that implement OAuth (such as Salesforce, Slack, Zendesk, and Google Analytics), you must fetch the access and refresh tokens. You can do this by implementing your own UI for OAuth, or by retrieving the tokens from elsewhere. Alternatively, you can use the Amazon AppFlow console to create the connector profile, and then use that connector profile in the flow creation CloudFormation template.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * Object customProperties;
 * CfnFlow cfnFlow = CfnFlow.Builder.create(this, "MyCfnFlow")
 *         .destinationFlowConfigList(List.of(DestinationFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
 *                         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(customProperties)
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .redshift(RedshiftDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .s3(S3DestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         .preserveSourceDataTyping(false)
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .sapoData(SAPODataDestinationPropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .upsolver(UpsolverDestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .build())
 *                         .zendesk(ZendeskDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .build()))
 *         .flowName("flowName")
 *         .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                         .amplitude(AmplitudeSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(customProperties)
 *                                 .build())
 *                         .datadog(DatadogSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .dynatrace(DynatraceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .inforNexus(InforNexusSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .s3(S3SourcePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 // the properties below are optional
 *                                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
 *                                         .s3InputFileType("s3InputFileType")
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .enableDynamicFieldUpdate(false)
 *                                 .includeDeletedRecords(false)
 *                                 .build())
 *                         .sapoData(SAPODataSourcePropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 .build())
 *                         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .singular(SingularSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .slack(SlackSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .veeva(VeevaSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .documentType("documentType")
 *                                 .includeAllVersions(false)
 *                                 .includeRenditions(false)
 *                                 .includeSourceFiles(false)
 *                                 .build())
 *                         .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                         .datetimeTypeFieldName("datetimeTypeFieldName")
 *                         .build())
 *                 .build())
 *         .tasks(List.of(TaskProperty.builder()
 *                 .sourceFields(List.of("sourceFields"))
 *                 .taskType("taskType")
 *                 // the properties below are optional
 *                 .connectorOperator(ConnectorOperatorProperty.builder()
 *                         .amplitude("amplitude")
 *                         .customConnector("customConnector")
 *                         .datadog("datadog")
 *                         .dynatrace("dynatrace")
 *                         .googleAnalytics("googleAnalytics")
 *                         .inforNexus("inforNexus")
 *                         .marketo("marketo")
 *                         .s3("s3")
 *                         .salesforce("salesforce")
 *                         .sapoData("sapoData")
 *                         .serviceNow("serviceNow")
 *                         .singular("singular")
 *                         .slack("slack")
 *                         .trendmicro("trendmicro")
 *                         .veeva("veeva")
 *                         .zendesk("zendesk")
 *                         .build())
 *                 .destinationField("destinationField")
 *                 .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .triggerConfig(TriggerConfigProperty.builder()
 *                 .triggerType("triggerType")
 *                 // the properties below are optional
 *                 .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataPullMode("dataPullMode")
 *                         .firstExecutionFrom(123)
 *                         .flowErrorDeactivationThreshold(123)
 *                         .scheduleEndTime(123)
 *                         .scheduleOffset(123)
 *                         .scheduleStartTime(123)
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .kmsArn("kmsArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.848Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow")
public class CfnFlow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFlow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appflow.CfnFlow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppFlow::Flow`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The flow's Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags used to organize, track, or control access for your flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDestinationFlowConfigList() {
        return software.amazon.jsii.Kernel.get(this, "destinationFlowConfigList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationFlowConfigList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "destinationFlowConfigList", java.util.Objects.requireNonNull(value, "destinationFlowConfigList is required"));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationFlowConfigList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "destinationFlowConfigList", java.util.Objects.requireNonNull(value, "destinationFlowConfigList is required"));
    }

    /**
     * The specified name of the flow.
     * <p>
     * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowName() {
        return software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The specified name of the flow.
     * <p>
     * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowName", java.util.Objects.requireNonNull(value, "flowName is required"));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceFlowConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFlowConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceFlowConfig", java.util.Objects.requireNonNull(value, "sourceFlowConfig is required"));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFlowConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceFlowConfig", java.util.Objects.requireNonNull(value, "sourceFlowConfig is required"));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTasks() {
        return software.amazon.jsii.Kernel.get(this, "tasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTasks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tasks", java.util.Objects.requireNonNull(value, "tasks is required"));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTasks(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.appflow.CfnFlow.TaskProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.appflow.CfnFlow.TaskProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tasks", java.util.Objects.requireNonNull(value, "tasks is required"));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTriggerConfig() {
        return software.amazon.jsii.Kernel.get(this, "triggerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "triggerConfig", java.util.Objects.requireNonNull(value, "triggerConfig is required"));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggerConfig", java.util.Objects.requireNonNull(value, "triggerConfig is required"));
    }

    /**
     * A user-entered description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-entered description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsArn", value);
    }
    /**
     * The aggregation settings that you can use to customize the output format of your flow data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AggregationConfigProperty aggregationConfigProperty = AggregationConfigProperty.builder()
     *         .aggregationType("aggregationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.AggregationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationConfigProperty> {
            java.lang.String aggregationType;

            /**
             * Sets the value of {@link AggregationConfigProperty#getAggregationType}
             * @param aggregationType Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationType(java.lang.String aggregationType) {
                this.aggregationType = aggregationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationConfigProperty {
            private final java.lang.String aggregationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationType = software.amazon.jsii.Kernel.get(this, "aggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationType = builder.aggregationType;
            }

            @Override
            public final java.lang.String getAggregationType() {
                return this.aggregationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregationType() != null) {
                    data.set("aggregationType", om.valueToTree(this.getAggregationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.AggregationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationConfigProperty.Jsii$Proxy that = (AggregationConfigProperty.Jsii$Proxy) o;

                return this.aggregationType != null ? this.aggregationType.equals(that.aggregationType) : that.aggregationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationType != null ? this.aggregationType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amplitude is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AmplitudeSourcePropertiesProperty amplitudeSourcePropertiesProperty = AmplitudeSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.AmplitudeSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AmplitudeSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmplitudeSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amplitude flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmplitudeSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link AmplitudeSourcePropertiesProperty#getObject}
             * @param object The object specified in the Amplitude flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmplitudeSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmplitudeSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmplitudeSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.AmplitudeSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmplitudeSourcePropertiesProperty.Jsii$Proxy that = (AmplitudeSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The operation to be performed on the provided source fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorOperatorProperty connectorOperatorProperty = ConnectorOperatorProperty.builder()
     *         .amplitude("amplitude")
     *         .customConnector("customConnector")
     *         .datadog("datadog")
     *         .dynatrace("dynatrace")
     *         .googleAnalytics("googleAnalytics")
     *         .inforNexus("inforNexus")
     *         .marketo("marketo")
     *         .s3("s3")
     *         .salesforce("salesforce")
     *         .sapoData("sapoData")
     *         .serviceNow("serviceNow")
     *         .singular("singular")
     *         .slack("slack")
     *         .trendmicro("trendmicro")
     *         .veeva("veeva")
     *         .zendesk("zendesk")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ConnectorOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operation to be performed on the provided Amplitude source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAmplitude() {
            return null;
        }

        /**
         * `CfnFlow.ConnectorOperatorProperty.CustomConnector`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomConnector() {
            return null;
        }

        /**
         * The operation to be performed on the provided Datadog source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatadog() {
            return null;
        }

        /**
         * The operation to be performed on the provided Dynatrace source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDynatrace() {
            return null;
        }

        /**
         * The operation to be performed on the provided Google Analytics source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGoogleAnalytics() {
            return null;
        }

        /**
         * The operation to be performed on the provided Infor Nexus source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInforNexus() {
            return null;
        }

        /**
         * The operation to be performed on the provided Marketo source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarketo() {
            return null;
        }

        /**
         * The operation to be performed on the provided Amazon S3 source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3() {
            return null;
        }

        /**
         * The operation to be performed on the provided Salesforce source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSalesforce() {
            return null;
        }

        /**
         * The operation to be performed on the provided SAPOData source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSapoData() {
            return null;
        }

        /**
         * The operation to be performed on the provided ServiceNow source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceNow() {
            return null;
        }

        /**
         * The operation to be performed on the provided Singular source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSingular() {
            return null;
        }

        /**
         * The operation to be performed on the provided Slack source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlack() {
            return null;
        }

        /**
         * The operation to be performed on the provided Trend Micro source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrendmicro() {
            return null;
        }

        /**
         * The operation to be performed on the provided Veeva source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVeeva() {
            return null;
        }

        /**
         * The operation to be performed on the provided Zendesk source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorOperatorProperty> {
            java.lang.String amplitude;
            java.lang.String customConnector;
            java.lang.String datadog;
            java.lang.String dynatrace;
            java.lang.String googleAnalytics;
            java.lang.String inforNexus;
            java.lang.String marketo;
            java.lang.String s3;
            java.lang.String salesforce;
            java.lang.String sapoData;
            java.lang.String serviceNow;
            java.lang.String singular;
            java.lang.String slack;
            java.lang.String trendmicro;
            java.lang.String veeva;
            java.lang.String zendesk;

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getAmplitude}
             * @param amplitude The operation to be performed on the provided Amplitude source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(java.lang.String amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getCustomConnector}
             * @param customConnector `CfnFlow.ConnectorOperatorProperty.CustomConnector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(java.lang.String customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getDatadog}
             * @param datadog The operation to be performed on the provided Datadog source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(java.lang.String datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getDynatrace}
             * @param dynatrace The operation to be performed on the provided Dynatrace source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(java.lang.String dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getGoogleAnalytics}
             * @param googleAnalytics The operation to be performed on the provided Google Analytics source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(java.lang.String googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getInforNexus}
             * @param inforNexus The operation to be performed on the provided Infor Nexus source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(java.lang.String inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getMarketo}
             * @param marketo The operation to be performed on the provided Marketo source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(java.lang.String marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getS3}
             * @param s3 The operation to be performed on the provided Amazon S3 source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(java.lang.String s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSalesforce}
             * @param salesforce The operation to be performed on the provided Salesforce source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(java.lang.String salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSapoData}
             * @param sapoData The operation to be performed on the provided SAPOData source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(java.lang.String sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getServiceNow}
             * @param serviceNow The operation to be performed on the provided ServiceNow source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(java.lang.String serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSingular}
             * @param singular The operation to be performed on the provided Singular source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(java.lang.String singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSlack}
             * @param slack The operation to be performed on the provided Slack source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(java.lang.String slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getTrendmicro}
             * @param trendmicro The operation to be performed on the provided Trend Micro source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(java.lang.String trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getVeeva}
             * @param veeva The operation to be performed on the provided Veeva source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(java.lang.String veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getZendesk}
             * @param zendesk The operation to be performed on the provided Zendesk source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(java.lang.String zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorOperatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorOperatorProperty {
            private final java.lang.String amplitude;
            private final java.lang.String customConnector;
            private final java.lang.String datadog;
            private final java.lang.String dynatrace;
            private final java.lang.String googleAnalytics;
            private final java.lang.String inforNexus;
            private final java.lang.String marketo;
            private final java.lang.String s3;
            private final java.lang.String salesforce;
            private final java.lang.String sapoData;
            private final java.lang.String serviceNow;
            private final java.lang.String singular;
            private final java.lang.String slack;
            private final java.lang.String trendmicro;
            private final java.lang.String veeva;
            private final java.lang.String zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.String getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.String getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.String getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.String getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.String getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.String getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.String getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.String getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.String getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.String getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.String getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.String getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.String getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.String getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.String getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.String getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ConnectorOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorOperatorProperty.Jsii$Proxy that = (ConnectorOperatorProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.customConnector != null ? this.customConnector.hashCode() : 0);
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * CustomConnectorDestinationPropertiesProperty customConnectorDestinationPropertiesProperty = CustomConnectorDestinationPropertiesProperty.builder()
     *         .entityName("entityName")
     *         // the properties below are optional
     *         .customProperties(customProperties)
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFlow.CustomConnectorDestinationPropertiesProperty.EntityName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

        /**
         * `CfnFlow.CustomConnectorDestinationPropertiesProperty.CustomProperties`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomProperties() {
            return null;
        }

        /**
         * `CfnFlow.CustomConnectorDestinationPropertiesProperty.ErrorHandlingConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * `CfnFlow.CustomConnectorDestinationPropertiesProperty.IdFieldNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * `CfnFlow.CustomConnectorDestinationPropertiesProperty.WriteOperationType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorDestinationPropertiesProperty> {
            java.lang.String entityName;
            java.lang.Object customProperties;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getEntityName}
             * @param entityName `CfnFlow.CustomConnectorDestinationPropertiesProperty.EntityName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityName(java.lang.String entityName) {
                this.entityName = entityName;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getCustomProperties}
             * @param customProperties `CfnFlow.CustomConnectorDestinationPropertiesProperty.CustomProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(java.lang.Object customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig `CfnFlow.CustomConnectorDestinationPropertiesProperty.ErrorHandlingConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig `CfnFlow.CustomConnectorDestinationPropertiesProperty.ErrorHandlingConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames `CfnFlow.CustomConnectorDestinationPropertiesProperty.IdFieldNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType `CfnFlow.CustomConnectorDestinationPropertiesProperty.WriteOperationType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorDestinationPropertiesProperty {
            private final java.lang.String entityName;
            private final java.lang.Object customProperties;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customProperties = software.amazon.jsii.Kernel.get(this, "customProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
                this.customProperties = builder.customProperties;
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getEntityName() {
                return this.entityName;
            }

            @Override
            public final java.lang.Object getCustomProperties() {
                return this.customProperties;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityName", om.valueToTree(this.getEntityName()));
                if (this.getCustomProperties() != null) {
                    data.set("customProperties", om.valueToTree(this.getCustomProperties()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorDestinationPropertiesProperty.Jsii$Proxy that = (CustomConnectorDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!entityName.equals(that.entityName)) return false;
                if (this.customProperties != null ? !this.customProperties.equals(that.customProperties) : that.customProperties != null) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityName.hashCode();
                result = 31 * result + (this.customProperties != null ? this.customProperties.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * CustomConnectorSourcePropertiesProperty customConnectorSourcePropertiesProperty = CustomConnectorSourcePropertiesProperty.builder()
     *         .entityName("entityName")
     *         // the properties below are optional
     *         .customProperties(customProperties)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFlow.CustomConnectorSourcePropertiesProperty.EntityName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

        /**
         * `CfnFlow.CustomConnectorSourcePropertiesProperty.CustomProperties`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorSourcePropertiesProperty> {
            java.lang.String entityName;
            java.lang.Object customProperties;

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getEntityName}
             * @param entityName `CfnFlow.CustomConnectorSourcePropertiesProperty.EntityName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityName(java.lang.String entityName) {
                this.entityName = entityName;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getCustomProperties}
             * @param customProperties `CfnFlow.CustomConnectorSourcePropertiesProperty.CustomProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(java.lang.Object customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorSourcePropertiesProperty {
            private final java.lang.String entityName;
            private final java.lang.Object customProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customProperties = software.amazon.jsii.Kernel.get(this, "customProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
                this.customProperties = builder.customProperties;
            }

            @Override
            public final java.lang.String getEntityName() {
                return this.entityName;
            }

            @Override
            public final java.lang.Object getCustomProperties() {
                return this.customProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityName", om.valueToTree(this.getEntityName()));
                if (this.getCustomProperties() != null) {
                    data.set("customProperties", om.valueToTree(this.getCustomProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorSourcePropertiesProperty.Jsii$Proxy that = (CustomConnectorSourcePropertiesProperty.Jsii$Proxy) o;

                if (!entityName.equals(that.entityName)) return false;
                return this.customProperties != null ? this.customProperties.equals(that.customProperties) : that.customProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityName.hashCode();
                result = 31 * result + (this.customProperties != null ? this.customProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Datadog is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogSourcePropertiesProperty datadogSourcePropertiesProperty = DatadogSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DatadogSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Datadog flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link DatadogSourcePropertiesProperty#getObject}
             * @param object The object specified in the Datadog flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DatadogSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogSourcePropertiesProperty.Jsii$Proxy that = (DatadogSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * This stores the information that is required to query a particular connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * DestinationConnectorPropertiesProperty destinationConnectorPropertiesProperty = DestinationConnectorPropertiesProperty.builder()
     *         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
     *                 .entityName("entityName")
     *                 // the properties below are optional
     *                 .customProperties(customProperties)
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .marketo(MarketoDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .redshift(RedshiftDestinationPropertiesProperty.builder()
     *                 .intermediateBucketName("intermediateBucketName")
     *                 .object("object")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .s3(S3DestinationPropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                         .aggregationConfig(AggregationConfigProperty.builder()
     *                                 .aggregationType("aggregationType")
     *                                 .build())
     *                         .fileType("fileType")
     *                         .prefixConfig(PrefixConfigProperty.builder()
     *                                 .prefixFormat("prefixFormat")
     *                                 .prefixType("prefixType")
     *                                 .build())
     *                         .preserveSourceDataTyping(false)
     *                         .build())
     *                 .build())
     *         .salesforce(SalesforceDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .sapoData(SAPODataDestinationPropertiesProperty.builder()
     *                 .objectPath("objectPath")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
     *                 .intermediateBucketName("intermediateBucketName")
     *                 .object("object")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .upsolver(UpsolverDestinationPropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                         .prefixConfig(PrefixConfigProperty.builder()
     *                                 .prefixFormat("prefixFormat")
     *                                 .prefixType("prefixType")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationConfig(AggregationConfigProperty.builder()
     *                                 .aggregationType("aggregationType")
     *                                 .build())
     *                         .fileType("fileType")
     *                         .build())
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .zendesk(ZendeskDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DestinationConnectorPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConnectorPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConnectorPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFlow.DestinationConnectorPropertiesProperty.CustomConnector`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * The properties required to query Amazon EventBridge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridge() {
            return null;
        }

        /**
         * The properties required to query Amazon Lookout for Metrics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLookoutMetrics() {
            return null;
        }

        /**
         * The properties required to query Marketo.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The properties required to query Amazon Redshift.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The properties required to query Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * The properties required to query Salesforce.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The properties required to query SAPOData.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The properties required to query Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The properties required to query Upsolver.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpsolver() {
            return null;
        }

        /**
         * The properties required to query Zendesk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConnectorPropertiesProperty> {
            java.lang.Object customConnector;
            java.lang.Object eventBridge;
            java.lang.Object lookoutMetrics;
            java.lang.Object marketo;
            java.lang.Object redshift;
            java.lang.Object s3;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object snowflake;
            java.lang.Object upsolver;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector `CfnFlow.DestinationConnectorPropertiesProperty.CustomConnector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector `CfnFlow.DestinationConnectorPropertiesProperty.CustomConnector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getEventBridge}
             * @param eventBridge The properties required to query Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridge(software.amazon.awscdk.services.appflow.CfnFlow.EventBridgeDestinationPropertiesProperty eventBridge) {
                this.eventBridge = eventBridge;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getEventBridge}
             * @param eventBridge The properties required to query Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridge(software.amazon.awscdk.IResolvable eventBridge) {
                this.eventBridge = eventBridge;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getLookoutMetrics}
             * @param lookoutMetrics The properties required to query Amazon Lookout for Metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookoutMetrics(software.amazon.awscdk.services.appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty lookoutMetrics) {
                this.lookoutMetrics = lookoutMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getLookoutMetrics}
             * @param lookoutMetrics The properties required to query Amazon Lookout for Metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookoutMetrics(software.amazon.awscdk.IResolvable lookoutMetrics) {
                this.lookoutMetrics = lookoutMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties required to query Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnFlow.MarketoDestinationPropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties required to query Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getRedshift}
             * @param redshift The properties required to query Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnFlow.RedshiftDestinationPropertiesProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getRedshift}
             * @param redshift The properties required to query Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getS3}
             * @param s3 The properties required to query Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.appflow.CfnFlow.S3DestinationPropertiesProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getS3}
             * @param s3 The properties required to query Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties required to query Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnFlow.SalesforceDestinationPropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties required to query Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties required to query SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataDestinationPropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties required to query SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSnowflake}
             * @param snowflake The properties required to query Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnFlow.SnowflakeDestinationPropertiesProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSnowflake}
             * @param snowflake The properties required to query Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getUpsolver}
             * @param upsolver The properties required to query Upsolver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upsolver(software.amazon.awscdk.services.appflow.CfnFlow.UpsolverDestinationPropertiesProperty upsolver) {
                this.upsolver = upsolver;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getUpsolver}
             * @param upsolver The properties required to query Upsolver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upsolver(software.amazon.awscdk.IResolvable upsolver) {
                this.upsolver = upsolver;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties required to query Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnFlow.ZendeskDestinationPropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties required to query Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConnectorPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConnectorPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConnectorPropertiesProperty {
            private final java.lang.Object customConnector;
            private final java.lang.Object eventBridge;
            private final java.lang.Object lookoutMetrics;
            private final java.lang.Object marketo;
            private final java.lang.Object redshift;
            private final java.lang.Object s3;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object snowflake;
            private final java.lang.Object upsolver;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridge = software.amazon.jsii.Kernel.get(this, "eventBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lookoutMetrics = software.amazon.jsii.Kernel.get(this, "lookoutMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.upsolver = software.amazon.jsii.Kernel.get(this, "upsolver", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customConnector = builder.customConnector;
                this.eventBridge = builder.eventBridge;
                this.lookoutMetrics = builder.lookoutMetrics;
                this.marketo = builder.marketo;
                this.redshift = builder.redshift;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.snowflake = builder.snowflake;
                this.upsolver = builder.upsolver;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getEventBridge() {
                return this.eventBridge;
            }

            @Override
            public final java.lang.Object getLookoutMetrics() {
                return this.lookoutMetrics;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getUpsolver() {
                return this.upsolver;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getEventBridge() != null) {
                    data.set("eventBridge", om.valueToTree(this.getEventBridge()));
                }
                if (this.getLookoutMetrics() != null) {
                    data.set("lookoutMetrics", om.valueToTree(this.getLookoutMetrics()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getUpsolver() != null) {
                    data.set("upsolver", om.valueToTree(this.getUpsolver()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DestinationConnectorPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConnectorPropertiesProperty.Jsii$Proxy that = (DestinationConnectorPropertiesProperty.Jsii$Proxy) o;

                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.eventBridge != null ? !this.eventBridge.equals(that.eventBridge) : that.eventBridge != null) return false;
                if (this.lookoutMetrics != null ? !this.lookoutMetrics.equals(that.lookoutMetrics) : that.lookoutMetrics != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.upsolver != null ? !this.upsolver.equals(that.upsolver) : that.upsolver != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customConnector != null ? this.customConnector.hashCode() : 0;
                result = 31 * result + (this.eventBridge != null ? this.eventBridge.hashCode() : 0);
                result = 31 * result + (this.lookoutMetrics != null ? this.lookoutMetrics.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.upsolver != null ? this.upsolver.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the configuration of destination connectors present in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * DestinationFlowConfigProperty destinationFlowConfigProperty = DestinationFlowConfigProperty.builder()
     *         .connectorType("connectorType")
     *         .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
     *                 .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
     *                         .entityName("entityName")
     *                         // the properties below are optional
     *                         .customProperties(customProperties)
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .marketo(MarketoDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .redshift(RedshiftDestinationPropertiesProperty.builder()
     *                         .intermediateBucketName("intermediateBucketName")
     *                         .object("object")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .s3(S3DestinationPropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                                 .aggregationConfig(AggregationConfigProperty.builder()
     *                                         .aggregationType("aggregationType")
     *                                         .build())
     *                                 .fileType("fileType")
     *                                 .prefixConfig(PrefixConfigProperty.builder()
     *                                         .prefixFormat("prefixFormat")
     *                                         .prefixType("prefixType")
     *                                         .build())
     *                                 .preserveSourceDataTyping(false)
     *                                 .build())
     *                         .build())
     *                 .salesforce(SalesforceDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .sapoData(SAPODataDestinationPropertiesProperty.builder()
     *                         .objectPath("objectPath")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .build())
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .snowflake(SnowflakeDestinationPropertiesProperty.builder()
     *                         .intermediateBucketName("intermediateBucketName")
     *                         .object("object")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .upsolver(UpsolverDestinationPropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                                 .prefixConfig(PrefixConfigProperty.builder()
     *                                         .prefixFormat("prefixFormat")
     *                                         .prefixType("prefixType")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .aggregationConfig(AggregationConfigProperty.builder()
     *                                         .aggregationType("aggregationType")
     *                                         .build())
     *                                 .fileType("fileType")
     *                                 .build())
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .zendesk(ZendeskDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .apiVersion("apiVersion")
     *         .connectorProfileName("connectorProfileName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DestinationFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of destination connector, such as Sales force, Amazon S3, and so on.
         * <p>
         * <em>Allowed Values</em> : <code>EventBridge | Redshift | S3 | Salesforce | Snowflake</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

        /**
         * This stores the information that is required to query a particular connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationConnectorProperties();

        /**
         * `CfnFlow.DestinationFlowConfigProperty.ApiVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
            return null;
        }

        /**
         * The name of the connector profile.
         * <p>
         * This name must be unique for each connector profile in the AWS account .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorProfileName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationFlowConfigProperty> {
            java.lang.String connectorType;
            java.lang.Object destinationConnectorProperties;
            java.lang.String apiVersion;
            java.lang.String connectorProfileName;

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getConnectorType}
             * @param connectorType The type of destination connector, such as Sales force, Amazon S3, and so on. This parameter is required.
             *                      <em>Allowed Values</em> : <code>EventBridge | Redshift | S3 | Salesforce | Snowflake</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorType(java.lang.String connectorType) {
                this.connectorType = connectorType;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getDestinationConnectorProperties}
             * @param destinationConnectorProperties This stores the information that is required to query a particular connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConnectorProperties(software.amazon.awscdk.services.appflow.CfnFlow.DestinationConnectorPropertiesProperty destinationConnectorProperties) {
                this.destinationConnectorProperties = destinationConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getDestinationConnectorProperties}
             * @param destinationConnectorProperties This stores the information that is required to query a particular connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConnectorProperties(software.amazon.awscdk.IResolvable destinationConnectorProperties) {
                this.destinationConnectorProperties = destinationConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getApiVersion}
             * @param apiVersion `CfnFlow.DestinationFlowConfigProperty.ApiVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiVersion(java.lang.String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getConnectorProfileName}
             * @param connectorProfileName The name of the connector profile.
             *                             This name must be unique for each connector profile in the AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileName(java.lang.String connectorProfileName) {
                this.connectorProfileName = connectorProfileName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationFlowConfigProperty {
            private final java.lang.String connectorType;
            private final java.lang.Object destinationConnectorProperties;
            private final java.lang.String apiVersion;
            private final java.lang.String connectorProfileName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationConnectorProperties = software.amazon.jsii.Kernel.get(this, "destinationConnectorProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
                this.destinationConnectorProperties = java.util.Objects.requireNonNull(builder.destinationConnectorProperties, "destinationConnectorProperties is required");
                this.apiVersion = builder.apiVersion;
                this.connectorProfileName = builder.connectorProfileName;
            }

            @Override
            public final java.lang.String getConnectorType() {
                return this.connectorType;
            }

            @Override
            public final java.lang.Object getDestinationConnectorProperties() {
                return this.destinationConnectorProperties;
            }

            @Override
            public final java.lang.String getApiVersion() {
                return this.apiVersion;
            }

            @Override
            public final java.lang.String getConnectorProfileName() {
                return this.connectorProfileName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorType", om.valueToTree(this.getConnectorType()));
                data.set("destinationConnectorProperties", om.valueToTree(this.getDestinationConnectorProperties()));
                if (this.getApiVersion() != null) {
                    data.set("apiVersion", om.valueToTree(this.getApiVersion()));
                }
                if (this.getConnectorProfileName() != null) {
                    data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DestinationFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationFlowConfigProperty.Jsii$Proxy that = (DestinationFlowConfigProperty.Jsii$Proxy) o;

                if (!connectorType.equals(that.connectorType)) return false;
                if (!destinationConnectorProperties.equals(that.destinationConnectorProperties)) return false;
                if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
                return this.connectorProfileName != null ? this.connectorProfileName.equals(that.connectorProfileName) : that.connectorProfileName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorType.hashCode();
                result = 31 * result + (this.destinationConnectorProperties.hashCode());
                result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
                result = 31 * result + (this.connectorProfileName != null ? this.connectorProfileName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Dynatrace is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceSourcePropertiesProperty dynatraceSourcePropertiesProperty = DynatraceSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DynatraceSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Dynatrace flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link DynatraceSourcePropertiesProperty#getObject}
             * @param object The object specified in the Dynatrace flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DynatraceSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceSourcePropertiesProperty.Jsii$Proxy that = (DynatraceSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
     * <p>
     * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ErrorHandlingConfigProperty errorHandlingConfigProperty = ErrorHandlingConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         .failOnFirstError(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ErrorHandlingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ErrorHandlingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ErrorHandlingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the name of the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * Specifies the Amazon S3 bucket prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnFirstError() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ErrorHandlingConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object failOnFirstError;

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getBucketName}
             * @param bucketName Specifies the name of the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getBucketPrefix}
             * @param bucketPrefix Specifies the Amazon S3 bucket prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getFailOnFirstError}
             * @param failOnFirstError Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failOnFirstError(java.lang.Boolean failOnFirstError) {
                this.failOnFirstError = failOnFirstError;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getFailOnFirstError}
             * @param failOnFirstError Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failOnFirstError(software.amazon.awscdk.IResolvable failOnFirstError) {
                this.failOnFirstError = failOnFirstError;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ErrorHandlingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ErrorHandlingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorHandlingConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object failOnFirstError;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failOnFirstError = software.amazon.jsii.Kernel.get(this, "failOnFirstError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = builder.bucketName;
                this.bucketPrefix = builder.bucketPrefix;
                this.failOnFirstError = builder.failOnFirstError;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getFailOnFirstError() {
                return this.failOnFirstError;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getFailOnFirstError() != null) {
                    data.set("failOnFirstError", om.valueToTree(this.getFailOnFirstError()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ErrorHandlingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ErrorHandlingConfigProperty.Jsii$Proxy that = (ErrorHandlingConfigProperty.Jsii$Proxy) o;

                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.failOnFirstError != null ? this.failOnFirstError.equals(that.failOnFirstError) : that.failOnFirstError == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.failOnFirstError != null ? this.failOnFirstError.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon EventBridge is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * EventBridgeDestinationPropertiesProperty eventBridgeDestinationPropertiesProperty = EventBridgeDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.EventBridgeDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amazon EventBridge flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object specified in the Amplitude flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon EventBridge flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The object specified in the Amplitude flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The object specified in the Amplitude flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.EventBridgeDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeDestinationPropertiesProperty.Jsii$Proxy that = (EventBridgeDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Google Analytics is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * GoogleAnalyticsSourcePropertiesProperty googleAnalyticsSourcePropertiesProperty = GoogleAnalyticsSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoogleAnalyticsSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Google Analytics flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoogleAnalyticsSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link GoogleAnalyticsSourcePropertiesProperty#getObject}
             * @param object The object specified in the Google Analytics flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoogleAnalyticsSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoogleAnalyticsSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoogleAnalyticsSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy that = (GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration used when importing incremental records from the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * IncrementalPullConfigProperty incrementalPullConfigProperty = IncrementalPullConfigProperty.builder()
     *         .datetimeTypeFieldName("datetimeTypeFieldName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.IncrementalPullConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalPullConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalPullConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatetimeTypeFieldName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalPullConfigProperty> {
            java.lang.String datetimeTypeFieldName;

            /**
             * Sets the value of {@link IncrementalPullConfigProperty#getDatetimeTypeFieldName}
             * @param datetimeTypeFieldName A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datetimeTypeFieldName(java.lang.String datetimeTypeFieldName) {
                this.datetimeTypeFieldName = datetimeTypeFieldName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalPullConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalPullConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalPullConfigProperty {
            private final java.lang.String datetimeTypeFieldName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datetimeTypeFieldName = software.amazon.jsii.Kernel.get(this, "datetimeTypeFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datetimeTypeFieldName = builder.datetimeTypeFieldName;
            }

            @Override
            public final java.lang.String getDatetimeTypeFieldName() {
                return this.datetimeTypeFieldName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatetimeTypeFieldName() != null) {
                    data.set("datetimeTypeFieldName", om.valueToTree(this.getDatetimeTypeFieldName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.IncrementalPullConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalPullConfigProperty.Jsii$Proxy that = (IncrementalPullConfigProperty.Jsii$Proxy) o;

                return this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.equals(that.datetimeTypeFieldName) : that.datetimeTypeFieldName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Infor Nexus is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusSourcePropertiesProperty inforNexusSourcePropertiesProperty = InforNexusSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.InforNexusSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Infor Nexus flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link InforNexusSourcePropertiesProperty#getObject}
             * @param object The object specified in the Infor Nexus flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.InforNexusSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusSourcePropertiesProperty.Jsii$Proxy that = (InforNexusSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon Lookout for Metrics is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * LookoutMetricsDestinationPropertiesProperty lookoutMetricsDestinationPropertiesProperty = LookoutMetricsDestinationPropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LookoutMetricsDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amazon Lookout for Metrics flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObject() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LookoutMetricsDestinationPropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link LookoutMetricsDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon Lookout for Metrics flow destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LookoutMetricsDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LookoutMetricsDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LookoutMetricsDestinationPropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = builder.object;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getObject() != null) {
                    data.set("object", om.valueToTree(this.getObject()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy that = (LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy) o;

                return this.object != null ? this.object.equals(that.object) : that.object == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object != null ? this.object.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that Amazon AppFlow applies when you use Marketo as a flow destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoDestinationPropertiesProperty marketoDestinationPropertiesProperty = MarketoDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.MarketoDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Marketo flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Marketo flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.MarketoDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoDestinationPropertiesProperty.Jsii$Proxy that = (MarketoDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Marketo is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoSourcePropertiesProperty marketoSourcePropertiesProperty = MarketoSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.MarketoSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Marketo flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link MarketoSourcePropertiesProperty#getObject}
             * @param object The object specified in the Marketo flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.MarketoSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoSourcePropertiesProperty.Jsii$Proxy that = (MarketoSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Determines the prefix that Amazon AppFlow applies to the destination folder name.
     * <p>
     * You can name your destination folders according to the flow frequency and date.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * PrefixConfigProperty prefixConfigProperty = PrefixConfigProperty.builder()
     *         .prefixFormat("prefixFormat")
     *         .prefixType("prefixType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.PrefixConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PrefixConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrefixConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the level of granularity that's included in the prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixFormat() {
            return null;
        }

        /**
         * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrefixConfigProperty> {
            java.lang.String prefixFormat;
            java.lang.String prefixType;

            /**
             * Sets the value of {@link PrefixConfigProperty#getPrefixFormat}
             * @param prefixFormat Determines the level of granularity that's included in the prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixFormat(java.lang.String prefixFormat) {
                this.prefixFormat = prefixFormat;
                return this;
            }

            /**
             * Sets the value of {@link PrefixConfigProperty#getPrefixType}
             * @param prefixType Determines the format of the prefix, and whether it applies to the file name, file path, or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixType(java.lang.String prefixType) {
                this.prefixType = prefixType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrefixConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrefixConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixConfigProperty {
            private final java.lang.String prefixFormat;
            private final java.lang.String prefixType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefixFormat = software.amazon.jsii.Kernel.get(this, "prefixFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefixType = software.amazon.jsii.Kernel.get(this, "prefixType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefixFormat = builder.prefixFormat;
                this.prefixType = builder.prefixType;
            }

            @Override
            public final java.lang.String getPrefixFormat() {
                return this.prefixFormat;
            }

            @Override
            public final java.lang.String getPrefixType() {
                return this.prefixType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrefixFormat() != null) {
                    data.set("prefixFormat", om.valueToTree(this.getPrefixFormat()));
                }
                if (this.getPrefixType() != null) {
                    data.set("prefixType", om.valueToTree(this.getPrefixType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.PrefixConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrefixConfigProperty.Jsii$Proxy that = (PrefixConfigProperty.Jsii$Proxy) o;

                if (this.prefixFormat != null ? !this.prefixFormat.equals(that.prefixFormat) : that.prefixFormat != null) return false;
                return this.prefixType != null ? this.prefixType.equals(that.prefixType) : that.prefixType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefixFormat != null ? this.prefixFormat.hashCode() : 0;
                result = 31 * result + (this.prefixType != null ? this.prefixType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon Redshift is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftDestinationPropertiesProperty redshiftDestinationPropertiesProperty = RedshiftDestinationPropertiesProperty.builder()
     *         .intermediateBucketName("intermediateBucketName")
     *         .object("object")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.RedshiftDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateBucketName();

        /**
         * The object specified in the Amazon Redshift flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object key for the bucket in which Amazon AppFlow places the destination files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDestinationPropertiesProperty> {
            java.lang.String intermediateBucketName;
            java.lang.String object;
            java.lang.String bucketPrefix;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getIntermediateBucketName}
             * @param intermediateBucketName The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateBucketName(java.lang.String intermediateBucketName) {
                this.intermediateBucketName = intermediateBucketName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon Redshift flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the bucket in which Amazon AppFlow places the destination files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDestinationPropertiesProperty {
            private final java.lang.String intermediateBucketName;
            private final java.lang.String object;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateBucketName = software.amazon.jsii.Kernel.get(this, "intermediateBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateBucketName = java.util.Objects.requireNonNull(builder.intermediateBucketName, "intermediateBucketName is required");
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getIntermediateBucketName() {
                return this.intermediateBucketName;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateBucketName", om.valueToTree(this.getIntermediateBucketName()));
                data.set("object", om.valueToTree(this.getObject()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.RedshiftDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDestinationPropertiesProperty.Jsii$Proxy that = (RedshiftDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!intermediateBucketName.equals(that.intermediateBucketName)) return false;
                if (!object.equals(that.object)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateBucketName.hashCode();
                result = 31 * result + (this.object.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon S3 is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3DestinationPropertiesProperty s3DestinationPropertiesProperty = S3DestinationPropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                 .aggregationConfig(AggregationConfigProperty.builder()
     *                         .aggregationType("aggregationType")
     *                         .build())
     *                 .fileType("fileType")
     *                 .prefixConfig(PrefixConfigProperty.builder()
     *                         .prefixFormat("prefixFormat")
     *                         .prefixType("prefixType")
     *                         .build())
     *                 .preserveSourceDataTyping(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3DestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3OutputFormatConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationPropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object s3OutputFormatConfig;

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.S3OutputFormatConfigProperty s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.IResolvable s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationPropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object s3OutputFormatConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3OutputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.s3OutputFormatConfig = builder.s3OutputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getS3OutputFormatConfig() {
                return this.s3OutputFormatConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getS3OutputFormatConfig() != null) {
                    data.set("s3OutputFormatConfig", om.valueToTree(this.getS3OutputFormatConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3DestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationPropertiesProperty.Jsii$Proxy that = (S3DestinationPropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.s3OutputFormatConfig != null ? this.s3OutputFormatConfig.equals(that.s3OutputFormatConfig) : that.s3OutputFormatConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.s3OutputFormatConfig != null ? this.s3OutputFormatConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3InputFormatConfigProperty s3InputFormatConfigProperty = S3InputFormatConfigProperty.builder()
     *         .s3InputFileType("s3InputFileType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3InputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3InputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3InputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputFileType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3InputFormatConfigProperty> {
            java.lang.String s3InputFileType;

            /**
             * Sets the value of {@link S3InputFormatConfigProperty#getS3InputFileType}
             * @param s3InputFileType The file type that Amazon AppFlow gets from your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFileType(java.lang.String s3InputFileType) {
                this.s3InputFileType = s3InputFileType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3InputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3InputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3InputFormatConfigProperty {
            private final java.lang.String s3InputFileType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3InputFileType = software.amazon.jsii.Kernel.get(this, "s3InputFileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3InputFileType = builder.s3InputFileType;
            }

            @Override
            public final java.lang.String getS3InputFileType() {
                return this.s3InputFileType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3InputFileType() != null) {
                    data.set("s3InputFileType", om.valueToTree(this.getS3InputFileType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3InputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3InputFormatConfigProperty.Jsii$Proxy that = (S3InputFormatConfigProperty.Jsii$Proxy) o;

                return this.s3InputFileType != null ? this.s3InputFileType.equals(that.s3InputFileType) : that.s3InputFileType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3InputFileType != null ? this.s3InputFileType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3OutputFormatConfigProperty s3OutputFormatConfigProperty = S3OutputFormatConfigProperty.builder()
     *         .aggregationConfig(AggregationConfigProperty.builder()
     *                 .aggregationType("aggregationType")
     *                 .build())
     *         .fileType("fileType")
     *         .prefixConfig(PrefixConfigProperty.builder()
     *                 .prefixFormat("prefixFormat")
     *                 .prefixType("prefixType")
     *                 .build())
     *         .preserveSourceDataTyping(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3OutputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregation settings that you can use to customize the output format of your flow data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationConfig() {
            return null;
        }

        /**
         * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileType() {
            return null;
        }

        /**
         * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
         * <p>
         * You can name folders according to the flow frequency and date.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrefixConfig() {
            return null;
        }

        /**
         * `CfnFlow.S3OutputFormatConfigProperty.PreserveSourceDataTyping`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreserveSourceDataTyping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputFormatConfigProperty> {
            java.lang.Object aggregationConfig;
            java.lang.String fileType;
            java.lang.Object prefixConfig;
            java.lang.Object preserveSourceDataTyping;

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.services.appflow.CfnFlow.AggregationConfigProperty aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.IResolvable aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getFileType}
             * @param fileType Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileType(java.lang.String fileType) {
                this.fileType = fileType;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
             *                     You can name folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.services.appflow.CfnFlow.PrefixConfigProperty prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
             *                     You can name folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.IResolvable prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPreserveSourceDataTyping}
             * @param preserveSourceDataTyping `CfnFlow.S3OutputFormatConfigProperty.PreserveSourceDataTyping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveSourceDataTyping(java.lang.Boolean preserveSourceDataTyping) {
                this.preserveSourceDataTyping = preserveSourceDataTyping;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPreserveSourceDataTyping}
             * @param preserveSourceDataTyping `CfnFlow.S3OutputFormatConfigProperty.PreserveSourceDataTyping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveSourceDataTyping(software.amazon.awscdk.IResolvable preserveSourceDataTyping) {
                this.preserveSourceDataTyping = preserveSourceDataTyping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputFormatConfigProperty {
            private final java.lang.Object aggregationConfig;
            private final java.lang.String fileType;
            private final java.lang.Object prefixConfig;
            private final java.lang.Object preserveSourceDataTyping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationConfig = software.amazon.jsii.Kernel.get(this, "aggregationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileType = software.amazon.jsii.Kernel.get(this, "fileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefixConfig = software.amazon.jsii.Kernel.get(this, "prefixConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preserveSourceDataTyping = software.amazon.jsii.Kernel.get(this, "preserveSourceDataTyping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationConfig = builder.aggregationConfig;
                this.fileType = builder.fileType;
                this.prefixConfig = builder.prefixConfig;
                this.preserveSourceDataTyping = builder.preserveSourceDataTyping;
            }

            @Override
            public final java.lang.Object getAggregationConfig() {
                return this.aggregationConfig;
            }

            @Override
            public final java.lang.String getFileType() {
                return this.fileType;
            }

            @Override
            public final java.lang.Object getPrefixConfig() {
                return this.prefixConfig;
            }

            @Override
            public final java.lang.Object getPreserveSourceDataTyping() {
                return this.preserveSourceDataTyping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregationConfig() != null) {
                    data.set("aggregationConfig", om.valueToTree(this.getAggregationConfig()));
                }
                if (this.getFileType() != null) {
                    data.set("fileType", om.valueToTree(this.getFileType()));
                }
                if (this.getPrefixConfig() != null) {
                    data.set("prefixConfig", om.valueToTree(this.getPrefixConfig()));
                }
                if (this.getPreserveSourceDataTyping() != null) {
                    data.set("preserveSourceDataTyping", om.valueToTree(this.getPreserveSourceDataTyping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3OutputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputFormatConfigProperty.Jsii$Proxy that = (S3OutputFormatConfigProperty.Jsii$Proxy) o;

                if (this.aggregationConfig != null ? !this.aggregationConfig.equals(that.aggregationConfig) : that.aggregationConfig != null) return false;
                if (this.fileType != null ? !this.fileType.equals(that.fileType) : that.fileType != null) return false;
                if (this.prefixConfig != null ? !this.prefixConfig.equals(that.prefixConfig) : that.prefixConfig != null) return false;
                return this.preserveSourceDataTyping != null ? this.preserveSourceDataTyping.equals(that.preserveSourceDataTyping) : that.preserveSourceDataTyping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationConfig != null ? this.aggregationConfig.hashCode() : 0;
                result = 31 * result + (this.fileType != null ? this.fileType.hashCode() : 0);
                result = 31 * result + (this.prefixConfig != null ? this.prefixConfig.hashCode() : 0);
                result = 31 * result + (this.preserveSourceDataTyping != null ? this.preserveSourceDataTyping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon S3 is being used as the flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3SourcePropertiesProperty s3SourcePropertiesProperty = S3SourcePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         // the properties below are optional
     *         .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                 .s3InputFileType("s3InputFileType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3SourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name where the source files are stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key for the Amazon S3 bucket in which the source files are stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketPrefix();

        /**
         * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3InputFormatConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourcePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object s3InputFormatConfig;

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name where the source files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the Amazon S3 bucket in which the source files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getS3InputFormatConfig}
             * @param s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.S3InputFormatConfigProperty s3InputFormatConfig) {
                this.s3InputFormatConfig = s3InputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getS3InputFormatConfig}
             * @param s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFormatConfig(software.amazon.awscdk.IResolvable s3InputFormatConfig) {
                this.s3InputFormatConfig = s3InputFormatConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourcePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object s3InputFormatConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3InputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = java.util.Objects.requireNonNull(builder.bucketPrefix, "bucketPrefix is required");
                this.s3InputFormatConfig = builder.s3InputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getS3InputFormatConfig() {
                return this.s3InputFormatConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                if (this.getS3InputFormatConfig() != null) {
                    data.set("s3InputFormatConfig", om.valueToTree(this.getS3InputFormatConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3SourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourcePropertiesProperty.Jsii$Proxy that = (S3SourcePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!bucketPrefix.equals(that.bucketPrefix)) return false;
                return this.s3InputFormatConfig != null ? this.s3InputFormatConfig.equals(that.s3InputFormatConfig) : that.s3InputFormatConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix.hashCode());
                result = 31 * result + (this.s3InputFormatConfig != null ? this.s3InputFormatConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using SAPOData as a flow destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataDestinationPropertiesProperty sAPODataDestinationPropertiesProperty = SAPODataDestinationPropertiesProperty.builder()
     *         .objectPath("objectPath")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object path specified in the SAPOData flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectPath();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
         * <p>
         * For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessResponseHandlingConfig() {
            return null;
        }

        /**
         * The possible write operations in the destination connector.
         * <p>
         * When this value is not provided, this defaults to the <code>INSERT</code> operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataDestinationPropertiesProperty> {
            java.lang.String objectPath;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.Object successResponseHandlingConfig;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getObjectPath}
             * @param objectPath The object path specified in the SAPOData flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectPath(java.lang.String objectPath) {
                this.objectPath = objectPath;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames A list of field names that can be used as an ID field when performing a write operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getSuccessResponseHandlingConfig}
             * @param successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
             *                                      For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponseHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.SuccessResponseHandlingConfigProperty successResponseHandlingConfig) {
                this.successResponseHandlingConfig = successResponseHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getSuccessResponseHandlingConfig}
             * @param successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
             *                                      For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponseHandlingConfig(software.amazon.awscdk.IResolvable successResponseHandlingConfig) {
                this.successResponseHandlingConfig = successResponseHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType The possible write operations in the destination connector.
             *                           When this value is not provided, this defaults to the <code>INSERT</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataDestinationPropertiesProperty {
            private final java.lang.String objectPath;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.Object successResponseHandlingConfig;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectPath = software.amazon.jsii.Kernel.get(this, "objectPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.successResponseHandlingConfig = software.amazon.jsii.Kernel.get(this, "successResponseHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectPath = java.util.Objects.requireNonNull(builder.objectPath, "objectPath is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.successResponseHandlingConfig = builder.successResponseHandlingConfig;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObjectPath() {
                return this.objectPath;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.Object getSuccessResponseHandlingConfig() {
                return this.successResponseHandlingConfig;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectPath", om.valueToTree(this.getObjectPath()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getSuccessResponseHandlingConfig() != null) {
                    data.set("successResponseHandlingConfig", om.valueToTree(this.getSuccessResponseHandlingConfig()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataDestinationPropertiesProperty.Jsii$Proxy that = (SAPODataDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!objectPath.equals(that.objectPath)) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                if (this.successResponseHandlingConfig != null ? !this.successResponseHandlingConfig.equals(that.successResponseHandlingConfig) : that.successResponseHandlingConfig != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectPath.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.successResponseHandlingConfig != null ? this.successResponseHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using SAPOData as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataSourcePropertiesProperty sAPODataSourcePropertiesProperty = SAPODataSourcePropertiesProperty.builder()
     *         .objectPath("objectPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object path specified in the SAPOData flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectPath();

        /**
         * @return a {@link Builder} of {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataSourcePropertiesProperty> {
            java.lang.String objectPath;

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getObjectPath}
             * @param objectPath The object path specified in the SAPOData flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectPath(java.lang.String objectPath) {
                this.objectPath = objectPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataSourcePropertiesProperty {
            private final java.lang.String objectPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectPath = software.amazon.jsii.Kernel.get(this, "objectPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectPath = java.util.Objects.requireNonNull(builder.objectPath, "objectPath is required");
            }

            @Override
            public final java.lang.String getObjectPath() {
                return this.objectPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectPath", om.valueToTree(this.getObjectPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataSourcePropertiesProperty.Jsii$Proxy that = (SAPODataSourcePropertiesProperty.Jsii$Proxy) o;

                return this.objectPath.equals(that.objectPath);
            }

            @Override
            public final int hashCode() {
                int result = this.objectPath.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceDestinationPropertiesProperty salesforceDestinationPropertiesProperty = SalesforceDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SalesforceDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * This specifies the type of write operation to be performed in Salesforce.
         * <p>
         * When the value is <code>UPSERT</code> , then <code>idFieldNames</code> is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Salesforce flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType This specifies the type of write operation to be performed in Salesforce.
             *                           When the value is <code>UPSERT</code> , then <code>idFieldNames</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SalesforceDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceDestinationPropertiesProperty.Jsii$Proxy that = (SalesforceDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceSourcePropertiesProperty salesforceSourcePropertiesProperty = SalesforceSourcePropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .enableDynamicFieldUpdate(false)
     *         .includeDeletedRecords(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SalesforceSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDynamicFieldUpdate() {
            return null;
        }

        /**
         * Indicates whether Amazon AppFlow includes deleted files in the flow run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeDeletedRecords() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceSourcePropertiesProperty> {
            java.lang.String object;
            java.lang.Object enableDynamicFieldUpdate;
            java.lang.Object includeDeletedRecords;

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getObject}
             * @param object The object specified in the Salesforce flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(java.lang.Boolean enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(software.amazon.awscdk.IResolvable enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(java.lang.Boolean includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(software.amazon.awscdk.IResolvable includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceSourcePropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object enableDynamicFieldUpdate;
            private final java.lang.Object includeDeletedRecords;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableDynamicFieldUpdate = software.amazon.jsii.Kernel.get(this, "enableDynamicFieldUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeDeletedRecords = software.amazon.jsii.Kernel.get(this, "includeDeletedRecords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.enableDynamicFieldUpdate = builder.enableDynamicFieldUpdate;
                this.includeDeletedRecords = builder.includeDeletedRecords;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getEnableDynamicFieldUpdate() {
                return this.enableDynamicFieldUpdate;
            }

            @Override
            public final java.lang.Object getIncludeDeletedRecords() {
                return this.includeDeletedRecords;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getEnableDynamicFieldUpdate() != null) {
                    data.set("enableDynamicFieldUpdate", om.valueToTree(this.getEnableDynamicFieldUpdate()));
                }
                if (this.getIncludeDeletedRecords() != null) {
                    data.set("includeDeletedRecords", om.valueToTree(this.getIncludeDeletedRecords()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SalesforceSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceSourcePropertiesProperty.Jsii$Proxy that = (SalesforceSourcePropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.enableDynamicFieldUpdate != null ? !this.enableDynamicFieldUpdate.equals(that.enableDynamicFieldUpdate) : that.enableDynamicFieldUpdate != null) return false;
                return this.includeDeletedRecords != null ? this.includeDeletedRecords.equals(that.includeDeletedRecords) : that.includeDeletedRecords == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.enableDynamicFieldUpdate != null ? this.enableDynamicFieldUpdate.hashCode() : 0);
                result = 31 * result + (this.includeDeletedRecords != null ? this.includeDeletedRecords.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration details of a schedule-triggered flow as defined by the user.
     * <p>
     * Currently, these settings only apply to the <code>Scheduled</code> trigger type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ScheduledTriggerPropertiesProperty scheduledTriggerPropertiesProperty = ScheduledTriggerPropertiesProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         // the properties below are optional
     *         .dataPullMode("dataPullMode")
     *         .firstExecutionFrom(123)
     *         .flowErrorDeactivationThreshold(123)
     *         .scheduleEndTime(123)
     *         .scheduleOffset(123)
     *         .scheduleStartTime(123)
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ScheduledTriggerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledTriggerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledTriggerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataPullMode() {
            return null;
        }

        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.FirstExecutionFrom`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFirstExecutionFrom() {
            return null;
        }

        /**
         * `CfnFlow.ScheduledTriggerPropertiesProperty.FlowErrorDeactivationThreshold`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFlowErrorDeactivationThreshold() {
            return null;
        }

        /**
         * The time at which the scheduled flow ends.
         * <p>
         * The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-27T13:00:00-07:00</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleEndTime() {
            return null;
        }

        /**
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleOffset() {
            return null;
        }

        /**
         * The time at which the scheduled flow starts.
         * <p>
         * The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-26T13:00:00-07:00</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleStartTime() {
            return null;
        }

        /**
         * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York` .
         * <p>
         * This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
         * <p>
         * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are <code>-04:00</code> EDT and <code>-05:00 EST</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledTriggerPropertiesProperty> {
            java.lang.String scheduleExpression;
            java.lang.String dataPullMode;
            java.lang.Number firstExecutionFrom;
            java.lang.Number flowErrorDeactivationThreshold;
            java.lang.Number scheduleEndTime;
            java.lang.Number scheduleOffset;
            java.lang.Number scheduleStartTime;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleExpression}
             * @param scheduleExpression The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getDataPullMode}
             * @param dataPullMode Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataPullMode(java.lang.String dataPullMode) {
                this.dataPullMode = dataPullMode;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getFirstExecutionFrom}
             * @param firstExecutionFrom `CfnFlow.ScheduledTriggerPropertiesProperty.FirstExecutionFrom`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstExecutionFrom(java.lang.Number firstExecutionFrom) {
                this.firstExecutionFrom = firstExecutionFrom;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getFlowErrorDeactivationThreshold}
             * @param flowErrorDeactivationThreshold `CfnFlow.ScheduledTriggerPropertiesProperty.FlowErrorDeactivationThreshold`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowErrorDeactivationThreshold(java.lang.Number flowErrorDeactivationThreshold) {
                this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleEndTime}
             * @param scheduleEndTime The time at which the scheduled flow ends.
             *                        The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-27T13:00:00-07:00</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleEndTime(java.lang.Number scheduleEndTime) {
                this.scheduleEndTime = scheduleEndTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleOffset}
             * @param scheduleOffset Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleOffset(java.lang.Number scheduleOffset) {
                this.scheduleOffset = scheduleOffset;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleStartTime}
             * @param scheduleStartTime The time at which the scheduled flow starts.
             *                          The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-26T13:00:00-07:00</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleStartTime(java.lang.Number scheduleStartTime) {
                this.scheduleStartTime = scheduleStartTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getTimeZone}
             * @param timeZone Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York` .
             *                 This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
             *                 <p>
             *                 If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are <code>-04:00</code> EDT and <code>-05:00 EST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledTriggerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledTriggerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledTriggerPropertiesProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.String dataPullMode;
            private final java.lang.Number firstExecutionFrom;
            private final java.lang.Number flowErrorDeactivationThreshold;
            private final java.lang.Number scheduleEndTime;
            private final java.lang.Number scheduleOffset;
            private final java.lang.Number scheduleStartTime;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataPullMode = software.amazon.jsii.Kernel.get(this, "dataPullMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstExecutionFrom = software.amazon.jsii.Kernel.get(this, "firstExecutionFrom", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.flowErrorDeactivationThreshold = software.amazon.jsii.Kernel.get(this, "flowErrorDeactivationThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleEndTime = software.amazon.jsii.Kernel.get(this, "scheduleEndTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleOffset = software.amazon.jsii.Kernel.get(this, "scheduleOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleStartTime = software.amazon.jsii.Kernel.get(this, "scheduleStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
                this.dataPullMode = builder.dataPullMode;
                this.firstExecutionFrom = builder.firstExecutionFrom;
                this.flowErrorDeactivationThreshold = builder.flowErrorDeactivationThreshold;
                this.scheduleEndTime = builder.scheduleEndTime;
                this.scheduleOffset = builder.scheduleOffset;
                this.scheduleStartTime = builder.scheduleStartTime;
                this.timeZone = builder.timeZone;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.String getDataPullMode() {
                return this.dataPullMode;
            }

            @Override
            public final java.lang.Number getFirstExecutionFrom() {
                return this.firstExecutionFrom;
            }

            @Override
            public final java.lang.Number getFlowErrorDeactivationThreshold() {
                return this.flowErrorDeactivationThreshold;
            }

            @Override
            public final java.lang.Number getScheduleEndTime() {
                return this.scheduleEndTime;
            }

            @Override
            public final java.lang.Number getScheduleOffset() {
                return this.scheduleOffset;
            }

            @Override
            public final java.lang.Number getScheduleStartTime() {
                return this.scheduleStartTime;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                if (this.getDataPullMode() != null) {
                    data.set("dataPullMode", om.valueToTree(this.getDataPullMode()));
                }
                if (this.getFirstExecutionFrom() != null) {
                    data.set("firstExecutionFrom", om.valueToTree(this.getFirstExecutionFrom()));
                }
                if (this.getFlowErrorDeactivationThreshold() != null) {
                    data.set("flowErrorDeactivationThreshold", om.valueToTree(this.getFlowErrorDeactivationThreshold()));
                }
                if (this.getScheduleEndTime() != null) {
                    data.set("scheduleEndTime", om.valueToTree(this.getScheduleEndTime()));
                }
                if (this.getScheduleOffset() != null) {
                    data.set("scheduleOffset", om.valueToTree(this.getScheduleOffset()));
                }
                if (this.getScheduleStartTime() != null) {
                    data.set("scheduleStartTime", om.valueToTree(this.getScheduleStartTime()));
                }
                if (this.getTimeZone() != null) {
                    data.set("timeZone", om.valueToTree(this.getTimeZone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ScheduledTriggerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledTriggerPropertiesProperty.Jsii$Proxy that = (ScheduledTriggerPropertiesProperty.Jsii$Proxy) o;

                if (!scheduleExpression.equals(that.scheduleExpression)) return false;
                if (this.dataPullMode != null ? !this.dataPullMode.equals(that.dataPullMode) : that.dataPullMode != null) return false;
                if (this.firstExecutionFrom != null ? !this.firstExecutionFrom.equals(that.firstExecutionFrom) : that.firstExecutionFrom != null) return false;
                if (this.flowErrorDeactivationThreshold != null ? !this.flowErrorDeactivationThreshold.equals(that.flowErrorDeactivationThreshold) : that.flowErrorDeactivationThreshold != null) return false;
                if (this.scheduleEndTime != null ? !this.scheduleEndTime.equals(that.scheduleEndTime) : that.scheduleEndTime != null) return false;
                if (this.scheduleOffset != null ? !this.scheduleOffset.equals(that.scheduleOffset) : that.scheduleOffset != null) return false;
                if (this.scheduleStartTime != null ? !this.scheduleStartTime.equals(that.scheduleStartTime) : that.scheduleStartTime != null) return false;
                return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                result = 31 * result + (this.dataPullMode != null ? this.dataPullMode.hashCode() : 0);
                result = 31 * result + (this.firstExecutionFrom != null ? this.firstExecutionFrom.hashCode() : 0);
                result = 31 * result + (this.flowErrorDeactivationThreshold != null ? this.flowErrorDeactivationThreshold.hashCode() : 0);
                result = 31 * result + (this.scheduleEndTime != null ? this.scheduleEndTime.hashCode() : 0);
                result = 31 * result + (this.scheduleOffset != null ? this.scheduleOffset.hashCode() : 0);
                result = 31 * result + (this.scheduleStartTime != null ? this.scheduleStartTime.hashCode() : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when ServiceNow is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowSourcePropertiesProperty serviceNowSourcePropertiesProperty = ServiceNowSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ServiceNowSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the ServiceNow flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ServiceNowSourcePropertiesProperty#getObject}
             * @param object The object specified in the ServiceNow flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ServiceNowSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowSourcePropertiesProperty.Jsii$Proxy that = (ServiceNowSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Singular is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SingularSourcePropertiesProperty singularSourcePropertiesProperty = SingularSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SingularSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SingularSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingularSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Singular flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingularSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link SingularSourcePropertiesProperty#getObject}
             * @param object The object specified in the Singular flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingularSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingularSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingularSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SingularSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingularSourcePropertiesProperty.Jsii$Proxy that = (SingularSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Slack is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackSourcePropertiesProperty slackSourcePropertiesProperty = SlackSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SlackSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Slack flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link SlackSourcePropertiesProperty#getObject}
             * @param object The object specified in the Slack flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SlackSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackSourcePropertiesProperty.Jsii$Proxy that = (SlackSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Snowflake is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeDestinationPropertiesProperty snowflakeDestinationPropertiesProperty = SnowflakeDestinationPropertiesProperty.builder()
     *         .intermediateBucketName("intermediateBucketName")
     *         .object("object")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SnowflakeDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateBucketName();

        /**
         * The object specified in the Snowflake flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeDestinationPropertiesProperty> {
            java.lang.String intermediateBucketName;
            java.lang.String object;
            java.lang.String bucketPrefix;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getIntermediateBucketName}
             * @param intermediateBucketName The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateBucketName(java.lang.String intermediateBucketName) {
                this.intermediateBucketName = intermediateBucketName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Snowflake flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeDestinationPropertiesProperty {
            private final java.lang.String intermediateBucketName;
            private final java.lang.String object;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateBucketName = software.amazon.jsii.Kernel.get(this, "intermediateBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateBucketName = java.util.Objects.requireNonNull(builder.intermediateBucketName, "intermediateBucketName is required");
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getIntermediateBucketName() {
                return this.intermediateBucketName;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateBucketName", om.valueToTree(this.getIntermediateBucketName()));
                data.set("object", om.valueToTree(this.getObject()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SnowflakeDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeDestinationPropertiesProperty.Jsii$Proxy that = (SnowflakeDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!intermediateBucketName.equals(that.intermediateBucketName)) return false;
                if (!object.equals(that.object)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateBucketName.hashCode();
                result = 31 * result + (this.object.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the information that is required to query a particular connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * SourceConnectorPropertiesProperty sourceConnectorPropertiesProperty = SourceConnectorPropertiesProperty.builder()
     *         .amplitude(AmplitudeSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
     *                 .entityName("entityName")
     *                 // the properties below are optional
     *                 .customProperties(customProperties)
     *                 .build())
     *         .datadog(DatadogSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .dynatrace(DynatraceSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .inforNexus(InforNexusSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .marketo(MarketoSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .s3(S3SourcePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 // the properties below are optional
     *                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                         .s3InputFileType("s3InputFileType")
     *                         .build())
     *                 .build())
     *         .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .enableDynamicFieldUpdate(false)
     *                 .includeDeletedRecords(false)
     *                 .build())
     *         .sapoData(SAPODataSourcePropertiesProperty.builder()
     *                 .objectPath("objectPath")
     *                 .build())
     *         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .singular(SingularSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .slack(SlackSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .veeva(VeevaSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .documentType("documentType")
     *                 .includeAllVersions(false)
     *                 .includeRenditions(false)
     *                 .includeSourceFiles(false)
     *                 .build())
     *         .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SourceConnectorPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConnectorPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConnectorPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the information that is required for querying Amplitude.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmplitude() {
            return null;
        }

        /**
         * `CfnFlow.SourceConnectorPropertiesProperty.CustomConnector`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Datadog.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Dynatrace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Google Analytics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoogleAnalytics() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Infor Nexus.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Marketo.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Amazon S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Salesforce.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The properties that are applied when using SAPOData as a flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * Specifies the information that is required for querying ServiceNow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Singular.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingular() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Trend Micro.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrendmicro() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Veeva.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Zendesk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConnectorPropertiesProperty> {
            java.lang.Object amplitude;
            java.lang.Object customConnector;
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object googleAnalytics;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object s3;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object singular;
            java.lang.Object slack;
            java.lang.Object trendmicro;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getAmplitude}
             * @param amplitude Specifies the information that is required for querying Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.services.appflow.CfnFlow.AmplitudeSourcePropertiesProperty amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getAmplitude}
             * @param amplitude Specifies the information that is required for querying Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.IResolvable amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector `CfnFlow.SourceConnectorPropertiesProperty.CustomConnector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorSourcePropertiesProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector `CfnFlow.SourceConnectorPropertiesProperty.CustomConnector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDatadog}
             * @param datadog Specifies the information that is required for querying Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnFlow.DatadogSourcePropertiesProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDatadog}
             * @param datadog Specifies the information that is required for querying Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDynatrace}
             * @param dynatrace Specifies the information that is required for querying Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnFlow.DynatraceSourcePropertiesProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDynatrace}
             * @param dynatrace Specifies the information that is required for querying Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getGoogleAnalytics}
             * @param googleAnalytics Specifies the information that is required for querying Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.services.appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getGoogleAnalytics}
             * @param googleAnalytics Specifies the information that is required for querying Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.IResolvable googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getInforNexus}
             * @param inforNexus Specifies the information that is required for querying Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnFlow.InforNexusSourcePropertiesProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getInforNexus}
             * @param inforNexus Specifies the information that is required for querying Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo Specifies the information that is required for querying Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnFlow.MarketoSourcePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo Specifies the information that is required for querying Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 Specifies the information that is required for querying Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.appflow.CfnFlow.S3SourcePropertiesProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 Specifies the information that is required for querying Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce Specifies the information that is required for querying Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnFlow.SalesforceSourcePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce Specifies the information that is required for querying Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties that are applied when using SAPOData as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataSourcePropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties that are applied when using SAPOData as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow Specifies the information that is required for querying ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnFlow.ServiceNowSourcePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow Specifies the information that is required for querying ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSingular}
             * @param singular Specifies the information that is required for querying Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.services.appflow.CfnFlow.SingularSourcePropertiesProperty singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSingular}
             * @param singular Specifies the information that is required for querying Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.IResolvable singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSlack}
             * @param slack Specifies the information that is required for querying Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnFlow.SlackSourcePropertiesProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSlack}
             * @param slack Specifies the information that is required for querying Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getTrendmicro}
             * @param trendmicro Specifies the information that is required for querying Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.services.appflow.CfnFlow.TrendmicroSourcePropertiesProperty trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getTrendmicro}
             * @param trendmicro Specifies the information that is required for querying Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.IResolvable trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getVeeva}
             * @param veeva Specifies the information that is required for querying Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnFlow.VeevaSourcePropertiesProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getVeeva}
             * @param veeva Specifies the information that is required for querying Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk Specifies the information that is required for querying Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnFlow.ZendeskSourcePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk Specifies the information that is required for querying Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConnectorPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConnectorPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConnectorPropertiesProperty {
            private final java.lang.Object amplitude;
            private final java.lang.Object customConnector;
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object googleAnalytics;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object s3;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object singular;
            private final java.lang.Object slack;
            private final java.lang.Object trendmicro;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SourceConnectorPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConnectorPropertiesProperty.Jsii$Proxy that = (SourceConnectorPropertiesProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.customConnector != null ? this.customConnector.hashCode() : 0);
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the configuration of the source connector used in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object customProperties;
     * SourceFlowConfigProperty sourceFlowConfigProperty = SourceFlowConfigProperty.builder()
     *         .connectorType("connectorType")
     *         .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
     *                 .amplitude(AmplitudeSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .customConnector(CustomConnectorSourcePropertiesProperty.builder()
     *                         .entityName("entityName")
     *                         // the properties below are optional
     *                         .customProperties(customProperties)
     *                         .build())
     *                 .datadog(DatadogSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .dynatrace(DynatraceSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .inforNexus(InforNexusSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .marketo(MarketoSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .s3(S3SourcePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         // the properties below are optional
     *                         .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                                 .s3InputFileType("s3InputFileType")
     *                                 .build())
     *                         .build())
     *                 .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .enableDynamicFieldUpdate(false)
     *                         .includeDeletedRecords(false)
     *                         .build())
     *                 .sapoData(SAPODataSourcePropertiesProperty.builder()
     *                         .objectPath("objectPath")
     *                         .build())
     *                 .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .singular(SingularSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .slack(SlackSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .trendmicro(TrendmicroSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .veeva(VeevaSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .documentType("documentType")
     *                         .includeAllVersions(false)
     *                         .includeRenditions(false)
     *                         .includeSourceFiles(false)
     *                         .build())
     *                 .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .apiVersion("apiVersion")
     *         .connectorProfileName("connectorProfileName")
     *         .incrementalPullConfig(IncrementalPullConfigProperty.builder()
     *                 .datetimeTypeFieldName("datetimeTypeFieldName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SourceFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of source connector, such as Salesforce, Amplitude, and so on.
         * <p>
         * <em>Allowed Values</em> : S3 | Amplitude | Datadog | Dynatrace | Googleanalytics | Infornexus | Salesforce | Servicenow | Singular | Slack | Trendmicro | Veeva | Zendesk
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

        /**
         * Specifies the information that is required to query a particular source connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConnectorProperties();

        /**
         * `CfnFlow.SourceFlowConfigProperty.ApiVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
            return null;
        }

        /**
         * The name of the connector profile.
         * <p>
         * This name must be unique for each connector profile in the AWS account .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorProfileName() {
            return null;
        }

        /**
         * Defines the configuration for a scheduled incremental data pull.
         * <p>
         * If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncrementalPullConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceFlowConfigProperty> {
            java.lang.String connectorType;
            java.lang.Object sourceConnectorProperties;
            java.lang.String apiVersion;
            java.lang.String connectorProfileName;
            java.lang.Object incrementalPullConfig;

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorType}
             * @param connectorType The type of source connector, such as Salesforce, Amplitude, and so on. This parameter is required.
             *                      <em>Allowed Values</em> : S3 | Amplitude | Datadog | Dynatrace | Googleanalytics | Infornexus | Salesforce | Servicenow | Singular | Slack | Trendmicro | Veeva | Zendesk
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorType(java.lang.String connectorType) {
                this.connectorType = connectorType;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.services.appflow.CfnFlow.SourceConnectorPropertiesProperty sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.IResolvable sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getApiVersion}
             * @param apiVersion `CfnFlow.SourceFlowConfigProperty.ApiVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiVersion(java.lang.String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorProfileName}
             * @param connectorProfileName The name of the connector profile.
             *                             This name must be unique for each connector profile in the AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileName(java.lang.String connectorProfileName) {
                this.connectorProfileName = connectorProfileName;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.services.appflow.CfnFlow.IncrementalPullConfigProperty incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.IResolvable incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceFlowConfigProperty {
            private final java.lang.String connectorType;
            private final java.lang.Object sourceConnectorProperties;
            private final java.lang.String apiVersion;
            private final java.lang.String connectorProfileName;
            private final java.lang.Object incrementalPullConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceConnectorProperties = software.amazon.jsii.Kernel.get(this, "sourceConnectorProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.incrementalPullConfig = software.amazon.jsii.Kernel.get(this, "incrementalPullConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
                this.sourceConnectorProperties = java.util.Objects.requireNonNull(builder.sourceConnectorProperties, "sourceConnectorProperties is required");
                this.apiVersion = builder.apiVersion;
                this.connectorProfileName = builder.connectorProfileName;
                this.incrementalPullConfig = builder.incrementalPullConfig;
            }

            @Override
            public final java.lang.String getConnectorType() {
                return this.connectorType;
            }

            @Override
            public final java.lang.Object getSourceConnectorProperties() {
                return this.sourceConnectorProperties;
            }

            @Override
            public final java.lang.String getApiVersion() {
                return this.apiVersion;
            }

            @Override
            public final java.lang.String getConnectorProfileName() {
                return this.connectorProfileName;
            }

            @Override
            public final java.lang.Object getIncrementalPullConfig() {
                return this.incrementalPullConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorType", om.valueToTree(this.getConnectorType()));
                data.set("sourceConnectorProperties", om.valueToTree(this.getSourceConnectorProperties()));
                if (this.getApiVersion() != null) {
                    data.set("apiVersion", om.valueToTree(this.getApiVersion()));
                }
                if (this.getConnectorProfileName() != null) {
                    data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
                }
                if (this.getIncrementalPullConfig() != null) {
                    data.set("incrementalPullConfig", om.valueToTree(this.getIncrementalPullConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SourceFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceFlowConfigProperty.Jsii$Proxy that = (SourceFlowConfigProperty.Jsii$Proxy) o;

                if (!connectorType.equals(that.connectorType)) return false;
                if (!sourceConnectorProperties.equals(that.sourceConnectorProperties)) return false;
                if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
                if (this.connectorProfileName != null ? !this.connectorProfileName.equals(that.connectorProfileName) : that.connectorProfileName != null) return false;
                return this.incrementalPullConfig != null ? this.incrementalPullConfig.equals(that.incrementalPullConfig) : that.incrementalPullConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorType.hashCode();
                result = 31 * result + (this.sourceConnectorProperties.hashCode());
                result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
                result = 31 * result + (this.connectorProfileName != null ? this.connectorProfileName.hashCode() : 0);
                result = 31 * result + (this.incrementalPullConfig != null ? this.incrementalPullConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
     * <p>
     * For example, this setting would determine where to write the response from the destination connector upon a successful insert operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SuccessResponseHandlingConfigProperty successResponseHandlingConfigProperty = SuccessResponseHandlingConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SuccessResponseHandlingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SuccessResponseHandlingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuccessResponseHandlingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * The Amazon S3 bucket prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuccessResponseHandlingConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link SuccessResponseHandlingConfigProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link SuccessResponseHandlingConfigProperty#getBucketPrefix}
             * @param bucketPrefix The Amazon S3 bucket prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuccessResponseHandlingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuccessResponseHandlingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuccessResponseHandlingConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = builder.bucketName;
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SuccessResponseHandlingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuccessResponseHandlingConfigProperty.Jsii$Proxy that = (SuccessResponseHandlingConfigProperty.Jsii$Proxy) o;

                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A map used to store task-related information.
     * <p>
     * The execution service looks for particular information based on the <code>TaskType</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TaskPropertiesObjectProperty taskPropertiesObjectProperty = TaskPropertiesObjectProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TaskPropertiesObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskPropertiesObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskPropertiesObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The task property key.
         * <p>
         * <em>Allowed Values</em> : <code>VALUE | VALUES | DATA_TYPE | UPPER_BOUND | LOWER_BOUND | SOURCE_DATA_TYPE | DESTINATION_DATA_TYPE | VALIDATION_ACTION | MASK_VALUE | MASK_LENGTH | TRUNCATE_LENGTH | MATH_OPERATION_FIELDS_ORDER | CONCAT_FORMAT | SUBFIELD_CATEGORY_MAP</code> | <code>EXCLUDE_SOURCE_FIELDS_LIST</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The task property value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskPropertiesObjectProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TaskPropertiesObjectProperty#getKey}
             * @param key The task property key. This parameter is required.
             *            <em>Allowed Values</em> : <code>VALUE | VALUES | DATA_TYPE | UPPER_BOUND | LOWER_BOUND | SOURCE_DATA_TYPE | DESTINATION_DATA_TYPE | VALIDATION_ACTION | MASK_VALUE | MASK_LENGTH | TRUNCATE_LENGTH | MATH_OPERATION_FIELDS_ORDER | CONCAT_FORMAT | SUBFIELD_CATEGORY_MAP</code> | <code>EXCLUDE_SOURCE_FIELDS_LIST</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TaskPropertiesObjectProperty#getValue}
             * @param value The task property value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskPropertiesObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskPropertiesObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskPropertiesObjectProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TaskPropertiesObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskPropertiesObjectProperty.Jsii$Proxy that = (TaskPropertiesObjectProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A class for modeling different type of tasks.
     * <p>
     * Task implementation varies based on the <code>TaskType</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TaskProperty taskProperty = TaskProperty.builder()
     *         .sourceFields(List.of("sourceFields"))
     *         .taskType("taskType")
     *         // the properties below are optional
     *         .connectorOperator(ConnectorOperatorProperty.builder()
     *                 .amplitude("amplitude")
     *                 .customConnector("customConnector")
     *                 .datadog("datadog")
     *                 .dynatrace("dynatrace")
     *                 .googleAnalytics("googleAnalytics")
     *                 .inforNexus("inforNexus")
     *                 .marketo("marketo")
     *                 .s3("s3")
     *                 .salesforce("salesforce")
     *                 .sapoData("sapoData")
     *                 .serviceNow("serviceNow")
     *                 .singular("singular")
     *                 .slack("slack")
     *                 .trendmicro("trendmicro")
     *                 .veeva("veeva")
     *                 .zendesk("zendesk")
     *                 .build())
     *         .destinationField("destinationField")
     *         .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TaskProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source fields to which a particular task is applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSourceFields();

        /**
         * Specifies the particular task implementation that Amazon AppFlow performs.
         * <p>
         * <em>Allowed values</em> : <code>Arithmetic</code> | <code>Filter</code> | <code>Map</code> | <code>Map_all</code> | <code>Mask</code> | <code>Merge</code> | <code>Truncate</code> | <code>Validate</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskType();

        /**
         * The operation to be performed on the provided source fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOperator() {
            return null;
        }

        /**
         * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationField() {
            return null;
        }

        /**
         * A map used to store task-related information.
         * <p>
         * The execution service looks for particular information based on the <code>TaskType</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskProperty> {
            java.util.List<java.lang.String> sourceFields;
            java.lang.String taskType;
            java.lang.Object connectorOperator;
            java.lang.String destinationField;
            java.lang.Object taskProperties;

            /**
             * Sets the value of {@link TaskProperty#getSourceFields}
             * @param sourceFields The source fields to which a particular task is applied. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFields(java.util.List<java.lang.String> sourceFields) {
                this.sourceFields = sourceFields;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskType}
             * @param taskType Specifies the particular task implementation that Amazon AppFlow performs. This parameter is required.
             *                 <em>Allowed values</em> : <code>Arithmetic</code> | <code>Filter</code> | <code>Map</code> | <code>Map_all</code> | <code>Mask</code> | <code>Merge</code> | <code>Truncate</code> | <code>Validate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskType(java.lang.String taskType) {
                this.taskType = taskType;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.services.appflow.CfnFlow.ConnectorOperatorProperty connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.IResolvable connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getDestinationField}
             * @param destinationField A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationField(java.lang.String destinationField) {
                this.destinationField = destinationField;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The execution service looks for particular information based on the <code>TaskType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(software.amazon.awscdk.IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The execution service looks for particular information based on the <code>TaskType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(java.util.List<? extends java.lang.Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskProperty {
            private final java.util.List<java.lang.String> sourceFields;
            private final java.lang.String taskType;
            private final java.lang.Object connectorOperator;
            private final java.lang.String destinationField;
            private final java.lang.Object taskProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceFields = software.amazon.jsii.Kernel.get(this, "sourceFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.taskType = software.amazon.jsii.Kernel.get(this, "taskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOperator = software.amazon.jsii.Kernel.get(this, "connectorOperator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationField = software.amazon.jsii.Kernel.get(this, "destinationField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskProperties = software.amazon.jsii.Kernel.get(this, "taskProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceFields = java.util.Objects.requireNonNull(builder.sourceFields, "sourceFields is required");
                this.taskType = java.util.Objects.requireNonNull(builder.taskType, "taskType is required");
                this.connectorOperator = builder.connectorOperator;
                this.destinationField = builder.destinationField;
                this.taskProperties = builder.taskProperties;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceFields() {
                return this.sourceFields;
            }

            @Override
            public final java.lang.String getTaskType() {
                return this.taskType;
            }

            @Override
            public final java.lang.Object getConnectorOperator() {
                return this.connectorOperator;
            }

            @Override
            public final java.lang.String getDestinationField() {
                return this.destinationField;
            }

            @Override
            public final java.lang.Object getTaskProperties() {
                return this.taskProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceFields", om.valueToTree(this.getSourceFields()));
                data.set("taskType", om.valueToTree(this.getTaskType()));
                if (this.getConnectorOperator() != null) {
                    data.set("connectorOperator", om.valueToTree(this.getConnectorOperator()));
                }
                if (this.getDestinationField() != null) {
                    data.set("destinationField", om.valueToTree(this.getDestinationField()));
                }
                if (this.getTaskProperties() != null) {
                    data.set("taskProperties", om.valueToTree(this.getTaskProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TaskProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskProperty.Jsii$Proxy that = (TaskProperty.Jsii$Proxy) o;

                if (!sourceFields.equals(that.sourceFields)) return false;
                if (!taskType.equals(that.taskType)) return false;
                if (this.connectorOperator != null ? !this.connectorOperator.equals(that.connectorOperator) : that.connectorOperator != null) return false;
                if (this.destinationField != null ? !this.destinationField.equals(that.destinationField) : that.destinationField != null) return false;
                return this.taskProperties != null ? this.taskProperties.equals(that.taskProperties) : that.taskProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceFields.hashCode();
                result = 31 * result + (this.taskType.hashCode());
                result = 31 * result + (this.connectorOperator != null ? this.connectorOperator.hashCode() : 0);
                result = 31 * result + (this.destinationField != null ? this.destinationField.hashCode() : 0);
                result = 31 * result + (this.taskProperties != null ? this.taskProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Trend Micro as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TrendmicroSourcePropertiesProperty trendmicroSourcePropertiesProperty = TrendmicroSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TrendmicroSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(TrendmicroSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrendmicroSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Trend Micro flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrendmicroSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link TrendmicroSourcePropertiesProperty#getObject}
             * @param object The object specified in the Trend Micro flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrendmicroSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrendmicroSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrendmicroSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TrendmicroSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrendmicroSourcePropertiesProperty.Jsii$Proxy that = (TrendmicroSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TriggerConfigProperty triggerConfigProperty = TriggerConfigProperty.builder()
     *         .triggerType("triggerType")
     *         // the properties below are optional
     *         .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 // the properties below are optional
     *                 .dataPullMode("dataPullMode")
     *                 .firstExecutionFrom(123)
     *                 .flowErrorDeactivationThreshold(123)
     *                 .scheduleEndTime(123)
     *                 .scheduleOffset(123)
     *                 .scheduleStartTime(123)
     *                 .timeZone("timeZone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TriggerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of flow trigger.
         * <p>
         * This can be <code>OnDemand</code> , <code>Scheduled</code> , or <code>Event</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTriggerType();

        /**
         * Specifies the configuration details of a schedule-triggered flow as defined by the user.
         * <p>
         * Currently, these settings only apply to the <code>Scheduled</code> trigger type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTriggerProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            java.lang.String triggerType;
            java.lang.Object triggerProperties;

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerType}
             * @param triggerType Specifies the type of flow trigger. This parameter is required.
             *                    This can be <code>OnDemand</code> , <code>Scheduled</code> , or <code>Event</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerType(java.lang.String triggerType) {
                this.triggerType = triggerType;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow as defined by the user.
             *                          Currently, these settings only apply to the <code>Scheduled</code> trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.services.appflow.CfnFlow.ScheduledTriggerPropertiesProperty triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow as defined by the user.
             *                          Currently, these settings only apply to the <code>Scheduled</code> trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.IResolvable triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConfigProperty {
            private final java.lang.String triggerType;
            private final java.lang.Object triggerProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.triggerType = software.amazon.jsii.Kernel.get(this, "triggerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.triggerProperties = software.amazon.jsii.Kernel.get(this, "triggerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.triggerType = java.util.Objects.requireNonNull(builder.triggerType, "triggerType is required");
                this.triggerProperties = builder.triggerProperties;
            }

            @Override
            public final java.lang.String getTriggerType() {
                return this.triggerType;
            }

            @Override
            public final java.lang.Object getTriggerProperties() {
                return this.triggerProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("triggerType", om.valueToTree(this.getTriggerType()));
                if (this.getTriggerProperties() != null) {
                    data.set("triggerProperties", om.valueToTree(this.getTriggerProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TriggerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConfigProperty.Jsii$Proxy that = (TriggerConfigProperty.Jsii$Proxy) o;

                if (!triggerType.equals(that.triggerType)) return false;
                return this.triggerProperties != null ? this.triggerProperties.equals(that.triggerProperties) : that.triggerProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.triggerType.hashCode();
                result = 31 * result + (this.triggerProperties != null ? this.triggerProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Upsolver is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * UpsolverDestinationPropertiesProperty upsolverDestinationPropertiesProperty = UpsolverDestinationPropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                 .prefixConfig(PrefixConfigProperty.builder()
     *                         .prefixFormat("prefixFormat")
     *                         .prefixType("prefixType")
     *                         .build())
     *                 // the properties below are optional
     *                 .aggregationConfig(AggregationConfigProperty.builder()
     *                         .aggregationType("aggregationType")
     *                         .build())
     *                 .fileType("fileType")
     *                 .build())
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.UpsolverDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(UpsolverDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpsolverDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The configuration that determines how data is formatted when Upsolver is used as the flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3OutputFormatConfig();

        /**
         * The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpsolverDestinationPropertiesProperty> {
            java.lang.String bucketName;
            java.lang.Object s3OutputFormatConfig;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getBucketName}
             * @param bucketName The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how data is formatted when Upsolver is used as the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how data is formatted when Upsolver is used as the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.IResolvable s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpsolverDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpsolverDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpsolverDestinationPropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.Object s3OutputFormatConfig;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3OutputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.s3OutputFormatConfig = java.util.Objects.requireNonNull(builder.s3OutputFormatConfig, "s3OutputFormatConfig is required");
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.Object getS3OutputFormatConfig() {
                return this.s3OutputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("s3OutputFormatConfig", om.valueToTree(this.getS3OutputFormatConfig()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.UpsolverDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpsolverDestinationPropertiesProperty.Jsii$Proxy that = (UpsolverDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!s3OutputFormatConfig.equals(that.s3OutputFormatConfig)) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.s3OutputFormatConfig.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that determines how Amazon AppFlow formats the flow output data when Upsolver is used as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * UpsolverS3OutputFormatConfigProperty upsolverS3OutputFormatConfigProperty = UpsolverS3OutputFormatConfigProperty.builder()
     *         .prefixConfig(PrefixConfigProperty.builder()
     *                 .prefixFormat("prefixFormat")
     *                 .prefixType("prefixType")
     *                 .build())
     *         // the properties below are optional
     *         .aggregationConfig(AggregationConfigProperty.builder()
     *                 .aggregationType("aggregationType")
     *                 .build())
     *         .fileType("fileType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UpsolverS3OutputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpsolverS3OutputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the prefix that Amazon AppFlow applies to the destination folder name.
         * <p>
         * You can name your destination folders according to the flow frequency and date.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrefixConfig();

        /**
         * The aggregation settings that you can use to customize the output format of your flow data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationConfig() {
            return null;
        }

        /**
         * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpsolverS3OutputFormatConfigProperty> {
            java.lang.Object prefixConfig;
            java.lang.Object aggregationConfig;
            java.lang.String fileType;

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the destination folder name. This parameter is required.
             *                     You can name your destination folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.services.appflow.CfnFlow.PrefixConfigProperty prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the destination folder name. This parameter is required.
             *                     You can name your destination folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.IResolvable prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.services.appflow.CfnFlow.AggregationConfigProperty aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.IResolvable aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getFileType}
             * @param fileType Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileType(java.lang.String fileType) {
                this.fileType = fileType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpsolverS3OutputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpsolverS3OutputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpsolverS3OutputFormatConfigProperty {
            private final java.lang.Object prefixConfig;
            private final java.lang.Object aggregationConfig;
            private final java.lang.String fileType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefixConfig = software.amazon.jsii.Kernel.get(this, "prefixConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aggregationConfig = software.amazon.jsii.Kernel.get(this, "aggregationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileType = software.amazon.jsii.Kernel.get(this, "fileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefixConfig = java.util.Objects.requireNonNull(builder.prefixConfig, "prefixConfig is required");
                this.aggregationConfig = builder.aggregationConfig;
                this.fileType = builder.fileType;
            }

            @Override
            public final java.lang.Object getPrefixConfig() {
                return this.prefixConfig;
            }

            @Override
            public final java.lang.Object getAggregationConfig() {
                return this.aggregationConfig;
            }

            @Override
            public final java.lang.String getFileType() {
                return this.fileType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("prefixConfig", om.valueToTree(this.getPrefixConfig()));
                if (this.getAggregationConfig() != null) {
                    data.set("aggregationConfig", om.valueToTree(this.getAggregationConfig()));
                }
                if (this.getFileType() != null) {
                    data.set("fileType", om.valueToTree(this.getFileType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpsolverS3OutputFormatConfigProperty.Jsii$Proxy that = (UpsolverS3OutputFormatConfigProperty.Jsii$Proxy) o;

                if (!prefixConfig.equals(that.prefixConfig)) return false;
                if (this.aggregationConfig != null ? !this.aggregationConfig.equals(that.aggregationConfig) : that.aggregationConfig != null) return false;
                return this.fileType != null ? this.fileType.equals(that.fileType) : that.fileType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefixConfig.hashCode();
                result = 31 * result + (this.aggregationConfig != null ? this.aggregationConfig.hashCode() : 0);
                result = 31 * result + (this.fileType != null ? this.fileType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Veeva as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaSourcePropertiesProperty veevaSourcePropertiesProperty = VeevaSourcePropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .documentType("documentType")
     *         .includeAllVersions(false)
     *         .includeRenditions(false)
     *         .includeSourceFiles(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.VeevaSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Veeva flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The document type specified in the Veeva document extract flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentType() {
            return null;
        }

        /**
         * Boolean value to include All Versions of files in Veeva document extract flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeAllVersions() {
            return null;
        }

        /**
         * Boolean value to include file renditions in Veeva document extract flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeRenditions() {
            return null;
        }

        /**
         * Boolean value to include source files in Veeva document extract flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSourceFiles() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaSourcePropertiesProperty> {
            java.lang.String object;
            java.lang.String documentType;
            java.lang.Object includeAllVersions;
            java.lang.Object includeRenditions;
            java.lang.Object includeSourceFiles;

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getObject}
             * @param object The object specified in the Veeva flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getDocumentType}
             * @param documentType The document type specified in the Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentType(java.lang.String documentType) {
                this.documentType = documentType;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeAllVersions}
             * @param includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAllVersions(java.lang.Boolean includeAllVersions) {
                this.includeAllVersions = includeAllVersions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeAllVersions}
             * @param includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAllVersions(software.amazon.awscdk.IResolvable includeAllVersions) {
                this.includeAllVersions = includeAllVersions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeRenditions}
             * @param includeRenditions Boolean value to include file renditions in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRenditions(java.lang.Boolean includeRenditions) {
                this.includeRenditions = includeRenditions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeRenditions}
             * @param includeRenditions Boolean value to include file renditions in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRenditions(software.amazon.awscdk.IResolvable includeRenditions) {
                this.includeRenditions = includeRenditions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeSourceFiles}
             * @param includeSourceFiles Boolean value to include source files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSourceFiles(java.lang.Boolean includeSourceFiles) {
                this.includeSourceFiles = includeSourceFiles;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeSourceFiles}
             * @param includeSourceFiles Boolean value to include source files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSourceFiles(software.amazon.awscdk.IResolvable includeSourceFiles) {
                this.includeSourceFiles = includeSourceFiles;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaSourcePropertiesProperty {
            private final java.lang.String object;
            private final java.lang.String documentType;
            private final java.lang.Object includeAllVersions;
            private final java.lang.Object includeRenditions;
            private final java.lang.Object includeSourceFiles;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentType = software.amazon.jsii.Kernel.get(this, "documentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeAllVersions = software.amazon.jsii.Kernel.get(this, "includeAllVersions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeRenditions = software.amazon.jsii.Kernel.get(this, "includeRenditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSourceFiles = software.amazon.jsii.Kernel.get(this, "includeSourceFiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.documentType = builder.documentType;
                this.includeAllVersions = builder.includeAllVersions;
                this.includeRenditions = builder.includeRenditions;
                this.includeSourceFiles = builder.includeSourceFiles;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getDocumentType() {
                return this.documentType;
            }

            @Override
            public final java.lang.Object getIncludeAllVersions() {
                return this.includeAllVersions;
            }

            @Override
            public final java.lang.Object getIncludeRenditions() {
                return this.includeRenditions;
            }

            @Override
            public final java.lang.Object getIncludeSourceFiles() {
                return this.includeSourceFiles;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getDocumentType() != null) {
                    data.set("documentType", om.valueToTree(this.getDocumentType()));
                }
                if (this.getIncludeAllVersions() != null) {
                    data.set("includeAllVersions", om.valueToTree(this.getIncludeAllVersions()));
                }
                if (this.getIncludeRenditions() != null) {
                    data.set("includeRenditions", om.valueToTree(this.getIncludeRenditions()));
                }
                if (this.getIncludeSourceFiles() != null) {
                    data.set("includeSourceFiles", om.valueToTree(this.getIncludeSourceFiles()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.VeevaSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaSourcePropertiesProperty.Jsii$Proxy that = (VeevaSourcePropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) return false;
                if (this.includeAllVersions != null ? !this.includeAllVersions.equals(that.includeAllVersions) : that.includeAllVersions != null) return false;
                if (this.includeRenditions != null ? !this.includeRenditions.equals(that.includeRenditions) : that.includeRenditions != null) return false;
                return this.includeSourceFiles != null ? this.includeSourceFiles.equals(that.includeSourceFiles) : that.includeSourceFiles == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
                result = 31 * result + (this.includeAllVersions != null ? this.includeAllVersions.hashCode() : 0);
                result = 31 * result + (this.includeRenditions != null ? this.includeRenditions.hashCode() : 0);
                result = 31 * result + (this.includeSourceFiles != null ? this.includeSourceFiles.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Zendesk is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskDestinationPropertiesProperty zendeskDestinationPropertiesProperty = ZendeskDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ZendeskDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Zendesk flow destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * The possible write operations in the destination connector.
         * <p>
         * When this value is not provided, this defaults to the <code>INSERT</code> operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Zendesk flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames A list of field names that can be used as an ID field when performing a write operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType The possible write operations in the destination connector.
             *                           When this value is not provided, this defaults to the <code>INSERT</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ZendeskDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskDestinationPropertiesProperty.Jsii$Proxy that = (ZendeskDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Zendesk as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskSourcePropertiesProperty zendeskSourcePropertiesProperty = ZendeskSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ZendeskSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Zendesk flow source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ZendeskSourcePropertiesProperty#getObject}
             * @param object The object specified in the Zendesk flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ZendeskSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskSourcePropertiesProperty.Jsii$Proxy that = (ZendeskSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appflow.CfnFlow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appflow.CfnFlow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appflow.CfnFlowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appflow.CfnFlowProps.Builder();
        }

        /**
         * The configuration that controls how Amazon AppFlow places data in the destination connector.
         * <p>
         * @return {@code this}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(final software.amazon.awscdk.IResolvable destinationFlowConfigList) {
            this.props.destinationFlowConfigList(destinationFlowConfigList);
            return this;
        }
        /**
         * The configuration that controls how Amazon AppFlow places data in the destination connector.
         * <p>
         * @return {@code this}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(final java.util.List<? extends java.lang.Object> destinationFlowConfigList) {
            this.props.destinationFlowConfigList(destinationFlowConfigList);
            return this;
        }

        /**
         * The specified name of the flow.
         * <p>
         * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * <p>
         * @return {@code this}
         * @param flowName The specified name of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowName(final java.lang.String flowName) {
            this.props.flowName(flowName);
            return this;
        }

        /**
         * Contains information about the configuration of the source connector used in the flow.
         * <p>
         * @return {@code this}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(final software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty sourceFlowConfig) {
            this.props.sourceFlowConfig(sourceFlowConfig);
            return this;
        }
        /**
         * Contains information about the configuration of the source connector used in the flow.
         * <p>
         * @return {@code this}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(final software.amazon.awscdk.IResolvable sourceFlowConfig) {
            this.props.sourceFlowConfig(sourceFlowConfig);
            return this;
        }

        /**
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * <p>
         * @return {@code this}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(final software.amazon.awscdk.IResolvable tasks) {
            this.props.tasks(tasks);
            return this;
        }
        /**
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * <p>
         * @return {@code this}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(final java.util.List<? extends java.lang.Object> tasks) {
            this.props.tasks(tasks);
            return this;
        }

        /**
         * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
         * <p>
         * @return {@code this}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(final software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty triggerConfig) {
            this.props.triggerConfig(triggerConfig);
            return this;
        }
        /**
         * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
         * <p>
         * @return {@code this}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(final software.amazon.awscdk.IResolvable triggerConfig) {
            this.props.triggerConfig(triggerConfig);
            return this;
        }

        /**
         * A user-entered description of the flow.
         * <p>
         * @return {@code this}
         * @param description A user-entered description of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         * <p>
         * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * <p>
         * @return {@code this}
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(final java.lang.String kmsArn) {
            this.props.kmsArn(kmsArn);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for your flow.
         * <p>
         * @return {@code this}
         * @param tags The tags used to organize, track, or control access for your flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appflow.CfnFlow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appflow.CfnFlow build() {
            return new software.amazon.awscdk.services.appflow.CfnFlow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
