package software.amazon.awscdk.services.apigateway;

/**
 * Props to instantiate a new SpecRestApi.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Integration integration;
 * SpecRestApi api = SpecRestApi.Builder.create(this, "books-api")
 *         .apiDefinition(ApiDefinition.fromAsset("path-to-file.json"))
 *         .build();
 * Resource booksResource = api.root.addResource("books");
 * booksResource.addMethod("GET", integration);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.727Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.SpecRestApiProps")
@software.amazon.jsii.Jsii.Proxy(SpecRestApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SpecRestApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.RestApiBaseProps {

    /**
     * An OpenAPI definition compatible with API Gateway.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ApiDefinition getApiDefinition();

    /**
     * @return a {@link Builder} of {@link SpecRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SpecRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SpecRestApiProps> {
        software.amazon.awscdk.services.apigateway.ApiDefinition apiDefinition;
        java.lang.Boolean cloudWatchRole;
        java.lang.Boolean deploy;
        software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        java.lang.String description;
        java.lang.Boolean disableExecuteApiEndpoint;
        software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        java.lang.String endpointExportName;
        java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        java.lang.Boolean failOnWarnings;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        software.amazon.awscdk.services.iam.PolicyDocument policy;
        java.lang.String restApiName;
        java.lang.Boolean retainDeployments;

        /**
         * Sets the value of {@link SpecRestApiProps#getApiDefinition}
         * @param apiDefinition An OpenAPI definition compatible with API Gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDefinition(software.amazon.awscdk.services.apigateway.ApiDefinition apiDefinition) {
            this.apiDefinition = apiDefinition;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getCloudWatchRole}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(java.lang.Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getDeploy}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         *               Since API Gateway deployments are immutable, When this option is enabled
         *               (by default), an AWS::ApiGateway::Deployment resource will automatically
         *               created with a logical ID that hashes the API model (methods, resources
         *               and options). This means that when the model changes, the logical ID of
         *               this CloudFormation resource will change, and a new deployment will be
         *               created.
         *               <p>
         *               If this is set, <code>latestDeployment</code> will refer to the <code>Deployment</code> object
         *               and <code>deploymentStage</code> will refer to a <code>Stage</code> that points to this
         *               deployment. To customize the stage options, use the <code>deployOptions</code>
         *               property.
         *               <p>
         *               A CloudFormation Output will also be defined with the root URL endpoint
         *               of this REST API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(java.lang.Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getDeployOptions}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         *                      If <code>deploy</code> is disabled,
         *                      this value cannot be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getDescription}
         * @param description A description of the RestApi construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke the API using the default execute-api endpoint.
         *                                  To require that clients use a custom domain name to invoke the
         *                                  API, disable the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getDomainName}
         * @param domainName Configure a custom domain name and map it to this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getEndpointExportName}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(java.lang.String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getEndpointTypes}
         * @param endpointTypes A list of the endpoint types of the API.
         *                      Use this property when creating
         *                      an API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder endpointTypes(java.util.List<? extends software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.endpointTypes = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)endpointTypes;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getFailOnWarnings}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getParameters}
         * @param parameters Custom header parameters for the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getPolicy}
         * @param policy A policy document that contains the permissions for this RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getRestApiName}
         * @param restApiName A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(java.lang.String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        /**
         * Sets the value of {@link SpecRestApiProps#getRetainDeployments}
         * @param retainDeployments Retains old deployment resources when the API changes.
         *                          This allows
         *                          manually reverting stages to point to old deployments via the AWS
         *                          Console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(java.lang.Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SpecRestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SpecRestApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SpecRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpecRestApiProps {
        private final software.amazon.awscdk.services.apigateway.ApiDefinition apiDefinition;
        private final java.lang.Boolean cloudWatchRole;
        private final java.lang.Boolean deploy;
        private final software.amazon.awscdk.services.apigateway.StageOptions deployOptions;
        private final java.lang.String description;
        private final java.lang.Boolean disableExecuteApiEndpoint;
        private final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName;
        private final java.lang.String endpointExportName;
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes;
        private final java.lang.Boolean failOnWarnings;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final java.lang.String restApiName;
        private final java.lang.Boolean retainDeployments;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiDefinition = software.amazon.jsii.Kernel.get(this, "apiDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ApiDefinition.class));
            this.cloudWatchRole = software.amazon.jsii.Kernel.get(this, "cloudWatchRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deploy = software.amazon.jsii.Kernel.get(this, "deploy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deployOptions = software.amazon.jsii.Kernel.get(this, "deployOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.StageOptions.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.DomainNameOptions.class));
            this.endpointExportName = software.amazon.jsii.Kernel.get(this, "endpointExportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointTypes = software.amazon.jsii.Kernel.get(this, "endpointTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class)));
            this.failOnWarnings = software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.restApiName = software.amazon.jsii.Kernel.get(this, "restApiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retainDeployments = software.amazon.jsii.Kernel.get(this, "retainDeployments", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiDefinition = java.util.Objects.requireNonNull(builder.apiDefinition, "apiDefinition is required");
            this.cloudWatchRole = builder.cloudWatchRole;
            this.deploy = builder.deploy;
            this.deployOptions = builder.deployOptions;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.domainName = builder.domainName;
            this.endpointExportName = builder.endpointExportName;
            this.endpointTypes = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)builder.endpointTypes;
            this.failOnWarnings = builder.failOnWarnings;
            this.parameters = builder.parameters;
            this.policy = builder.policy;
            this.restApiName = builder.restApiName;
            this.retainDeployments = builder.retainDeployments;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ApiDefinition getApiDefinition() {
            return this.apiDefinition;
        }

        @Override
        public final java.lang.Boolean getCloudWatchRole() {
            return this.cloudWatchRole;
        }

        @Override
        public final java.lang.Boolean getDeploy() {
            return this.deploy;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.deployOptions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.DomainNameOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getEndpointExportName() {
            return this.endpointExportName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.endpointTypes;
        }

        @Override
        public final java.lang.Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.String getRestApiName() {
            return this.restApiName;
        }

        @Override
        public final java.lang.Boolean getRetainDeployments() {
            return this.retainDeployments;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiDefinition", om.valueToTree(this.getApiDefinition()));
            if (this.getCloudWatchRole() != null) {
                data.set("cloudWatchRole", om.valueToTree(this.getCloudWatchRole()));
            }
            if (this.getDeploy() != null) {
                data.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDeployOptions() != null) {
                data.set("deployOptions", om.valueToTree(this.getDeployOptions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEndpointExportName() != null) {
                data.set("endpointExportName", om.valueToTree(this.getEndpointExportName()));
            }
            if (this.getEndpointTypes() != null) {
                data.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRestApiName() != null) {
                data.set("restApiName", om.valueToTree(this.getRestApiName()));
            }
            if (this.getRetainDeployments() != null) {
                data.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.SpecRestApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SpecRestApiProps.Jsii$Proxy that = (SpecRestApiProps.Jsii$Proxy) o;

            if (!apiDefinition.equals(that.apiDefinition)) return false;
            if (this.cloudWatchRole != null ? !this.cloudWatchRole.equals(that.cloudWatchRole) : that.cloudWatchRole != null) return false;
            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            if (this.deployOptions != null ? !this.deployOptions.equals(that.deployOptions) : that.deployOptions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.endpointExportName != null ? !this.endpointExportName.equals(that.endpointExportName) : that.endpointExportName != null) return false;
            if (this.endpointTypes != null ? !this.endpointTypes.equals(that.endpointTypes) : that.endpointTypes != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.restApiName != null ? !this.restApiName.equals(that.restApiName) : that.restApiName != null) return false;
            return this.retainDeployments != null ? this.retainDeployments.equals(that.retainDeployments) : that.retainDeployments == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiDefinition.hashCode();
            result = 31 * result + (this.cloudWatchRole != null ? this.cloudWatchRole.hashCode() : 0);
            result = 31 * result + (this.deploy != null ? this.deploy.hashCode() : 0);
            result = 31 * result + (this.deployOptions != null ? this.deployOptions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.endpointExportName != null ? this.endpointExportName.hashCode() : 0);
            result = 31 * result + (this.endpointTypes != null ? this.endpointTypes.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.restApiName != null ? this.restApiName.hashCode() : 0);
            result = 31 * result + (this.retainDeployments != null ? this.retainDeployments.hashCode() : 0);
            return result;
        }
    }
}
