package software.amazon.awscdk.pipelines;

/**
 * Construction props for a CodeBuildStep.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(CodeBuildStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("...", "npm ci", "npm run build", "npx cdk synth", "..."))
 *                 .rolePolicyStatements(List.of(
 *                     PolicyStatement.Builder.create()
 *                             .actions(List.of("sts:AssumeRole"))
 *                             .resources(List.of("*"))
 *                             .conditions(Map.of(
 *                                     "StringEquals", Map.of(
 *                                             "iam:ResourceTag/aws-cdk:bootstrap-role", "lookup")))
 *                             .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:11.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodeBuildStepProps")
@software.amazon.jsii.Jsii.Proxy(CodeBuildStepProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeBuildStepProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.pipelines.ShellStepProps {

    /**
     * Custom execution role to be used for the Code Build Action.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getActionRole() {
        return null;
    }

    /**
     * Changes to environment.
     * <p>
     * This environment will be combined with the pipeline's default
     * environment.
     * <p>
     * Default: - Use the pipeline's default build environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
        return null;
    }

    /**
     * Caching strategy to use.
     * <p>
     * Default: - No cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.Cache getCache() {
        return null;
    }

    /**
     * Additional configuration that can only be configured via BuildSpec.
     * <p>
     * You should not use this to specify output artifacts; those
     * should be supplied via the other properties of this class, otherwise
     * CDK Pipelines won't be able to inspect the artifacts.
     * <p>
     * Set the <code>commands</code> to an empty array if you want to fully specify
     * the BuildSpec using this field.
     * <p>
     * The BuildSpec must be available inline--it cannot reference a file
     * on disk.
     * <p>
     * Default: - BuildSpec completely derived from other properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
        return null;
    }

    /**
     * Name for the generated CodeBuild project.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return null;
    }

    /**
     * Custom execution role to be used for the CodeBuild project.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Policy statements to add to role used during the synth.
     * <p>
     * Can be used to add acces to a CodeArtifact repository etc.
     * <p>
     * Default: - No policy statements added to CodeBuild Project Role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicyStatements() {
        return null;
    }

    /**
     * Which security group to associate with the script's project network interfaces.
     * <p>
     * If no security group is identified, one will be created automatically.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - Security group will be automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The VPC where to execute the SimpleSynth.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeBuildStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeBuildStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeBuildStepProps> {
        software.amazon.awscdk.services.iam.IRole actionRole;
        software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        software.amazon.awscdk.services.codebuild.Cache cache;
        software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        java.lang.String projectName;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<java.lang.String> commands;
        java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs;
        java.util.Map<java.lang.String, java.lang.String> env;
        java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> envFromCfnOutputs;
        software.amazon.awscdk.pipelines.IFileSetProducer input;
        java.util.List<java.lang.String> installCommands;
        java.lang.String primaryOutputDirectory;

        /**
         * Sets the value of {@link CodeBuildStepProps#getActionRole}
         * @param actionRole Custom execution role to be used for the Code Build Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionRole(software.amazon.awscdk.services.iam.IRole actionRole) {
            this.actionRole = actionRole;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getBuildEnvironment}
         * @param buildEnvironment Changes to environment.
         *                         This environment will be combined with the pipeline's default
         *                         environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildEnvironment(software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            this.buildEnvironment = buildEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getCache}
         * @param cache Caching strategy to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(software.amazon.awscdk.services.codebuild.Cache cache) {
            this.cache = cache;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getPartialBuildSpec}
         * @param partialBuildSpec Additional configuration that can only be configured via BuildSpec.
         *                         You should not use this to specify output artifacts; those
         *                         should be supplied via the other properties of this class, otherwise
         *                         CDK Pipelines won't be able to inspect the artifacts.
         *                         <p>
         *                         Set the <code>commands</code> to an empty array if you want to fully specify
         *                         the BuildSpec using this field.
         *                         <p>
         *                         The BuildSpec must be available inline--it cannot reference a file
         *                         on disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partialBuildSpec(software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec) {
            this.partialBuildSpec = partialBuildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getProjectName}
         * @param projectName Name for the generated CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getRole}
         * @param role Custom execution role to be used for the CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getRolePolicyStatements}
         * @param rolePolicyStatements Policy statements to add to role used during the synth.
         *                             Can be used to add acces to a CodeArtifact repository etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rolePolicyStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements) {
            this.rolePolicyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)rolePolicyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getSecurityGroups}
         * @param securityGroups Which security group to associate with the script's project network interfaces.
         *                       If no security group is identified, one will be created automatically.
         *                       <p>
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getVpc}
         * @param vpc The VPC where to execute the SimpleSynth.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getCommands}
         * @param commands Commands to run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(java.util.List<java.lang.String> commands) {
            this.commands = commands;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getAdditionalInputs}
         * @param additionalInputs Additional FileSets to put in other directories.
         *                         Specifies a mapping from directory name to FileSets. During the
         *                         script execution, the FileSets will be available in the directories
         *                         indicated.
         *                         <p>
         *                         The directory names may be relative. For example, you can put
         *                         the main input and an additional input side-by-side with the
         *                         following configuration:
         *                         <p>
         *                         <blockquote><pre>
         *                         ShellStep script = ShellStep.Builder.create("MainScript")
         *                                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
         *                                 .input(CodePipelineSource.gitHub("org/source1", "main"))
         *                                 .additionalInputs(Map.of(
         *                                         "../siblingdir", CodePipelineSource.gitHub("org/source2", "main")))
         *                                 .build();
         *                         </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalInputs(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs) {
            this.additionalInputs = (java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer>)additionalInputs;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getEnv}
         * @param env Environment variables to set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.Map<java.lang.String, java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getEnvFromCfnOutputs}
         * @param envFromCfnOutputs Set environment variables based on Stack Outputs.
         *                          <code>ShellStep</code>s following stack or stage deployments may
         *                          access the <code>CfnOutput</code>s of those stacks to get access to
         *                          --for example--automatically generated resource names or
         *                          endpoint URLs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder envFromCfnOutputs(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.CfnOutput> envFromCfnOutputs) {
            this.envFromCfnOutputs = (java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput>)envFromCfnOutputs;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getInput}
         * @param input FileSet to run these scripts on.
         *              The files in the FileSet will be placed in the working directory when
         *              the script is executed. Use <code>additionalInputs</code> to download file sets
         *              to other directories as well.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.pipelines.IFileSetProducer input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getInstallCommands}
         * @param installCommands Installation commands to run before the regular commands.
         *                        For deployment engines that support it, install commands will be classified
         *                        differently in the job history from the regular <code>commands</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installCommands(java.util.List<java.lang.String> installCommands) {
            this.installCommands = installCommands;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildStepProps#getPrimaryOutputDirectory}
         * @param primaryOutputDirectory The directory that will contain the primary output fileset.
         *                               After running the script, the contents of the given directory
         *                               will be treated as the primary output of this Step.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryOutputDirectory(java.lang.String primaryOutputDirectory) {
            this.primaryOutputDirectory = primaryOutputDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeBuildStepProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeBuildStepProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeBuildStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeBuildStepProps {
        private final software.amazon.awscdk.services.iam.IRole actionRole;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        private final software.amazon.awscdk.services.codebuild.Cache cache;
        private final software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        private final java.lang.String projectName;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<java.lang.String> commands;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs;
        private final java.util.Map<java.lang.String, java.lang.String> env;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> envFromCfnOutputs;
        private final software.amazon.awscdk.pipelines.IFileSetProducer input;
        private final java.util.List<java.lang.String> installCommands;
        private final java.lang.String primaryOutputDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionRole = software.amazon.jsii.Kernel.get(this, "actionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.buildEnvironment = software.amazon.jsii.Kernel.get(this, "buildEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.cache = software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
            this.partialBuildSpec = software.amazon.jsii.Kernel.get(this, "partialBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.rolePolicyStatements = software.amazon.jsii.Kernel.get(this, "rolePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.additionalInputs = software.amazon.jsii.Kernel.get(this, "additionalInputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class)));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envFromCfnOutputs = software.amazon.jsii.Kernel.get(this, "envFromCfnOutputs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnOutput.class)));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
            this.installCommands = software.amazon.jsii.Kernel.get(this, "installCommands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.primaryOutputDirectory = software.amazon.jsii.Kernel.get(this, "primaryOutputDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionRole = builder.actionRole;
            this.buildEnvironment = builder.buildEnvironment;
            this.cache = builder.cache;
            this.partialBuildSpec = builder.partialBuildSpec;
            this.projectName = builder.projectName;
            this.role = builder.role;
            this.rolePolicyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.rolePolicyStatements;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.timeout = builder.timeout;
            this.vpc = builder.vpc;
            this.commands = java.util.Objects.requireNonNull(builder.commands, "commands is required");
            this.additionalInputs = (java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer>)builder.additionalInputs;
            this.env = builder.env;
            this.envFromCfnOutputs = (java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput>)builder.envFromCfnOutputs;
            this.input = builder.input;
            this.installCommands = builder.installCommands;
            this.primaryOutputDirectory = builder.primaryOutputDirectory;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getActionRole() {
            return this.actionRole;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
            return this.buildEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.Cache getCache() {
            return this.cache;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
            return this.partialBuildSpec;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicyStatements() {
            return this.rolePolicyStatements;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<java.lang.String> getCommands() {
            return this.commands;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.pipelines.IFileSetProducer> getAdditionalInputs() {
            return this.additionalInputs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.CfnOutput> getEnvFromCfnOutputs() {
            return this.envFromCfnOutputs;
        }

        @Override
        public final software.amazon.awscdk.pipelines.IFileSetProducer getInput() {
            return this.input;
        }

        @Override
        public final java.util.List<java.lang.String> getInstallCommands() {
            return this.installCommands;
        }

        @Override
        public final java.lang.String getPrimaryOutputDirectory() {
            return this.primaryOutputDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActionRole() != null) {
                data.set("actionRole", om.valueToTree(this.getActionRole()));
            }
            if (this.getBuildEnvironment() != null) {
                data.set("buildEnvironment", om.valueToTree(this.getBuildEnvironment()));
            }
            if (this.getCache() != null) {
                data.set("cache", om.valueToTree(this.getCache()));
            }
            if (this.getPartialBuildSpec() != null) {
                data.set("partialBuildSpec", om.valueToTree(this.getPartialBuildSpec()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getRolePolicyStatements() != null) {
                data.set("rolePolicyStatements", om.valueToTree(this.getRolePolicyStatements()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            data.set("commands", om.valueToTree(this.getCommands()));
            if (this.getAdditionalInputs() != null) {
                data.set("additionalInputs", om.valueToTree(this.getAdditionalInputs()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvFromCfnOutputs() != null) {
                data.set("envFromCfnOutputs", om.valueToTree(this.getEnvFromCfnOutputs()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getInstallCommands() != null) {
                data.set("installCommands", om.valueToTree(this.getInstallCommands()));
            }
            if (this.getPrimaryOutputDirectory() != null) {
                data.set("primaryOutputDirectory", om.valueToTree(this.getPrimaryOutputDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CodeBuildStepProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeBuildStepProps.Jsii$Proxy that = (CodeBuildStepProps.Jsii$Proxy) o;

            if (this.actionRole != null ? !this.actionRole.equals(that.actionRole) : that.actionRole != null) return false;
            if (this.buildEnvironment != null ? !this.buildEnvironment.equals(that.buildEnvironment) : that.buildEnvironment != null) return false;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) return false;
            if (this.partialBuildSpec != null ? !this.partialBuildSpec.equals(that.partialBuildSpec) : that.partialBuildSpec != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.rolePolicyStatements != null ? !this.rolePolicyStatements.equals(that.rolePolicyStatements) : that.rolePolicyStatements != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (!commands.equals(that.commands)) return false;
            if (this.additionalInputs != null ? !this.additionalInputs.equals(that.additionalInputs) : that.additionalInputs != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envFromCfnOutputs != null ? !this.envFromCfnOutputs.equals(that.envFromCfnOutputs) : that.envFromCfnOutputs != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.installCommands != null ? !this.installCommands.equals(that.installCommands) : that.installCommands != null) return false;
            return this.primaryOutputDirectory != null ? this.primaryOutputDirectory.equals(that.primaryOutputDirectory) : that.primaryOutputDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionRole != null ? this.actionRole.hashCode() : 0;
            result = 31 * result + (this.buildEnvironment != null ? this.buildEnvironment.hashCode() : 0);
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            result = 31 * result + (this.partialBuildSpec != null ? this.partialBuildSpec.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.rolePolicyStatements != null ? this.rolePolicyStatements.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.commands.hashCode());
            result = 31 * result + (this.additionalInputs != null ? this.additionalInputs.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envFromCfnOutputs != null ? this.envFromCfnOutputs.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.installCommands != null ? this.installCommands.hashCode() : 0);
            result = 31 * result + (this.primaryOutputDirectory != null ? this.primaryOutputDirectory.hashCode() : 0);
            return result;
        }
    }
}
