package software.amazon.awscdk.assertions;

/**
 * Partial and special matching during template assertions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.479Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Match")
public abstract class Match extends software.amazon.jsii.JsiiObject {

    protected Match(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Match(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Match() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use this matcher in the place of a field's value, if the field must not be present.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher absent() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "absent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class));
    }

    /**
     * Matches any non-null value at the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher anyValue() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "anyValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class));
    }

    /**
     * Matches the specified pattern with the array found in the same relative path of the target.
     * <p>
     * The set of elements (or matchers) must match exactly and in order.
     * <p>
     * @param pattern the pattern to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher arrayEquals(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "arrayEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Matches the specified pattern with the array found in the same relative path of the target.
     * <p>
     * The set of elements (or matchers) must be in the same order as would be found.
     * <p>
     * @param pattern the pattern to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher arrayWith(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "arrayWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Deep exact matching of the specified pattern to the target.
     * <p>
     * @param pattern the pattern to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher exact(final @org.jetbrains.annotations.NotNull java.lang.Object pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "exact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { pattern });
    }

    /**
     * Matches any target which does NOT follow the specified pattern.
     * <p>
     * @param pattern the pattern to NOT match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher not(final @org.jetbrains.annotations.NotNull java.lang.Object pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "not", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { pattern });
    }

    /**
     * Matches the specified pattern to an object found in the same relative path of the target.
     * <p>
     * The keys and their values (or matchers) must match exactly with the target.
     * <p>
     * @param pattern the pattern to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher objectEquals(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "objectEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Matches the specified pattern to an object found in the same relative path of the target.
     * <p>
     * The keys and their values (or matchers) must be present in the target but the target can be a superset.
     * <p>
     * @param pattern the pattern to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher objectLike(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "objectLike", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Matches any string-encoded JSON and applies the specified pattern after parsing it.
     * <p>
     * @param pattern the pattern to match after parsing the encoded JSON. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher serializedJson(final @org.jetbrains.annotations.NotNull java.lang.Object pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "serializedJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { pattern });
    }

    /**
     * Matches targets according to a regular expression.
     * <p>
     * @param pattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher stringLikeRegexp(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Match.class, "stringLikeRegexp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.assertions.Match {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
