/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.CodeBuildProjectProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_events_targets.CodeBuildProject")
public class CodeBuildProject
extends JsiiObject
implements IRuleTarget {
    protected CodeBuildProject(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeBuildProject(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CodeBuildProject(@NotNull IProject project, @Nullable CodeBuildProjectProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), props});
    }

    public CodeBuildProject(@NotNull IProject project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodeBuildProject> {
        private final IProject project;
        private CodeBuildProjectProps.Builder props;

        public static Builder create(IProject project) {
            return new Builder(project);
        }

        private Builder(IProject project) {
            this.project = project;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder event(RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        public Builder eventRole(IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        public CodeBuildProject build() {
            return new CodeBuildProject(this.project, this.props != null ? this.props.build() : null);
        }

        private CodeBuildProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new CodeBuildProjectProps.Builder();
            }
            return this.props;
        }
    }
}

