package software.amazon.awscdk.services.xray;

/**
 * A CloudFormation `AWS::XRay::SamplingRule`.
 * <p>
 * Use the <code>AWS::XRay::SamplingRule</code> resource to specify a sampling rule, which controls sampling behavior for instrumented applications. A new sampling rule is created by specifying a <code>SamplingRule</code> . To change the configuration of an existing sampling rule, specify a <code>SamplingRuleUpdate</code> .
 * <p>
 * Services retrieve rules with <a href="https://docs.aws.amazon.com//xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a> , and evaluate each rule in ascending order of <em>priority</em> for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with <a href="https://docs.aws.amazon.com//xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.xray.*;
 * Object tags;
 * CfnSamplingRule cfnSamplingRule = CfnSamplingRule.Builder.create(this, "MyCfnSamplingRule")
 *         .ruleName("ruleName")
 *         .samplingRule(SamplingRuleProperty.builder()
 *                 .attributes(Map.of(
 *                         "attributesKey", "attributes"))
 *                 .fixedRate(123)
 *                 .host("host")
 *                 .httpMethod("httpMethod")
 *                 .priority(123)
 *                 .reservoirSize(123)
 *                 .resourceArn("resourceArn")
 *                 .ruleArn("ruleArn")
 *                 .ruleName("ruleName")
 *                 .serviceName("serviceName")
 *                 .serviceType("serviceType")
 *                 .urlPath("urlPath")
 *                 .version(123)
 *                 .build())
 *         .samplingRuleRecord(SamplingRuleRecordProperty.builder()
 *                 .createdAt("createdAt")
 *                 .modifiedAt("modifiedAt")
 *                 .samplingRule(SamplingRuleProperty.builder()
 *                         .attributes(Map.of(
 *                                 "attributesKey", "attributes"))
 *                         .fixedRate(123)
 *                         .host("host")
 *                         .httpMethod("httpMethod")
 *                         .priority(123)
 *                         .reservoirSize(123)
 *                         .resourceArn("resourceArn")
 *                         .ruleArn("ruleArn")
 *                         .ruleName("ruleName")
 *                         .serviceName("serviceName")
 *                         .serviceType("serviceType")
 *                         .urlPath("urlPath")
 *                         .version(123)
 *                         .build())
 *                 .build())
 *         .samplingRuleUpdate(SamplingRuleUpdateProperty.builder()
 *                 .attributes(Map.of(
 *                         "attributesKey", "attributes"))
 *                 .fixedRate(123)
 *                 .host("host")
 *                 .httpMethod("httpMethod")
 *                 .priority(123)
 *                 .reservoirSize(123)
 *                 .resourceArn("resourceArn")
 *                 .ruleArn("ruleArn")
 *                 .ruleName("ruleName")
 *                 .serviceName("serviceName")
 *                 .serviceType("serviceType")
 *                 .urlPath("urlPath")
 *                 .build())
 *         .tags(List.of(tags))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:42.835Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnSamplingRule")
public class CfnSamplingRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSamplingRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSamplingRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.xray.CfnSamplingRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::XRay::SamplingRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSamplingRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.xray.CfnSamplingRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::XRay::SamplingRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSamplingRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The sampling rule ARN that was created or updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the sampling rule.
     * <p>
     * Specify a rule by either name or ARN, but not both. Used only when deleting a sampling rule. When creating or updating a sampling rule, use the <code>RuleName</code> or <code>RuleARN</code> properties within <code>SamplingRule</code> or <code>SamplingRuleUpdate</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the sampling rule.
     * <p>
     * Specify a rule by either name or ARN, but not both. Used only when deleting a sampling rule. When creating or updating a sampling rule, use the <code>RuleName</code> or <code>RuleARN</code> properties within <code>SamplingRule</code> or <code>SamplingRuleUpdate</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", value);
    }

    /**
     * The sampling rule to be created.
     * <p>
     * Must be provided if creating a new sampling rule. Not valid when updating an existing sampling rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSamplingRule() {
        return software.amazon.jsii.Kernel.get(this, "samplingRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The sampling rule to be created.
     * <p>
     * Must be provided if creating a new sampling rule. Not valid when updating an existing sampling rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "samplingRule", value);
    }

    /**
     * The sampling rule to be created.
     * <p>
     * Must be provided if creating a new sampling rule. Not valid when updating an existing sampling rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "samplingRule", value);
    }

    /**
     * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSamplingRuleRecord() {
        return software.amazon.jsii.Kernel.get(this, "samplingRuleRecord", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRuleRecord(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleRecordProperty value) {
        software.amazon.jsii.Kernel.set(this, "samplingRuleRecord", value);
    }

    /**
     * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRuleRecord(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "samplingRuleRecord", value);
    }

    /**
     * A document specifying changes to a sampling rule's configuration.
     * <p>
     * Must be provided if updating an existing sampling rule. Not valid when creating a new sampling rule.
     * <p>
     * <blockquote>
     * <p>
     * The <code>Version</code> of a sampling rule cannot be updated, and is not part of <code>SamplingRuleUpdate</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSamplingRuleUpdate() {
        return software.amazon.jsii.Kernel.get(this, "samplingRuleUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A document specifying changes to a sampling rule's configuration.
     * <p>
     * Must be provided if updating an existing sampling rule. Not valid when creating a new sampling rule.
     * <p>
     * <blockquote>
     * <p>
     * The <code>Version</code> of a sampling rule cannot be updated, and is not part of <code>SamplingRuleUpdate</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRuleUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleUpdateProperty value) {
        software.amazon.jsii.Kernel.set(this, "samplingRuleUpdate", value);
    }

    /**
     * A document specifying changes to a sampling rule's configuration.
     * <p>
     * Must be provided if updating an existing sampling rule. Not valid when creating a new sampling rule.
     * <p>
     * <blockquote>
     * <p>
     * The <code>Version</code> of a sampling rule cannot be updated, and is not part of <code>SamplingRuleUpdate</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRuleUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "samplingRuleUpdate", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getTags() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A sampling rule that services use to decide whether to instrument a request.
     * <p>
     * Rule fields can match properties of the service, or properties of a request. The service can ignore rules that don't match its properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.xray.*;
     * SamplingRuleProperty samplingRuleProperty = SamplingRuleProperty.builder()
     *         .attributes(Map.of(
     *                 "attributesKey", "attributes"))
     *         .fixedRate(123)
     *         .host("host")
     *         .httpMethod("httpMethod")
     *         .priority(123)
     *         .reservoirSize(123)
     *         .resourceArn("resourceArn")
     *         .ruleArn("ruleArn")
     *         .ruleName("ruleName")
     *         .serviceName("serviceName")
     *         .serviceType("serviceType")
     *         .urlPath("urlPath")
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(SamplingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SamplingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Matches attributes derived from the request.
         * <p>
         * <em>Map Entries:</em> Maximum number of 5 items.
         * <p>
         * <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
         * <p>
         * <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFixedRate() {
            return null;
        }

        /**
         * Matches the hostname from a request URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * Matches the HTTP method of a request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * The priority of the sampling rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * A fixed number of matching requests to instrument per second, prior to applying the fixed rate.
         * <p>
         * The reservoir is not used directly by services, but applies to all services using the rule collectively.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReservoirSize() {
            return null;
        }

        /**
         * Matches the ARN of the AWS resource on which the service runs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceArn() {
            return null;
        }

        /**
         * The ARN of the sampling rule.
         * <p>
         * You must specify either RuleARN or RuleName, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleArn() {
            return null;
        }

        /**
         * The name of the sampling rule.
         * <p>
         * You must specify either RuleARN or RuleName, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
            return null;
        }

        /**
         * Matches the `name` that the service uses to identify itself in segments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * Matches the `origin` that the service uses to identify its type in segments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
            return null;
        }

        /**
         * Matches the path from a request URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrlPath() {
            return null;
        }

        /**
         * The version of the sampling rule format ( `1` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SamplingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SamplingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SamplingRuleProperty> {
            java.lang.Object attributes;
            java.lang.Number fixedRate;
            java.lang.String host;
            java.lang.String httpMethod;
            java.lang.Number priority;
            java.lang.Number reservoirSize;
            java.lang.String resourceArn;
            java.lang.String ruleArn;
            java.lang.String ruleName;
            java.lang.String serviceName;
            java.lang.String serviceType;
            java.lang.String urlPath;
            java.lang.Number version;

            /**
             * Sets the value of {@link SamplingRuleProperty#getAttributes}
             * @param attributes Matches attributes derived from the request.
             *                   <em>Map Entries:</em> Maximum number of 5 items.
             *                   <p>
             *                   <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             *                   <p>
             *                   <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getAttributes}
             * @param attributes Matches attributes derived from the request.
             *                   <em>Map Entries:</em> Maximum number of 5 items.
             *                   <p>
             *                   <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             *                   <p>
             *                   <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getFixedRate}
             * @param fixedRate The percentage of matching requests to instrument, after the reservoir is exhausted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedRate(java.lang.Number fixedRate) {
                this.fixedRate = fixedRate;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getHost}
             * @param host Matches the hostname from a request URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getHttpMethod}
             * @param httpMethod Matches the HTTP method of a request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getPriority}
             * @param priority The priority of the sampling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getReservoirSize}
             * @param reservoirSize A fixed number of matching requests to instrument per second, prior to applying the fixed rate.
             *                      The reservoir is not used directly by services, but applies to all services using the rule collectively.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reservoirSize(java.lang.Number reservoirSize) {
                this.reservoirSize = reservoirSize;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getResourceArn}
             * @param resourceArn Matches the ARN of the AWS resource on which the service runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getRuleArn}
             * @param ruleArn The ARN of the sampling rule.
             *                You must specify either RuleARN or RuleName, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleArn(java.lang.String ruleArn) {
                this.ruleArn = ruleArn;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getRuleName}
             * @param ruleName The name of the sampling rule.
             *                 You must specify either RuleARN or RuleName, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getServiceName}
             * @param serviceName Matches the `name` that the service uses to identify itself in segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getServiceType}
             * @param serviceType Matches the `origin` that the service uses to identify its type in segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceType(java.lang.String serviceType) {
                this.serviceType = serviceType;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getUrlPath}
             * @param urlPath Matches the path from a request URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlPath(java.lang.String urlPath) {
                this.urlPath = urlPath;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleProperty#getVersion}
             * @param version The version of the sampling rule format ( `1` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SamplingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SamplingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SamplingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SamplingRuleProperty {
            private final java.lang.Object attributes;
            private final java.lang.Number fixedRate;
            private final java.lang.String host;
            private final java.lang.String httpMethod;
            private final java.lang.Number priority;
            private final java.lang.Number reservoirSize;
            private final java.lang.String resourceArn;
            private final java.lang.String ruleArn;
            private final java.lang.String ruleName;
            private final java.lang.String serviceName;
            private final java.lang.String serviceType;
            private final java.lang.String urlPath;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fixedRate = software.amazon.jsii.Kernel.get(this, "fixedRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.reservoirSize = software.amazon.jsii.Kernel.get(this, "reservoirSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleArn = software.amazon.jsii.Kernel.get(this, "ruleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceType = software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.urlPath = software.amazon.jsii.Kernel.get(this, "urlPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
                this.fixedRate = builder.fixedRate;
                this.host = builder.host;
                this.httpMethod = builder.httpMethod;
                this.priority = builder.priority;
                this.reservoirSize = builder.reservoirSize;
                this.resourceArn = builder.resourceArn;
                this.ruleArn = builder.ruleArn;
                this.ruleName = builder.ruleName;
                this.serviceName = builder.serviceName;
                this.serviceType = builder.serviceType;
                this.urlPath = builder.urlPath;
                this.version = builder.version;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Number getFixedRate() {
                return this.fixedRate;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Number getReservoirSize() {
                return this.reservoirSize;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRuleArn() {
                return this.ruleArn;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.String getServiceType() {
                return this.serviceType;
            }

            @Override
            public final java.lang.String getUrlPath() {
                return this.urlPath;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getFixedRate() != null) {
                    data.set("fixedRate", om.valueToTree(this.getFixedRate()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getReservoirSize() != null) {
                    data.set("reservoirSize", om.valueToTree(this.getReservoirSize()));
                }
                if (this.getResourceArn() != null) {
                    data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                }
                if (this.getRuleArn() != null) {
                    data.set("ruleArn", om.valueToTree(this.getRuleArn()));
                }
                if (this.getRuleName() != null) {
                    data.set("ruleName", om.valueToTree(this.getRuleName()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }
                if (this.getServiceType() != null) {
                    data.set("serviceType", om.valueToTree(this.getServiceType()));
                }
                if (this.getUrlPath() != null) {
                    data.set("urlPath", om.valueToTree(this.getUrlPath()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SamplingRuleProperty.Jsii$Proxy that = (SamplingRuleProperty.Jsii$Proxy) o;

                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.fixedRate != null ? !this.fixedRate.equals(that.fixedRate) : that.fixedRate != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.reservoirSize != null ? !this.reservoirSize.equals(that.reservoirSize) : that.reservoirSize != null) return false;
                if (this.resourceArn != null ? !this.resourceArn.equals(that.resourceArn) : that.resourceArn != null) return false;
                if (this.ruleArn != null ? !this.ruleArn.equals(that.ruleArn) : that.ruleArn != null) return false;
                if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
                if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
                if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) return false;
                if (this.urlPath != null ? !this.urlPath.equals(that.urlPath) : that.urlPath != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                result = 31 * result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.reservoirSize != null ? this.reservoirSize.hashCode() : 0);
                result = 31 * result + (this.resourceArn != null ? this.resourceArn.hashCode() : 0);
                result = 31 * result + (this.ruleArn != null ? this.ruleArn.hashCode() : 0);
                result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
                result = 31 * result + (this.urlPath != null ? this.urlPath.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A [SamplingRule](https://docs.aws.amazon.com//xray/latest/api/API_SamplingRule.html) and its metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.xray.*;
     * SamplingRuleRecordProperty samplingRuleRecordProperty = SamplingRuleRecordProperty.builder()
     *         .createdAt("createdAt")
     *         .modifiedAt("modifiedAt")
     *         .samplingRule(SamplingRuleProperty.builder()
     *                 .attributes(Map.of(
     *                         "attributesKey", "attributes"))
     *                 .fixedRate(123)
     *                 .host("host")
     *                 .httpMethod("httpMethod")
     *                 .priority(123)
     *                 .reservoirSize(123)
     *                 .resourceArn("resourceArn")
     *                 .ruleArn("ruleArn")
     *                 .ruleName("ruleName")
     *                 .serviceName("serviceName")
     *                 .serviceType("serviceType")
     *                 .urlPath("urlPath")
     *                 .version(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleRecordProperty")
    @software.amazon.jsii.Jsii.Proxy(SamplingRuleRecordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SamplingRuleRecordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the rule was created, in Unix time seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * When the rule was last modified, in Unix time seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModifiedAt() {
            return null;
        }

        /**
         * The sampling rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSamplingRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SamplingRuleRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SamplingRuleRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SamplingRuleRecordProperty> {
            java.lang.String createdAt;
            java.lang.String modifiedAt;
            java.lang.Object samplingRule;

            /**
             * Sets the value of {@link SamplingRuleRecordProperty#getCreatedAt}
             * @param createdAt When the rule was created, in Unix time seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleRecordProperty#getModifiedAt}
             * @param modifiedAt When the rule was last modified, in Unix time seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modifiedAt(java.lang.String modifiedAt) {
                this.modifiedAt = modifiedAt;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleRecordProperty#getSamplingRule}
             * @param samplingRule The sampling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samplingRule(software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleProperty samplingRule) {
                this.samplingRule = samplingRule;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleRecordProperty#getSamplingRule}
             * @param samplingRule The sampling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samplingRule(software.amazon.awscdk.IResolvable samplingRule) {
                this.samplingRule = samplingRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SamplingRuleRecordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SamplingRuleRecordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SamplingRuleRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SamplingRuleRecordProperty {
            private final java.lang.String createdAt;
            private final java.lang.String modifiedAt;
            private final java.lang.Object samplingRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modifiedAt = software.amazon.jsii.Kernel.get(this, "modifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.samplingRule = software.amazon.jsii.Kernel.get(this, "samplingRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.createdAt = builder.createdAt;
                this.modifiedAt = builder.modifiedAt;
                this.samplingRule = builder.samplingRule;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getModifiedAt() {
                return this.modifiedAt;
            }

            @Override
            public final java.lang.Object getSamplingRule() {
                return this.samplingRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getModifiedAt() != null) {
                    data.set("modifiedAt", om.valueToTree(this.getModifiedAt()));
                }
                if (this.getSamplingRule() != null) {
                    data.set("samplingRule", om.valueToTree(this.getSamplingRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleRecordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SamplingRuleRecordProperty.Jsii$Proxy that = (SamplingRuleRecordProperty.Jsii$Proxy) o;

                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.modifiedAt != null ? !this.modifiedAt.equals(that.modifiedAt) : that.modifiedAt != null) return false;
                return this.samplingRule != null ? this.samplingRule.equals(that.samplingRule) : that.samplingRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.createdAt != null ? this.createdAt.hashCode() : 0;
                result = 31 * result + (this.modifiedAt != null ? this.modifiedAt.hashCode() : 0);
                result = 31 * result + (this.samplingRule != null ? this.samplingRule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A document specifying changes to a sampling rule's configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.xray.*;
     * SamplingRuleUpdateProperty samplingRuleUpdateProperty = SamplingRuleUpdateProperty.builder()
     *         .attributes(Map.of(
     *                 "attributesKey", "attributes"))
     *         .fixedRate(123)
     *         .host("host")
     *         .httpMethod("httpMethod")
     *         .priority(123)
     *         .reservoirSize(123)
     *         .resourceArn("resourceArn")
     *         .ruleArn("ruleArn")
     *         .ruleName("ruleName")
     *         .serviceName("serviceName")
     *         .serviceType("serviceType")
     *         .urlPath("urlPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(SamplingRuleUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SamplingRuleUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Matches attributes derived from the request.
         * <p>
         * <em>Map Entries:</em> Maximum number of 5 items.
         * <p>
         * <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
         * <p>
         * <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFixedRate() {
            return null;
        }

        /**
         * Matches the hostname from a request URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * Matches the HTTP method of a request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * The priority of the sampling rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * A fixed number of matching requests to instrument per second, prior to applying the fixed rate.
         * <p>
         * The reservoir is not used directly by services, but applies to all services using the rule collectively.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReservoirSize() {
            return null;
        }

        /**
         * Matches the ARN of the AWS resource on which the service runs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceArn() {
            return null;
        }

        /**
         * The ARN of the sampling rule.
         * <p>
         * You must specify either RuleARN or RuleName, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleArn() {
            return null;
        }

        /**
         * The name of the sampling rule.
         * <p>
         * You must specify either RuleARN or RuleName, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
            return null;
        }

        /**
         * Matches the `name` that the service uses to identify itself in segments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * Matches the `origin` that the service uses to identify its type in segments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
            return null;
        }

        /**
         * Matches the path from a request URL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrlPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SamplingRuleUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SamplingRuleUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SamplingRuleUpdateProperty> {
            java.lang.Object attributes;
            java.lang.Number fixedRate;
            java.lang.String host;
            java.lang.String httpMethod;
            java.lang.Number priority;
            java.lang.Number reservoirSize;
            java.lang.String resourceArn;
            java.lang.String ruleArn;
            java.lang.String ruleName;
            java.lang.String serviceName;
            java.lang.String serviceType;
            java.lang.String urlPath;

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getAttributes}
             * @param attributes Matches attributes derived from the request.
             *                   <em>Map Entries:</em> Maximum number of 5 items.
             *                   <p>
             *                   <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             *                   <p>
             *                   <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getAttributes}
             * @param attributes Matches attributes derived from the request.
             *                   <em>Map Entries:</em> Maximum number of 5 items.
             *                   <p>
             *                   <em>Key Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             *                   <p>
             *                   <em>Value Length Constraints:</em> Minimum length of 1. Maximum length of 32.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getFixedRate}
             * @param fixedRate The percentage of matching requests to instrument, after the reservoir is exhausted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedRate(java.lang.Number fixedRate) {
                this.fixedRate = fixedRate;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getHost}
             * @param host Matches the hostname from a request URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getHttpMethod}
             * @param httpMethod Matches the HTTP method of a request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getPriority}
             * @param priority The priority of the sampling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getReservoirSize}
             * @param reservoirSize A fixed number of matching requests to instrument per second, prior to applying the fixed rate.
             *                      The reservoir is not used directly by services, but applies to all services using the rule collectively.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reservoirSize(java.lang.Number reservoirSize) {
                this.reservoirSize = reservoirSize;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getResourceArn}
             * @param resourceArn Matches the ARN of the AWS resource on which the service runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getRuleArn}
             * @param ruleArn The ARN of the sampling rule.
             *                You must specify either RuleARN or RuleName, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleArn(java.lang.String ruleArn) {
                this.ruleArn = ruleArn;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getRuleName}
             * @param ruleName The name of the sampling rule.
             *                 You must specify either RuleARN or RuleName, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleName(java.lang.String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getServiceName}
             * @param serviceName Matches the `name` that the service uses to identify itself in segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getServiceType}
             * @param serviceType Matches the `origin` that the service uses to identify its type in segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceType(java.lang.String serviceType) {
                this.serviceType = serviceType;
                return this;
            }

            /**
             * Sets the value of {@link SamplingRuleUpdateProperty#getUrlPath}
             * @param urlPath Matches the path from a request URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlPath(java.lang.String urlPath) {
                this.urlPath = urlPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SamplingRuleUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SamplingRuleUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SamplingRuleUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SamplingRuleUpdateProperty {
            private final java.lang.Object attributes;
            private final java.lang.Number fixedRate;
            private final java.lang.String host;
            private final java.lang.String httpMethod;
            private final java.lang.Number priority;
            private final java.lang.Number reservoirSize;
            private final java.lang.String resourceArn;
            private final java.lang.String ruleArn;
            private final java.lang.String ruleName;
            private final java.lang.String serviceName;
            private final java.lang.String serviceType;
            private final java.lang.String urlPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fixedRate = software.amazon.jsii.Kernel.get(this, "fixedRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.reservoirSize = software.amazon.jsii.Kernel.get(this, "reservoirSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleArn = software.amazon.jsii.Kernel.get(this, "ruleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceType = software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.urlPath = software.amazon.jsii.Kernel.get(this, "urlPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
                this.fixedRate = builder.fixedRate;
                this.host = builder.host;
                this.httpMethod = builder.httpMethod;
                this.priority = builder.priority;
                this.reservoirSize = builder.reservoirSize;
                this.resourceArn = builder.resourceArn;
                this.ruleArn = builder.ruleArn;
                this.ruleName = builder.ruleName;
                this.serviceName = builder.serviceName;
                this.serviceType = builder.serviceType;
                this.urlPath = builder.urlPath;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Number getFixedRate() {
                return this.fixedRate;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Number getReservoirSize() {
                return this.reservoirSize;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRuleArn() {
                return this.ruleArn;
            }

            @Override
            public final java.lang.String getRuleName() {
                return this.ruleName;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.String getServiceType() {
                return this.serviceType;
            }

            @Override
            public final java.lang.String getUrlPath() {
                return this.urlPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getFixedRate() != null) {
                    data.set("fixedRate", om.valueToTree(this.getFixedRate()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getReservoirSize() != null) {
                    data.set("reservoirSize", om.valueToTree(this.getReservoirSize()));
                }
                if (this.getResourceArn() != null) {
                    data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                }
                if (this.getRuleArn() != null) {
                    data.set("ruleArn", om.valueToTree(this.getRuleArn()));
                }
                if (this.getRuleName() != null) {
                    data.set("ruleName", om.valueToTree(this.getRuleName()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }
                if (this.getServiceType() != null) {
                    data.set("serviceType", om.valueToTree(this.getServiceType()));
                }
                if (this.getUrlPath() != null) {
                    data.set("urlPath", om.valueToTree(this.getUrlPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnSamplingRule.SamplingRuleUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SamplingRuleUpdateProperty.Jsii$Proxy that = (SamplingRuleUpdateProperty.Jsii$Proxy) o;

                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.fixedRate != null ? !this.fixedRate.equals(that.fixedRate) : that.fixedRate != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.reservoirSize != null ? !this.reservoirSize.equals(that.reservoirSize) : that.reservoirSize != null) return false;
                if (this.resourceArn != null ? !this.resourceArn.equals(that.resourceArn) : that.resourceArn != null) return false;
                if (this.ruleArn != null ? !this.ruleArn.equals(that.ruleArn) : that.ruleArn != null) return false;
                if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
                if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
                if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) return false;
                return this.urlPath != null ? this.urlPath.equals(that.urlPath) : that.urlPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                result = 31 * result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.reservoirSize != null ? this.reservoirSize.hashCode() : 0);
                result = 31 * result + (this.resourceArn != null ? this.resourceArn.hashCode() : 0);
                result = 31 * result + (this.ruleArn != null ? this.ruleArn.hashCode() : 0);
                result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
                result = 31 * result + (this.urlPath != null ? this.urlPath.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.xray.CfnSamplingRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.xray.CfnSamplingRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.xray.CfnSamplingRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the sampling rule.
         * <p>
         * Specify a rule by either name or ARN, but not both. Used only when deleting a sampling rule. When creating or updating a sampling rule, use the <code>RuleName</code> or <code>RuleARN</code> properties within <code>SamplingRule</code> or <code>SamplingRuleUpdate</code> .
         * <p>
         * @return {@code this}
         * @param ruleName The name of the sampling rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props().ruleName(ruleName);
            return this;
        }

        /**
         * The sampling rule to be created.
         * <p>
         * Must be provided if creating a new sampling rule. Not valid when updating an existing sampling rule.
         * <p>
         * @return {@code this}
         * @param samplingRule The sampling rule to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRule(final software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleProperty samplingRule) {
            this.props().samplingRule(samplingRule);
            return this;
        }
        /**
         * The sampling rule to be created.
         * <p>
         * Must be provided if creating a new sampling rule. Not valid when updating an existing sampling rule.
         * <p>
         * @return {@code this}
         * @param samplingRule The sampling rule to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRule(final software.amazon.awscdk.IResolvable samplingRule) {
            this.props().samplingRule(samplingRule);
            return this;
        }

        /**
         * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
         * <p>
         * @return {@code this}
         * @param samplingRuleRecord `AWS::XRay::SamplingRule.SamplingRuleRecord`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRuleRecord(final software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleRecordProperty samplingRuleRecord) {
            this.props().samplingRuleRecord(samplingRuleRecord);
            return this;
        }
        /**
         * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
         * <p>
         * @return {@code this}
         * @param samplingRuleRecord `AWS::XRay::SamplingRule.SamplingRuleRecord`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRuleRecord(final software.amazon.awscdk.IResolvable samplingRuleRecord) {
            this.props().samplingRuleRecord(samplingRuleRecord);
            return this;
        }

        /**
         * A document specifying changes to a sampling rule's configuration.
         * <p>
         * Must be provided if updating an existing sampling rule. Not valid when creating a new sampling rule.
         * <p>
         * <blockquote>
         * <p>
         * The <code>Version</code> of a sampling rule cannot be updated, and is not part of <code>SamplingRuleUpdate</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param samplingRuleUpdate A document specifying changes to a sampling rule's configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRuleUpdate(final software.amazon.awscdk.services.xray.CfnSamplingRule.SamplingRuleUpdateProperty samplingRuleUpdate) {
            this.props().samplingRuleUpdate(samplingRuleUpdate);
            return this;
        }
        /**
         * A document specifying changes to a sampling rule's configuration.
         * <p>
         * Must be provided if updating an existing sampling rule. Not valid when creating a new sampling rule.
         * <p>
         * <blockquote>
         * <p>
         * The <code>Version</code> of a sampling rule cannot be updated, and is not part of <code>SamplingRuleUpdate</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param samplingRuleUpdate A document specifying changes to a sampling rule's configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRuleUpdate(final software.amazon.awscdk.IResolvable samplingRuleUpdate) {
            this.props().samplingRuleUpdate(samplingRuleUpdate);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends java.lang.Object> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.xray.CfnSamplingRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.xray.CfnSamplingRule build() {
            return new software.amazon.awscdk.services.xray.CfnSamplingRule(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.xray.CfnSamplingRuleProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.xray.CfnSamplingRuleProps.Builder();
            }
            return this.props;
        }
    }
}
