package software.amazon.awscdk.services.stepfunctions;

/**
 * AWS Step Functions integrates with services directly in the Amazon States Language.
 * <p>
 * You can control these AWS services using service integration patterns:
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Define a state machine with one Pass state
 * StateMachine child = StateMachine.Builder.create(this, "ChildStateMachine")
 *         .definition(Chain.start(new Pass(this, "PassState")))
 *         .build();
 * // Include the state machine in a Task state with callback pattern
 * StepFunctionsStartExecution task = StepFunctionsStartExecution.Builder.create(this, "ChildTask")
 *         .stateMachine(child)
 *         .integrationPattern(IntegrationPattern.WAIT_FOR_TASK_TOKEN)
 *         .input(TaskInput.fromObject(Map.of(
 *                 "token", JsonPath.getTaskToken(),
 *                 "foo", "bar")))
 *         .name("MyExecutionName")
 *         .build();
 * // Define a second state machine with the Task state above
 * // Define a second state machine with the Task state above
 * StateMachine.Builder.create(this, "ParentStateMachine")
 *         .definition(task)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:42.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.IntegrationPattern")
public enum IntegrationPattern {
    /**
     * Step Functions will wait for an HTTP response and then progress to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Step Functions can wait for a request to complete before progressing to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RUN_JOB,
    /**
     * Callback tasks provide a way to pause a workflow until a task token is returned.
     * <p>
     * You must set a task token when using the callback pattern
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WAIT_FOR_TASK_TOKEN,
}
