package software.amazon.awscdk.services.route53resolver;

/**
 * Properties for defining a `CfnResolverQueryLoggingConfigAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnResolverQueryLoggingConfigAssociationProps cfnResolverQueryLoggingConfigAssociationProps = CfnResolverQueryLoggingConfigAssociationProps.builder()
 *         .resolverQueryLogConfigId("resolverQueryLogConfigId")
 *         .resourceId("resourceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.716Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnResolverQueryLoggingConfigAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnResolverQueryLoggingConfigAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResolverQueryLoggingConfigAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the query logging configuration that a VPC is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResolverQueryLogConfigId() {
        return null;
    }

    /**
     * The ID of the Amazon VPC that is associated with the query logging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResolverQueryLoggingConfigAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResolverQueryLoggingConfigAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResolverQueryLoggingConfigAssociationProps> {
        java.lang.String resolverQueryLogConfigId;
        java.lang.String resourceId;

        /**
         * Sets the value of {@link CfnResolverQueryLoggingConfigAssociationProps#getResolverQueryLogConfigId}
         * @param resolverQueryLogConfigId The ID of the query logging configuration that a VPC is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverQueryLogConfigId(java.lang.String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverQueryLoggingConfigAssociationProps#getResourceId}
         * @param resourceId The ID of the Amazon VPC that is associated with the query logging configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResolverQueryLoggingConfigAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResolverQueryLoggingConfigAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResolverQueryLoggingConfigAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResolverQueryLoggingConfigAssociationProps {
        private final java.lang.String resolverQueryLogConfigId;
        private final java.lang.String resourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resolverQueryLogConfigId = software.amazon.jsii.Kernel.get(this, "resolverQueryLogConfigId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resolverQueryLogConfigId = builder.resolverQueryLogConfigId;
            this.resourceId = builder.resourceId;
        }

        @Override
        public final java.lang.String getResolverQueryLogConfigId() {
            return this.resolverQueryLogConfigId;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getResolverQueryLogConfigId() != null) {
                data.set("resolverQueryLogConfigId", om.valueToTree(this.getResolverQueryLogConfigId()));
            }
            if (this.getResourceId() != null) {
                data.set("resourceId", om.valueToTree(this.getResourceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnResolverQueryLoggingConfigAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResolverQueryLoggingConfigAssociationProps.Jsii$Proxy that = (CfnResolverQueryLoggingConfigAssociationProps.Jsii$Proxy) o;

            if (this.resolverQueryLogConfigId != null ? !this.resolverQueryLogConfigId.equals(that.resolverQueryLogConfigId) : that.resolverQueryLogConfigId != null) return false;
            return this.resourceId != null ? this.resourceId.equals(that.resourceId) : that.resourceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resolverQueryLogConfigId != null ? this.resolverQueryLogConfigId.hashCode() : 0;
            result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
            return result;
        }
    }
}
