package software.amazon.awscdk.services.redshiftserverless;

/**
 * A CloudFormation `AWS::RedshiftServerless::Workgroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnWorkgroup cfnWorkgroup = CfnWorkgroup.Builder.create(this, "MyCfnWorkgroup")
 *         .workgroupName("workgroupName")
 *         // the properties below are optional
 *         .baseCapacity(123)
 *         .configParameters(List.of(ConfigParameterProperty.builder()
 *                 .parameterKey("parameterKey")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .enhancedVpcRouting(false)
 *         .namespaceName("namespaceName")
 *         .publiclyAccessible(false)
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup")
public class CfnWorkgroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWorkgroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkgroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RedshiftServerless::Workgroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkgroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.WorkgroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupName() {
        return software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.WorkgroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkgroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workgroupName", java.util.Objects.requireNonNull(value, "workgroupName is required"));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.BaseCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.BaseCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaseCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "baseCapacity", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.ConfigParameters`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigParameters() {
        return software.amazon.jsii.Kernel.get(this, "configParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.ConfigParameters`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configParameters", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.ConfigParameters`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.ConfigParameterProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.ConfigParameterProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configParameters", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.NamespaceName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.NamespaceName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespaceName", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.SecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.SecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.SubnetIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::RedshiftServerless::Workgroup.SubnetIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * ConfigParameterProperty configParameterProperty = ConfigParameterProperty.builder()
     *         .parameterKey("parameterKey")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.ConfigParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnWorkgroup.ConfigParameterProperty.ParameterKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterKey() {
            return null;
        }

        /**
         * `CfnWorkgroup.ConfigParameterProperty.ParameterValue`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigParameterProperty> {
            java.lang.String parameterKey;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ConfigParameterProperty#getParameterKey}
             * @param parameterKey `CfnWorkgroup.ConfigParameterProperty.ParameterKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterKey(java.lang.String parameterKey) {
                this.parameterKey = parameterKey;
                return this;
            }

            /**
             * Sets the value of {@link ConfigParameterProperty#getParameterValue}
             * @param parameterValue `CfnWorkgroup.ConfigParameterProperty.ParameterValue`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigParameterProperty {
            private final java.lang.String parameterKey;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterKey = software.amazon.jsii.Kernel.get(this, "parameterKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterKey = builder.parameterKey;
                this.parameterValue = builder.parameterValue;
            }

            @Override
            public final java.lang.String getParameterKey() {
                return this.parameterKey;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParameterKey() != null) {
                    data.set("parameterKey", om.valueToTree(this.getParameterKey()));
                }
                if (this.getParameterValue() != null) {
                    data.set("parameterValue", om.valueToTree(this.getParameterValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.ConfigParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigParameterProperty.Jsii$Proxy that = (ConfigParameterProperty.Jsii$Proxy) o;

                if (this.parameterKey != null ? !this.parameterKey.equals(that.parameterKey) : that.parameterKey != null) return false;
                return this.parameterValue != null ? this.parameterValue.equals(that.parameterValue) : that.parameterValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameterKey != null ? this.parameterKey.hashCode() : 0;
                result = 31 * result + (this.parameterValue != null ? this.parameterValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps.Builder();
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.WorkgroupName`.
         * <p>
         * @return {@code this}
         * @param workgroupName `AWS::RedshiftServerless::Workgroup.WorkgroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroupName(final java.lang.String workgroupName) {
            this.props.workgroupName(workgroupName);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.BaseCapacity`.
         * <p>
         * @return {@code this}
         * @param baseCapacity `AWS::RedshiftServerless::Workgroup.BaseCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(final java.lang.Number baseCapacity) {
            this.props.baseCapacity(baseCapacity);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.ConfigParameters`.
         * <p>
         * @return {@code this}
         * @param configParameters `AWS::RedshiftServerless::Workgroup.ConfigParameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(final software.amazon.awscdk.IResolvable configParameters) {
            this.props.configParameters(configParameters);
            return this;
        }
        /**
         * `AWS::RedshiftServerless::Workgroup.ConfigParameters`.
         * <p>
         * @return {@code this}
         * @param configParameters `AWS::RedshiftServerless::Workgroup.ConfigParameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(final java.util.List<? extends java.lang.Object> configParameters) {
            this.props.configParameters(configParameters);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`.
         * <p>
         * @return {@code this}
         * @param enhancedVpcRouting `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final java.lang.Boolean enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }
        /**
         * `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`.
         * <p>
         * @return {@code this}
         * @param enhancedVpcRouting `AWS::RedshiftServerless::Workgroup.EnhancedVpcRouting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final software.amazon.awscdk.IResolvable enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.NamespaceName`.
         * <p>
         * @return {@code this}
         * @param namespaceName `AWS::RedshiftServerless::Workgroup.NamespaceName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(final java.lang.String namespaceName) {
            this.props.namespaceName(namespaceName);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`.
         * <p>
         * @return {@code this}
         * @param publiclyAccessible `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`.
         * <p>
         * @return {@code this}
         * @param publiclyAccessible `AWS::RedshiftServerless::Workgroup.PubliclyAccessible`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.SecurityGroupIds`.
         * <p>
         * @return {@code this}
         * @param securityGroupIds `AWS::RedshiftServerless::Workgroup.SecurityGroupIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.SubnetIds`.
         * <p>
         * @return {@code this}
         * @param subnetIds `AWS::RedshiftServerless::Workgroup.SubnetIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * `AWS::RedshiftServerless::Workgroup.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::RedshiftServerless::Workgroup.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup build() {
            return new software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
