package software.amazon.awscdk.services.rds;

/**
 * The versions for the MariaDB instance engines (those returned by {@link DatabaseInstanceEngine.mariaDb}).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * MariaDbEngineVersion mariaDbEngineVersion = MariaDbEngineVersion.VER_10_2;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.495Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.MariaDbEngineVersion")
public class MariaDbEngineVersion extends software.amazon.jsii.JsiiObject {

    protected MariaDbEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MariaDbEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_37 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_37", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_39 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_39", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_40 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_40", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_41 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_41", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_6_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_6_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_6_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_6_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_6_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_6_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
    }

    /**
     * Create a new MariaDbEngineVersion with an arbitrary version.
     * <p>
     * @param mariaDbFullVersion the full version string, for example "10.5.28". This parameter is required.
     * @param mariaDbMajorVersion the major version of the engine, for example "10.5". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MariaDbEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String mariaDbFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String mariaDbMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(mariaDbFullVersion, "mariaDbFullVersion is required"), java.util.Objects.requireNonNull(mariaDbMajorVersion, "mariaDbMajorVersion is required") });
    }

    /**
     * (deprecated) Version "10.2" (only a major version, without a specific minor version).
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2;

    /**
     * (deprecated) Version "10.2.11".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_11;

    /**
     * (deprecated) Version "10.2.12".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_12;

    /**
     * (deprecated) Version "10.2.15".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_15;

    /**
     * (deprecated) Version "10.2.21".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_21;

    /**
     * (deprecated) Version "10.2.32".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_32;

    /**
     * (deprecated) Version "10.2.37".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_37;

    /**
     * (deprecated) Version "10.2.39".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_39;

    /**
     * (deprecated) Version "10.2.40".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_40;

    /**
     * (deprecated) Version "10.2.41".
     * <p>
     * @deprecated MariaDB 10.2 will reach end of life on October 15, 2022
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_41;

    /**
     * Version "10.3" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3;

    /**
     * Version "10.3.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_13;

    /**
     * Version "10.3.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_20;

    /**
     * Version "10.3.23".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_23;

    /**
     * Version "10.3.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_28;

    /**
     * Version "10.3.31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_31;

    /**
     * Version "10.3.32".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_32;

    /**
     * Version "10.3.34".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_34;

    /**
     * Version "10.3.35".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_35;

    /**
     * Version "10.3.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_8;

    /**
     * Version "10.4" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4;

    /**
     * Version "10.4.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_13;

    /**
     * Version "10.4.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_18;

    /**
     * Version "10.4.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_21;

    /**
     * Version "10.4.22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_22;

    /**
     * Version "10.4.24".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_24;

    /**
     * Version "10.4.25".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_25;

    /**
     * Version "10.4.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_8;

    /**
     * Version "10.5" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5;

    /**
     * Version "10.5.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_12;

    /**
     * Version "10.5.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_13;

    /**
     * Version "10.5.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_15;

    /**
     * Version "10.5.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_16;

    /**
     * Version "10.5.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_8;

    /**
     * Version "10.5.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_9;

    /**
     * Version "10.6" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_6;

    /**
     * Version "10.6.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_6_5;

    /**
     * Version "10.6.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_6_7;

    /**
     * Version "10.6.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_6_8;

    /**
     * The full version string, for example, "10.5.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMariaDbFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "mariaDbFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "10.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMariaDbMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "mariaDbMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
