package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`.
 * <p>
 * The <code>AWS::RDS::DBProxyTargetGroup</code> resource represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 * <p>
 * This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.
 * <p>
 * For information about RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * For a sample template that creates a DB proxy and registers a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#aws-resource-rds-dbproxy--examples">Examples</a> in AWS::RDS::DBProxy.
 * <p>
 * <blockquote>
 * <p>
 * Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * <p>
 * For information about limitations that apply to RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about that apply to RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBProxyTargetGroup cfnDBProxyTargetGroup = CfnDBProxyTargetGroup.Builder.create(this, "MyCfnDBProxyTargetGroup")
 *         .dbProxyName("dbProxyName")
 *         .targetGroupName("targetGroupName")
 *         // the properties below are optional
 *         .connectionPoolConfigurationInfo(ConnectionPoolConfigurationInfoFormatProperty.builder()
 *                 .connectionBorrowTimeout(123)
 *                 .initQuery("initQuery")
 *                 .maxConnectionsPercent(123)
 *                 .maxIdleConnectionsPercent(123)
 *                 .sessionPinningFilters(List.of("sessionPinningFilters"))
 *                 .build())
 *         .dbClusterIdentifiers(List.of("dbClusterIdentifiers"))
 *         .dbInstanceIdentifiers(List.of("dbInstanceIdentifiers"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.420Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup")
public class CfnDBProxyTargetGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBProxyTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBProxyTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBProxyTargetGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTargetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTargetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier of the `DBProxy` that is associated with the `DBProxyTargetGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the `DBProxy` that is associated with the `DBProxyTargetGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbProxyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbProxyName", java.util.Objects.requireNonNull(value, "dbProxyName is required"));
    }

    /**
     * The identifier for the target group.
     * <p>
     * <blockquote>
     * <p>
     * Currently, this property must be set to <code>default</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the target group.
     * <p>
     * <blockquote>
     * <p>
     * Currently, this property must be set to <code>default</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetGroupName", java.util.Objects.requireNonNull(value, "targetGroupName is required"));
    }

    /**
     * Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectionPoolConfigurationInfo() {
        return software.amazon.jsii.Kernel.get(this, "connectionPoolConfigurationInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionPoolConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectionPoolConfigurationInfo", value);
    }

    /**
     * Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionPoolConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectionPoolConfigurationInfo", value);
    }

    /**
     * One or more DB cluster identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbClusterIdentifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbClusterIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more DB cluster identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifiers", value);
    }

    /**
     * One or more DB instance identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbInstanceIdentifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more DB instance identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceIdentifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceIdentifiers", value);
    }
    /**
     * Specifies the settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ConnectionPoolConfigurationInfoFormatProperty connectionPoolConfigurationInfoFormatProperty = ConnectionPoolConfigurationInfoFormatProperty.builder()
     *         .connectionBorrowTimeout(123)
     *         .initQuery("initQuery")
     *         .maxConnectionsPercent(123)
     *         .maxIdleConnectionsPercent(123)
     *         .sessionPinningFilters(List.of("sessionPinningFilters"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionPoolConfigurationInfoFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of seconds for a proxy to wait for a connection to become available in the connection pool.
         * <p>
         * Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
         * <p>
         * Default: 120
         * <p>
         * Constraints: between 1 and 3600, or 0 representing unlimited
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionBorrowTimeout() {
            return null;
        }

        /**
         * One or more SQL statements for the proxy to run when opening each new database connection.
         * <p>
         * Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code> .
         * <p>
         * Default: no initialization query
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInitQuery() {
            return null;
        }

        /**
         * The maximum size of the connection pool for each target in a target group.
         * <p>
         * The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.
         * <p>
         * Default: 100
         * <p>
         * Constraints: between 1 and 100
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnectionsPercent() {
            return null;
        }

        /**
         * Controls how actively the proxy closes idle database connections in the connection pool.
         * <p>
         * The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
         * <p>
         * Default: 50
         * <p>
         * Constraints: between 0 and <code>MaxConnectionsPercent</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxIdleConnectionsPercent() {
            return null;
        }

        /**
         * Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
         * <p>
         * Including an item in the list exempts that class of SQL operations from the pinning behavior.
         * <p>
         * Default: no session pinning filters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSessionPinningFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionPoolConfigurationInfoFormatProperty> {
            java.lang.Number connectionBorrowTimeout;
            java.lang.String initQuery;
            java.lang.Number maxConnectionsPercent;
            java.lang.Number maxIdleConnectionsPercent;
            java.util.List<java.lang.String> sessionPinningFilters;

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getConnectionBorrowTimeout}
             * @param connectionBorrowTimeout The number of seconds for a proxy to wait for a connection to become available in the connection pool.
             *                                Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
             *                                <p>
             *                                Default: 120
             *                                <p>
             *                                Constraints: between 1 and 3600, or 0 representing unlimited
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionBorrowTimeout(java.lang.Number connectionBorrowTimeout) {
                this.connectionBorrowTimeout = connectionBorrowTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getInitQuery}
             * @param initQuery One or more SQL statements for the proxy to run when opening each new database connection.
             *                  Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code> .
             *                  <p>
             *                  Default: no initialization query
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initQuery(java.lang.String initQuery) {
                this.initQuery = initQuery;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getMaxConnectionsPercent}
             * @param maxConnectionsPercent The maximum size of the connection pool for each target in a target group.
             *                              The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.
             *                              <p>
             *                              Default: 100
             *                              <p>
             *                              Constraints: between 1 and 100
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConnectionsPercent(java.lang.Number maxConnectionsPercent) {
                this.maxConnectionsPercent = maxConnectionsPercent;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getMaxIdleConnectionsPercent}
             * @param maxIdleConnectionsPercent Controls how actively the proxy closes idle database connections in the connection pool.
             *                                  The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
             *                                  <p>
             *                                  Default: 50
             *                                  <p>
             *                                  Constraints: between 0 and <code>MaxConnectionsPercent</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxIdleConnectionsPercent(java.lang.Number maxIdleConnectionsPercent) {
                this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getSessionPinningFilters}
             * @param sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
             *                              Including an item in the list exempts that class of SQL operations from the pinning behavior.
             *                              <p>
             *                              Default: no session pinning filters
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionPinningFilters(java.util.List<java.lang.String> sessionPinningFilters) {
                this.sessionPinningFilters = sessionPinningFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionPoolConfigurationInfoFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionPoolConfigurationInfoFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionPoolConfigurationInfoFormatProperty {
            private final java.lang.Number connectionBorrowTimeout;
            private final java.lang.String initQuery;
            private final java.lang.Number maxConnectionsPercent;
            private final java.lang.Number maxIdleConnectionsPercent;
            private final java.util.List<java.lang.String> sessionPinningFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionBorrowTimeout = software.amazon.jsii.Kernel.get(this, "connectionBorrowTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.initQuery = software.amazon.jsii.Kernel.get(this, "initQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxIdleConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxIdleConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionPinningFilters = software.amazon.jsii.Kernel.get(this, "sessionPinningFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionBorrowTimeout = builder.connectionBorrowTimeout;
                this.initQuery = builder.initQuery;
                this.maxConnectionsPercent = builder.maxConnectionsPercent;
                this.maxIdleConnectionsPercent = builder.maxIdleConnectionsPercent;
                this.sessionPinningFilters = builder.sessionPinningFilters;
            }

            @Override
            public final java.lang.Number getConnectionBorrowTimeout() {
                return this.connectionBorrowTimeout;
            }

            @Override
            public final java.lang.String getInitQuery() {
                return this.initQuery;
            }

            @Override
            public final java.lang.Number getMaxConnectionsPercent() {
                return this.maxConnectionsPercent;
            }

            @Override
            public final java.lang.Number getMaxIdleConnectionsPercent() {
                return this.maxIdleConnectionsPercent;
            }

            @Override
            public final java.util.List<java.lang.String> getSessionPinningFilters() {
                return this.sessionPinningFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionBorrowTimeout() != null) {
                    data.set("connectionBorrowTimeout", om.valueToTree(this.getConnectionBorrowTimeout()));
                }
                if (this.getInitQuery() != null) {
                    data.set("initQuery", om.valueToTree(this.getInitQuery()));
                }
                if (this.getMaxConnectionsPercent() != null) {
                    data.set("maxConnectionsPercent", om.valueToTree(this.getMaxConnectionsPercent()));
                }
                if (this.getMaxIdleConnectionsPercent() != null) {
                    data.set("maxIdleConnectionsPercent", om.valueToTree(this.getMaxIdleConnectionsPercent()));
                }
                if (this.getSessionPinningFilters() != null) {
                    data.set("sessionPinningFilters", om.valueToTree(this.getSessionPinningFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy that = (ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy) o;

                if (this.connectionBorrowTimeout != null ? !this.connectionBorrowTimeout.equals(that.connectionBorrowTimeout) : that.connectionBorrowTimeout != null) return false;
                if (this.initQuery != null ? !this.initQuery.equals(that.initQuery) : that.initQuery != null) return false;
                if (this.maxConnectionsPercent != null ? !this.maxConnectionsPercent.equals(that.maxConnectionsPercent) : that.maxConnectionsPercent != null) return false;
                if (this.maxIdleConnectionsPercent != null ? !this.maxIdleConnectionsPercent.equals(that.maxIdleConnectionsPercent) : that.maxIdleConnectionsPercent != null) return false;
                return this.sessionPinningFilters != null ? this.sessionPinningFilters.equals(that.sessionPinningFilters) : that.sessionPinningFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionBorrowTimeout != null ? this.connectionBorrowTimeout.hashCode() : 0;
                result = 31 * result + (this.initQuery != null ? this.initQuery.hashCode() : 0);
                result = 31 * result + (this.maxConnectionsPercent != null ? this.maxConnectionsPercent.hashCode() : 0);
                result = 31 * result + (this.maxIdleConnectionsPercent != null ? this.maxIdleConnectionsPercent.hashCode() : 0);
                result = 31 * result + (this.sessionPinningFilters != null ? this.sessionPinningFilters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps.Builder();
        }

        /**
         * The identifier of the `DBProxy` that is associated with the `DBProxyTargetGroup` .
         * <p>
         * @return {@code this}
         * @param dbProxyName The identifier of the `DBProxy` that is associated with the `DBProxyTargetGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(final java.lang.String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        /**
         * The identifier for the target group.
         * <p>
         * <blockquote>
         * <p>
         * Currently, this property must be set to <code>default</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param targetGroupName The identifier for the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(final java.lang.String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        /**
         * Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
         * <p>
         * @return {@code this}
         * @param connectionPoolConfigurationInfo Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(final software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty connectionPoolConfigurationInfo) {
            this.props.connectionPoolConfigurationInfo(connectionPoolConfigurationInfo);
            return this;
        }
        /**
         * Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` .
         * <p>
         * @return {@code this}
         * @param connectionPoolConfigurationInfo Settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(final software.amazon.awscdk.IResolvable connectionPoolConfigurationInfo) {
            this.props.connectionPoolConfigurationInfo(connectionPoolConfigurationInfo);
            return this;
        }

        /**
         * One or more DB cluster identifiers.
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifiers One or more DB cluster identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifiers(final java.util.List<java.lang.String> dbClusterIdentifiers) {
            this.props.dbClusterIdentifiers(dbClusterIdentifiers);
            return this;
        }

        /**
         * One or more DB instance identifiers.
         * <p>
         * @return {@code this}
         * @param dbInstanceIdentifiers One or more DB instance identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifiers(final java.util.List<java.lang.String> dbInstanceIdentifiers) {
            this.props.dbInstanceIdentifiers(dbInstanceIdentifiers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup build() {
            return new software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
