package software.amazon.awscdk.services.opsworks;

/**
 * A CloudFormation `AWS::OpsWorks::Layer`.
 * <p>
 * Creates a layer. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html">How to Create a Layer</a> .
 * <p>
 * <blockquote>
 * <p>
 * You should use <em>CreateLayer</em> for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, <em>CreateLayer</em> fails. A stack can have an arbitrary number of custom layers, so you can call <em>CreateLayer</em> as many times as you like for that layer type.
 * <p>
 * </blockquote>
 * <p>
 * <em>Required Permissions</em> : To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * Object customJson;
 * CfnLayer cfnLayer = CfnLayer.Builder.create(this, "MyCfnLayer")
 *         .autoAssignElasticIps(false)
 *         .autoAssignPublicIps(false)
 *         .enableAutoHealing(false)
 *         .name("name")
 *         .shortname("shortname")
 *         .stackId("stackId")
 *         .type("type")
 *         // the properties below are optional
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .customInstanceProfileArn("customInstanceProfileArn")
 *         .customJson(customJson)
 *         .customRecipes(RecipesProperty.builder()
 *                 .configure(List.of("configure"))
 *                 .deploy(List.of("deploy"))
 *                 .setup(List.of("setup"))
 *                 .shutdown(List.of("shutdown"))
 *                 .undeploy(List.of("undeploy"))
 *                 .build())
 *         .customSecurityGroupIds(List.of("customSecurityGroupIds"))
 *         .installUpdatesOnBoot(false)
 *         .lifecycleEventConfiguration(LifecycleEventConfigurationProperty.builder()
 *                 .shutdownEventConfiguration(ShutdownEventConfigurationProperty.builder()
 *                         .delayUntilElbConnectionsDrained(false)
 *                         .executionTimeout(123)
 *                         .build())
 *                 .build())
 *         .loadBasedAutoScaling(LoadBasedAutoScalingProperty.builder()
 *                 .downScaling(AutoScalingThresholdsProperty.builder()
 *                         .cpuThreshold(123)
 *                         .ignoreMetricsTime(123)
 *                         .instanceCount(123)
 *                         .loadThreshold(123)
 *                         .memoryThreshold(123)
 *                         .thresholdsWaitTime(123)
 *                         .build())
 *                 .enable(false)
 *                 .upScaling(AutoScalingThresholdsProperty.builder()
 *                         .cpuThreshold(123)
 *                         .ignoreMetricsTime(123)
 *                         .instanceCount(123)
 *                         .loadThreshold(123)
 *                         .memoryThreshold(123)
 *                         .thresholdsWaitTime(123)
 *                         .build())
 *                 .build())
 *         .packages(List.of("packages"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useEbsOptimizedInstances(false)
 *         .volumeConfigurations(List.of(VolumeConfigurationProperty.builder()
 *                 .encrypted(false)
 *                 .iops(123)
 *                 .mountPoint("mountPoint")
 *                 .numberOfDisks(123)
 *                 .raidLevel(123)
 *                 .size(123)
 *                 .volumeType("volumeType")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.134Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer")
public class CfnLayer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLayer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLayer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opsworks.CfnLayer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::OpsWorks::Layer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLayer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opsworks.CfnLayerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies one or more sets of tags (key–value pairs) to associate with this AWS OpsWorks layer.
     * <p>
     * Use tags to manage your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAutoAssignElasticIps() {
        return software.amazon.jsii.Kernel.get(this, "autoAssignElasticIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoAssignElasticIps(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoAssignElasticIps", java.util.Objects.requireNonNull(value, "autoAssignElasticIps is required"));
    }

    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoAssignElasticIps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoAssignElasticIps", java.util.Objects.requireNonNull(value, "autoAssignElasticIps is required"));
    }

    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAutoAssignPublicIps() {
        return software.amazon.jsii.Kernel.get(this, "autoAssignPublicIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoAssignPublicIps(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoAssignPublicIps", java.util.Objects.requireNonNull(value, "autoAssignPublicIps is required"));
    }

    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoAssignPublicIps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoAssignPublicIps", java.util.Objects.requireNonNull(value, "autoAssignPublicIps is required"));
    }

    /**
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Using Custom JSON</a> . This feature is supported as of version 1.7.42 of the AWS CLI .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCustomJson() {
        return software.amazon.jsii.Kernel.get(this, "customJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Using Custom JSON</a> . This feature is supported as of version 1.7.42 of the AWS CLI .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomJson(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "customJson", java.util.Objects.requireNonNull(value, "customJson is required"));
    }

    /**
     * Whether to disable auto healing for the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEnableAutoHealing() {
        return software.amazon.jsii.Kernel.get(this, "enableAutoHealing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to disable auto healing for the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAutoHealing(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableAutoHealing", java.util.Objects.requireNonNull(value, "enableAutoHealing is required"));
    }

    /**
     * Whether to disable auto healing for the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAutoHealing(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableAutoHealing", java.util.Objects.requireNonNull(value, "enableAutoHealing is required"));
    }

    /**
     * The layer name, which is used by the console.
     * <p>
     * Layer names can be a maximum of 32 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The layer name, which is used by the console.
     * <p>
     * Layer names can be a maximum of 32 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes.
     * <p>
     * The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
     * <p>
     * Built-in layer short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getShortname() {
        return software.amazon.jsii.Kernel.get(this, "shortname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes.
     * <p>
     * The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
     * <p>
     * Built-in layer short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShortname(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "shortname", java.util.Objects.requireNonNull(value, "shortname is required"));
    }

    /**
     * The layer stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackId() {
        return software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The layer stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stackId", java.util.Objects.requireNonNull(value, "stackId is required"));
    }

    /**
     * The layer type.
     * <p>
     * A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The layer type.
     * <p>
     * A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * The ARN of an IAM profile to be used for the layer's EC2 instances.
     * <p>
     * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "customInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of an IAM profile to be used for the layer's EC2 instances.
     * <p>
     * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomInstanceProfileArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customInstanceProfileArn", value);
    }

    /**
     * A `LayerCustomRecipes` object that specifies the layer custom recipes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomRecipes() {
        return software.amazon.jsii.Kernel.get(this, "customRecipes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A `LayerCustomRecipes` object that specifies the layer custom recipes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomRecipes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnLayer.RecipesProperty value) {
        software.amazon.jsii.Kernel.set(this, "customRecipes", value);
    }

    /**
     * A `LayerCustomRecipes` object that specifies the layer custom recipes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomRecipes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customRecipes", value);
    }

    /**
     * An array containing the layer custom security group IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCustomSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "customSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array containing the layer custom security group IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "customSecurityGroupIds", value);
    }

    /**
     * Whether to install operating system and package updates when the instance boots.
     * <p>
     * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * <p>
     * <blockquote>
     * <p>
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstallUpdatesOnBoot() {
        return software.amazon.jsii.Kernel.get(this, "installUpdatesOnBoot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to install operating system and package updates when the instance boots.
     * <p>
     * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * <p>
     * <blockquote>
     * <p>
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstallUpdatesOnBoot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "installUpdatesOnBoot", value);
    }

    /**
     * Whether to install operating system and package updates when the instance boots.
     * <p>
     * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * <p>
     * <blockquote>
     * <p>
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstallUpdatesOnBoot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "installUpdatesOnBoot", value);
    }

    /**
     * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleEventConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleEventConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleEventConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnLayer.LifecycleEventConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleEventConfiguration", value);
    }

    /**
     * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleEventConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleEventConfiguration", value);
    }

    /**
     * The load-based scaling configuration for the AWS OpsWorks layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBasedAutoScaling() {
        return software.amazon.jsii.Kernel.get(this, "loadBasedAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The load-based scaling configuration for the AWS OpsWorks layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBasedAutoScaling(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnLayer.LoadBasedAutoScalingProperty value) {
        software.amazon.jsii.Kernel.set(this, "loadBasedAutoScaling", value);
    }

    /**
     * The load-based scaling configuration for the AWS OpsWorks layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBasedAutoScaling(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loadBasedAutoScaling", value);
    }

    /**
     * An array of `Package` objects that describes the layer packages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPackages() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "packages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of `Package` objects that describes the layer packages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPackages(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "packages", value);
    }

    /**
     * Whether to use Amazon EBS-optimized instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseEbsOptimizedInstances() {
        return software.amazon.jsii.Kernel.get(this, "useEbsOptimizedInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to use Amazon EBS-optimized instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseEbsOptimizedInstances(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useEbsOptimizedInstances", value);
    }

    /**
     * Whether to use Amazon EBS-optimized instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseEbsOptimizedInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useEbsOptimizedInstances", value);
    }

    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVolumeConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "volumeConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "volumeConfigurations", value);
    }

    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.opsworks.CfnLayer.VolumeConfigurationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.opsworks.CfnLayer.VolumeConfigurationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "volumeConfigurations", value);
    }
    /**
     * Describes a load-based auto scaling upscaling or downscaling threshold configuration, which specifies when AWS OpsWorks Stacks starts or stops load-based instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * AutoScalingThresholdsProperty autoScalingThresholdsProperty = AutoScalingThresholdsProperty.builder()
     *         .cpuThreshold(123)
     *         .ignoreMetricsTime(123)
     *         .instanceCount(123)
     *         .loadThreshold(123)
     *         .memoryThreshold(123)
     *         .thresholdsWaitTime(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.AutoScalingThresholdsProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingThresholdsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingThresholdsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU utilization threshold, as a percent of the available CPU.
         * <p>
         * A value of -1 disables the threshold.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpuThreshold() {
            return null;
        }

        /**
         * The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
         * <p>
         * For example, AWS OpsWorks Stacks adds new instances following an upscaling event but the instances won't start reducing the load until they have been booted and configured. There is no point in raising additional scaling events during that operation, which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIgnoreMetricsTime() {
            return null;
        }

        /**
         * The number of instances to add or remove when the load exceeds a threshold.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * The load threshold.
         * <p>
         * A value of -1 disables the threshold. For more information about how load is computed, see <a href="https://docs.aws.amazon.com/http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadThreshold() {
            return null;
        }

        /**
         * The memory utilization threshold, as a percent of the available memory.
         * <p>
         * A value of -1 disables the threshold.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryThreshold() {
            return null;
        }

        /**
         * The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThresholdsWaitTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingThresholdsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingThresholdsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingThresholdsProperty> {
            java.lang.Number cpuThreshold;
            java.lang.Number ignoreMetricsTime;
            java.lang.Number instanceCount;
            java.lang.Number loadThreshold;
            java.lang.Number memoryThreshold;
            java.lang.Number thresholdsWaitTime;

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getCpuThreshold}
             * @param cpuThreshold The CPU utilization threshold, as a percent of the available CPU.
             *                     A value of -1 disables the threshold.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuThreshold(java.lang.Number cpuThreshold) {
                this.cpuThreshold = cpuThreshold;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getIgnoreMetricsTime}
             * @param ignoreMetricsTime The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
             *                          For example, AWS OpsWorks Stacks adds new instances following an upscaling event but the instances won't start reducing the load until they have been booted and configured. There is no point in raising additional scaling events during that operation, which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreMetricsTime(java.lang.Number ignoreMetricsTime) {
                this.ignoreMetricsTime = ignoreMetricsTime;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getInstanceCount}
             * @param instanceCount The number of instances to add or remove when the load exceeds a threshold.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getLoadThreshold}
             * @param loadThreshold The load threshold.
             *                      A value of -1 disables the threshold. For more information about how load is computed, see <a href="https://docs.aws.amazon.com/http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadThreshold(java.lang.Number loadThreshold) {
                this.loadThreshold = loadThreshold;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getMemoryThreshold}
             * @param memoryThreshold The memory utilization threshold, as a percent of the available memory.
             *                        A value of -1 disables the threshold.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryThreshold(java.lang.Number memoryThreshold) {
                this.memoryThreshold = memoryThreshold;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingThresholdsProperty#getThresholdsWaitTime}
             * @param thresholdsWaitTime The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdsWaitTime(java.lang.Number thresholdsWaitTime) {
                this.thresholdsWaitTime = thresholdsWaitTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingThresholdsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingThresholdsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingThresholdsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingThresholdsProperty {
            private final java.lang.Number cpuThreshold;
            private final java.lang.Number ignoreMetricsTime;
            private final java.lang.Number instanceCount;
            private final java.lang.Number loadThreshold;
            private final java.lang.Number memoryThreshold;
            private final java.lang.Number thresholdsWaitTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuThreshold = software.amazon.jsii.Kernel.get(this, "cpuThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ignoreMetricsTime = software.amazon.jsii.Kernel.get(this, "ignoreMetricsTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loadThreshold = software.amazon.jsii.Kernel.get(this, "loadThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryThreshold = software.amazon.jsii.Kernel.get(this, "memoryThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdsWaitTime = software.amazon.jsii.Kernel.get(this, "thresholdsWaitTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuThreshold = builder.cpuThreshold;
                this.ignoreMetricsTime = builder.ignoreMetricsTime;
                this.instanceCount = builder.instanceCount;
                this.loadThreshold = builder.loadThreshold;
                this.memoryThreshold = builder.memoryThreshold;
                this.thresholdsWaitTime = builder.thresholdsWaitTime;
            }

            @Override
            public final java.lang.Number getCpuThreshold() {
                return this.cpuThreshold;
            }

            @Override
            public final java.lang.Number getIgnoreMetricsTime() {
                return this.ignoreMetricsTime;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.Number getLoadThreshold() {
                return this.loadThreshold;
            }

            @Override
            public final java.lang.Number getMemoryThreshold() {
                return this.memoryThreshold;
            }

            @Override
            public final java.lang.Number getThresholdsWaitTime() {
                return this.thresholdsWaitTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuThreshold() != null) {
                    data.set("cpuThreshold", om.valueToTree(this.getCpuThreshold()));
                }
                if (this.getIgnoreMetricsTime() != null) {
                    data.set("ignoreMetricsTime", om.valueToTree(this.getIgnoreMetricsTime()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getLoadThreshold() != null) {
                    data.set("loadThreshold", om.valueToTree(this.getLoadThreshold()));
                }
                if (this.getMemoryThreshold() != null) {
                    data.set("memoryThreshold", om.valueToTree(this.getMemoryThreshold()));
                }
                if (this.getThresholdsWaitTime() != null) {
                    data.set("thresholdsWaitTime", om.valueToTree(this.getThresholdsWaitTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.AutoScalingThresholdsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingThresholdsProperty.Jsii$Proxy that = (AutoScalingThresholdsProperty.Jsii$Proxy) o;

                if (this.cpuThreshold != null ? !this.cpuThreshold.equals(that.cpuThreshold) : that.cpuThreshold != null) return false;
                if (this.ignoreMetricsTime != null ? !this.ignoreMetricsTime.equals(that.ignoreMetricsTime) : that.ignoreMetricsTime != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.loadThreshold != null ? !this.loadThreshold.equals(that.loadThreshold) : that.loadThreshold != null) return false;
                if (this.memoryThreshold != null ? !this.memoryThreshold.equals(that.memoryThreshold) : that.memoryThreshold != null) return false;
                return this.thresholdsWaitTime != null ? this.thresholdsWaitTime.equals(that.thresholdsWaitTime) : that.thresholdsWaitTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuThreshold != null ? this.cpuThreshold.hashCode() : 0;
                result = 31 * result + (this.ignoreMetricsTime != null ? this.ignoreMetricsTime.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.loadThreshold != null ? this.loadThreshold.hashCode() : 0);
                result = 31 * result + (this.memoryThreshold != null ? this.memoryThreshold.hashCode() : 0);
                result = 31 * result + (this.thresholdsWaitTime != null ? this.thresholdsWaitTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the lifecycle event configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * LifecycleEventConfigurationProperty lifecycleEventConfigurationProperty = LifecycleEventConfigurationProperty.builder()
     *         .shutdownEventConfiguration(ShutdownEventConfigurationProperty.builder()
     *                 .delayUntilElbConnectionsDrained(false)
     *                 .executionTimeout(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.LifecycleEventConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleEventConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleEventConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Shutdown event configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShutdownEventConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LifecycleEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleEventConfigurationProperty> {
            java.lang.Object shutdownEventConfiguration;

            /**
             * Sets the value of {@link LifecycleEventConfigurationProperty#getShutdownEventConfiguration}
             * @param shutdownEventConfiguration The Shutdown event configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shutdownEventConfiguration(software.amazon.awscdk.services.opsworks.CfnLayer.ShutdownEventConfigurationProperty shutdownEventConfiguration) {
                this.shutdownEventConfiguration = shutdownEventConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleEventConfigurationProperty#getShutdownEventConfiguration}
             * @param shutdownEventConfiguration The Shutdown event configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shutdownEventConfiguration(software.amazon.awscdk.IResolvable shutdownEventConfiguration) {
                this.shutdownEventConfiguration = shutdownEventConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleEventConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleEventConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecycleEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleEventConfigurationProperty {
            private final java.lang.Object shutdownEventConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shutdownEventConfiguration = software.amazon.jsii.Kernel.get(this, "shutdownEventConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shutdownEventConfiguration = builder.shutdownEventConfiguration;
            }

            @Override
            public final java.lang.Object getShutdownEventConfiguration() {
                return this.shutdownEventConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShutdownEventConfiguration() != null) {
                    data.set("shutdownEventConfiguration", om.valueToTree(this.getShutdownEventConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.LifecycleEventConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleEventConfigurationProperty.Jsii$Proxy that = (LifecycleEventConfigurationProperty.Jsii$Proxy) o;

                return this.shutdownEventConfiguration != null ? this.shutdownEventConfiguration.equals(that.shutdownEventConfiguration) : that.shutdownEventConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shutdownEventConfiguration != null ? this.shutdownEventConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes a layer's load-based auto scaling configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * LoadBasedAutoScalingProperty loadBasedAutoScalingProperty = LoadBasedAutoScalingProperty.builder()
     *         .downScaling(AutoScalingThresholdsProperty.builder()
     *                 .cpuThreshold(123)
     *                 .ignoreMetricsTime(123)
     *                 .instanceCount(123)
     *                 .loadThreshold(123)
     *                 .memoryThreshold(123)
     *                 .thresholdsWaitTime(123)
     *                 .build())
     *         .enable(false)
     *         .upScaling(AutoScalingThresholdsProperty.builder()
     *                 .cpuThreshold(123)
     *                 .ignoreMetricsTime(123)
     *                 .instanceCount(123)
     *                 .loadThreshold(123)
     *                 .memoryThreshold(123)
     *                 .thresholdsWaitTime(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.LoadBasedAutoScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBasedAutoScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBasedAutoScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An `AutoScalingThresholds` object that describes the downscaling configuration, which defines how and when AWS OpsWorks Stacks reduces the number of instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDownScaling() {
            return null;
        }

        /**
         * Whether load-based auto scaling is enabled for the layer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
            return null;
        }

        /**
         * An `AutoScalingThresholds` object that describes the upscaling configuration, which defines how and when AWS OpsWorks Stacks increases the number of instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpScaling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBasedAutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBasedAutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBasedAutoScalingProperty> {
            java.lang.Object downScaling;
            java.lang.Object enable;
            java.lang.Object upScaling;

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getDownScaling}
             * @param downScaling An `AutoScalingThresholds` object that describes the downscaling configuration, which defines how and when AWS OpsWorks Stacks reduces the number of instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder downScaling(software.amazon.awscdk.services.opsworks.CfnLayer.AutoScalingThresholdsProperty downScaling) {
                this.downScaling = downScaling;
                return this;
            }

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getDownScaling}
             * @param downScaling An `AutoScalingThresholds` object that describes the downscaling configuration, which defines how and when AWS OpsWorks Stacks reduces the number of instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder downScaling(software.amazon.awscdk.IResolvable downScaling) {
                this.downScaling = downScaling;
                return this;
            }

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getEnable}
             * @param enable Whether load-based auto scaling is enabled for the layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getEnable}
             * @param enable Whether load-based auto scaling is enabled for the layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getUpScaling}
             * @param upScaling An `AutoScalingThresholds` object that describes the upscaling configuration, which defines how and when AWS OpsWorks Stacks increases the number of instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upScaling(software.amazon.awscdk.services.opsworks.CfnLayer.AutoScalingThresholdsProperty upScaling) {
                this.upScaling = upScaling;
                return this;
            }

            /**
             * Sets the value of {@link LoadBasedAutoScalingProperty#getUpScaling}
             * @param upScaling An `AutoScalingThresholds` object that describes the upscaling configuration, which defines how and when AWS OpsWorks Stacks increases the number of instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upScaling(software.amazon.awscdk.IResolvable upScaling) {
                this.upScaling = upScaling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBasedAutoScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBasedAutoScalingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBasedAutoScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBasedAutoScalingProperty {
            private final java.lang.Object downScaling;
            private final java.lang.Object enable;
            private final java.lang.Object upScaling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.downScaling = software.amazon.jsii.Kernel.get(this, "downScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.upScaling = software.amazon.jsii.Kernel.get(this, "upScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.downScaling = builder.downScaling;
                this.enable = builder.enable;
                this.upScaling = builder.upScaling;
            }

            @Override
            public final java.lang.Object getDownScaling() {
                return this.downScaling;
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            public final java.lang.Object getUpScaling() {
                return this.upScaling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDownScaling() != null) {
                    data.set("downScaling", om.valueToTree(this.getDownScaling()));
                }
                if (this.getEnable() != null) {
                    data.set("enable", om.valueToTree(this.getEnable()));
                }
                if (this.getUpScaling() != null) {
                    data.set("upScaling", om.valueToTree(this.getUpScaling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.LoadBasedAutoScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBasedAutoScalingProperty.Jsii$Proxy that = (LoadBasedAutoScalingProperty.Jsii$Proxy) o;

                if (this.downScaling != null ? !this.downScaling.equals(that.downScaling) : that.downScaling != null) return false;
                if (this.enable != null ? !this.enable.equals(that.enable) : that.enable != null) return false;
                return this.upScaling != null ? this.upScaling.equals(that.upScaling) : that.upScaling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.downScaling != null ? this.downScaling.hashCode() : 0;
                result = 31 * result + (this.enable != null ? this.enable.hashCode() : 0);
                result = 31 * result + (this.upScaling != null ? this.upScaling.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * AWS OpsWorks Stacks supports five lifecycle events: *setup* , *configuration* , *deploy* , *undeploy* , and *shutdown* .
     * <p>
     * For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. In addition, you can provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of the five events.
     * <p>
     * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name, which is the recipe's file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb recipe in the repository's phpapp2 folder.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * RecipesProperty recipesProperty = RecipesProperty.builder()
     *         .configure(List.of("configure"))
     *         .deploy(List.of("deploy"))
     *         .setup(List.of("setup"))
     *         .shutdown(List.of("shutdown"))
     *         .undeploy(List.of("undeploy"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.RecipesProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of custom recipe names to be run following a `configure` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigure() {
            return null;
        }

        /**
         * An array of custom recipe names to be run following a `deploy` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDeploy() {
            return null;
        }

        /**
         * An array of custom recipe names to be run following a `setup` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSetup() {
            return null;
        }

        /**
         * An array of custom recipe names to be run following a `shutdown` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getShutdown() {
            return null;
        }

        /**
         * An array of custom recipe names to be run following a `undeploy` event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUndeploy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecipesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipesProperty> {
            java.util.List<java.lang.String> configure;
            java.util.List<java.lang.String> deploy;
            java.util.List<java.lang.String> setup;
            java.util.List<java.lang.String> shutdown;
            java.util.List<java.lang.String> undeploy;

            /**
             * Sets the value of {@link RecipesProperty#getConfigure}
             * @param configure An array of custom recipe names to be run following a `configure` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configure(java.util.List<java.lang.String> configure) {
                this.configure = configure;
                return this;
            }

            /**
             * Sets the value of {@link RecipesProperty#getDeploy}
             * @param deploy An array of custom recipe names to be run following a `deploy` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploy(java.util.List<java.lang.String> deploy) {
                this.deploy = deploy;
                return this;
            }

            /**
             * Sets the value of {@link RecipesProperty#getSetup}
             * @param setup An array of custom recipe names to be run following a `setup` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setup(java.util.List<java.lang.String> setup) {
                this.setup = setup;
                return this;
            }

            /**
             * Sets the value of {@link RecipesProperty#getShutdown}
             * @param shutdown An array of custom recipe names to be run following a `shutdown` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shutdown(java.util.List<java.lang.String> shutdown) {
                this.shutdown = shutdown;
                return this;
            }

            /**
             * Sets the value of {@link RecipesProperty#getUndeploy}
             * @param undeploy An array of custom recipe names to be run following a `undeploy` event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder undeploy(java.util.List<java.lang.String> undeploy) {
                this.undeploy = undeploy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipesProperty {
            private final java.util.List<java.lang.String> configure;
            private final java.util.List<java.lang.String> deploy;
            private final java.util.List<java.lang.String> setup;
            private final java.util.List<java.lang.String> shutdown;
            private final java.util.List<java.lang.String> undeploy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configure = software.amazon.jsii.Kernel.get(this, "configure", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.deploy = software.amazon.jsii.Kernel.get(this, "deploy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.setup = software.amazon.jsii.Kernel.get(this, "setup", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.shutdown = software.amazon.jsii.Kernel.get(this, "shutdown", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.undeploy = software.amazon.jsii.Kernel.get(this, "undeploy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configure = builder.configure;
                this.deploy = builder.deploy;
                this.setup = builder.setup;
                this.shutdown = builder.shutdown;
                this.undeploy = builder.undeploy;
            }

            @Override
            public final java.util.List<java.lang.String> getConfigure() {
                return this.configure;
            }

            @Override
            public final java.util.List<java.lang.String> getDeploy() {
                return this.deploy;
            }

            @Override
            public final java.util.List<java.lang.String> getSetup() {
                return this.setup;
            }

            @Override
            public final java.util.List<java.lang.String> getShutdown() {
                return this.shutdown;
            }

            @Override
            public final java.util.List<java.lang.String> getUndeploy() {
                return this.undeploy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigure() != null) {
                    data.set("configure", om.valueToTree(this.getConfigure()));
                }
                if (this.getDeploy() != null) {
                    data.set("deploy", om.valueToTree(this.getDeploy()));
                }
                if (this.getSetup() != null) {
                    data.set("setup", om.valueToTree(this.getSetup()));
                }
                if (this.getShutdown() != null) {
                    data.set("shutdown", om.valueToTree(this.getShutdown()));
                }
                if (this.getUndeploy() != null) {
                    data.set("undeploy", om.valueToTree(this.getUndeploy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.RecipesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipesProperty.Jsii$Proxy that = (RecipesProperty.Jsii$Proxy) o;

                if (this.configure != null ? !this.configure.equals(that.configure) : that.configure != null) return false;
                if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
                if (this.setup != null ? !this.setup.equals(that.setup) : that.setup != null) return false;
                if (this.shutdown != null ? !this.shutdown.equals(that.shutdown) : that.shutdown != null) return false;
                return this.undeploy != null ? this.undeploy.equals(that.undeploy) : that.undeploy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configure != null ? this.configure.hashCode() : 0;
                result = 31 * result + (this.deploy != null ? this.deploy.hashCode() : 0);
                result = 31 * result + (this.setup != null ? this.setup.hashCode() : 0);
                result = 31 * result + (this.shutdown != null ? this.shutdown.hashCode() : 0);
                result = 31 * result + (this.undeploy != null ? this.undeploy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Shutdown event configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * ShutdownEventConfigurationProperty shutdownEventConfigurationProperty = ShutdownEventConfigurationProperty.builder()
     *         .delayUntilElbConnectionsDrained(false)
     *         .executionTimeout(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.ShutdownEventConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ShutdownEventConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShutdownEventConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable Elastic Load Balancing connection draining.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDelayUntilElbConnectionsDrained() {
            return null;
        }

        /**
         * The time, in seconds, that AWS OpsWorks Stacks waits after triggering a Shutdown event before shutting down an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExecutionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShutdownEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShutdownEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShutdownEventConfigurationProperty> {
            java.lang.Object delayUntilElbConnectionsDrained;
            java.lang.Number executionTimeout;

            /**
             * Sets the value of {@link ShutdownEventConfigurationProperty#getDelayUntilElbConnectionsDrained}
             * @param delayUntilElbConnectionsDrained Whether to enable Elastic Load Balancing connection draining.
             *                                        For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delayUntilElbConnectionsDrained(java.lang.Boolean delayUntilElbConnectionsDrained) {
                this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
                return this;
            }

            /**
             * Sets the value of {@link ShutdownEventConfigurationProperty#getDelayUntilElbConnectionsDrained}
             * @param delayUntilElbConnectionsDrained Whether to enable Elastic Load Balancing connection draining.
             *                                        For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delayUntilElbConnectionsDrained(software.amazon.awscdk.IResolvable delayUntilElbConnectionsDrained) {
                this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
                return this;
            }

            /**
             * Sets the value of {@link ShutdownEventConfigurationProperty#getExecutionTimeout}
             * @param executionTimeout The time, in seconds, that AWS OpsWorks Stacks waits after triggering a Shutdown event before shutting down an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionTimeout(java.lang.Number executionTimeout) {
                this.executionTimeout = executionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShutdownEventConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShutdownEventConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShutdownEventConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShutdownEventConfigurationProperty {
            private final java.lang.Object delayUntilElbConnectionsDrained;
            private final java.lang.Number executionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delayUntilElbConnectionsDrained = software.amazon.jsii.Kernel.get(this, "delayUntilElbConnectionsDrained", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionTimeout = software.amazon.jsii.Kernel.get(this, "executionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
                this.executionTimeout = builder.executionTimeout;
            }

            @Override
            public final java.lang.Object getDelayUntilElbConnectionsDrained() {
                return this.delayUntilElbConnectionsDrained;
            }

            @Override
            public final java.lang.Number getExecutionTimeout() {
                return this.executionTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelayUntilElbConnectionsDrained() != null) {
                    data.set("delayUntilElbConnectionsDrained", om.valueToTree(this.getDelayUntilElbConnectionsDrained()));
                }
                if (this.getExecutionTimeout() != null) {
                    data.set("executionTimeout", om.valueToTree(this.getExecutionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.ShutdownEventConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShutdownEventConfigurationProperty.Jsii$Proxy that = (ShutdownEventConfigurationProperty.Jsii$Proxy) o;

                if (this.delayUntilElbConnectionsDrained != null ? !this.delayUntilElbConnectionsDrained.equals(that.delayUntilElbConnectionsDrained) : that.delayUntilElbConnectionsDrained != null) return false;
                return this.executionTimeout != null ? this.executionTimeout.equals(that.executionTimeout) : that.executionTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delayUntilElbConnectionsDrained != null ? this.delayUntilElbConnectionsDrained.hashCode() : 0;
                result = 31 * result + (this.executionTimeout != null ? this.executionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an Amazon EBS volume configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * VolumeConfigurationProperty volumeConfigurationProperty = VolumeConfigurationProperty.builder()
     *         .encrypted(false)
     *         .iops(123)
     *         .mountPoint("mountPoint")
     *         .numberOfDisks(123)
     *         .raidLevel(123)
     *         .size(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayer.VolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether an Amazon EBS volume is encrypted.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS) to provision for the volume.
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * <p>
         * If you specify <code>io1</code> for the volume type, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The volume mount point.
         * <p>
         * For example "/dev/sdh".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountPoint() {
            return null;
        }

        /**
         * The number of disks in the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfDisks() {
            return null;
        }

        /**
         * The volume [RAID level](https://docs.aws.amazon.com/http://en.wikipedia.org/wiki/Standard_RAID_levels) .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRaidLevel() {
            return null;
        }

        /**
         * The volume size.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * The volume type. For more information, see [Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) .
         * <p>
         * <ul>
         * <li><code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</li>
         * <li><code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</li>
         * <li><code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</li>
         * <li><code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</li>
         * <li><code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeConfigurationProperty> {
            java.lang.Object encrypted;
            java.lang.Number iops;
            java.lang.String mountPoint;
            java.lang.Number numberOfDisks;
            java.lang.Number raidLevel;
            java.lang.Number size;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getEncrypted}
             * @param encrypted Specifies whether an Amazon EBS volume is encrypted.
             *                  For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getEncrypted}
             * @param encrypted Specifies whether an Amazon EBS volume is encrypted.
             *                  For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) to provision for the volume.
             *             For PIOPS volumes, the IOPS per disk.
             *             <p>
             *             If you specify <code>io1</code> for the volume type, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getMountPoint}
             * @param mountPoint The volume mount point.
             *                   For example "/dev/sdh".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoint(java.lang.String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getNumberOfDisks}
             * @param numberOfDisks The number of disks in the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfDisks(java.lang.Number numberOfDisks) {
                this.numberOfDisks = numberOfDisks;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getRaidLevel}
             * @param raidLevel The volume [RAID level](https://docs.aws.amazon.com/http://en.wikipedia.org/wiki/Standard_RAID_levels) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder raidLevel(java.lang.Number raidLevel) {
                this.raidLevel = raidLevel;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getSize}
             * @param size The volume size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getVolumeType}
             * @param volumeType The volume type. For more information, see [Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) .
             *                   <ul>
             *                   <li><code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</li>
             *                   <li><code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</li>
             *                   <li><code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</li>
             *                   <li><code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</li>
             *                   <li><code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeConfigurationProperty {
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String mountPoint;
            private final java.lang.Number numberOfDisks;
            private final java.lang.Number raidLevel;
            private final java.lang.Number size;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPoint = software.amazon.jsii.Kernel.get(this, "mountPoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfDisks = software.amazon.jsii.Kernel.get(this, "numberOfDisks", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.raidLevel = software.amazon.jsii.Kernel.get(this, "raidLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encrypted = builder.encrypted;
                this.iops = builder.iops;
                this.mountPoint = builder.mountPoint;
                this.numberOfDisks = builder.numberOfDisks;
                this.raidLevel = builder.raidLevel;
                this.size = builder.size;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getMountPoint() {
                return this.mountPoint;
            }

            @Override
            public final java.lang.Number getNumberOfDisks() {
                return this.numberOfDisks;
            }

            @Override
            public final java.lang.Number getRaidLevel() {
                return this.raidLevel;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getMountPoint() != null) {
                    data.set("mountPoint", om.valueToTree(this.getMountPoint()));
                }
                if (this.getNumberOfDisks() != null) {
                    data.set("numberOfDisks", om.valueToTree(this.getNumberOfDisks()));
                }
                if (this.getRaidLevel() != null) {
                    data.set("raidLevel", om.valueToTree(this.getRaidLevel()));
                }
                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayer.VolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeConfigurationProperty.Jsii$Proxy that = (VolumeConfigurationProperty.Jsii$Proxy) o;

                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.mountPoint != null ? !this.mountPoint.equals(that.mountPoint) : that.mountPoint != null) return false;
                if (this.numberOfDisks != null ? !this.numberOfDisks.equals(that.numberOfDisks) : that.numberOfDisks != null) return false;
                if (this.raidLevel != null ? !this.raidLevel.equals(that.raidLevel) : that.raidLevel != null) return false;
                if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encrypted != null ? this.encrypted.hashCode() : 0;
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.mountPoint != null ? this.mountPoint.hashCode() : 0);
                result = 31 * result + (this.numberOfDisks != null ? this.numberOfDisks.hashCode() : 0);
                result = 31 * result + (this.raidLevel != null ? this.raidLevel.hashCode() : 0);
                result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opsworks.CfnLayer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opsworks.CfnLayer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opsworks.CfnLayerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opsworks.CfnLayerProps.Builder();
        }

        /**
         * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
         * <p>
         * @return {@code this}
         * @param autoAssignElasticIps Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignElasticIps(final java.lang.Boolean autoAssignElasticIps) {
            this.props.autoAssignElasticIps(autoAssignElasticIps);
            return this;
        }
        /**
         * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
         * <p>
         * @return {@code this}
         * @param autoAssignElasticIps Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignElasticIps(final software.amazon.awscdk.IResolvable autoAssignElasticIps) {
            this.props.autoAssignElasticIps(autoAssignElasticIps);
            return this;
        }

        /**
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
         * <p>
         * @return {@code this}
         * @param autoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignPublicIps(final java.lang.Boolean autoAssignPublicIps) {
            this.props.autoAssignPublicIps(autoAssignPublicIps);
            return this;
        }
        /**
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
         * <p>
         * @return {@code this}
         * @param autoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignPublicIps(final software.amazon.awscdk.IResolvable autoAssignPublicIps) {
            this.props.autoAssignPublicIps(autoAssignPublicIps);
            return this;
        }

        /**
         * Whether to disable auto healing for the layer.
         * <p>
         * @return {@code this}
         * @param enableAutoHealing Whether to disable auto healing for the layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoHealing(final java.lang.Boolean enableAutoHealing) {
            this.props.enableAutoHealing(enableAutoHealing);
            return this;
        }
        /**
         * Whether to disable auto healing for the layer.
         * <p>
         * @return {@code this}
         * @param enableAutoHealing Whether to disable auto healing for the layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoHealing(final software.amazon.awscdk.IResolvable enableAutoHealing) {
            this.props.enableAutoHealing(enableAutoHealing);
            return this;
        }

        /**
         * The layer name, which is used by the console.
         * <p>
         * Layer names can be a maximum of 32 characters.
         * <p>
         * @return {@code this}
         * @param name The layer name, which is used by the console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes.
         * <p>
         * The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
         * <p>
         * Built-in layer short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> .
         * <p>
         * @return {@code this}
         * @param shortname For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortname(final java.lang.String shortname) {
            this.props.shortname(shortname);
            return this;
        }

        /**
         * The layer stack ID.
         * <p>
         * @return {@code this}
         * @param stackId The layer stack ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackId(final java.lang.String stackId) {
            this.props.stackId(stackId);
            return this;
        }

        /**
         * The layer type.
         * <p>
         * A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
         * <p>
         * @return {@code this}
         * @param type The layer type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * <p>
         * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * <p>
         * @return {@code this}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * <p>
         * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * <p>
         * @return {@code this}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * The ARN of an IAM profile to be used for the layer's EC2 instances.
         * <p>
         * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * <p>
         * @return {@code this}
         * @param customInstanceProfileArn The ARN of an IAM profile to be used for the layer's EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customInstanceProfileArn(final java.lang.String customInstanceProfileArn) {
            this.props.customInstanceProfileArn(customInstanceProfileArn);
            return this;
        }

        /**
         * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Using Custom JSON</a> . This feature is supported as of version 1.7.42 of the AWS CLI .
         * <p>
         * @return {@code this}
         * @param customJson A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customJson(final java.lang.Object customJson) {
            this.props.customJson(customJson);
            return this;
        }

        /**
         * A `LayerCustomRecipes` object that specifies the layer custom recipes.
         * <p>
         * @return {@code this}
         * @param customRecipes A `LayerCustomRecipes` object that specifies the layer custom recipes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRecipes(final software.amazon.awscdk.services.opsworks.CfnLayer.RecipesProperty customRecipes) {
            this.props.customRecipes(customRecipes);
            return this;
        }
        /**
         * A `LayerCustomRecipes` object that specifies the layer custom recipes.
         * <p>
         * @return {@code this}
         * @param customRecipes A `LayerCustomRecipes` object that specifies the layer custom recipes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRecipes(final software.amazon.awscdk.IResolvable customRecipes) {
            this.props.customRecipes(customRecipes);
            return this;
        }

        /**
         * An array containing the layer custom security group IDs.
         * <p>
         * @return {@code this}
         * @param customSecurityGroupIds An array containing the layer custom security group IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecurityGroupIds(final java.util.List<java.lang.String> customSecurityGroupIds) {
            this.props.customSecurityGroupIds(customSecurityGroupIds);
            return this;
        }

        /**
         * Whether to install operating system and package updates when the instance boots.
         * <p>
         * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * <p>
         * <blockquote>
         * <p>
         * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(final java.lang.Boolean installUpdatesOnBoot) {
            this.props.installUpdatesOnBoot(installUpdatesOnBoot);
            return this;
        }
        /**
         * Whether to install operating system and package updates when the instance boots.
         * <p>
         * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * <p>
         * <blockquote>
         * <p>
         * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(final software.amazon.awscdk.IResolvable installUpdatesOnBoot) {
            this.props.installUpdatesOnBoot(installUpdatesOnBoot);
            return this;
        }

        /**
         * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * <p>
         * @return {@code this}
         * @param lifecycleEventConfiguration A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleEventConfiguration(final software.amazon.awscdk.services.opsworks.CfnLayer.LifecycleEventConfigurationProperty lifecycleEventConfiguration) {
            this.props.lifecycleEventConfiguration(lifecycleEventConfiguration);
            return this;
        }
        /**
         * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * <p>
         * @return {@code this}
         * @param lifecycleEventConfiguration A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleEventConfiguration(final software.amazon.awscdk.IResolvable lifecycleEventConfiguration) {
            this.props.lifecycleEventConfiguration(lifecycleEventConfiguration);
            return this;
        }

        /**
         * The load-based scaling configuration for the AWS OpsWorks layer.
         * <p>
         * @return {@code this}
         * @param loadBasedAutoScaling The load-based scaling configuration for the AWS OpsWorks layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBasedAutoScaling(final software.amazon.awscdk.services.opsworks.CfnLayer.LoadBasedAutoScalingProperty loadBasedAutoScaling) {
            this.props.loadBasedAutoScaling(loadBasedAutoScaling);
            return this;
        }
        /**
         * The load-based scaling configuration for the AWS OpsWorks layer.
         * <p>
         * @return {@code this}
         * @param loadBasedAutoScaling The load-based scaling configuration for the AWS OpsWorks layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBasedAutoScaling(final software.amazon.awscdk.IResolvable loadBasedAutoScaling) {
            this.props.loadBasedAutoScaling(loadBasedAutoScaling);
            return this;
        }

        /**
         * An array of `Package` objects that describes the layer packages.
         * <p>
         * @return {@code this}
         * @param packages An array of `Package` objects that describes the layer packages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packages(final java.util.List<java.lang.String> packages) {
            this.props.packages(packages);
            return this;
        }

        /**
         * Specifies one or more sets of tags (key–value pairs) to associate with this AWS OpsWorks layer.
         * <p>
         * Use tags to manage your resources.
         * <p>
         * @return {@code this}
         * @param tags Specifies one or more sets of tags (key–value pairs) to associate with this AWS OpsWorks layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Whether to use Amazon EBS-optimized instances.
         * <p>
         * @return {@code this}
         * @param useEbsOptimizedInstances Whether to use Amazon EBS-optimized instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEbsOptimizedInstances(final java.lang.Boolean useEbsOptimizedInstances) {
            this.props.useEbsOptimizedInstances(useEbsOptimizedInstances);
            return this;
        }
        /**
         * Whether to use Amazon EBS-optimized instances.
         * <p>
         * @return {@code this}
         * @param useEbsOptimizedInstances Whether to use Amazon EBS-optimized instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEbsOptimizedInstances(final software.amazon.awscdk.IResolvable useEbsOptimizedInstances) {
            this.props.useEbsOptimizedInstances(useEbsOptimizedInstances);
            return this;
        }

        /**
         * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         * <p>
         * @return {@code this}
         * @param volumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(final software.amazon.awscdk.IResolvable volumeConfigurations) {
            this.props.volumeConfigurations(volumeConfigurations);
            return this;
        }
        /**
         * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         * <p>
         * @return {@code this}
         * @param volumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(final java.util.List<? extends java.lang.Object> volumeConfigurations) {
            this.props.volumeConfigurations(volumeConfigurations);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.opsworks.CfnLayer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opsworks.CfnLayer build() {
            return new software.amazon.awscdk.services.opsworks.CfnLayer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
