package software.amazon.awscdk.services.networkmanager;

/**
 * A CloudFormation `AWS::NetworkManager::ConnectPeer`.
 * <p>
 * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectPeer cfnConnectPeer = CfnConnectPeer.Builder.create(this, "MyCfnConnectPeer")
 *         .bgpOptions(BgpOptionsProperty.builder()
 *                 .peerAsn(123)
 *                 .build())
 *         .connectAttachmentId("connectAttachmentId")
 *         .coreNetworkAddress("coreNetworkAddress")
 *         .insideCidrBlocks(List.of("insideCidrBlocks"))
 *         .peerAddress("peerAddress")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.044Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectPeer")
public class CfnConnectPeer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnectPeer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnectPeer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkmanager.CfnConnectPeer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::NetworkManager::ConnectPeer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectPeer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::NetworkManager::ConnectPeer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectPeer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectPeerId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectPeerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCoreNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "attrCoreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the Connect peer was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Region where the edge is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEdgeLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrEdgeLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the Connect peer.
     * <p>
     * This will be: <code>REJECTED</code> | <code>PENDING_ATTACHMENT_ACCEPTANCE</code> | <code>CREATING</code> | <code>FAILED</code> | <code>AVAILABLE</code> | <code>UPDATING</code> | <code>PENDING_NETWORK_UPDATE</code> | <code>PENDING_TAG_ACCEPTANCE</code> | <code>DELETING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags associated with the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The BGP peer options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBgpOptions() {
        return software.amazon.jsii.Kernel.get(this, "bgpOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The BGP peer options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBgpOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "bgpOptions", value);
    }

    /**
     * The BGP peer options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBgpOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bgpOptions", value);
    }

    /**
     * The ID of Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectAttachmentId() {
        return software.amazon.jsii.Kernel.get(this, "connectAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectAttachmentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectAttachmentId", value);
    }

    /**
     * The IP address of a core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
        return software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of a core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCoreNetworkAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "coreNetworkAddress", value);
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsideCidrBlocks() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsideCidrBlocks(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "insideCidrBlocks", value);
    }

    /**
     * The IP address of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
        return software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPeerAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "peerAddress", value);
    }
    /**
     * Describes the BGP options.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * BgpOptionsProperty bgpOptionsProperty = BgpOptionsProperty.builder()
     *         .peerAsn(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectPeer.BgpOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BgpOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BgpOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Peer ASN of the BGP.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeerAsn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BgpOptionsProperty> {
            java.lang.Number peerAsn;

            /**
             * Sets the value of {@link BgpOptionsProperty#getPeerAsn}
             * @param peerAsn The Peer ASN of the BGP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAsn(java.lang.Number peerAsn) {
                this.peerAsn = peerAsn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BgpOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BgpOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BgpOptionsProperty {
            private final java.lang.Number peerAsn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.peerAsn = software.amazon.jsii.Kernel.get(this, "peerAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.peerAsn = builder.peerAsn;
            }

            @Override
            public final java.lang.Number getPeerAsn() {
                return this.peerAsn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPeerAsn() != null) {
                    data.set("peerAsn", om.valueToTree(this.getPeerAsn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnConnectPeer.BgpOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BgpOptionsProperty.Jsii$Proxy that = (BgpOptionsProperty.Jsii$Proxy) o;

                return this.peerAsn != null ? this.peerAsn.equals(that.peerAsn) : that.peerAsn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.peerAsn != null ? this.peerAsn.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkmanager.CfnConnectPeer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkmanager.CfnConnectPeer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The BGP peer options.
         * <p>
         * @return {@code this}
         * @param bgpOptions The BGP peer options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(final software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty bgpOptions) {
            this.props().bgpOptions(bgpOptions);
            return this;
        }
        /**
         * The BGP peer options.
         * <p>
         * @return {@code this}
         * @param bgpOptions The BGP peer options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(final software.amazon.awscdk.IResolvable bgpOptions) {
            this.props().bgpOptions(bgpOptions);
            return this;
        }

        /**
         * The ID of Connect peer.
         * <p>
         * @return {@code this}
         * @param connectAttachmentId The ID of Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectAttachmentId(final java.lang.String connectAttachmentId) {
            this.props().connectAttachmentId(connectAttachmentId);
            return this;
        }

        /**
         * The IP address of a core network.
         * <p>
         * @return {@code this}
         * @param coreNetworkAddress The IP address of a core network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkAddress(final java.lang.String coreNetworkAddress) {
            this.props().coreNetworkAddress(coreNetworkAddress);
            return this;
        }

        /**
         * The inside IP addresses used for a Connect peer configuration.
         * <p>
         * @return {@code this}
         * @param insideCidrBlocks The inside IP addresses used for a Connect peer configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insideCidrBlocks(final java.util.List<java.lang.String> insideCidrBlocks) {
            this.props().insideCidrBlocks(insideCidrBlocks);
            return this;
        }

        /**
         * The IP address of the Connect peer.
         * <p>
         * @return {@code this}
         * @param peerAddress The IP address of the Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAddress(final java.lang.String peerAddress) {
            this.props().peerAddress(peerAddress);
            return this;
        }

        /**
         * The tags associated with the Connect peer.
         * <p>
         * @return {@code this}
         * @param tags The tags associated with the Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.networkmanager.CfnConnectPeer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkmanager.CfnConnectPeer build() {
            return new software.amazon.awscdk.services.networkmanager.CfnConnectPeer(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder();
            }
            return this.props;
        }
    }
}
