package software.amazon.awscdk.services.mediapackage;

/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 * <p>
 * Create an endpoint on an AWS Elemental MediaPackage channel.
 * <p>
 * An endpoint represents a single delivery point of a channel, and defines content output handling through various components, such as packaging protocols, DRM and encryption integration, and more.
 * <p>
 * After it's created, an endpoint provides a fixed public URL. This URL remains the same throughout the lifetime of the endpoint, regardless of any failures or upgrades that might occur. Integrate the URL with a downstream CDN (such as Amazon CloudFront) or playback device.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackage.*;
 * CfnOriginEndpoint cfnOriginEndpoint = CfnOriginEndpoint.Builder.create(this, "MyCfnOriginEndpoint")
 *         .channelId("channelId")
 *         .id("id")
 *         // the properties below are optional
 *         .authorization(AuthorizationProperty.builder()
 *                 .cdnIdentifierSecret("cdnIdentifierSecret")
 *                 .secretsRoleArn("secretsRoleArn")
 *                 .build())
 *         .cmafPackage(CmafPackageProperty.builder()
 *                 .encryption(CmafEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .certificateArn("certificateArn")
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .keyRotationIntervalSeconds(123)
 *                         .build())
 *                 .hlsManifests(List.of(HlsManifestProperty.builder()
 *                         .id("id")
 *                         // the properties below are optional
 *                         .adMarkers("adMarkers")
 *                         .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
 *                         .adTriggers(List.of("adTriggers"))
 *                         .includeIframeOnlyStream(false)
 *                         .manifestName("manifestName")
 *                         .playlistType("playlistType")
 *                         .playlistWindowSeconds(123)
 *                         .programDateTimeIntervalSeconds(123)
 *                         .url("url")
 *                         .build()))
 *                 .segmentDurationSeconds(123)
 *                 .segmentPrefix("segmentPrefix")
 *                 .streamSelection(StreamSelectionProperty.builder()
 *                         .maxVideoBitsPerSecond(123)
 *                         .minVideoBitsPerSecond(123)
 *                         .streamOrder("streamOrder")
 *                         .build())
 *                 .build())
 *         .dashPackage(DashPackageProperty.builder()
 *                 .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
 *                 .adTriggers(List.of("adTriggers"))
 *                 .encryption(DashEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .certificateArn("certificateArn")
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .keyRotationIntervalSeconds(123)
 *                         .build())
 *                 .includeIframeOnlyStream(false)
 *                 .manifestLayout("manifestLayout")
 *                 .manifestWindowSeconds(123)
 *                 .minBufferTimeSeconds(123)
 *                 .minUpdatePeriodSeconds(123)
 *                 .periodTriggers(List.of("periodTriggers"))
 *                 .profile("profile")
 *                 .segmentDurationSeconds(123)
 *                 .segmentTemplateFormat("segmentTemplateFormat")
 *                 .streamSelection(StreamSelectionProperty.builder()
 *                         .maxVideoBitsPerSecond(123)
 *                         .minVideoBitsPerSecond(123)
 *                         .streamOrder("streamOrder")
 *                         .build())
 *                 .suggestedPresentationDelaySeconds(123)
 *                 .utcTiming("utcTiming")
 *                 .utcTimingUri("utcTimingUri")
 *                 .build())
 *         .description("description")
 *         .hlsPackage(HlsPackageProperty.builder()
 *                 .adMarkers("adMarkers")
 *                 .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
 *                 .adTriggers(List.of("adTriggers"))
 *                 .encryption(HlsEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .certificateArn("certificateArn")
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .encryptionMethod("encryptionMethod")
 *                         .keyRotationIntervalSeconds(123)
 *                         .repeatExtXKey(false)
 *                         .build())
 *                 .includeIframeOnlyStream(false)
 *                 .playlistType("playlistType")
 *                 .playlistWindowSeconds(123)
 *                 .programDateTimeIntervalSeconds(123)
 *                 .segmentDurationSeconds(123)
 *                 .streamSelection(StreamSelectionProperty.builder()
 *                         .maxVideoBitsPerSecond(123)
 *                         .minVideoBitsPerSecond(123)
 *                         .streamOrder("streamOrder")
 *                         .build())
 *                 .useAudioRenditionGroup(false)
 *                 .build())
 *         .manifestName("manifestName")
 *         .mssPackage(MssPackageProperty.builder()
 *                 .encryption(MssEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .certificateArn("certificateArn")
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .segmentDurationSeconds(123)
 *                 .streamSelection(StreamSelectionProperty.builder()
 *                         .maxVideoBitsPerSecond(123)
 *                         .minVideoBitsPerSecond(123)
 *                         .streamOrder("streamOrder")
 *                         .build())
 *                 .build())
 *         .origination("origination")
 *         .startoverWindowSeconds(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeDelaySeconds(123)
 *         .whitelist(List.of("whitelist"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:40.918Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint")
public class CfnOriginEndpoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnOriginEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::MediaPackage::OriginEndpoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackage.CfnOriginEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The endpoint's unique system-generated resource name, based on the AWS record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * URL for the key provider’s key retrieval API endpoint.
     * <p>
     * Must start with https://.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to assign to the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the channel associated with this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelId() {
        return software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the channel associated with this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelId", java.util.Objects.requireNonNull(value, "channelId is required"));
    }

    /**
     * The manifest ID is required and must be unique within the OriginEndpoint.
     * <p>
     * The ID can't be changed after the endpoint is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The manifest ID is required and must be unique within the OriginEndpoint.
     * <p>
     * The ID can't be changed after the endpoint is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "id", java.util.Objects.requireNonNull(value, "id is required"));
    }

    /**
     * Parameters for CDN authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuthorization() {
        return software.amazon.jsii.Kernel.get(this, "authorization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for CDN authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.AuthorizationProperty value) {
        software.amazon.jsii.Kernel.set(this, "authorization", value);
    }

    /**
     * Parameters for CDN authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authorization", value);
    }

    /**
     * Parameters for Common Media Application Format (CMAF) packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCmafPackage() {
        return software.amazon.jsii.Kernel.get(this, "cmafPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for Common Media Application Format (CMAF) packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmafPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.CmafPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "cmafPackage", value);
    }

    /**
     * Parameters for Common Media Application Format (CMAF) packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmafPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cmafPackage", value);
    }

    /**
     * Parameters for DASH packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashPackage() {
        return software.amazon.jsii.Kernel.get(this, "dashPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for DASH packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.DashPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "dashPackage", value);
    }

    /**
     * Parameters for DASH packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashPackage", value);
    }

    /**
     * Any descriptive information that you want to add to the endpoint for future identification purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Any descriptive information that you want to add to the endpoint for future identification purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHlsPackage() {
        return software.amazon.jsii.Kernel.get(this, "hlsPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.HlsPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "hlsPackage", value);
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hlsPackage", value);
    }

    /**
     * A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getManifestName() {
        return software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManifestName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "manifestName", value);
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMssPackage() {
        return software.amazon.jsii.Kernel.get(this, "mssPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "mssPackage", value);
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mssPackage", value);
    }

    /**
     * Controls video origination from this endpoint.
     * <p>
     * <ul>
     * <li><code>ALLOW</code> - enables this endpoint to serve content to requesting devices.</li>
     * <li><code>DENY</code> - prevents this endpoint from serving content. Denying origination is helpful for harvesting live-to-VOD assets. For more information about harvesting and origination, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/ltov-reqmts.html">Live-to-VOD Requirements</a> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOrigination() {
        return software.amazon.jsii.Kernel.get(this, "origination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Controls video origination from this endpoint.
     * <p>
     * <ul>
     * <li><code>ALLOW</code> - enables this endpoint to serve content to requesting devices.</li>
     * <li><code>DENY</code> - prevents this endpoint from serving content. Denying origination is helpful for harvesting live-to-VOD assets. For more information about harvesting and origination, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/ltov-reqmts.html">Live-to-VOD Requirements</a> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrigination(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "origination", value);
    }

    /**
     * Maximum duration (seconds) of content to retain for startover playback.
     * <p>
     * Omit this attribute or enter <code>0</code> to indicate that startover playback is disabled for this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStartoverWindowSeconds() {
        return software.amazon.jsii.Kernel.get(this, "startoverWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Maximum duration (seconds) of content to retain for startover playback.
     * <p>
     * Omit this attribute or enter <code>0</code> to indicate that startover playback is disabled for this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartoverWindowSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "startoverWindowSeconds", value);
    }

    /**
     * Minimum duration (seconds) of delay to enforce on the playback of live content.
     * <p>
     * Omit this attribute or enter <code>0</code> to indicate that there is no time delay in effect for this endpoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeDelaySeconds() {
        return software.amazon.jsii.Kernel.get(this, "timeDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Minimum duration (seconds) of delay to enforce on the playback of live content.
     * <p>
     * Omit this attribute or enter <code>0</code> to indicate that there is no time delay in effect for this endpoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeDelaySeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeDelaySeconds", value);
    }

    /**
     * The IP addresses that can access this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWhitelist() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "whitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IP addresses that can access this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWhitelist(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "whitelist", value);
    }
    /**
     * Parameters for enabling CDN authorization on the endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * AuthorizationProperty authorizationProperty = AuthorizationProperty.builder()
     *         .cdnIdentifierSecret("cdnIdentifierSecret")
     *         .secretsRoleArn("secretsRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.AuthorizationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCdnIdentifierSecret();

        /**
         * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretsRoleArn();

        /**
         * @return a {@link Builder} of {@link AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationProperty> {
            java.lang.String cdnIdentifierSecret;
            java.lang.String secretsRoleArn;

            /**
             * Sets the value of {@link AuthorizationProperty#getCdnIdentifierSecret}
             * @param cdnIdentifierSecret The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdnIdentifierSecret(java.lang.String cdnIdentifierSecret) {
                this.cdnIdentifierSecret = cdnIdentifierSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationProperty#getSecretsRoleArn}
             * @param secretsRoleArn The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsRoleArn(java.lang.String secretsRoleArn) {
                this.secretsRoleArn = secretsRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationProperty {
            private final java.lang.String cdnIdentifierSecret;
            private final java.lang.String secretsRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cdnIdentifierSecret = software.amazon.jsii.Kernel.get(this, "cdnIdentifierSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsRoleArn = software.amazon.jsii.Kernel.get(this, "secretsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cdnIdentifierSecret = java.util.Objects.requireNonNull(builder.cdnIdentifierSecret, "cdnIdentifierSecret is required");
                this.secretsRoleArn = java.util.Objects.requireNonNull(builder.secretsRoleArn, "secretsRoleArn is required");
            }

            @Override
            public final java.lang.String getCdnIdentifierSecret() {
                return this.cdnIdentifierSecret;
            }

            @Override
            public final java.lang.String getSecretsRoleArn() {
                return this.secretsRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cdnIdentifierSecret", om.valueToTree(this.getCdnIdentifierSecret()));
                data.set("secretsRoleArn", om.valueToTree(this.getSecretsRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.AuthorizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationProperty.Jsii$Proxy that = (AuthorizationProperty.Jsii$Proxy) o;

                if (!cdnIdentifierSecret.equals(that.cdnIdentifierSecret)) return false;
                return this.secretsRoleArn.equals(that.secretsRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.cdnIdentifierSecret.hashCode();
                result = 31 * result + (this.secretsRoleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * CmafEncryptionProperty cmafEncryptionProperty = CmafEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .resourceId("resourceId")
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                         .presetSpeke20Audio("presetSpeke20Audio")
     *                         .presetSpeke20Video("presetSpeke20Video")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .constantInitializationVector("constantInitializationVector")
     *         .keyRotationIntervalSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.CmafEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks.
         * <p>
         * If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * Number of seconds before AWS Elemental MediaPackage rotates to a new key.
         * <p>
         * By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getKeyRotationIntervalSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafEncryptionProperty> {
            java.lang.Object spekeKeyProvider;
            java.lang.String constantInitializationVector;
            java.lang.Number keyRotationIntervalSeconds;

            /**
             * Sets the value of {@link CmafEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link CmafEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link CmafEncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks.
             *                                     If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link CmafEncryptionProperty#getKeyRotationIntervalSeconds}
             * @param keyRotationIntervalSeconds Number of seconds before AWS Elemental MediaPackage rotates to a new key.
             *                                   By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyRotationIntervalSeconds(java.lang.Number keyRotationIntervalSeconds) {
                this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;
            private final java.lang.String constantInitializationVector;
            private final java.lang.Number keyRotationIntervalSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyRotationIntervalSeconds = software.amazon.jsii.Kernel.get(this, "keyRotationIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
                this.constantInitializationVector = builder.constantInitializationVector;
                this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.Number getKeyRotationIntervalSeconds() {
                return this.keyRotationIntervalSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getKeyRotationIntervalSeconds() != null) {
                    data.set("keyRotationIntervalSeconds", om.valueToTree(this.getKeyRotationIntervalSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.CmafEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafEncryptionProperty.Jsii$Proxy that = (CmafEncryptionProperty.Jsii$Proxy) o;

                if (!spekeKeyProvider.equals(that.spekeKeyProvider)) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                return this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.equals(that.keyRotationIntervalSeconds) : that.keyRotationIntervalSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for Common Media Application Format (CMAF) packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * CmafPackageProperty cmafPackageProperty = CmafPackageProperty.builder()
     *         .encryption(CmafEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .resourceId("resourceId")
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         // the properties below are optional
     *                         .certificateArn("certificateArn")
     *                         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                                 .presetSpeke20Audio("presetSpeke20Audio")
     *                                 .presetSpeke20Video("presetSpeke20Video")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .keyRotationIntervalSeconds(123)
     *                 .build())
     *         .hlsManifests(List.of(HlsManifestProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .adMarkers("adMarkers")
     *                 .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
     *                 .adTriggers(List.of("adTriggers"))
     *                 .includeIframeOnlyStream(false)
     *                 .manifestName("manifestName")
     *                 .playlistType("playlistType")
     *                 .playlistWindowSeconds(123)
     *                 .programDateTimeIntervalSeconds(123)
     *                 .url("url")
     *                 .build()))
     *         .segmentDurationSeconds(123)
     *         .segmentPrefix("segmentPrefix")
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.CmafPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * A list of HLS manifest configurations that are available from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHlsManifests() {
            return null;
        }

        /**
         * Duration (in seconds) of each segment.
         * <p>
         * Actual segments are rounded to the nearest multiple of the source segment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * An optional custom string that is prepended to the name of each segment.
         * <p>
         * If not specified, the segment prefix defaults to the ChannelId.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentPrefix() {
            return null;
        }

        /**
         * Limitations for outputs from the endpoint, based on the video bitrate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafPackageProperty> {
            java.lang.Object encryption;
            java.lang.Object hlsManifests;
            java.lang.Number segmentDurationSeconds;
            java.lang.String segmentPrefix;
            java.lang.Object streamSelection;

            /**
             * Sets the value of {@link CmafPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.CmafEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(software.amazon.awscdk.IResolvable hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(java.util.List<? extends java.lang.Object> hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each segment.
             *                               Actual segments are rounded to the nearest multiple of the source segment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getSegmentPrefix}
             * @param segmentPrefix An optional custom string that is prepended to the name of each segment.
             *                      If not specified, the segment prefix defaults to the ChannelId.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentPrefix(java.lang.String segmentPrefix) {
                this.segmentPrefix = segmentPrefix;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafPackageProperty {
            private final java.lang.Object encryption;
            private final java.lang.Object hlsManifests;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.String segmentPrefix;
            private final java.lang.Object streamSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hlsManifests = software.amazon.jsii.Kernel.get(this, "hlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentPrefix = software.amazon.jsii.Kernel.get(this, "segmentPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryption = builder.encryption;
                this.hlsManifests = builder.hlsManifests;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.segmentPrefix = builder.segmentPrefix;
                this.streamSelection = builder.streamSelection;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getHlsManifests() {
                return this.hlsManifests;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.String getSegmentPrefix() {
                return this.segmentPrefix;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getHlsManifests() != null) {
                    data.set("hlsManifests", om.valueToTree(this.getHlsManifests()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getSegmentPrefix() != null) {
                    data.set("segmentPrefix", om.valueToTree(this.getSegmentPrefix()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.CmafPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafPackageProperty.Jsii$Proxy that = (CmafPackageProperty.Jsii$Proxy) o;

                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.hlsManifests != null ? !this.hlsManifests.equals(that.hlsManifests) : that.hlsManifests != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                if (this.segmentPrefix != null ? !this.segmentPrefix.equals(that.segmentPrefix) : that.segmentPrefix != null) return false;
                return this.streamSelection != null ? this.streamSelection.equals(that.streamSelection) : that.streamSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryption != null ? this.encryption.hashCode() : 0;
                result = 31 * result + (this.hlsManifests != null ? this.hlsManifests.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentPrefix != null ? this.segmentPrefix.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * DashEncryptionProperty dashEncryptionProperty = DashEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .resourceId("resourceId")
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                         .presetSpeke20Audio("presetSpeke20Audio")
     *                         .presetSpeke20Video("presetSpeke20Video")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .keyRotationIntervalSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.DashEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(DashEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * Number of seconds before AWS Elemental MediaPackage rotates to a new key.
         * <p>
         * By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getKeyRotationIntervalSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashEncryptionProperty> {
            java.lang.Object spekeKeyProvider;
            java.lang.Number keyRotationIntervalSeconds;

            /**
             * Sets the value of {@link DashEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link DashEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link DashEncryptionProperty#getKeyRotationIntervalSeconds}
             * @param keyRotationIntervalSeconds Number of seconds before AWS Elemental MediaPackage rotates to a new key.
             *                                   By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyRotationIntervalSeconds(java.lang.Number keyRotationIntervalSeconds) {
                this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;
            private final java.lang.Number keyRotationIntervalSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyRotationIntervalSeconds = software.amazon.jsii.Kernel.get(this, "keyRotationIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
                this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            public final java.lang.Number getKeyRotationIntervalSeconds() {
                return this.keyRotationIntervalSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));
                if (this.getKeyRotationIntervalSeconds() != null) {
                    data.set("keyRotationIntervalSeconds", om.valueToTree(this.getKeyRotationIntervalSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.DashEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashEncryptionProperty.Jsii$Proxy that = (DashEncryptionProperty.Jsii$Proxy) o;

                if (!spekeKeyProvider.equals(that.spekeKeyProvider)) return false;
                return this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.equals(that.keyRotationIntervalSeconds) : that.keyRotationIntervalSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                result = 31 * result + (this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for DASH packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * DashPackageProperty dashPackageProperty = DashPackageProperty.builder()
     *         .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
     *         .adTriggers(List.of("adTriggers"))
     *         .encryption(DashEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .resourceId("resourceId")
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         // the properties below are optional
     *                         .certificateArn("certificateArn")
     *                         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                                 .presetSpeke20Audio("presetSpeke20Audio")
     *                                 .presetSpeke20Video("presetSpeke20Video")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .keyRotationIntervalSeconds(123)
     *                 .build())
     *         .includeIframeOnlyStream(false)
     *         .manifestLayout("manifestLayout")
     *         .manifestWindowSeconds(123)
     *         .minBufferTimeSeconds(123)
     *         .minUpdatePeriodSeconds(123)
     *         .periodTriggers(List.of("periodTriggers"))
     *         .profile("profile")
     *         .segmentDurationSeconds(123)
     *         .segmentTemplateFormat("segmentTemplateFormat")
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .suggestedPresentationDelaySeconds(123)
     *         .utcTiming("utcTiming")
     *         .utcTimingUri("utcTimingUri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.DashPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(DashPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
         * <p>
         * For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdsOnDeliveryRestrictions() {
            return null;
        }

        /**
         * Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>BREAK</code></li>
         * <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
         * <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code> .</li>
         * <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code> .</li>
         * <li><code>PROVIDER_ADVERTISEMENT</code> .</li>
         * <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code> .</li>
         * <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code> .</li>
         * <li><code>SPLICE_INSERT</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdTriggers() {
            return null;
        }

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * `CfnOriginEndpoint.DashPackageProperty.IncludeIframeOnlyStream`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeIframeOnlyStream() {
            return null;
        }

        /**
         * Determines the position of some tags in the manifest.
         * <p>
         * Options:
         * <p>
         * <ul>
         * <li><code>FULL</code> - elements like <code>SegmentTemplate</code> and <code>ContentProtection</code> are included in each <code>Representation</code> .</li>
         * <li><code>COMPACT</code> - duplicate elements are combined and presented at the <code>AdaptationSet</code> level.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestLayout() {
            return null;
        }

        /**
         * Time window (in seconds) contained in each manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinBufferTimeSeconds() {
            return null;
        }

        /**
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinUpdatePeriodSeconds() {
            return null;
        }

        /**
         * Controls whether MediaPackage produces single-period or multi-period DASH manifests.
         * <p>
         * For more information about periods, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>ADS</code> - MediaPackage will produce multi-period DASH manifests. Periods are created based on the SCTE-35 ad markers present in the input manifest.</li>
         * <li><em>No value</em> - MediaPackage will produce single-period DASH manifests. This is the default setting.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPeriodTriggers() {
            return null;
        }

        /**
         * DASH profile for the output, such as HbbTV.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>NONE</code> - the output doesn't use a DASH profile.</li>
         * <li><code>HBBTV_1_5</code> - the output is HbbTV-compliant.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * Determines the type of variable used in the `media` URL of the `SegmentTemplate` tag in the manifest.
         * <p>
         * Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code> .
         * <p>
         * <ul>
         * <li><code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
         * <li><code>NUMBER_WITH_DURATION</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL and a <code>duration</code> attribute is added to the segment template. The <code>SegmentTimeline</code> object is removed from the representation.</li>
         * <li><code>TIME_WITH_TIMELINE</code> - The <code>$Time$</code> variable is used in the <code>media</code> URL. The value of this variable is the timestamp of when the segment starts. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentTemplateFormat() {
            return null;
        }

        /**
         * Limitations for outputs from the endpoint, based on the video bitrate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSuggestedPresentationDelaySeconds() {
            return null;
        }

        /**
         * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUtcTiming() {
            return null;
        }

        /**
         * Specifies the value attribute of the UTC timing field when utcTiming is set to HTTP-ISO or HTTP-HEAD.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUtcTimingUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashPackageProperty> {
            java.lang.String adsOnDeliveryRestrictions;
            java.util.List<java.lang.String> adTriggers;
            java.lang.Object encryption;
            java.lang.Object includeIframeOnlyStream;
            java.lang.String manifestLayout;
            java.lang.Number manifestWindowSeconds;
            java.lang.Number minBufferTimeSeconds;
            java.lang.Number minUpdatePeriodSeconds;
            java.util.List<java.lang.String> periodTriggers;
            java.lang.String profile;
            java.lang.Number segmentDurationSeconds;
            java.lang.String segmentTemplateFormat;
            java.lang.Object streamSelection;
            java.lang.Number suggestedPresentationDelaySeconds;
            java.lang.String utcTiming;
            java.lang.String utcTimingUri;

            /**
             * Sets the value of {@link DashPackageProperty#getAdsOnDeliveryRestrictions}
             * @param adsOnDeliveryRestrictions The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
             *                                  For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adsOnDeliveryRestrictions(java.lang.String adsOnDeliveryRestrictions) {
                this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getAdTriggers}
             * @param adTriggers Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
             *                   Valid values:
             *                   <p>
             *                   <ul>
             *                   <li><code>BREAK</code></li>
             *                   <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
             *                   <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code> .</li>
             *                   <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code> .</li>
             *                   <li><code>PROVIDER_ADVERTISEMENT</code> .</li>
             *                   <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code> .</li>
             *                   <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code> .</li>
             *                   <li><code>SPLICE_INSERT</code> .</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adTriggers(java.util.List<java.lang.String> adTriggers) {
                this.adTriggers = adTriggers;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.DashEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream `CfnOriginEndpoint.DashPackageProperty.IncludeIframeOnlyStream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(java.lang.Boolean includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream `CfnOriginEndpoint.DashPackageProperty.IncludeIframeOnlyStream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(software.amazon.awscdk.IResolvable includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getManifestLayout}
             * @param manifestLayout Determines the position of some tags in the manifest.
             *                       Options:
             *                       <p>
             *                       <ul>
             *                       <li><code>FULL</code> - elements like <code>SegmentTemplate</code> and <code>ContentProtection</code> are included in each <code>Representation</code> .</li>
             *                       <li><code>COMPACT</code> - duplicate elements are combined and presented at the <code>AdaptationSet</code> level.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestLayout(java.lang.String manifestLayout) {
                this.manifestLayout = manifestLayout;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds Time window (in seconds) contained in each manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getMinBufferTimeSeconds}
             * @param minBufferTimeSeconds Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minBufferTimeSeconds(java.lang.Number minBufferTimeSeconds) {
                this.minBufferTimeSeconds = minBufferTimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getMinUpdatePeriodSeconds}
             * @param minUpdatePeriodSeconds Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minUpdatePeriodSeconds(java.lang.Number minUpdatePeriodSeconds) {
                this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getPeriodTriggers}
             * @param periodTriggers Controls whether MediaPackage produces single-period or multi-period DASH manifests.
             *                       For more information about periods, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
             *                       <p>
             *                       Valid values:
             *                       <p>
             *                       <ul>
             *                       <li><code>ADS</code> - MediaPackage will produce multi-period DASH manifests. Periods are created based on the SCTE-35 ad markers present in the input manifest.</li>
             *                       <li><em>No value</em> - MediaPackage will produce single-period DASH manifests. This is the default setting.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodTriggers(java.util.List<java.lang.String> periodTriggers) {
                this.periodTriggers = periodTriggers;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getProfile}
             * @param profile DASH profile for the output, such as HbbTV.
             *                Valid values:
             *                <p>
             *                <ul>
             *                <li><code>NONE</code> - the output doesn't use a DASH profile.</li>
             *                <li><code>HBBTV_1_5</code> - the output is HbbTV-compliant.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profile(java.lang.String profile) {
                this.profile = profile;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getSegmentTemplateFormat}
             * @param segmentTemplateFormat Determines the type of variable used in the `media` URL of the `SegmentTemplate` tag in the manifest.
             *                              Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code> .
             *                              <p>
             *                              <ul>
             *                              <li><code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
             *                              <li><code>NUMBER_WITH_DURATION</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL and a <code>duration</code> attribute is added to the segment template. The <code>SegmentTimeline</code> object is removed from the representation.</li>
             *                              <li><code>TIME_WITH_TIMELINE</code> - The <code>$Time$</code> variable is used in the <code>media</code> URL. The value of this variable is the timestamp of when the segment starts. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentTemplateFormat(java.lang.String segmentTemplateFormat) {
                this.segmentTemplateFormat = segmentTemplateFormat;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getSuggestedPresentationDelaySeconds}
             * @param suggestedPresentationDelaySeconds Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suggestedPresentationDelaySeconds(java.lang.Number suggestedPresentationDelaySeconds) {
                this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getUtcTiming}
             * @param utcTiming Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utcTiming(java.lang.String utcTiming) {
                this.utcTiming = utcTiming;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getUtcTimingUri}
             * @param utcTimingUri Specifies the value attribute of the UTC timing field when utcTiming is set to HTTP-ISO or HTTP-HEAD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utcTimingUri(java.lang.String utcTimingUri) {
                this.utcTimingUri = utcTimingUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashPackageProperty {
            private final java.lang.String adsOnDeliveryRestrictions;
            private final java.util.List<java.lang.String> adTriggers;
            private final java.lang.Object encryption;
            private final java.lang.Object includeIframeOnlyStream;
            private final java.lang.String manifestLayout;
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number minBufferTimeSeconds;
            private final java.lang.Number minUpdatePeriodSeconds;
            private final java.util.List<java.lang.String> periodTriggers;
            private final java.lang.String profile;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.String segmentTemplateFormat;
            private final java.lang.Object streamSelection;
            private final java.lang.Number suggestedPresentationDelaySeconds;
            private final java.lang.String utcTiming;
            private final java.lang.String utcTimingUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adsOnDeliveryRestrictions = software.amazon.jsii.Kernel.get(this, "adsOnDeliveryRestrictions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adTriggers = software.amazon.jsii.Kernel.get(this, "adTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeIframeOnlyStream = software.amazon.jsii.Kernel.get(this, "includeIframeOnlyStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestLayout = software.amazon.jsii.Kernel.get(this, "manifestLayout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minBufferTimeSeconds = software.amazon.jsii.Kernel.get(this, "minBufferTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minUpdatePeriodSeconds = software.amazon.jsii.Kernel.get(this, "minUpdatePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.periodTriggers = software.amazon.jsii.Kernel.get(this, "periodTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentTemplateFormat = software.amazon.jsii.Kernel.get(this, "segmentTemplateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.suggestedPresentationDelaySeconds = software.amazon.jsii.Kernel.get(this, "suggestedPresentationDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.utcTiming = software.amazon.jsii.Kernel.get(this, "utcTiming", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.utcTimingUri = software.amazon.jsii.Kernel.get(this, "utcTimingUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
                this.adTriggers = builder.adTriggers;
                this.encryption = builder.encryption;
                this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
                this.manifestLayout = builder.manifestLayout;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
                this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
                this.periodTriggers = builder.periodTriggers;
                this.profile = builder.profile;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.segmentTemplateFormat = builder.segmentTemplateFormat;
                this.streamSelection = builder.streamSelection;
                this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
                this.utcTiming = builder.utcTiming;
                this.utcTimingUri = builder.utcTimingUri;
            }

            @Override
            public final java.lang.String getAdsOnDeliveryRestrictions() {
                return this.adsOnDeliveryRestrictions;
            }

            @Override
            public final java.util.List<java.lang.String> getAdTriggers() {
                return this.adTriggers;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getIncludeIframeOnlyStream() {
                return this.includeIframeOnlyStream;
            }

            @Override
            public final java.lang.String getManifestLayout() {
                return this.manifestLayout;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getMinBufferTimeSeconds() {
                return this.minBufferTimeSeconds;
            }

            @Override
            public final java.lang.Number getMinUpdatePeriodSeconds() {
                return this.minUpdatePeriodSeconds;
            }

            @Override
            public final java.util.List<java.lang.String> getPeriodTriggers() {
                return this.periodTriggers;
            }

            @Override
            public final java.lang.String getProfile() {
                return this.profile;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.String getSegmentTemplateFormat() {
                return this.segmentTemplateFormat;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            public final java.lang.Number getSuggestedPresentationDelaySeconds() {
                return this.suggestedPresentationDelaySeconds;
            }

            @Override
            public final java.lang.String getUtcTiming() {
                return this.utcTiming;
            }

            @Override
            public final java.lang.String getUtcTimingUri() {
                return this.utcTimingUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdsOnDeliveryRestrictions() != null) {
                    data.set("adsOnDeliveryRestrictions", om.valueToTree(this.getAdsOnDeliveryRestrictions()));
                }
                if (this.getAdTriggers() != null) {
                    data.set("adTriggers", om.valueToTree(this.getAdTriggers()));
                }
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getIncludeIframeOnlyStream() != null) {
                    data.set("includeIframeOnlyStream", om.valueToTree(this.getIncludeIframeOnlyStream()));
                }
                if (this.getManifestLayout() != null) {
                    data.set("manifestLayout", om.valueToTree(this.getManifestLayout()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getMinBufferTimeSeconds() != null) {
                    data.set("minBufferTimeSeconds", om.valueToTree(this.getMinBufferTimeSeconds()));
                }
                if (this.getMinUpdatePeriodSeconds() != null) {
                    data.set("minUpdatePeriodSeconds", om.valueToTree(this.getMinUpdatePeriodSeconds()));
                }
                if (this.getPeriodTriggers() != null) {
                    data.set("periodTriggers", om.valueToTree(this.getPeriodTriggers()));
                }
                if (this.getProfile() != null) {
                    data.set("profile", om.valueToTree(this.getProfile()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getSegmentTemplateFormat() != null) {
                    data.set("segmentTemplateFormat", om.valueToTree(this.getSegmentTemplateFormat()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }
                if (this.getSuggestedPresentationDelaySeconds() != null) {
                    data.set("suggestedPresentationDelaySeconds", om.valueToTree(this.getSuggestedPresentationDelaySeconds()));
                }
                if (this.getUtcTiming() != null) {
                    data.set("utcTiming", om.valueToTree(this.getUtcTiming()));
                }
                if (this.getUtcTimingUri() != null) {
                    data.set("utcTimingUri", om.valueToTree(this.getUtcTimingUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.DashPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashPackageProperty.Jsii$Proxy that = (DashPackageProperty.Jsii$Proxy) o;

                if (this.adsOnDeliveryRestrictions != null ? !this.adsOnDeliveryRestrictions.equals(that.adsOnDeliveryRestrictions) : that.adsOnDeliveryRestrictions != null) return false;
                if (this.adTriggers != null ? !this.adTriggers.equals(that.adTriggers) : that.adTriggers != null) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.includeIframeOnlyStream != null ? !this.includeIframeOnlyStream.equals(that.includeIframeOnlyStream) : that.includeIframeOnlyStream != null) return false;
                if (this.manifestLayout != null ? !this.manifestLayout.equals(that.manifestLayout) : that.manifestLayout != null) return false;
                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.minBufferTimeSeconds != null ? !this.minBufferTimeSeconds.equals(that.minBufferTimeSeconds) : that.minBufferTimeSeconds != null) return false;
                if (this.minUpdatePeriodSeconds != null ? !this.minUpdatePeriodSeconds.equals(that.minUpdatePeriodSeconds) : that.minUpdatePeriodSeconds != null) return false;
                if (this.periodTriggers != null ? !this.periodTriggers.equals(that.periodTriggers) : that.periodTriggers != null) return false;
                if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                if (this.segmentTemplateFormat != null ? !this.segmentTemplateFormat.equals(that.segmentTemplateFormat) : that.segmentTemplateFormat != null) return false;
                if (this.streamSelection != null ? !this.streamSelection.equals(that.streamSelection) : that.streamSelection != null) return false;
                if (this.suggestedPresentationDelaySeconds != null ? !this.suggestedPresentationDelaySeconds.equals(that.suggestedPresentationDelaySeconds) : that.suggestedPresentationDelaySeconds != null) return false;
                if (this.utcTiming != null ? !this.utcTiming.equals(that.utcTiming) : that.utcTiming != null) return false;
                return this.utcTimingUri != null ? this.utcTimingUri.equals(that.utcTimingUri) : that.utcTimingUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adsOnDeliveryRestrictions != null ? this.adsOnDeliveryRestrictions.hashCode() : 0;
                result = 31 * result + (this.adTriggers != null ? this.adTriggers.hashCode() : 0);
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.includeIframeOnlyStream != null ? this.includeIframeOnlyStream.hashCode() : 0);
                result = 31 * result + (this.manifestLayout != null ? this.manifestLayout.hashCode() : 0);
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.minBufferTimeSeconds != null ? this.minBufferTimeSeconds.hashCode() : 0);
                result = 31 * result + (this.minUpdatePeriodSeconds != null ? this.minUpdatePeriodSeconds.hashCode() : 0);
                result = 31 * result + (this.periodTriggers != null ? this.periodTriggers.hashCode() : 0);
                result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentTemplateFormat != null ? this.segmentTemplateFormat.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                result = 31 * result + (this.suggestedPresentationDelaySeconds != null ? this.suggestedPresentationDelaySeconds.hashCode() : 0);
                result = 31 * result + (this.utcTiming != null ? this.utcTiming.hashCode() : 0);
                result = 31 * result + (this.utcTimingUri != null ? this.utcTimingUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * EncryptionContractConfigurationProperty encryptionContractConfigurationProperty = EncryptionContractConfigurationProperty.builder()
     *         .presetSpeke20Audio("presetSpeke20Audio")
     *         .presetSpeke20Video("presetSpeke20Video")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.EncryptionContractConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionContractConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionContractConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnOriginEndpoint.EncryptionContractConfigurationProperty.PresetSpeke20Audio`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPresetSpeke20Audio();

        /**
         * `CfnOriginEndpoint.EncryptionContractConfigurationProperty.PresetSpeke20Video`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPresetSpeke20Video();

        /**
         * @return a {@link Builder} of {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionContractConfigurationProperty> {
            java.lang.String presetSpeke20Audio;
            java.lang.String presetSpeke20Video;

            /**
             * Sets the value of {@link EncryptionContractConfigurationProperty#getPresetSpeke20Audio}
             * @param presetSpeke20Audio `CfnOriginEndpoint.EncryptionContractConfigurationProperty.PresetSpeke20Audio`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder presetSpeke20Audio(java.lang.String presetSpeke20Audio) {
                this.presetSpeke20Audio = presetSpeke20Audio;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionContractConfigurationProperty#getPresetSpeke20Video}
             * @param presetSpeke20Video `CfnOriginEndpoint.EncryptionContractConfigurationProperty.PresetSpeke20Video`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder presetSpeke20Video(java.lang.String presetSpeke20Video) {
                this.presetSpeke20Video = presetSpeke20Video;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionContractConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionContractConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionContractConfigurationProperty {
            private final java.lang.String presetSpeke20Audio;
            private final java.lang.String presetSpeke20Video;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.presetSpeke20Audio = software.amazon.jsii.Kernel.get(this, "presetSpeke20Audio", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.presetSpeke20Video = software.amazon.jsii.Kernel.get(this, "presetSpeke20Video", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.presetSpeke20Audio = java.util.Objects.requireNonNull(builder.presetSpeke20Audio, "presetSpeke20Audio is required");
                this.presetSpeke20Video = java.util.Objects.requireNonNull(builder.presetSpeke20Video, "presetSpeke20Video is required");
            }

            @Override
            public final java.lang.String getPresetSpeke20Audio() {
                return this.presetSpeke20Audio;
            }

            @Override
            public final java.lang.String getPresetSpeke20Video() {
                return this.presetSpeke20Video;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("presetSpeke20Audio", om.valueToTree(this.getPresetSpeke20Audio()));
                data.set("presetSpeke20Video", om.valueToTree(this.getPresetSpeke20Video()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.EncryptionContractConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionContractConfigurationProperty.Jsii$Proxy that = (EncryptionContractConfigurationProperty.Jsii$Proxy) o;

                if (!presetSpeke20Audio.equals(that.presetSpeke20Audio)) return false;
                return this.presetSpeke20Video.equals(that.presetSpeke20Video);
            }

            @Override
            public final int hashCode() {
                int result = this.presetSpeke20Audio.hashCode();
                result = 31 * result + (this.presetSpeke20Video.hashCode());
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsEncryptionProperty hlsEncryptionProperty = HlsEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .resourceId("resourceId")
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                         .presetSpeke20Audio("presetSpeke20Audio")
     *                         .presetSpeke20Video("presetSpeke20Video")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .constantInitializationVector("constantInitializationVector")
     *         .encryptionMethod("encryptionMethod")
     *         .keyRotationIntervalSeconds(123)
     *         .repeatExtXKey(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, used with the key for encrypting blocks.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * HLS encryption type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMethod() {
            return null;
        }

        /**
         * Number of seconds before AWS Elemental MediaPackage rotates to a new key.
         * <p>
         * By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getKeyRotationIntervalSeconds() {
            return null;
        }

        /**
         * Repeat the `EXT-X-KEY` directive for every media segment.
         * <p>
         * This might result in an increase in client requests to the DRM server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepeatExtXKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsEncryptionProperty> {
            java.lang.Object spekeKeyProvider;
            java.lang.String constantInitializationVector;
            java.lang.String encryptionMethod;
            java.lang.Number keyRotationIntervalSeconds;
            java.lang.Object repeatExtXKey;

            /**
             * Sets the value of {@link HlsEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, used with the key for encrypting blocks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getEncryptionMethod}
             * @param encryptionMethod HLS encryption type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMethod(java.lang.String encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getKeyRotationIntervalSeconds}
             * @param keyRotationIntervalSeconds Number of seconds before AWS Elemental MediaPackage rotates to a new key.
             *                                   By default, rotation is set to 60 seconds. Set to <code>0</code> to disable key rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyRotationIntervalSeconds(java.lang.Number keyRotationIntervalSeconds) {
                this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getRepeatExtXKey}
             * @param repeatExtXKey Repeat the `EXT-X-KEY` directive for every media segment.
             *                      This might result in an increase in client requests to the DRM server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repeatExtXKey(java.lang.Boolean repeatExtXKey) {
                this.repeatExtXKey = repeatExtXKey;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getRepeatExtXKey}
             * @param repeatExtXKey Repeat the `EXT-X-KEY` directive for every media segment.
             *                      This might result in an increase in client requests to the DRM server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repeatExtXKey(software.amazon.awscdk.IResolvable repeatExtXKey) {
                this.repeatExtXKey = repeatExtXKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String encryptionMethod;
            private final java.lang.Number keyRotationIntervalSeconds;
            private final java.lang.Object repeatExtXKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionMethod = software.amazon.jsii.Kernel.get(this, "encryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyRotationIntervalSeconds = software.amazon.jsii.Kernel.get(this, "keyRotationIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.repeatExtXKey = software.amazon.jsii.Kernel.get(this, "repeatExtXKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
                this.constantInitializationVector = builder.constantInitializationVector;
                this.encryptionMethod = builder.encryptionMethod;
                this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
                this.repeatExtXKey = builder.repeatExtXKey;
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getEncryptionMethod() {
                return this.encryptionMethod;
            }

            @Override
            public final java.lang.Number getKeyRotationIntervalSeconds() {
                return this.keyRotationIntervalSeconds;
            }

            @Override
            public final java.lang.Object getRepeatExtXKey() {
                return this.repeatExtXKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getEncryptionMethod() != null) {
                    data.set("encryptionMethod", om.valueToTree(this.getEncryptionMethod()));
                }
                if (this.getKeyRotationIntervalSeconds() != null) {
                    data.set("keyRotationIntervalSeconds", om.valueToTree(this.getKeyRotationIntervalSeconds()));
                }
                if (this.getRepeatExtXKey() != null) {
                    data.set("repeatExtXKey", om.valueToTree(this.getRepeatExtXKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsEncryptionProperty.Jsii$Proxy that = (HlsEncryptionProperty.Jsii$Proxy) o;

                if (!spekeKeyProvider.equals(that.spekeKeyProvider)) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                if (this.encryptionMethod != null ? !this.encryptionMethod.equals(that.encryptionMethod) : that.encryptionMethod != null) return false;
                if (this.keyRotationIntervalSeconds != null ? !this.keyRotationIntervalSeconds.equals(that.keyRotationIntervalSeconds) : that.keyRotationIntervalSeconds != null) return false;
                return this.repeatExtXKey != null ? this.repeatExtXKey.equals(that.repeatExtXKey) : that.repeatExtXKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.encryptionMethod != null ? this.encryptionMethod.hashCode() : 0);
                result = 31 * result + (this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.repeatExtXKey != null ? this.repeatExtXKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An HTTP Live Streaming (HLS) manifest configuration on a CMAF endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsManifestProperty hlsManifestProperty = HlsManifestProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .adMarkers("adMarkers")
     *         .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
     *         .adTriggers(List.of("adTriggers"))
     *         .includeIframeOnlyStream(false)
     *         .manifestName("manifestName")
     *         .playlistType("playlistType")
     *         .playlistWindowSeconds(123)
     *         .programDateTimeIntervalSeconds(123)
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsManifestProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsManifestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsManifestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The manifest ID is required and must be unique within the OriginEndpoint.
         * <p>
         * The ID can't be changed after the endpoint is created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * Controls how ad markers are included in the packaged endpoint.
         * <p>
         * Valid values are <code>none</code> , <code>passthrough</code> , or <code>scte35_enhanced</code> .
         * <p>
         * <ul>
         * <li><code>NONE</code> - omits all SCTE-35 ad markers from the output.</li>
         * <li><code>PASSTHROUGH</code> - creates a copy in the output of the SCTE-35 ad markers (comments) taken directly from the input manifest.</li>
         * <li><code>SCTE35_ENHANCED</code> - generates ad markers and blackout tags in the output based on the SCTE-35 messages from the input manifest.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdMarkers() {
            return null;
        }

        /**
         * The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
         * <p>
         * For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdsOnDeliveryRestrictions() {
            return null;
        }

        /**
         * Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>BREAK</code></li>
         * <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
         * <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>PROVIDER_ADVERTISEMENT</code></li>
         * <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>SPLICE_INSERT</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdTriggers() {
            return null;
        }

        /**
         * Applies to stream sets with a single video track only.
         * <p>
         * When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeIframeOnlyStream() {
            return null;
        }

        /**
         * A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint.
         * <p>
         * The manifestName on the HLSManifest object overrides the manifestName that you provided on the originEndpoint object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestName() {
            return null;
        }

        /**
         * When specified as either `event` or `vod` , a corresponding `EXT-X-PLAYLIST-TYPE` entry is included in the media playlist.
         * <p>
         * Indicates if the playlist is live-to-VOD content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlaylistType() {
            return null;
        }

        /**
         * Time window (in seconds) contained in each parent manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPlaylistWindowSeconds() {
            return null;
        }

        /**
         * Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
         * <p>
         * Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
         * <p>
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
         * <p>
         * Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProgramDateTimeIntervalSeconds() {
            return null;
        }

        /**
         * The URL that's used to request this manifest from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsManifestProperty> {
            java.lang.String id;
            java.lang.String adMarkers;
            java.lang.String adsOnDeliveryRestrictions;
            java.util.List<java.lang.String> adTriggers;
            java.lang.Object includeIframeOnlyStream;
            java.lang.String manifestName;
            java.lang.String playlistType;
            java.lang.Number playlistWindowSeconds;
            java.lang.Number programDateTimeIntervalSeconds;
            java.lang.String url;

            /**
             * Sets the value of {@link HlsManifestProperty#getId}
             * @param id The manifest ID is required and must be unique within the OriginEndpoint. This parameter is required.
             *           The ID can't be changed after the endpoint is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getAdMarkers}
             * @param adMarkers Controls how ad markers are included in the packaged endpoint.
             *                  Valid values are <code>none</code> , <code>passthrough</code> , or <code>scte35_enhanced</code> .
             *                  <p>
             *                  <ul>
             *                  <li><code>NONE</code> - omits all SCTE-35 ad markers from the output.</li>
             *                  <li><code>PASSTHROUGH</code> - creates a copy in the output of the SCTE-35 ad markers (comments) taken directly from the input manifest.</li>
             *                  <li><code>SCTE35_ENHANCED</code> - generates ad markers and blackout tags in the output based on the SCTE-35 messages from the input manifest.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkers(java.lang.String adMarkers) {
                this.adMarkers = adMarkers;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getAdsOnDeliveryRestrictions}
             * @param adsOnDeliveryRestrictions The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
             *                                  For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adsOnDeliveryRestrictions(java.lang.String adsOnDeliveryRestrictions) {
                this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getAdTriggers}
             * @param adTriggers Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
             *                   Valid values:
             *                   <p>
             *                   <ul>
             *                   <li><code>BREAK</code></li>
             *                   <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
             *                   <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>PROVIDER_ADVERTISEMENT</code></li>
             *                   <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>SPLICE_INSERT</code></li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adTriggers(java.util.List<java.lang.String> adTriggers) {
                this.adTriggers = adTriggers;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Applies to stream sets with a single video track only.
             *                                When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(java.lang.Boolean includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Applies to stream sets with a single video track only.
             *                                When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(software.amazon.awscdk.IResolvable includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getManifestName}
             * @param manifestName A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint.
             *                     The manifestName on the HLSManifest object overrides the manifestName that you provided on the originEndpoint object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getPlaylistType}
             * @param playlistType When specified as either `event` or `vod` , a corresponding `EXT-X-PLAYLIST-TYPE` entry is included in the media playlist.
             *                     Indicates if the playlist is live-to-VOD content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder playlistType(java.lang.String playlistType) {
                this.playlistType = playlistType;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getPlaylistWindowSeconds}
             * @param playlistWindowSeconds Time window (in seconds) contained in each parent manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder playlistWindowSeconds(java.lang.Number playlistWindowSeconds) {
                this.playlistWindowSeconds = playlistWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getProgramDateTimeIntervalSeconds}
             * @param programDateTimeIntervalSeconds Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
             *                                       Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
             *                                       <p>
             *                                       Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
             *                                       <p>
             *                                       Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programDateTimeIntervalSeconds(java.lang.Number programDateTimeIntervalSeconds) {
                this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getUrl}
             * @param url The URL that's used to request this manifest from this endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsManifestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsManifestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsManifestProperty {
            private final java.lang.String id;
            private final java.lang.String adMarkers;
            private final java.lang.String adsOnDeliveryRestrictions;
            private final java.util.List<java.lang.String> adTriggers;
            private final java.lang.Object includeIframeOnlyStream;
            private final java.lang.String manifestName;
            private final java.lang.String playlistType;
            private final java.lang.Number playlistWindowSeconds;
            private final java.lang.Number programDateTimeIntervalSeconds;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adMarkers = software.amazon.jsii.Kernel.get(this, "adMarkers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adsOnDeliveryRestrictions = software.amazon.jsii.Kernel.get(this, "adsOnDeliveryRestrictions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adTriggers = software.amazon.jsii.Kernel.get(this, "adTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeIframeOnlyStream = software.amazon.jsii.Kernel.get(this, "includeIframeOnlyStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.playlistType = software.amazon.jsii.Kernel.get(this, "playlistType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.playlistWindowSeconds = software.amazon.jsii.Kernel.get(this, "playlistWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.programDateTimeIntervalSeconds = software.amazon.jsii.Kernel.get(this, "programDateTimeIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.adMarkers = builder.adMarkers;
                this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
                this.adTriggers = builder.adTriggers;
                this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
                this.manifestName = builder.manifestName;
                this.playlistType = builder.playlistType;
                this.playlistWindowSeconds = builder.playlistWindowSeconds;
                this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getAdMarkers() {
                return this.adMarkers;
            }

            @Override
            public final java.lang.String getAdsOnDeliveryRestrictions() {
                return this.adsOnDeliveryRestrictions;
            }

            @Override
            public final java.util.List<java.lang.String> getAdTriggers() {
                return this.adTriggers;
            }

            @Override
            public final java.lang.Object getIncludeIframeOnlyStream() {
                return this.includeIframeOnlyStream;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.String getPlaylistType() {
                return this.playlistType;
            }

            @Override
            public final java.lang.Number getPlaylistWindowSeconds() {
                return this.playlistWindowSeconds;
            }

            @Override
            public final java.lang.Number getProgramDateTimeIntervalSeconds() {
                return this.programDateTimeIntervalSeconds;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getAdMarkers() != null) {
                    data.set("adMarkers", om.valueToTree(this.getAdMarkers()));
                }
                if (this.getAdsOnDeliveryRestrictions() != null) {
                    data.set("adsOnDeliveryRestrictions", om.valueToTree(this.getAdsOnDeliveryRestrictions()));
                }
                if (this.getAdTriggers() != null) {
                    data.set("adTriggers", om.valueToTree(this.getAdTriggers()));
                }
                if (this.getIncludeIframeOnlyStream() != null) {
                    data.set("includeIframeOnlyStream", om.valueToTree(this.getIncludeIframeOnlyStream()));
                }
                if (this.getManifestName() != null) {
                    data.set("manifestName", om.valueToTree(this.getManifestName()));
                }
                if (this.getPlaylistType() != null) {
                    data.set("playlistType", om.valueToTree(this.getPlaylistType()));
                }
                if (this.getPlaylistWindowSeconds() != null) {
                    data.set("playlistWindowSeconds", om.valueToTree(this.getPlaylistWindowSeconds()));
                }
                if (this.getProgramDateTimeIntervalSeconds() != null) {
                    data.set("programDateTimeIntervalSeconds", om.valueToTree(this.getProgramDateTimeIntervalSeconds()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsManifestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsManifestProperty.Jsii$Proxy that = (HlsManifestProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.adMarkers != null ? !this.adMarkers.equals(that.adMarkers) : that.adMarkers != null) return false;
                if (this.adsOnDeliveryRestrictions != null ? !this.adsOnDeliveryRestrictions.equals(that.adsOnDeliveryRestrictions) : that.adsOnDeliveryRestrictions != null) return false;
                if (this.adTriggers != null ? !this.adTriggers.equals(that.adTriggers) : that.adTriggers != null) return false;
                if (this.includeIframeOnlyStream != null ? !this.includeIframeOnlyStream.equals(that.includeIframeOnlyStream) : that.includeIframeOnlyStream != null) return false;
                if (this.manifestName != null ? !this.manifestName.equals(that.manifestName) : that.manifestName != null) return false;
                if (this.playlistType != null ? !this.playlistType.equals(that.playlistType) : that.playlistType != null) return false;
                if (this.playlistWindowSeconds != null ? !this.playlistWindowSeconds.equals(that.playlistWindowSeconds) : that.playlistWindowSeconds != null) return false;
                if (this.programDateTimeIntervalSeconds != null ? !this.programDateTimeIntervalSeconds.equals(that.programDateTimeIntervalSeconds) : that.programDateTimeIntervalSeconds != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.adMarkers != null ? this.adMarkers.hashCode() : 0);
                result = 31 * result + (this.adsOnDeliveryRestrictions != null ? this.adsOnDeliveryRestrictions.hashCode() : 0);
                result = 31 * result + (this.adTriggers != null ? this.adTriggers.hashCode() : 0);
                result = 31 * result + (this.includeIframeOnlyStream != null ? this.includeIframeOnlyStream.hashCode() : 0);
                result = 31 * result + (this.manifestName != null ? this.manifestName.hashCode() : 0);
                result = 31 * result + (this.playlistType != null ? this.playlistType.hashCode() : 0);
                result = 31 * result + (this.playlistWindowSeconds != null ? this.playlistWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.programDateTimeIntervalSeconds != null ? this.programDateTimeIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for Apple HLS packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsPackageProperty hlsPackageProperty = HlsPackageProperty.builder()
     *         .adMarkers("adMarkers")
     *         .adsOnDeliveryRestrictions("adsOnDeliveryRestrictions")
     *         .adTriggers(List.of("adTriggers"))
     *         .encryption(HlsEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .resourceId("resourceId")
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         // the properties below are optional
     *                         .certificateArn("certificateArn")
     *                         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                                 .presetSpeke20Audio("presetSpeke20Audio")
     *                                 .presetSpeke20Video("presetSpeke20Video")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .encryptionMethod("encryptionMethod")
     *                 .keyRotationIntervalSeconds(123)
     *                 .repeatExtXKey(false)
     *                 .build())
     *         .includeIframeOnlyStream(false)
     *         .playlistType("playlistType")
     *         .playlistWindowSeconds(123)
     *         .programDateTimeIntervalSeconds(123)
     *         .segmentDurationSeconds(123)
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .useAudioRenditionGroup(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Controls how ad markers are included in the packaged endpoint.
         * <p>
         * Valid values are <code>none</code> , <code>passthrough</code> , or <code>scte35_enhanced</code> .
         * <p>
         * <ul>
         * <li><code>NONE</code> - omits all SCTE-35 ad markers from the output.</li>
         * <li><code>PASSTHROUGH</code> - creates a copy in the output of the SCTE-35 ad markers (comments) taken directly from the input manifest.</li>
         * <li><code>SCTE35_ENHANCED</code> - generates ad markers and blackout tags in the output based on the SCTE-35 messages from the input manifest.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdMarkers() {
            return null;
        }

        /**
         * The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
         * <p>
         * For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdsOnDeliveryRestrictions() {
            return null;
        }

        /**
         * Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>BREAK</code></li>
         * <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
         * <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>PROVIDER_ADVERTISEMENT</code></li>
         * <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code></li>
         * <li><code>SPLICE_INSERT</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdTriggers() {
            return null;
        }

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * Only applies to stream sets with a single video track.
         * <p>
         * When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeIframeOnlyStream() {
            return null;
        }

        /**
         * When specified as either `event` or `vod` , a corresponding `EXT-X-PLAYLIST-TYPE` entry is included in the media playlist.
         * <p>
         * Indicates if the playlist is live-to-VOD content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlaylistType() {
            return null;
        }

        /**
         * Time window (in seconds) contained in each parent manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPlaylistWindowSeconds() {
            return null;
        }

        /**
         * Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
         * <p>
         * Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
         * <p>
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
         * <p>
         * Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProgramDateTimeIntervalSeconds() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * Limitations for outputs from the endpoint, based on the video bitrate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
         * <p>
         * All other tracks in the stream can be used with any audio rendition from the group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseAudioRenditionGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsPackageProperty> {
            java.lang.String adMarkers;
            java.lang.String adsOnDeliveryRestrictions;
            java.util.List<java.lang.String> adTriggers;
            java.lang.Object encryption;
            java.lang.Object includeIframeOnlyStream;
            java.lang.String playlistType;
            java.lang.Number playlistWindowSeconds;
            java.lang.Number programDateTimeIntervalSeconds;
            java.lang.Number segmentDurationSeconds;
            java.lang.Object streamSelection;
            java.lang.Object useAudioRenditionGroup;

            /**
             * Sets the value of {@link HlsPackageProperty#getAdMarkers}
             * @param adMarkers Controls how ad markers are included in the packaged endpoint.
             *                  Valid values are <code>none</code> , <code>passthrough</code> , or <code>scte35_enhanced</code> .
             *                  <p>
             *                  <ul>
             *                  <li><code>NONE</code> - omits all SCTE-35 ad markers from the output.</li>
             *                  <li><code>PASSTHROUGH</code> - creates a copy in the output of the SCTE-35 ad markers (comments) taken directly from the input manifest.</li>
             *                  <li><code>SCTE35_ENHANCED</code> - generates ad markers and blackout tags in the output based on the SCTE-35 messages from the input manifest.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkers(java.lang.String adMarkers) {
                this.adMarkers = adMarkers;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getAdsOnDeliveryRestrictions}
             * @param adsOnDeliveryRestrictions The flags on SCTE-35 segmentation descriptors that have to be present for MediaPackage to insert ad markers in the output manifest.
             *                                  For information about SCTE-35 in MediaPackage, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/scte.html">SCTE-35 Message Options in AWS Elemental MediaPackage</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adsOnDeliveryRestrictions(java.lang.String adsOnDeliveryRestrictions) {
                this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getAdTriggers}
             * @param adTriggers Specifies the SCTE-35 message types that MediaPackage treats as ad markers in the output manifest.
             *                   Valid values:
             *                   <p>
             *                   <ul>
             *                   <li><code>BREAK</code></li>
             *                   <li><code>DISTRIBUTOR_ADVERTISEMENT</code></li>
             *                   <li><code>DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>DISTRIBUTOR_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>PROVIDER_ADVERTISEMENT</code></li>
             *                   <li><code>PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>PROVIDER_PLACEMENT_OPPORTUNITY</code></li>
             *                   <li><code>SPLICE_INSERT</code></li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adTriggers(java.util.List<java.lang.String> adTriggers) {
                this.adTriggers = adTriggers;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.HlsEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Only applies to stream sets with a single video track.
             *                                When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(java.lang.Boolean includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Only applies to stream sets with a single video track.
             *                                When true, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(software.amazon.awscdk.IResolvable includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getPlaylistType}
             * @param playlistType When specified as either `event` or `vod` , a corresponding `EXT-X-PLAYLIST-TYPE` entry is included in the media playlist.
             *                     Indicates if the playlist is live-to-VOD content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder playlistType(java.lang.String playlistType) {
                this.playlistType = playlistType;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getPlaylistWindowSeconds}
             * @param playlistWindowSeconds Time window (in seconds) contained in each parent manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder playlistWindowSeconds(java.lang.Number playlistWindowSeconds) {
                this.playlistWindowSeconds = playlistWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getProgramDateTimeIntervalSeconds}
             * @param programDateTimeIntervalSeconds Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
             *                                       Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
             *                                       <p>
             *                                       Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
             *                                       <p>
             *                                       Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programDateTimeIntervalSeconds(java.lang.Number programDateTimeIntervalSeconds) {
                this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getUseAudioRenditionGroup}
             * @param useAudioRenditionGroup When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
             *                               All other tracks in the stream can be used with any audio rendition from the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAudioRenditionGroup(java.lang.Boolean useAudioRenditionGroup) {
                this.useAudioRenditionGroup = useAudioRenditionGroup;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getUseAudioRenditionGroup}
             * @param useAudioRenditionGroup When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
             *                               All other tracks in the stream can be used with any audio rendition from the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAudioRenditionGroup(software.amazon.awscdk.IResolvable useAudioRenditionGroup) {
                this.useAudioRenditionGroup = useAudioRenditionGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsPackageProperty {
            private final java.lang.String adMarkers;
            private final java.lang.String adsOnDeliveryRestrictions;
            private final java.util.List<java.lang.String> adTriggers;
            private final java.lang.Object encryption;
            private final java.lang.Object includeIframeOnlyStream;
            private final java.lang.String playlistType;
            private final java.lang.Number playlistWindowSeconds;
            private final java.lang.Number programDateTimeIntervalSeconds;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.Object streamSelection;
            private final java.lang.Object useAudioRenditionGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkers = software.amazon.jsii.Kernel.get(this, "adMarkers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adsOnDeliveryRestrictions = software.amazon.jsii.Kernel.get(this, "adsOnDeliveryRestrictions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adTriggers = software.amazon.jsii.Kernel.get(this, "adTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeIframeOnlyStream = software.amazon.jsii.Kernel.get(this, "includeIframeOnlyStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.playlistType = software.amazon.jsii.Kernel.get(this, "playlistType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.playlistWindowSeconds = software.amazon.jsii.Kernel.get(this, "playlistWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.programDateTimeIntervalSeconds = software.amazon.jsii.Kernel.get(this, "programDateTimeIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useAudioRenditionGroup = software.amazon.jsii.Kernel.get(this, "useAudioRenditionGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkers = builder.adMarkers;
                this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
                this.adTriggers = builder.adTriggers;
                this.encryption = builder.encryption;
                this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
                this.playlistType = builder.playlistType;
                this.playlistWindowSeconds = builder.playlistWindowSeconds;
                this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.streamSelection = builder.streamSelection;
                this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
            }

            @Override
            public final java.lang.String getAdMarkers() {
                return this.adMarkers;
            }

            @Override
            public final java.lang.String getAdsOnDeliveryRestrictions() {
                return this.adsOnDeliveryRestrictions;
            }

            @Override
            public final java.util.List<java.lang.String> getAdTriggers() {
                return this.adTriggers;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getIncludeIframeOnlyStream() {
                return this.includeIframeOnlyStream;
            }

            @Override
            public final java.lang.String getPlaylistType() {
                return this.playlistType;
            }

            @Override
            public final java.lang.Number getPlaylistWindowSeconds() {
                return this.playlistWindowSeconds;
            }

            @Override
            public final java.lang.Number getProgramDateTimeIntervalSeconds() {
                return this.programDateTimeIntervalSeconds;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            public final java.lang.Object getUseAudioRenditionGroup() {
                return this.useAudioRenditionGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkers() != null) {
                    data.set("adMarkers", om.valueToTree(this.getAdMarkers()));
                }
                if (this.getAdsOnDeliveryRestrictions() != null) {
                    data.set("adsOnDeliveryRestrictions", om.valueToTree(this.getAdsOnDeliveryRestrictions()));
                }
                if (this.getAdTriggers() != null) {
                    data.set("adTriggers", om.valueToTree(this.getAdTriggers()));
                }
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getIncludeIframeOnlyStream() != null) {
                    data.set("includeIframeOnlyStream", om.valueToTree(this.getIncludeIframeOnlyStream()));
                }
                if (this.getPlaylistType() != null) {
                    data.set("playlistType", om.valueToTree(this.getPlaylistType()));
                }
                if (this.getPlaylistWindowSeconds() != null) {
                    data.set("playlistWindowSeconds", om.valueToTree(this.getPlaylistWindowSeconds()));
                }
                if (this.getProgramDateTimeIntervalSeconds() != null) {
                    data.set("programDateTimeIntervalSeconds", om.valueToTree(this.getProgramDateTimeIntervalSeconds()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }
                if (this.getUseAudioRenditionGroup() != null) {
                    data.set("useAudioRenditionGroup", om.valueToTree(this.getUseAudioRenditionGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.HlsPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsPackageProperty.Jsii$Proxy that = (HlsPackageProperty.Jsii$Proxy) o;

                if (this.adMarkers != null ? !this.adMarkers.equals(that.adMarkers) : that.adMarkers != null) return false;
                if (this.adsOnDeliveryRestrictions != null ? !this.adsOnDeliveryRestrictions.equals(that.adsOnDeliveryRestrictions) : that.adsOnDeliveryRestrictions != null) return false;
                if (this.adTriggers != null ? !this.adTriggers.equals(that.adTriggers) : that.adTriggers != null) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.includeIframeOnlyStream != null ? !this.includeIframeOnlyStream.equals(that.includeIframeOnlyStream) : that.includeIframeOnlyStream != null) return false;
                if (this.playlistType != null ? !this.playlistType.equals(that.playlistType) : that.playlistType != null) return false;
                if (this.playlistWindowSeconds != null ? !this.playlistWindowSeconds.equals(that.playlistWindowSeconds) : that.playlistWindowSeconds != null) return false;
                if (this.programDateTimeIntervalSeconds != null ? !this.programDateTimeIntervalSeconds.equals(that.programDateTimeIntervalSeconds) : that.programDateTimeIntervalSeconds != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                if (this.streamSelection != null ? !this.streamSelection.equals(that.streamSelection) : that.streamSelection != null) return false;
                return this.useAudioRenditionGroup != null ? this.useAudioRenditionGroup.equals(that.useAudioRenditionGroup) : that.useAudioRenditionGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkers != null ? this.adMarkers.hashCode() : 0;
                result = 31 * result + (this.adsOnDeliveryRestrictions != null ? this.adsOnDeliveryRestrictions.hashCode() : 0);
                result = 31 * result + (this.adTriggers != null ? this.adTriggers.hashCode() : 0);
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.includeIframeOnlyStream != null ? this.includeIframeOnlyStream.hashCode() : 0);
                result = 31 * result + (this.playlistType != null ? this.playlistType.hashCode() : 0);
                result = 31 * result + (this.playlistWindowSeconds != null ? this.playlistWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.programDateTimeIntervalSeconds != null ? this.programDateTimeIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                result = 31 * result + (this.useAudioRenditionGroup != null ? this.useAudioRenditionGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * MssEncryptionProperty mssEncryptionProperty = MssEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .resourceId("resourceId")
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                         .presetSpeke20Audio("presetSpeke20Audio")
     *                         .presetSpeke20Video("presetSpeke20Video")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.MssEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(MssEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * @return a {@link Builder} of {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssEncryptionProperty> {
            java.lang.Object spekeKeyProvider;

            /**
             * Sets the value of {@link MssEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link MssEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.MssEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssEncryptionProperty.Jsii$Proxy that = (MssEncryptionProperty.Jsii$Proxy) o;

                return this.spekeKeyProvider.equals(that.spekeKeyProvider);
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * MssPackageProperty mssPackageProperty = MssPackageProperty.builder()
     *         .encryption(MssEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .resourceId("resourceId")
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         // the properties below are optional
     *                         .certificateArn("certificateArn")
     *                         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                                 .presetSpeke20Audio("presetSpeke20Audio")
     *                                 .presetSpeke20Video("presetSpeke20Video")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .manifestWindowSeconds(123)
     *         .segmentDurationSeconds(123)
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.MssPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(MssPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * Time window (in seconds) contained in each manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * Limitations for outputs from the endpoint, based on the video bitrate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssPackageProperty> {
            java.lang.Object encryption;
            java.lang.Number manifestWindowSeconds;
            java.lang.Number segmentDurationSeconds;
            java.lang.Object streamSelection;

            /**
             * Sets the value of {@link MssPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds Time window (in seconds) contained in each manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssPackageProperty {
            private final java.lang.Object encryption;
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.Object streamSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryption = builder.encryption;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.streamSelection = builder.streamSelection;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.MssPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssPackageProperty.Jsii$Proxy that = (MssPackageProperty.Jsii$Proxy) o;

                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                return this.streamSelection != null ? this.streamSelection.equals(that.streamSelection) : that.streamSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryption != null ? this.encryption.hashCode() : 0;
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Keyprovider settings for DRM.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * SpekeKeyProviderProperty spekeKeyProviderProperty = SpekeKeyProviderProperty.builder()
     *         .resourceId("resourceId")
     *         .roleArn("roleArn")
     *         .systemIds(List.of("systemIds"))
     *         .url("url")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                 .presetSpeke20Audio("presetSpeke20Audio")
     *                 .presetSpeke20Video("presetSpeke20Video")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(SpekeKeyProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpekeKeyProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Unique identifier for this endpoint, as it is configured in the key provider service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

        /**
         * The ARN for the IAM role that's granted by the key provider to provide access to the key provider API.
         * <p>
         * This role must have a trust policy that allows AWS Elemental MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Valid format: arn:aws:iam::{accountID}:role/{name}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * List of unique identifiers for the DRM systems to use, as defined in the CPIX specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSystemIds();

        /**
         * URL for the key provider’s key retrieval API endpoint.
         * <p>
         * Must start with https://.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * The Amazon Resource Name (ARN) for the certificate that you imported to AWS Certificate Manager to add content key encryption to this endpoint.
         * <p>
         * For this feature to work, your DRM key provider must support content key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.EncryptionContractConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionContractConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpekeKeyProviderProperty> {
            java.lang.String resourceId;
            java.lang.String roleArn;
            java.util.List<java.lang.String> systemIds;
            java.lang.String url;
            java.lang.String certificateArn;
            java.lang.Object encryptionContractConfiguration;

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getResourceId}
             * @param resourceId Unique identifier for this endpoint, as it is configured in the key provider service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getRoleArn}
             * @param roleArn The ARN for the IAM role that's granted by the key provider to provide access to the key provider API. This parameter is required.
             *                This role must have a trust policy that allows AWS Elemental MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Valid format: arn:aws:iam::{accountID}:role/{name}
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getSystemIds}
             * @param systemIds List of unique identifiers for the DRM systems to use, as defined in the CPIX specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemIds(java.util.List<java.lang.String> systemIds) {
                this.systemIds = systemIds;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getUrl}
             * @param url URL for the key provider’s key retrieval API endpoint. This parameter is required.
             *            Must start with https://.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getCertificateArn}
             * @param certificateArn The Amazon Resource Name (ARN) for the certificate that you imported to AWS Certificate Manager to add content key encryption to this endpoint.
             *                       For this feature to work, your DRM key provider must support content key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getEncryptionContractConfiguration}
             * @param encryptionContractConfiguration `CfnOriginEndpoint.SpekeKeyProviderProperty.EncryptionContractConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionContractConfiguration(software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.EncryptionContractConfigurationProperty encryptionContractConfiguration) {
                this.encryptionContractConfiguration = encryptionContractConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getEncryptionContractConfiguration}
             * @param encryptionContractConfiguration `CfnOriginEndpoint.SpekeKeyProviderProperty.EncryptionContractConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionContractConfiguration(software.amazon.awscdk.IResolvable encryptionContractConfiguration) {
                this.encryptionContractConfiguration = encryptionContractConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpekeKeyProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpekeKeyProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpekeKeyProviderProperty {
            private final java.lang.String resourceId;
            private final java.lang.String roleArn;
            private final java.util.List<java.lang.String> systemIds;
            private final java.lang.String url;
            private final java.lang.String certificateArn;
            private final java.lang.Object encryptionContractConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.systemIds = software.amazon.jsii.Kernel.get(this, "systemIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionContractConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionContractConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.systemIds = java.util.Objects.requireNonNull(builder.systemIds, "systemIds is required");
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
                this.certificateArn = builder.certificateArn;
                this.encryptionContractConfiguration = builder.encryptionContractConfiguration;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getSystemIds() {
                return this.systemIds;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.Object getEncryptionContractConfiguration() {
                return this.encryptionContractConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceId", om.valueToTree(this.getResourceId()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("systemIds", om.valueToTree(this.getSystemIds()));
                data.set("url", om.valueToTree(this.getUrl()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getEncryptionContractConfiguration() != null) {
                    data.set("encryptionContractConfiguration", om.valueToTree(this.getEncryptionContractConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpekeKeyProviderProperty.Jsii$Proxy that = (SpekeKeyProviderProperty.Jsii$Proxy) o;

                if (!resourceId.equals(that.resourceId)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!systemIds.equals(that.systemIds)) return false;
                if (!url.equals(that.url)) return false;
                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                return this.encryptionContractConfiguration != null ? this.encryptionContractConfiguration.equals(that.encryptionContractConfiguration) : that.encryptionContractConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceId.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.systemIds.hashCode());
                result = 31 * result + (this.url.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                result = 31 * result + (this.encryptionContractConfiguration != null ? this.encryptionContractConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Limitations for outputs from the endpoint, based on the video bitrate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * StreamSelectionProperty streamSelectionProperty = StreamSelectionProperty.builder()
     *         .maxVideoBitsPerSecond(123)
     *         .minVideoBitsPerSecond(123)
     *         .streamOrder("streamOrder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.StreamSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper limit of the bitrates that this endpoint serves.
         * <p>
         * If the video track exceeds this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 2147483647 bits per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxVideoBitsPerSecond() {
            return null;
        }

        /**
         * The lower limit of the bitrates that this endpoint serves.
         * <p>
         * If the video track is below this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 0 bits per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinVideoBitsPerSecond() {
            return null;
        }

        /**
         * Order in which the different video bitrates are presented to the player.
         * <p>
         * Valid values: <code>ORIGINAL</code> , <code>VIDEO_BITRATE_ASCENDING</code> , <code>VIDEO_BITRATE_DESCENDING</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSelectionProperty> {
            java.lang.Number maxVideoBitsPerSecond;
            java.lang.Number minVideoBitsPerSecond;
            java.lang.String streamOrder;

            /**
             * Sets the value of {@link StreamSelectionProperty#getMaxVideoBitsPerSecond}
             * @param maxVideoBitsPerSecond The upper limit of the bitrates that this endpoint serves.
             *                              If the video track exceeds this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 2147483647 bits per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxVideoBitsPerSecond(java.lang.Number maxVideoBitsPerSecond) {
                this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link StreamSelectionProperty#getMinVideoBitsPerSecond}
             * @param minVideoBitsPerSecond The lower limit of the bitrates that this endpoint serves.
             *                              If the video track is below this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 0 bits per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minVideoBitsPerSecond(java.lang.Number minVideoBitsPerSecond) {
                this.minVideoBitsPerSecond = minVideoBitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link StreamSelectionProperty#getStreamOrder}
             * @param streamOrder Order in which the different video bitrates are presented to the player.
             *                    Valid values: <code>ORIGINAL</code> , <code>VIDEO_BITRATE_ASCENDING</code> , <code>VIDEO_BITRATE_DESCENDING</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamOrder(java.lang.String streamOrder) {
                this.streamOrder = streamOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSelectionProperty {
            private final java.lang.Number maxVideoBitsPerSecond;
            private final java.lang.Number minVideoBitsPerSecond;
            private final java.lang.String streamOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxVideoBitsPerSecond = software.amazon.jsii.Kernel.get(this, "maxVideoBitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minVideoBitsPerSecond = software.amazon.jsii.Kernel.get(this, "minVideoBitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.streamOrder = software.amazon.jsii.Kernel.get(this, "streamOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
                this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
                this.streamOrder = builder.streamOrder;
            }

            @Override
            public final java.lang.Number getMaxVideoBitsPerSecond() {
                return this.maxVideoBitsPerSecond;
            }

            @Override
            public final java.lang.Number getMinVideoBitsPerSecond() {
                return this.minVideoBitsPerSecond;
            }

            @Override
            public final java.lang.String getStreamOrder() {
                return this.streamOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxVideoBitsPerSecond() != null) {
                    data.set("maxVideoBitsPerSecond", om.valueToTree(this.getMaxVideoBitsPerSecond()));
                }
                if (this.getMinVideoBitsPerSecond() != null) {
                    data.set("minVideoBitsPerSecond", om.valueToTree(this.getMinVideoBitsPerSecond()));
                }
                if (this.getStreamOrder() != null) {
                    data.set("streamOrder", om.valueToTree(this.getStreamOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnOriginEndpoint.StreamSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSelectionProperty.Jsii$Proxy that = (StreamSelectionProperty.Jsii$Proxy) o;

                if (this.maxVideoBitsPerSecond != null ? !this.maxVideoBitsPerSecond.equals(that.maxVideoBitsPerSecond) : that.maxVideoBitsPerSecond != null) return false;
                if (this.minVideoBitsPerSecond != null ? !this.minVideoBitsPerSecond.equals(that.minVideoBitsPerSecond) : that.minVideoBitsPerSecond != null) return false;
                return this.streamOrder != null ? this.streamOrder.equals(that.streamOrder) : that.streamOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxVideoBitsPerSecond != null ? this.maxVideoBitsPerSecond.hashCode() : 0;
                result = 31 * result + (this.minVideoBitsPerSecond != null ? this.minVideoBitsPerSecond.hashCode() : 0);
                result = 31 * result + (this.streamOrder != null ? this.streamOrder.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediapackage.CfnOriginEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediapackage.CfnOriginEndpointProps.Builder();
        }

        /**
         * The ID of the channel associated with this endpoint.
         * <p>
         * @return {@code this}
         * @param channelId The ID of the channel associated with this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelId(final java.lang.String channelId) {
            this.props.channelId(channelId);
            return this;
        }

        /**
         * The manifest ID is required and must be unique within the OriginEndpoint.
         * <p>
         * The ID can't be changed after the endpoint is created.
         * <p>
         * @return {@code this}
         * @param id The manifest ID is required and must be unique within the OriginEndpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(final java.lang.String id) {
            this.props.id(id);
            return this;
        }

        /**
         * Parameters for CDN authorization.
         * <p>
         * @return {@code this}
         * @param authorization Parameters for CDN authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorization(final software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.AuthorizationProperty authorization) {
            this.props.authorization(authorization);
            return this;
        }
        /**
         * Parameters for CDN authorization.
         * <p>
         * @return {@code this}
         * @param authorization Parameters for CDN authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorization(final software.amazon.awscdk.IResolvable authorization) {
            this.props.authorization(authorization);
            return this;
        }

        /**
         * Parameters for Common Media Application Format (CMAF) packaging.
         * <p>
         * @return {@code this}
         * @param cmafPackage Parameters for Common Media Application Format (CMAF) packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(final software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.CmafPackageProperty cmafPackage) {
            this.props.cmafPackage(cmafPackage);
            return this;
        }
        /**
         * Parameters for Common Media Application Format (CMAF) packaging.
         * <p>
         * @return {@code this}
         * @param cmafPackage Parameters for Common Media Application Format (CMAF) packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(final software.amazon.awscdk.IResolvable cmafPackage) {
            this.props.cmafPackage(cmafPackage);
            return this;
        }

        /**
         * Parameters for DASH packaging.
         * <p>
         * @return {@code this}
         * @param dashPackage Parameters for DASH packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(final software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.DashPackageProperty dashPackage) {
            this.props.dashPackage(dashPackage);
            return this;
        }
        /**
         * Parameters for DASH packaging.
         * <p>
         * @return {@code this}
         * @param dashPackage Parameters for DASH packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(final software.amazon.awscdk.IResolvable dashPackage) {
            this.props.dashPackage(dashPackage);
            return this;
        }

        /**
         * Any descriptive information that you want to add to the endpoint for future identification purposes.
         * <p>
         * @return {@code this}
         * @param description Any descriptive information that you want to add to the endpoint for future identification purposes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Parameters for Apple HLS packaging.
         * <p>
         * @return {@code this}
         * @param hlsPackage Parameters for Apple HLS packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(final software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.HlsPackageProperty hlsPackage) {
            this.props.hlsPackage(hlsPackage);
            return this;
        }
        /**
         * Parameters for Apple HLS packaging.
         * <p>
         * @return {@code this}
         * @param hlsPackage Parameters for Apple HLS packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(final software.amazon.awscdk.IResolvable hlsPackage) {
            this.props.hlsPackage(hlsPackage);
            return this;
        }

        /**
         * A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint.
         * <p>
         * @return {@code this}
         * @param manifestName A short string that's appended to the end of the endpoint URL to create a unique path to this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestName(final java.lang.String manifestName) {
            this.props.manifestName(manifestName);
            return this;
        }

        /**
         * Parameters for Microsoft Smooth Streaming packaging.
         * <p>
         * @return {@code this}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(final software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssPackageProperty mssPackage) {
            this.props.mssPackage(mssPackage);
            return this;
        }
        /**
         * Parameters for Microsoft Smooth Streaming packaging.
         * <p>
         * @return {@code this}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(final software.amazon.awscdk.IResolvable mssPackage) {
            this.props.mssPackage(mssPackage);
            return this;
        }

        /**
         * Controls video origination from this endpoint.
         * <p>
         * <ul>
         * <li><code>ALLOW</code> - enables this endpoint to serve content to requesting devices.</li>
         * <li><code>DENY</code> - prevents this endpoint from serving content. Denying origination is helpful for harvesting live-to-VOD assets. For more information about harvesting and origination, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/ltov-reqmts.html">Live-to-VOD Requirements</a> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param origination Controls video origination from this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origination(final java.lang.String origination) {
            this.props.origination(origination);
            return this;
        }

        /**
         * Maximum duration (seconds) of content to retain for startover playback.
         * <p>
         * Omit this attribute or enter <code>0</code> to indicate that startover playback is disabled for this endpoint.
         * <p>
         * @return {@code this}
         * @param startoverWindowSeconds Maximum duration (seconds) of content to retain for startover playback. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startoverWindowSeconds(final java.lang.Number startoverWindowSeconds) {
            this.props.startoverWindowSeconds(startoverWindowSeconds);
            return this;
        }

        /**
         * The tags to assign to the endpoint.
         * <p>
         * @return {@code this}
         * @param tags The tags to assign to the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Minimum duration (seconds) of delay to enforce on the playback of live content.
         * <p>
         * Omit this attribute or enter <code>0</code> to indicate that there is no time delay in effect for this endpoint
         * <p>
         * @return {@code this}
         * @param timeDelaySeconds Minimum duration (seconds) of delay to enforce on the playback of live content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeDelaySeconds(final java.lang.Number timeDelaySeconds) {
            this.props.timeDelaySeconds(timeDelaySeconds);
            return this;
        }

        /**
         * The IP addresses that can access this endpoint.
         * <p>
         * @return {@code this}
         * @param whitelist The IP addresses that can access this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelist(final java.util.List<java.lang.String> whitelist) {
            this.props.whitelist(whitelist);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint build() {
            return new software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
