package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a `CfnChannel`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * Object tags;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .cdiInputSpecification(CdiInputSpecificationProperty.builder()
 *                 .resolution("resolution")
 *                 .build())
 *         .channelClass("channelClass")
 *         .destinations(List.of(OutputDestinationProperty.builder()
 *                 .id("id")
 *                 .mediaPackageSettings(List.of(MediaPackageOutputDestinationSettingsProperty.builder()
 *                         .channelId("channelId")
 *                         .build()))
 *                 .multiplexSettings(MultiplexProgramChannelDestinationSettingsProperty.builder()
 *                         .multiplexId("multiplexId")
 *                         .programName("programName")
 *                         .build())
 *                 .settings(List.of(OutputDestinationSettingsProperty.builder()
 *                         .passwordParam("passwordParam")
 *                         .streamName("streamName")
 *                         .url("url")
 *                         .username("username")
 *                         .build()))
 *                 .build()))
 *         .encoderSettings(EncoderSettingsProperty.builder()
 *                 .audioDescriptions(List.of(AudioDescriptionProperty.builder()
 *                         .audioNormalizationSettings(AudioNormalizationSettingsProperty.builder()
 *                                 .algorithm("algorithm")
 *                                 .algorithmControl("algorithmControl")
 *                                 .targetLkfs(123)
 *                                 .build())
 *                         .audioSelectorName("audioSelectorName")
 *                         .audioType("audioType")
 *                         .audioTypeControl("audioTypeControl")
 *                         .audioWatermarkingSettings(AudioWatermarkSettingsProperty.builder()
 *                                 .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
 *                                         .nielsenCbetSettings(NielsenCBETProperty.builder()
 *                                                 .cbetCheckDigitString("cbetCheckDigitString")
 *                                                 .cbetStepaside("cbetStepaside")
 *                                                 .csid("csid")
 *                                                 .build())
 *                                         .nielsenDistributionType("nielsenDistributionType")
 *                                         .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
 *                                                 .checkDigitString("checkDigitString")
 *                                                 .sid(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .codecSettings(AudioCodecSettingsProperty.builder()
 *                                 .aacSettings(AacSettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .codingMode("codingMode")
 *                                         .inputType("inputType")
 *                                         .profile("profile")
 *                                         .rateControlMode("rateControlMode")
 *                                         .rawFormat("rawFormat")
 *                                         .sampleRate(123)
 *                                         .spec("spec")
 *                                         .vbrQuality("vbrQuality")
 *                                         .build())
 *                                 .ac3Settings(Ac3SettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .bitstreamMode("bitstreamMode")
 *                                         .codingMode("codingMode")
 *                                         .dialnorm(123)
 *                                         .drcProfile("drcProfile")
 *                                         .lfeFilter("lfeFilter")
 *                                         .metadataControl("metadataControl")
 *                                         .build())
 *                                 .eac3Settings(Eac3SettingsProperty.builder()
 *                                         .attenuationControl("attenuationControl")
 *                                         .bitrate(123)
 *                                         .bitstreamMode("bitstreamMode")
 *                                         .codingMode("codingMode")
 *                                         .dcFilter("dcFilter")
 *                                         .dialnorm(123)
 *                                         .drcLine("drcLine")
 *                                         .drcRf("drcRf")
 *                                         .lfeControl("lfeControl")
 *                                         .lfeFilter("lfeFilter")
 *                                         .loRoCenterMixLevel(123)
 *                                         .loRoSurroundMixLevel(123)
 *                                         .ltRtCenterMixLevel(123)
 *                                         .ltRtSurroundMixLevel(123)
 *                                         .metadataControl("metadataControl")
 *                                         .passthroughControl("passthroughControl")
 *                                         .phaseControl("phaseControl")
 *                                         .stereoDownmix("stereoDownmix")
 *                                         .surroundExMode("surroundExMode")
 *                                         .surroundMode("surroundMode")
 *                                         .build())
 *                                 .mp2Settings(Mp2SettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .codingMode("codingMode")
 *                                         .sampleRate(123)
 *                                         .build())
 *                                 .passThroughSettings(PassThroughSettingsProperty.builder().build())
 *                                 .wavSettings(WavSettingsProperty.builder()
 *                                         .bitDepth(123)
 *                                         .codingMode("codingMode")
 *                                         .sampleRate(123)
 *                                         .build())
 *                                 .build())
 *                         .languageCode("languageCode")
 *                         .languageCodeControl("languageCodeControl")
 *                         .name("name")
 *                         .remixSettings(RemixSettingsProperty.builder()
 *                                 .channelMappings(List.of(AudioChannelMappingProperty.builder()
 *                                         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
 *                                                 .gain(123)
 *                                                 .inputChannel(123)
 *                                                 .build()))
 *                                         .outputChannel(123)
 *                                         .build()))
 *                                 .channelsIn(123)
 *                                 .channelsOut(123)
 *                                 .build())
 *                         .streamName("streamName")
 *                         .build()))
 *                 .availBlanking(AvailBlankingProperty.builder()
 *                         .availBlankingImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .state("state")
 *                         .build())
 *                 .availConfiguration(AvailConfigurationProperty.builder()
 *                         .availSettings(AvailSettingsProperty.builder()
 *                                 .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
 *                                         .adAvailOffset(123)
 *                                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
 *                                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
 *                                         .build())
 *                                 .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
 *                                         .adAvailOffset(123)
 *                                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
 *                                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .blackoutSlate(BlackoutSlateProperty.builder()
 *                         .blackoutSlateImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .networkEndBlackout("networkEndBlackout")
 *                         .networkEndBlackoutImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .networkId("networkId")
 *                         .state("state")
 *                         .build())
 *                 .captionDescriptions(List.of(CaptionDescriptionProperty.builder()
 *                         .captionSelectorName("captionSelectorName")
 *                         .destinationSettings(CaptionDestinationSettingsProperty.builder()
 *                                 .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
 *                                 .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
 *                                         .alignment("alignment")
 *                                         .backgroundColor("backgroundColor")
 *                                         .backgroundOpacity(123)
 *                                         .font(InputLocationProperty.builder()
 *                                                 .passwordParam("passwordParam")
 *                                                 .uri("uri")
 *                                                 .username("username")
 *                                                 .build())
 *                                         .fontColor("fontColor")
 *                                         .fontOpacity(123)
 *                                         .fontResolution(123)
 *                                         .fontSize("fontSize")
 *                                         .outlineColor("outlineColor")
 *                                         .outlineSize(123)
 *                                         .shadowColor("shadowColor")
 *                                         .shadowOpacity(123)
 *                                         .shadowXOffset(123)
 *                                         .shadowYOffset(123)
 *                                         .teletextGridControl("teletextGridControl")
 *                                         .xPosition(123)
 *                                         .yPosition(123)
 *                                         .build())
 *                                 .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
 *                                         .alignment("alignment")
 *                                         .backgroundColor("backgroundColor")
 *                                         .backgroundOpacity(123)
 *                                         .font(InputLocationProperty.builder()
 *                                                 .passwordParam("passwordParam")
 *                                                 .uri("uri")
 *                                                 .username("username")
 *                                                 .build())
 *                                         .fontColor("fontColor")
 *                                         .fontOpacity(123)
 *                                         .fontResolution(123)
 *                                         .fontSize("fontSize")
 *                                         .outlineColor("outlineColor")
 *                                         .outlineSize(123)
 *                                         .shadowColor("shadowColor")
 *                                         .shadowOpacity(123)
 *                                         .shadowXOffset(123)
 *                                         .shadowYOffset(123)
 *                                         .teletextGridControl("teletextGridControl")
 *                                         .xPosition(123)
 *                                         .yPosition(123)
 *                                         .build())
 *                                 .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
 *                                         .copyrightHolder("copyrightHolder")
 *                                         .fillLineGap("fillLineGap")
 *                                         .fontFamily("fontFamily")
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
 *                                 .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
 *                                 .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
 *                                 .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
 *                                 .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
 *                                 .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
 *                                 .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
 *                                 .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .build())
 *                         .languageCode("languageCode")
 *                         .languageDescription("languageDescription")
 *                         .name("name")
 *                         .build()))
 *                 .featureActivations(FeatureActivationsProperty.builder()
 *                         .inputPrepareScheduleActions("inputPrepareScheduleActions")
 *                         .build())
 *                 .globalConfiguration(GlobalConfigurationProperty.builder()
 *                         .initialAudioGain(123)
 *                         .inputEndAction("inputEndAction")
 *                         .inputLossBehavior(InputLossBehaviorProperty.builder()
 *                                 .blackFrameMsec(123)
 *                                 .inputLossImageColor("inputLossImageColor")
 *                                 .inputLossImageSlate(InputLocationProperty.builder()
 *                                         .passwordParam("passwordParam")
 *                                         .uri("uri")
 *                                         .username("username")
 *                                         .build())
 *                                 .inputLossImageType("inputLossImageType")
 *                                 .repeatFrameMsec(123)
 *                                 .build())
 *                         .outputLockingMode("outputLockingMode")
 *                         .outputTimingSource("outputTimingSource")
 *                         .supportLowFramerateInputs("supportLowFramerateInputs")
 *                         .build())
 *                 .motionGraphicsConfiguration(MotionGraphicsConfigurationProperty.builder()
 *                         .motionGraphicsInsertion("motionGraphicsInsertion")
 *                         .motionGraphicsSettings(MotionGraphicsSettingsProperty.builder()
 *                                 .htmlMotionGraphicsSettings(HtmlMotionGraphicsSettingsProperty.builder().build())
 *                                 .build())
 *                         .build())
 *                 .nielsenConfiguration(NielsenConfigurationProperty.builder()
 *                         .distributorId("distributorId")
 *                         .nielsenPcmToId3Tagging("nielsenPcmToId3Tagging")
 *                         .build())
 *                 .outputGroups(List.of(OutputGroupProperty.builder()
 *                         .name("name")
 *                         .outputGroupSettings(OutputGroupSettingsProperty.builder()
 *                                 .archiveGroupSettings(ArchiveGroupSettingsProperty.builder()
 *                                         .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
 *                                                 .archiveS3Settings(ArchiveS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .build())
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .rolloverInterval(123)
 *                                         .build())
 *                                 .frameCaptureGroupSettings(FrameCaptureGroupSettingsProperty.builder()
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .frameCaptureCdnSettings(FrameCaptureCdnSettingsProperty.builder()
 *                                                 .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .hlsGroupSettings(HlsGroupSettingsProperty.builder()
 *                                         .adMarkers(List.of("adMarkers"))
 *                                         .baseUrlContent("baseUrlContent")
 *                                         .baseUrlContent1("baseUrlContent1")
 *                                         .baseUrlManifest("baseUrlManifest")
 *                                         .baseUrlManifest1("baseUrlManifest1")
 *                                         .captionLanguageMappings(List.of(CaptionLanguageMappingProperty.builder()
 *                                                 .captionChannel(123)
 *                                                 .languageCode("languageCode")
 *                                                 .languageDescription("languageDescription")
 *                                                 .build()))
 *                                         .captionLanguageSetting("captionLanguageSetting")
 *                                         .clientCache("clientCache")
 *                                         .codecSpecification("codecSpecification")
 *                                         .constantIv("constantIv")
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .directoryStructure("directoryStructure")
 *                                         .discontinuityTags("discontinuityTags")
 *                                         .encryptionType("encryptionType")
 *                                         .hlsCdnSettings(HlsCdnSettingsProperty.builder()
 *                                                 .hlsAkamaiSettings(HlsAkamaiSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .httpTransferMode("httpTransferMode")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .salt("salt")
 *                                                         .token("token")
 *                                                         .build())
 *                                                 .hlsBasicPutSettings(HlsBasicPutSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .hlsMediaStoreSettings(HlsMediaStoreSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .mediaStoreStorageClass("mediaStoreStorageClass")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .hlsS3Settings(HlsS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .hlsWebdavSettings(HlsWebdavSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .httpTransferMode("httpTransferMode")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .hlsId3SegmentTagging("hlsId3SegmentTagging")
 *                                         .iFrameOnlyPlaylists("iFrameOnlyPlaylists")
 *                                         .incompleteSegmentBehavior("incompleteSegmentBehavior")
 *                                         .indexNSegments(123)
 *                                         .inputLossAction("inputLossAction")
 *                                         .ivInManifest("ivInManifest")
 *                                         .ivSource("ivSource")
 *                                         .keepSegments(123)
 *                                         .keyFormat("keyFormat")
 *                                         .keyFormatVersions("keyFormatVersions")
 *                                         .keyProviderSettings(KeyProviderSettingsProperty.builder()
 *                                                 .staticKeySettings(StaticKeySettingsProperty.builder()
 *                                                         .keyProviderServer(InputLocationProperty.builder()
 *                                                                 .passwordParam("passwordParam")
 *                                                                 .uri("uri")
 *                                                                 .username("username")
 *                                                                 .build())
 *                                                         .staticKeyValue("staticKeyValue")
 *                                                         .build())
 *                                                 .build())
 *                                         .manifestCompression("manifestCompression")
 *                                         .manifestDurationFormat("manifestDurationFormat")
 *                                         .minSegmentLength(123)
 *                                         .mode("mode")
 *                                         .outputSelection("outputSelection")
 *                                         .programDateTime("programDateTime")
 *                                         .programDateTimeClock("programDateTimeClock")
 *                                         .programDateTimePeriod(123)
 *                                         .redundantManifest("redundantManifest")
 *                                         .segmentationMode("segmentationMode")
 *                                         .segmentLength(123)
 *                                         .segmentsPerSubdirectory(123)
 *                                         .streamInfResolution("streamInfResolution")
 *                                         .timedMetadataId3Frame("timedMetadataId3Frame")
 *                                         .timedMetadataId3Period(123)
 *                                         .timestampDeltaMilliseconds(123)
 *                                         .tsFileMode("tsFileMode")
 *                                         .build())
 *                                 .mediaPackageGroupSettings(MediaPackageGroupSettingsProperty.builder()
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .build())
 *                                 .msSmoothGroupSettings(MsSmoothGroupSettingsProperty.builder()
 *                                         .acquisitionPointId("acquisitionPointId")
 *                                         .audioOnlyTimecodeControl("audioOnlyTimecodeControl")
 *                                         .certificateMode("certificateMode")
 *                                         .connectionRetryInterval(123)
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .eventId("eventId")
 *                                         .eventIdMode("eventIdMode")
 *                                         .eventStopBehavior("eventStopBehavior")
 *                                         .filecacheDuration(123)
 *                                         .fragmentLength(123)
 *                                         .inputLossAction("inputLossAction")
 *                                         .numRetries(123)
 *                                         .restartDelay(123)
 *                                         .segmentationMode("segmentationMode")
 *                                         .sendDelayMs(123)
 *                                         .sparseTrackType("sparseTrackType")
 *                                         .streamManifestBehavior("streamManifestBehavior")
 *                                         .timestampOffset("timestampOffset")
 *                                         .timestampOffsetMode("timestampOffsetMode")
 *                                         .build())
 *                                 .multiplexGroupSettings(MultiplexGroupSettingsProperty.builder().build())
 *                                 .rtmpGroupSettings(RtmpGroupSettingsProperty.builder()
 *                                         .adMarkers(List.of("adMarkers"))
 *                                         .authenticationScheme("authenticationScheme")
 *                                         .cacheFullBehavior("cacheFullBehavior")
 *                                         .cacheLength(123)
 *                                         .captionData("captionData")
 *                                         .inputLossAction("inputLossAction")
 *                                         .restartDelay(123)
 *                                         .build())
 *                                 .udpGroupSettings(UdpGroupSettingsProperty.builder()
 *                                         .inputLossAction("inputLossAction")
 *                                         .timedMetadataId3Frame("timedMetadataId3Frame")
 *                                         .timedMetadataId3Period(123)
 *                                         .build())
 *                                 .build())
 *                         .outputs(List.of(OutputProperty.builder()
 *                                 .audioDescriptionNames(List.of("audioDescriptionNames"))
 *                                 .captionDescriptionNames(List.of("captionDescriptionNames"))
 *                                 .outputName("outputName")
 *                                 .outputSettings(OutputSettingsProperty.builder()
 *                                         .archiveOutputSettings(ArchiveOutputSettingsProperty.builder()
 *                                                 .containerSettings(ArchiveContainerSettingsProperty.builder()
 *                                                         .m2TsSettings(M2tsSettingsProperty.builder()
 *                                                                 .absentInputAudioBehavior("absentInputAudioBehavior")
 *                                                                 .arib("arib")
 *                                                                 .aribCaptionsPid("aribCaptionsPid")
 *                                                                 .aribCaptionsPidControl("aribCaptionsPidControl")
 *                                                                 .audioBufferModel("audioBufferModel")
 *                                                                 .audioFramesPerPes(123)
 *                                                                 .audioPids("audioPids")
 *                                                                 .audioStreamType("audioStreamType")
 *                                                                 .bitrate(123)
 *                                                                 .bufferModel("bufferModel")
 *                                                                 .ccDescriptor("ccDescriptor")
 *                                                                 .dvbNitSettings(DvbNitSettingsProperty.builder()
 *                                                                         .networkId(123)
 *                                                                         .networkName("networkName")
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 *                                                                         .outputSdt("outputSdt")
 *                                                                         .repInterval(123)
 *                                                                         .serviceName("serviceName")
 *                                                                         .serviceProviderName("serviceProviderName")
 *                                                                         .build())
 *                                                                 .dvbSubPids("dvbSubPids")
 *                                                                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbTeletextPid("dvbTeletextPid")
 *                                                                 .ebif("ebif")
 *                                                                 .ebpAudioInterval("ebpAudioInterval")
 *                                                                 .ebpLookaheadMs(123)
 *                                                                 .ebpPlacement("ebpPlacement")
 *                                                                 .ecmPid("ecmPid")
 *                                                                 .esRateInPes("esRateInPes")
 *                                                                 .etvPlatformPid("etvPlatformPid")
 *                                                                 .etvSignalPid("etvSignalPid")
 *                                                                 .fragmentTime(123)
 *                                                                 .klv("klv")
 *                                                                 .klvDataPids("klvDataPids")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .nullPacketBitrate(123)
 *                                                                 .patInterval(123)
 *                                                                 .pcrControl("pcrControl")
 *                                                                 .pcrPeriod(123)
 *                                                                 .pcrPid("pcrPid")
 *                                                                 .pmtInterval(123)
 *                                                                 .pmtPid("pmtPid")
 *                                                                 .programNum(123)
 *                                                                 .rateMode("rateMode")
 *                                                                 .scte27Pids("scte27Pids")
 *                                                                 .scte35Control("scte35Control")
 *                                                                 .scte35Pid("scte35Pid")
 *                                                                 .segmentationMarkers("segmentationMarkers")
 *                                                                 .segmentationStyle("segmentationStyle")
 *                                                                 .segmentationTime(123)
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .timedMetadataPid("timedMetadataPid")
 *                                                                 .transportStreamId(123)
 *                                                                 .videoPid("videoPid")
 *                                                                 .build())
 *                                                         .rawSettings(RawSettingsProperty.builder().build())
 *                                                         .build())
 *                                                 .extension("extension")
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .frameCaptureOutputSettings(FrameCaptureOutputSettingsProperty.builder()
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .hlsOutputSettings(HlsOutputSettingsProperty.builder()
 *                                                 .h265PackagingType("h265PackagingType")
 *                                                 .hlsSettings(HlsSettingsProperty.builder()
 *                                                         .audioOnlyHlsSettings(AudioOnlyHlsSettingsProperty.builder()
 *                                                                 .audioGroupId("audioGroupId")
 *                                                                 .audioOnlyImage(InputLocationProperty.builder()
 *                                                                         .passwordParam("passwordParam")
 *                                                                         .uri("uri")
 *                                                                         .username("username")
 *                                                                         .build())
 *                                                                 .audioTrackType("audioTrackType")
 *                                                                 .segmentType("segmentType")
 *                                                                 .build())
 *                                                         .fmp4HlsSettings(Fmp4HlsSettingsProperty.builder()
 *                                                                 .audioRenditionSets("audioRenditionSets")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .build())
 *                                                         .frameCaptureHlsSettings(FrameCaptureHlsSettingsProperty.builder().build())
 *                                                         .standardHlsSettings(StandardHlsSettingsProperty.builder()
 *                                                                 .audioRenditionSets("audioRenditionSets")
 *                                                                 .m3U8Settings(M3u8SettingsProperty.builder()
 *                                                                         .audioFramesPerPes(123)
 *                                                                         .audioPids("audioPids")
 *                                                                         .ecmPid("ecmPid")
 *                                                                         .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                         .patInterval(123)
 *                                                                         .pcrControl("pcrControl")
 *                                                                         .pcrPeriod(123)
 *                                                                         .pcrPid("pcrPid")
 *                                                                         .pmtInterval(123)
 *                                                                         .pmtPid("pmtPid")
 *                                                                         .programNum(123)
 *                                                                         .scte35Behavior("scte35Behavior")
 *                                                                         .scte35Pid("scte35Pid")
 *                                                                         .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                         .timedMetadataPid("timedMetadataPid")
 *                                                                         .transportStreamId(123)
 *                                                                         .videoPid("videoPid")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 .nameModifier("nameModifier")
 *                                                 .segmentModifier("segmentModifier")
 *                                                 .build())
 *                                         .mediaPackageOutputSettings(MediaPackageOutputSettingsProperty.builder().build())
 *                                         .msSmoothOutputSettings(MsSmoothOutputSettingsProperty.builder()
 *                                                 .h265PackagingType("h265PackagingType")
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .multiplexOutputSettings(MultiplexOutputSettingsProperty.builder()
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .build())
 *                                         .rtmpOutputSettings(RtmpOutputSettingsProperty.builder()
 *                                                 .certificateMode("certificateMode")
 *                                                 .connectionRetryInterval(123)
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .numRetries(123)
 *                                                 .build())
 *                                         .udpOutputSettings(UdpOutputSettingsProperty.builder()
 *                                                 .bufferMsec(123)
 *                                                 .containerSettings(UdpContainerSettingsProperty.builder()
 *                                                         .m2TsSettings(M2tsSettingsProperty.builder()
 *                                                                 .absentInputAudioBehavior("absentInputAudioBehavior")
 *                                                                 .arib("arib")
 *                                                                 .aribCaptionsPid("aribCaptionsPid")
 *                                                                 .aribCaptionsPidControl("aribCaptionsPidControl")
 *                                                                 .audioBufferModel("audioBufferModel")
 *                                                                 .audioFramesPerPes(123)
 *                                                                 .audioPids("audioPids")
 *                                                                 .audioStreamType("audioStreamType")
 *                                                                 .bitrate(123)
 *                                                                 .bufferModel("bufferModel")
 *                                                                 .ccDescriptor("ccDescriptor")
 *                                                                 .dvbNitSettings(DvbNitSettingsProperty.builder()
 *                                                                         .networkId(123)
 *                                                                         .networkName("networkName")
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 *                                                                         .outputSdt("outputSdt")
 *                                                                         .repInterval(123)
 *                                                                         .serviceName("serviceName")
 *                                                                         .serviceProviderName("serviceProviderName")
 *                                                                         .build())
 *                                                                 .dvbSubPids("dvbSubPids")
 *                                                                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbTeletextPid("dvbTeletextPid")
 *                                                                 .ebif("ebif")
 *                                                                 .ebpAudioInterval("ebpAudioInterval")
 *                                                                 .ebpLookaheadMs(123)
 *                                                                 .ebpPlacement("ebpPlacement")
 *                                                                 .ecmPid("ecmPid")
 *                                                                 .esRateInPes("esRateInPes")
 *                                                                 .etvPlatformPid("etvPlatformPid")
 *                                                                 .etvSignalPid("etvSignalPid")
 *                                                                 .fragmentTime(123)
 *                                                                 .klv("klv")
 *                                                                 .klvDataPids("klvDataPids")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .nullPacketBitrate(123)
 *                                                                 .patInterval(123)
 *                                                                 .pcrControl("pcrControl")
 *                                                                 .pcrPeriod(123)
 *                                                                 .pcrPid("pcrPid")
 *                                                                 .pmtInterval(123)
 *                                                                 .pmtPid("pmtPid")
 *                                                                 .programNum(123)
 *                                                                 .rateMode("rateMode")
 *                                                                 .scte27Pids("scte27Pids")
 *                                                                 .scte35Control("scte35Control")
 *                                                                 .scte35Pid("scte35Pid")
 *                                                                 .segmentationMarkers("segmentationMarkers")
 *                                                                 .segmentationStyle("segmentationStyle")
 *                                                                 .segmentationTime(123)
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .timedMetadataPid("timedMetadataPid")
 *                                                                 .transportStreamId(123)
 *                                                                 .videoPid("videoPid")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .fecOutputSettings(FecOutputSettingsProperty.builder()
 *                                                         .columnDepth(123)
 *                                                         .includeFec("includeFec")
 *                                                         .rowLength(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .videoDescriptionName("videoDescriptionName")
 *                                 .build()))
 *                         .build()))
 *                 .timecodeConfig(TimecodeConfigProperty.builder()
 *                         .source("source")
 *                         .syncThreshold(123)
 *                         .build())
 *                 .videoDescriptions(List.of(VideoDescriptionProperty.builder()
 *                         .codecSettings(VideoCodecSettingsProperty.builder()
 *                                 .frameCaptureSettings(FrameCaptureSettingsProperty.builder()
 *                                         .captureInterval(123)
 *                                         .captureIntervalUnits("captureIntervalUnits")
 *                                         .build())
 *                                 .h264Settings(H264SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .bitrate(123)
 *                                         .bufFillPct(123)
 *                                         .bufSize(123)
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpaceSettings(H264ColorSpaceSettingsProperty.builder()
 *                                                 .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
 *                                                 .rec601Settings(Rec601SettingsProperty.builder().build())
 *                                                 .rec709Settings(Rec709SettingsProperty.builder().build())
 *                                                 .build())
 *                                         .entropyEncoding("entropyEncoding")
 *                                         .filterSettings(H264FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .flickerAq("flickerAq")
 *                                         .forceFieldPictures("forceFieldPictures")
 *                                         .framerateControl("framerateControl")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopBReference("gopBReference")
 *                                         .gopClosedCadence(123)
 *                                         .gopNumBFrames(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .level("level")
 *                                         .lookAheadRateControl("lookAheadRateControl")
 *                                         .maxBitrate(123)
 *                                         .minIInterval(123)
 *                                         .numRefFrames(123)
 *                                         .parControl("parControl")
 *                                         .parDenominator(123)
 *                                         .parNumerator(123)
 *                                         .profile("profile")
 *                                         .qualityLevel("qualityLevel")
 *                                         .qvbrQualityLevel(123)
 *                                         .rateControlMode("rateControlMode")
 *                                         .scanType("scanType")
 *                                         .sceneChangeDetect("sceneChangeDetect")
 *                                         .slices(123)
 *                                         .softness(123)
 *                                         .spatialAq("spatialAq")
 *                                         .subgopLength("subgopLength")
 *                                         .syntax("syntax")
 *                                         .temporalAq("temporalAq")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .h265Settings(H265SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .alternativeTransferFunction("alternativeTransferFunction")
 *                                         .bitrate(123)
 *                                         .bufSize(123)
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpaceSettings(H265ColorSpaceSettingsProperty.builder()
 *                                                 .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
 *                                                 .hdr10Settings(Hdr10SettingsProperty.builder()
 *                                                         .maxCll(123)
 *                                                         .maxFall(123)
 *                                                         .build())
 *                                                 .rec601Settings(Rec601SettingsProperty.builder().build())
 *                                                 .rec709Settings(Rec709SettingsProperty.builder().build())
 *                                                 .build())
 *                                         .filterSettings(H265FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .flickerAq("flickerAq")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopClosedCadence(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .level("level")
 *                                         .lookAheadRateControl("lookAheadRateControl")
 *                                         .maxBitrate(123)
 *                                         .minIInterval(123)
 *                                         .parDenominator(123)
 *                                         .parNumerator(123)
 *                                         .profile("profile")
 *                                         .qvbrQualityLevel(123)
 *                                         .rateControlMode("rateControlMode")
 *                                         .scanType("scanType")
 *                                         .sceneChangeDetect("sceneChangeDetect")
 *                                         .slices(123)
 *                                         .tier("tier")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .mpeg2Settings(Mpeg2SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpace("colorSpace")
 *                                         .displayAspectRatio("displayAspectRatio")
 *                                         .filterSettings(Mpeg2FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopClosedCadence(123)
 *                                         .gopNumBFrames(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .scanType("scanType")
 *                                         .subgopLength("subgopLength")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .build())
 *                         .height(123)
 *                         .name("name")
 *                         .respondToAfd("respondToAfd")
 *                         .scalingBehavior("scalingBehavior")
 *                         .sharpness(123)
 *                         .width(123)
 *                         .build()))
 *                 .build())
 *         .inputAttachments(List.of(InputAttachmentProperty.builder()
 *                 .automaticInputFailoverSettings(AutomaticInputFailoverSettingsProperty.builder()
 *                         .errorClearTimeMsec(123)
 *                         .failoverConditions(List.of(FailoverConditionProperty.builder()
 *                                 .failoverConditionSettings(FailoverConditionSettingsProperty.builder()
 *                                         .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
 *                                                 .audioSelectorName("audioSelectorName")
 *                                                 .audioSilenceThresholdMsec(123)
 *                                                 .build())
 *                                         .inputLossSettings(InputLossFailoverSettingsProperty.builder()
 *                                                 .inputLossThresholdMsec(123)
 *                                                 .build())
 *                                         .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
 *                                                 .blackDetectThreshold(123)
 *                                                 .videoBlackThresholdMsec(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .inputPreference("inputPreference")
 *                         .secondaryInputId("secondaryInputId")
 *                         .build())
 *                 .inputAttachmentName("inputAttachmentName")
 *                 .inputId("inputId")
 *                 .inputSettings(InputSettingsProperty.builder()
 *                         .audioSelectors(List.of(AudioSelectorProperty.builder()
 *                                 .name("name")
 *                                 .selectorSettings(AudioSelectorSettingsProperty.builder()
 *                                         .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
 *                                                 .groupId("groupId")
 *                                                 .name("name")
 *                                                 .build())
 *                                         .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
 *                                                 .languageCode("languageCode")
 *                                                 .languageSelectionPolicy("languageSelectionPolicy")
 *                                                 .build())
 *                                         .audioPidSelection(AudioPidSelectionProperty.builder()
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .audioTrackSelection(AudioTrackSelectionProperty.builder()
 *                                                 .tracks(List.of(AudioTrackProperty.builder()
 *                                                         .track(123)
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .captionSelectors(List.of(CaptionSelectorProperty.builder()
 *                                 .languageCode("languageCode")
 *                                 .name("name")
 *                                 .selectorSettings(CaptionSelectorSettingsProperty.builder()
 *                                         .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
 *                                                 .sourceAncillaryChannelNumber(123)
 *                                                 .build())
 *                                         .aribSourceSettings(AribSourceSettingsProperty.builder().build())
 *                                         .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
 *                                                 .ocrLanguage("ocrLanguage")
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
 *                                                 .convert608To708("convert608To708")
 *                                                 .scte20Detection("scte20Detection")
 *                                                 .source608ChannelNumber(123)
 *                                                 .source608TrackNumber(123)
 *                                                 .build())
 *                                         .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
 *                                                 .convert608To708("convert608To708")
 *                                                 .source608ChannelNumber(123)
 *                                                 .build())
 *                                         .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
 *                                                 .ocrLanguage("ocrLanguage")
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
 *                                                 .outputRectangle(CaptionRectangleProperty.builder()
 *                                                         .height(123)
 *                                                         .leftOffset(123)
 *                                                         .topOffset(123)
 *                                                         .width(123)
 *                                                         .build())
 *                                                 .pageNumber("pageNumber")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .deblockFilter("deblockFilter")
 *                         .denoiseFilter("denoiseFilter")
 *                         .filterStrength(123)
 *                         .inputFilter("inputFilter")
 *                         .networkInputSettings(NetworkInputSettingsProperty.builder()
 *                                 .hlsInputSettings(HlsInputSettingsProperty.builder()
 *                                         .bandwidth(123)
 *                                         .bufferSegments(123)
 *                                         .retries(123)
 *                                         .retryInterval(123)
 *                                         .scte35Source("scte35Source")
 *                                         .build())
 *                                 .serverValidation("serverValidation")
 *                                 .build())
 *                         .scte35Pid(123)
 *                         .smpte2038DataPreference("smpte2038DataPreference")
 *                         .sourceEndBehavior("sourceEndBehavior")
 *                         .videoSelector(VideoSelectorProperty.builder()
 *                                 .colorSpace("colorSpace")
 *                                 .colorSpaceSettings(VideoSelectorColorSpaceSettingsProperty.builder()
 *                                         .hdr10Settings(Hdr10SettingsProperty.builder()
 *                                                 .maxCll(123)
 *                                                 .maxFall(123)
 *                                                 .build())
 *                                         .build())
 *                                 .colorSpaceUsage("colorSpaceUsage")
 *                                 .selectorSettings(VideoSelectorSettingsProperty.builder()
 *                                         .videoSelectorPid(VideoSelectorPidProperty.builder()
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .videoSelectorProgramId(VideoSelectorProgramIdProperty.builder()
 *                                                 .programId(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .inputSpecification(InputSpecificationProperty.builder()
 *                 .codec("codec")
 *                 .maximumBitrate("maximumBitrate")
 *                 .resolution("resolution")
 *                 .build())
 *         .logLevel("logLevel")
 *         .name("name")
 *         .roleArn("roleArn")
 *         .tags(tags)
 *         .vpc(VpcOutputSettingsProperty.builder()
 *                 .publicAddressAllocationIds(List.of("publicAddressAllocationIds"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:40.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCdiInputSpecification() {
        return null;
    }

    /**
     * The class for this channel.
     * <p>
     * For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChannelClass() {
        return null;
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return null;
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncoderSettings() {
        return null;
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputAttachments() {
        return null;
    }

    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputSpecification() {
        return null;
    }

    /**
     * The verbosity for logging activity for this channel.
     * <p>
     * Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
        return null;
    }

    /**
     * A name for this audio selector.
     * <p>
     * The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     * <p>
     * The role is identified by its ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * A collection of tags for this channel.
     * <p>
     * Each tag is a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.Object cdiInputSpecification;
        java.lang.String channelClass;
        java.lang.Object destinations;
        java.lang.Object encoderSettings;
        java.lang.Object inputAttachments;
        java.lang.Object inputSpecification;
        java.lang.String logLevel;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object tags;
        java.lang.Object vpc;

        /**
         * Sets the value of {@link CfnChannelProps#getCdiInputSpecification}
         * @param cdiInputSpecification Specification of CDI inputs for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdiInputSpecification(software.amazon.awscdk.services.medialive.CfnChannel.CdiInputSpecificationProperty cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getCdiInputSpecification}
         * @param cdiInputSpecification Specification of CDI inputs for this channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdiInputSpecification(software.amazon.awscdk.IResolvable cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelClass}
         * @param channelClass The class for this channel.
         *                     For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelClass(java.lang.String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDestinations}
         * @param destinations The settings that identify the destination for the outputs in this MediaLive output package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDestinations}
         * @param destinations The settings that identify the destination for the outputs in this MediaLive output package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
            this.destinations = destinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEncoderSettings}
         * @param encoderSettings The encoding configuration for the output content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encoderSettings(software.amazon.awscdk.services.medialive.CfnChannel.EncoderSettingsProperty encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEncoderSettings}
         * @param encoderSettings The encoding configuration for the output content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encoderSettings(software.amazon.awscdk.IResolvable encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputAttachments}
         * @param inputAttachments The list of input attachments for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputAttachments(software.amazon.awscdk.IResolvable inputAttachments) {
            this.inputAttachments = inputAttachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputAttachments}
         * @param inputAttachments The list of input attachments for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputAttachments(java.util.List<? extends java.lang.Object> inputAttachments) {
            this.inputAttachments = inputAttachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputSpecification}
         * @param inputSpecification The input specification for this channel.
         *                           It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSpecification(software.amazon.awscdk.services.medialive.CfnChannel.InputSpecificationProperty inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInputSpecification}
         * @param inputSpecification The input specification for this channel.
         *                           It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSpecification(software.amazon.awscdk.IResolvable inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLogLevel}
         * @param logLevel The verbosity for logging activity for this channel.
         *                 Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logLevel(java.lang.String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getName}
         * @param name A name for this audio selector.
         *             The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRoleArn}
         * @param roleArn The IAM role for MediaLive to assume when running this channel.
         *                The role is identified by its ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags A collection of tags for this channel.
         *             Each tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getVpc}
         * @param vpc Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.medialive.CfnChannel.VpcOutputSettingsProperty vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getVpc}
         * @param vpc Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.Object cdiInputSpecification;
        private final java.lang.String channelClass;
        private final java.lang.Object destinations;
        private final java.lang.Object encoderSettings;
        private final java.lang.Object inputAttachments;
        private final java.lang.Object inputSpecification;
        private final java.lang.String logLevel;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object tags;
        private final java.lang.Object vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cdiInputSpecification = software.amazon.jsii.Kernel.get(this, "cdiInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.channelClass = software.amazon.jsii.Kernel.get(this, "channelClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encoderSettings = software.amazon.jsii.Kernel.get(this, "encoderSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputAttachments = software.amazon.jsii.Kernel.get(this, "inputAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputSpecification = software.amazon.jsii.Kernel.get(this, "inputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cdiInputSpecification = builder.cdiInputSpecification;
            this.channelClass = builder.channelClass;
            this.destinations = builder.destinations;
            this.encoderSettings = builder.encoderSettings;
            this.inputAttachments = builder.inputAttachments;
            this.inputSpecification = builder.inputSpecification;
            this.logLevel = builder.logLevel;
            this.name = builder.name;
            this.roleArn = builder.roleArn;
            this.tags = builder.tags;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Object getCdiInputSpecification() {
            return this.cdiInputSpecification;
        }

        @Override
        public final java.lang.String getChannelClass() {
            return this.channelClass;
        }

        @Override
        public final java.lang.Object getDestinations() {
            return this.destinations;
        }

        @Override
        public final java.lang.Object getEncoderSettings() {
            return this.encoderSettings;
        }

        @Override
        public final java.lang.Object getInputAttachments() {
            return this.inputAttachments;
        }

        @Override
        public final java.lang.Object getInputSpecification() {
            return this.inputSpecification;
        }

        @Override
        public final java.lang.String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCdiInputSpecification() != null) {
                data.set("cdiInputSpecification", om.valueToTree(this.getCdiInputSpecification()));
            }
            if (this.getChannelClass() != null) {
                data.set("channelClass", om.valueToTree(this.getChannelClass()));
            }
            if (this.getDestinations() != null) {
                data.set("destinations", om.valueToTree(this.getDestinations()));
            }
            if (this.getEncoderSettings() != null) {
                data.set("encoderSettings", om.valueToTree(this.getEncoderSettings()));
            }
            if (this.getInputAttachments() != null) {
                data.set("inputAttachments", om.valueToTree(this.getInputAttachments()));
            }
            if (this.getInputSpecification() != null) {
                data.set("inputSpecification", om.valueToTree(this.getInputSpecification()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.cdiInputSpecification != null ? !this.cdiInputSpecification.equals(that.cdiInputSpecification) : that.cdiInputSpecification != null) return false;
            if (this.channelClass != null ? !this.channelClass.equals(that.channelClass) : that.channelClass != null) return false;
            if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
            if (this.encoderSettings != null ? !this.encoderSettings.equals(that.encoderSettings) : that.encoderSettings != null) return false;
            if (this.inputAttachments != null ? !this.inputAttachments.equals(that.inputAttachments) : that.inputAttachments != null) return false;
            if (this.inputSpecification != null ? !this.inputSpecification.equals(that.inputSpecification) : that.inputSpecification != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cdiInputSpecification != null ? this.cdiInputSpecification.hashCode() : 0;
            result = 31 * result + (this.channelClass != null ? this.channelClass.hashCode() : 0);
            result = 31 * result + (this.destinations != null ? this.destinations.hashCode() : 0);
            result = 31 * result + (this.encoderSettings != null ? this.encoderSettings.hashCode() : 0);
            result = 31 * result + (this.inputAttachments != null ? this.inputAttachments.hashCode() : 0);
            result = 31 * result + (this.inputSpecification != null ? this.inputSpecification.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
